/*****************************************************************************
* FILE:         dispvidctrl_ClientSds_ttsIf.h
* PROJECT:      G3G project
* SW-COMPONENT: dispvidctrl
* Template:     ClientIf.h.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*
*               Generated file
*               Do here client specific implementation
*               Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2018 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

#ifndef __dispvidctrl_ClientSds_ttsIf__IF__H_
#define __dispvidctrl_ClientSds_ttsIf__IF__H_

/******************************************************************************/
/* INCLUDES                                                                   */
/******************************************************************************/

//include base class
#include "I_dispvidctrl_ClientSds_ttsIf.h"
#include "dispvidctrl_AppMain.h"
#include "dispvidctrl_ClientSds_ttsCallbackIf.h"

// dispvidctrl_tclClientSds_ttsIf_Include: user specific code start
class dispvidctrl_tclAudio_Routing;
// dispvidctrl_tclClientSds_ttsIf_Include: user specific code end

/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/
class Idispvidctrl_tclClientSds_tts;

class dispvidctrl_tclClientSds_ttsIf : public Idispvidctrl_tclClientSds_ttsIf, public dispvidctrl_tclClientSds_ttsCallbackIF
{
public:

   dispvidctrl_tclClientSds_ttsIf(tVoid); 
   dispvidctrl_tclClientSds_ttsIf(dispvidctrl_tclAppMain* poMainAppl);
   virtual ~dispvidctrl_tclClientSds_ttsIf();

   virtual const tChar* getName() const { return "dispvidctrl_tclClientSds_ttsIf"; };
   
   virtual tVoid vHandleMessage(dispvidctrl_tclBaseIf::TMsg* pMsg);
   virtual tVoid vHandleTraceMessage(const tUChar* puchData);
   virtual tVoid vGetReferences();
   virtual tVoid vStartCommunication();
   virtual tVoid vTraceInfo();

   /***************************************************************************
   * all public methods to send / getCurrentState.
   ***************************************************************************/



   virtual tBool sendTTSStatusGet(){
       //just forward send request
       DISPVIDCTRL_NULL_POINTER_CHECK_VAL(_poClientRef);
       return _poClientRef->sendTTSStatusGet();
   }
   virtual tVoid getTTSStatusStatus(sds_fi_tcl_e8_TTSStatus& rTTSStatus){
       //just forward send request
       DISPVIDCTRL_NULL_POINTER_CHECK(_poClientRef);
       _poClientRef->getTTSStatusStatus(rTTSStatus);
   }


   virtual tBool sendSynthesizeSpeakMStart(sds_fi_tclString TextAndTags, sds_fi_tcl_e8_TextStyleOption TextStyle, sds_fi_tcl_b8_AudioOutputLocation AudioOutputLocation, sds_fi_tcl_e8_StatusInfoOption StatusInfo, tU32 ExpDate, tBool LastPackage){
       //just forward send request
       DISPVIDCTRL_NULL_POINTER_CHECK_VAL(_poClientRef);
       return _poClientRef->sendSynthesizeSpeakMStart(TextAndTags, TextStyle, AudioOutputLocation, StatusInfo, ExpDate, LastPackage);
   }
   virtual tBool sendPrepareVoiceOutputMStart(sds_fi_tclString Device){
       //just forward send request
       DISPVIDCTRL_NULL_POINTER_CHECK_VAL(_poClientRef);
       return _poClientRef->sendPrepareVoiceOutputMStart(Device);
   }
   virtual tBool sendAbortPromptMStart(sds_fi_tcl_e8_PromptAbortOption AbortPromptOption){
       //just forward send request
       DISPVIDCTRL_NULL_POINTER_CHECK_VAL(_poClientRef);
       return _poClientRef->sendAbortPromptMStart(AbortPromptOption);
   }
private:
   /***************************************************************************
   * handling of incomming messages
   ***************************************************************************/
   virtual tVoid onTTSStatusStatus(sds_fi_tcl_e8_TTSStatus TTSStatus);

   virtual tVoid onPrepareVoiceOutputMResult();
   virtual tVoid onAbortPromptMResult();

   // dispvidctrl_tclClientSds_ttsIfDeclarations: user specific code start
   // dispvidctrl_tclClientSds_ttsIfDeclarations: user specific code end

   virtual tVoid onServiceAvailable();
   virtual tVoid onServiceUnavailable();
   
private:
   Idispvidctrl_tclClientSds_tts* _poClientRef;

// dispvidctrl_tclClientSds_ttsIfDeclarationsPart2: user specific code start
   tVoid vPrepareSynthesizeMStart();

   sds_fi_tclString* m_TextAndTags;
   sds_fi_tcl_e8_TTSStatus m_TtsStatus;
   
   dispvidctrl_tclAudio_Routing* m_poAudioRouting;

public:
   virtual tVoid RestartTTS();
   virtual tVoid requestPrepareVoiceOutput();
   virtual tVoid setTTSString(sds_fi_tclString TextAndTags);
   virtual tBool bIsCurrentlyActive() { return (m_TtsStatus.enType == sds_fi_tcl_e8_TTSStatus::FI_EN_SYNTHESIZING); }

private:
   // declare (but hide and don't implement, i.e. effectively disable) copy contructor and assignment operator to make Coverity happy
   dispvidctrl_tclClientSds_ttsIf(const dispvidctrl_tclClientSds_ttsIf&);
   dispvidctrl_tclClientSds_ttsIf& operator=(const dispvidctrl_tclClientSds_ttsIf&);
   
// dispvidctrl_tclClientSds_ttsIfDeclarationsPart2: user specific code end

};

#endif // __dispvidctrl_ClientSds_ttsIf__IF__H_


