
/*****************************************************************************
* FILE:         dispvidctrl_ClientSds_ttsIf.cpp
* PROJECT:      G3G project
* SW-COMPONENT: dispvidctrl
* Template:     ClientIf.cpp.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*
*               Generated file
*               Do here client specific implementation
*               Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2018 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

// Include common fi interface
#define FI_S_IMPORT_INTERFACE_BASE_TYPES
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "common_fi_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

// dispvidctrl_tclClientSds_ttsIfIncludes: user specific code start
#include "dispvidctrl_tclAudioRouting.h"
// dispvidctrl_tclClientSds_ttsIfIncludes: user specific code end

#include "dispvidctrl_ClientSds_ttsIf.h"
#include "Idispvidctrl_ClientSds_tts.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_DISPVIDCTRL_CLIENT_SDS_TTS
#include "trcGenProj/Header/dispvidctrl_ClientSds_ttsIf.cpp.trc.h"
#endif

/******************************************************************************/
/*                                                                            */
/* METHODS                                                                    */
/*                                                                            */
/******************************************************************************/

/*******************************************************************************
*
* FUNCTION: dispvidctrl_tclClientSds_ttsIf::
*             dispvidctrl_tclClientSds_ttsIf(dispvidctrl_tclAppMain* poMainAppl)
*
* DESCRIPTION: Constructor.
*
*              Create an object of the base class
*              ahl_tclBaseOneThreadClientHandler with a pointer to this
*              application, the to be used service identifier and the service
*              version as parameters.
*
* PARAMETER: [IN] poMainAppl = Pointer to the object of this application.
*
* RETURNVALUE: None.
*
*******************************************************************************/
dispvidctrl_tclClientSds_ttsIf::dispvidctrl_tclClientSds_ttsIf(dispvidctrl_tclAppMain* poMainAppl) : 
Idispvidctrl_tclClientSds_ttsIf(poMainAppl)
{
   ETG_TRACE_USR4(("dispvidctrl_tclClientSds_ttsIf() entered."));
   _poClientRef = OSAL_NULL;

   // dispvidctrl_tclClientSds_ttsIfConstructor: user specific code start
   m_poAudioRouting = OSAL_NULL;

   m_TtsStatus.enType = sds_fi_tcl_e8_TTSStatus::FI_EN_INITIALIZATION;
   m_TextAndTags = new sds_fi_tclString();
   if ( m_TextAndTags != OSAL_NULL )
      m_TextAndTags->bSet("", sds_fi_tclString::FI_EN_UTF8);
   // dispvidctrl_tclClientSds_ttsIfConstructor: user specific code end

   //__PRPPERTY_PARAM_INIT__
}

/*******************************************************************************
*
* FUNCTION: dispvidctrl_tclClientSds_ttsIf::
*             ~dispvidctrl_tclClientSds_ttsIf(tVoid)
*
* DESCRIPTION: Destructor.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
dispvidctrl_tclClientSds_ttsIf::~dispvidctrl_tclClientSds_ttsIf(tVoid)
{
   ETG_TRACE_USR4(("~dispvidctrl_tclClientSds_ttsIf() entered."));
   _poClientRef = OSAL_NULL;

   // dispvidctrl_tclClientSds_ttsIfDestructor: user specific code start
   m_poAudioRouting = OSAL_NULL;

   if (m_TextAndTags)
   {
      delete m_TextAndTags;
      m_TextAndTags = OSAL_NULL;
   }
   // dispvidctrl_tclClientSds_ttsIfDestructor: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclClientSds_ttsIf::vGetReferences(tVoid)
*
* DESCRIPTION: Function to get all reference needed by this class.
* A reference should always be the Interface class of the object
* 
* Example how to get a reference:
*  Declaration in 'dispvidctrl_ClientSds_ttsIf.h':
*     Add forward declaration:
*         class Idispvidctrl_tclObject2Get;
*
*     Add declaration of object reference:
*         Idispvidctrl_tclObject2Get*  pIObjRef;  
*        
*  Add this snippet to the vGetReferences() method:
*     pIObjRef = dynamic_cast<Idispvidctrl_tclObject2Get*>(_cpoMain->getHandler("Idispvidctrl_tclObject2Get"));
*     SDS_TTS_NULL_POINTER_CHECK(pIObjRef);
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid dispvidctrl_tclClientSds_ttsIf::vGetReferences(tVoid)
{
   ETG_TRACE_USR4(("dispvidctrl_tclClientSds_ttsIf::vGetReferences() entered."));

   _poClientRef = dynamic_cast<Idispvidctrl_tclClientSds_tts*>(_cpoMain->getHandler("Idispvidctrl_tclClientSds_tts"));

   DISPVIDCTRL_NULL_POINTER_CHECK(_poClientRef);

   _poClientRef->vSetCallbackIf(this);

   //set callback interface

   // dispvidctrl_tclClientSds_ttsIfvGetReferences: user specific code start
   m_poAudioRouting = dynamic_cast<dispvidctrl_tclAudio_Routing*>(_cpoMain->getHandler("dispvidctrl_tclAudio_Routing"));
   DISPVIDCTRL_NULL_POINTER_CHECK(m_poAudioRouting);
   // dispvidctrl_tclClientSds_ttsIfvGetReferences: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclClientSds_ttsIf::vStartCommunication(tVoid)
*
* DESCRIPTION: Function to start all dynamic objects e.g. threads, ...
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid dispvidctrl_tclClientSds_ttsIf::vStartCommunication(tVoid)
{
   ETG_TRACE_USR4(("dispvidctrl_tclClientSds_ttsIf::vStartCommunication() entered."));
   // dispvidctrl_tclClientSds_ttsIfvStartCommunication: user specific code start
   // dispvidctrl_tclClientSds_ttsIfvStartCommunication: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclClientSds_ttsIf::vHandleMessage(TMsg* pMsg)
*
* DESCRIPTION: Handle worker events.
*
* PARAMETER:   dispvidctrl_tclBaseIf::TMsg* pMsg
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid dispvidctrl_tclClientSds_ttsIf::vHandleMessage(dispvidctrl_tclBaseIf::TMsg* pMsg)
{
   ETG_TRACE_USR4(("dispvidctrl_tclClientSds_ttsIf::vHandleMessage() entered %u -> data: %d.", ETG_CENUM(dispvidctrl_tclBaseIf::ECmdTypes , (tU32)pMsg->eCmd), pMsg->u.u32Data));
   
   // dispvidctrl_tclClientSds_ttsIfvHandleMessage: user specific code start
   // dispvidctrl_tclClientSds_ttsIfvHandleMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclClientSds_ttsIf::vHandleTraceMessage()
*
* DESCRIPTION: Handle trace message.
*
* PARAMETER:   const tUChar* puchData
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid dispvidctrl_tclClientSds_ttsIf::vHandleTraceMessage(const tUChar* puchData)
{
   DISPVIDCTRL_NULL_POINTER_CHECK(puchData);
   
   tU32 u32MsgCode = ((puchData[1]<<8) | puchData[2]);
   ETG_TRACE_USR4(("dispvidctrl_tclClientSds_ttsIf::vHandleTraceMessage(): trace command %d", u32MsgCode ));

   // dispvidctrl_tclClientSds_ttsIfvHandleTraceMessage: user specific code start
   // dispvidctrl_tclClientSds_ttsIfvHandleTraceMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclClientSds_ttsIf::vTraceInfo()
*
* DESCRIPTION: Trace information
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid dispvidctrl_tclClientSds_ttsIf::vTraceInfo()
{
   // dispvidctrl_tclClientSds_ttsIfvTraceInfo: user specific code start
   ETG_TRACE_FATAL(("dispvidctrl_tclClientSds_ttsIf::vTraceInfo() entered"));
   ETG_TRACE_FATAL(("dispvidctrl_tclClientSds_ttsIf::vTraceInfo() TTS Status .............. = %u", m_TtsStatus.enType));
   ETG_TRACE_FATAL(("dispvidctrl_tclClientSds_ttsIf::vTraceInfo() TTS String .............. = %s", m_TextAndTags->szValue));
   ETG_TRACE_FATAL(("dispvidctrl_tclClientSds_ttsIf::vTraceInfo() TTS String length ....... = %u", strlen(m_TextAndTags->szValue)));
   // dispvidctrl_tclClientSds_ttsIfvTraceInfo: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclClientSds_ttsIf::vOnServiceAvailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become available.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceAvailable().
*******************************************************************************/
tVoid dispvidctrl_tclClientSds_ttsIf::onServiceAvailable()
{
   ETG_TRACE_USR4(("dispvidctrl_tclClientSds_ttsIf::onServiceAvailable() entered."));

   // dispvidctrl_tclClientSds_ttsIfvOnServiceAvailable: user specific code start
   // dispvidctrl_tclClientSds_ttsIfvOnServiceAvailable: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclClientSds_ttsIf::vOnServiceUnavailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become unavailable.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceUnavailable().
*******************************************************************************/
tVoid dispvidctrl_tclClientSds_ttsIf::onServiceUnavailable()
{
   ETG_TRACE_USR4(("dispvidctrl_tclClientSds_ttsIf::onServiceUnavailable() entered."));

   // dispvidctrl_tclClientSds_ttsIfvOnServiceUnavailable: user specific code start
   // dispvidctrl_tclClientSds_ttsIfvOnServiceUnavailable: user specific code end
}

tVoid dispvidctrl_tclClientSds_ttsIf::onTTSStatusStatus(sds_fi_tcl_e8_TTSStatus TTSStatus) {
   ETG_TRACE_USR1( ( "dispvidctrl_tclClientSds_ttsIf::onTTSStatusStatus(): CALLED" ) );

   // onTTSStatusStatus: user specific code start
   m_TtsStatus.enType = TTSStatus.enType;
   ETG_TRACE_USR1(( "dispvidctrl_tclClientSds_ttsIf::onTTSStatusStatus(): TTS Status is %u", m_TtsStatus.enType ));
   
   // deallocate Audio Channel if the TTS is done or went to Idle
   if ( m_TtsStatus.enType == sds_fi_tcl_e8_TTSStatus::FI_EN_IDLE || m_TtsStatus.enType == sds_fi_tcl_e8_TTSStatus::FI_EN_DONE )
   {
      if (m_poAudioRouting)
      {
         m_poAudioRouting->vInformAudioPlaybackFinished(ARL_SRC_IPA_TTS);
      }
   }
   // onTTSStatusStatus: user specific code end
}

tVoid dispvidctrl_tclClientSds_ttsIf::onPrepareVoiceOutputMResult() {
   ETG_TRACE_USR1( ( "dispvidctrl_tclClientSds_ttsIf::onPrepareVoiceOutputMResult(): CALLED" ) );

   // onPrepareVoiceOutputMResult: user specific code start
   vPrepareSynthesizeMStart();
   // onPrepareVoiceOutputMResult: user specific code end
}
tVoid dispvidctrl_tclClientSds_ttsIf::onAbortPromptMResult() {
   ETG_TRACE_USR1( ( "dispvidctrl_tclClientSds_ttsIf::onAbortPromptMResult(): CALLED" ) );

   // onAbortPromptMResult: user specific code start
   // There is something to be played ?
   if ( strlen(m_TextAndTags->szValue) > 0 )
   {
      ETG_TRACE_USR1( ( "dispvidctrl_tclClientSds_ttsIf::onAbortPromptMResult(): Prepare TTS" ) );
      requestPrepareVoiceOutput();
   }
   else
   {
      ETG_TRACE_USR1( ( "dispvidctrl_tclClientSds_ttsIf::onAbortPromptMResult(): Nothing to be played StringLength %u", strlen(m_TextAndTags->szValue) ) );
   }
   // onAbortPromptMResult: user specific code end
}



// dispvidctrl_tclClientSds_ttsIfdispvidctrl_ClientSds_ttsIf: user specific code start
tVoid dispvidctrl_tclClientSds_ttsIf::RestartTTS()
{
   if ( bIsCurrentlyActive() )
   {
      sds_fi_tcl_e8_PromptAbortOption oAbortOption;
      oAbortOption.enType = sds_fi_tcl_e8_PromptAbortOption::FI_EN_IMMEDIATE;
      sendAbortPromptMStart(oAbortOption);
   }
   else
   {
      requestPrepareVoiceOutput();
   }
}

tVoid dispvidctrl_tclClientSds_ttsIf::requestPrepareVoiceOutput()
{
   ETG_TRACE_USR1( ( "dispvidctrl_tclClientSds_ttsIf::request for sendPrepareVoiceOutputMStart()" ) );
   sds_fi_tclString szText;
   szText.bSet("\0", sds_fi_tclString::FI_EN_UTF8);
   sendPrepareVoiceOutputMStart(szText);
}

tVoid dispvidctrl_tclClientSds_ttsIf::setTTSString(sds_fi_tclString TextAndTags) 
{
   ETG_TRACE_USR1( ( "dispvidctrl_tclClientSds_ttsIf::setTTSString \"%s\" ", TextAndTags.szValue ) );
   if ( m_TextAndTags != OSAL_NULL )
   {
      m_TextAndTags->bSet(TextAndTags.szValue, sds_fi_tclString::FI_EN_UTF8);
   }
}


tVoid dispvidctrl_tclClientSds_ttsIf::vPrepareSynthesizeMStart()
{
    ETG_TRACE_USR1(( "dispvidctrl_tclClientSds_ttsIf::vPrepareSynthesizeMStart() entered TTS String \"%s\"", m_TextAndTags->szValue));

    DISPVIDCTRL_NULL_POINTER_CHECK(m_TextAndTags);
    
    // There is something to be played
    if ( strlen(m_TextAndTags->szValue) > 0 )
    {
        sds_fi_tcl_e8_TextStyleOption TextStyle;
        TextStyle.enType = sds_fi_tcl_e8_TextStyleOption::FI_EN_PLAIN;

        sds_fi_tcl_b8_AudioOutputLocation AudioOutputLocation;
        //AudioOutputLocation.vSetBackLeft(TRUE);
        //AudioOutputLocation.vSetBackRight(TRUE);
        //AudioOutputLocation.vSetFrontLeft(TRUE);
        //AudioOutputLocation.vSetFrontRight(TRUE);
        AudioOutputLocation.vSetStandard(TRUE);

        sds_fi_tcl_e8_StatusInfoOption StatusInfo;
        StatusInfo.enType = sds_fi_tcl_e8_StatusInfoOption::FI_EN_NOINFO;
        tU32 ExpDate = 0; // maximum time 10s
        tBool LastPackage = TRUE;

        tBool bMStartSent = sendSynthesizeSpeakMStart(*m_TextAndTags, TextStyle, AudioOutputLocation, StatusInfo, ExpDate, LastPackage);
        ETG_TRACE_USR1(( "dispvidctrl_tclClientSds_ttsIf::vPrepareSynthesizeMStart() sendSynthesizeSpeakMStart Success %u", bMStartSent) );
        
        // Clear the String after the request is sent
        m_TextAndTags->bSet("", sds_fi_tclString::FI_EN_UTF8);
    }
    else
    {
        ETG_TRACE_USR1(( "dispvidctrl_tclClientSds_ttsIf::vPrepareSynthesizeMStart() Nothing to be played StringLength %u", strlen(m_TextAndTags->szValue)));
    }
}
// dispvidctrl_tclClientSds_ttsIfdispvidctrl_ClientSds_ttsIf: user specific code end

//EOF
