
/*****************************************************************************
* FILE:         dispvidctrl_ClientDiaglogIf.cpp
* PROJECT:      G3G project
* SW-COMPONENT: dispvidctrl
* Template:     ClientIf.cpp.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*
*               Generated file
*               Do here client specific implementation
*               Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2018 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

// Include common fi interface
#define FI_S_IMPORT_INTERFACE_BASE_TYPES
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "common_fi_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

// dispvidctrl_tclClientDiaglogIfIncludes: user specific code start
#define VD_DIAGLOG_S_IMPORT_INTERFACE_MSG
#include "vd_diaglog_if.h"
// dispvidctrl_tclClientDiaglogIfIncludes: user specific code end

#include "dispvidctrl_ClientDiaglogIf.h"
#include "Idispvidctrl_ClientDiaglog.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_DISPVIDCTRL_CLIENT_DIAGLOG
#include "trcGenProj/Header/dispvidctrl_ClientDiaglogIf.cpp.trc.h"
#endif

/******************************************************************************/
/*                                                                            */
/* METHODS                                                                    */
/*                                                                            */
/******************************************************************************/

/*******************************************************************************
*
* FUNCTION: dispvidctrl_tclClientDiaglogIf::
*             dispvidctrl_tclClientDiaglogIf(dispvidctrl_tclAppMain* poMainAppl)
*
* DESCRIPTION: Constructor.
*
*              Create an object of the base class
*              ahl_tclBaseOneThreadClientHandler with a pointer to this
*              application, the to be used service identifier and the service
*              version as parameters.
*
* PARAMETER: [IN] poMainAppl = Pointer to the object of this application.
*
* RETURNVALUE: None.
*
*******************************************************************************/
dispvidctrl_tclClientDiaglogIf::dispvidctrl_tclClientDiaglogIf(dispvidctrl_tclAppMain* poMainAppl) : 
Idispvidctrl_tclClientDiaglogIf(poMainAppl)
{
   ETG_TRACE_USR4(("dispvidctrl_tclClientDiaglogIf() entered."));
   _poClientRef = OSAL_NULL;

   // dispvidctrl_tclClientDiaglogIfConstructor: user specific code start
   m_bDiagLogServiceAvailable = FALSE;
   (tVoid)memset((tVoid*) m_au8ItcState, 0xFF, sizeof(m_au8ItcState));
   // dispvidctrl_tclClientDiaglogIfConstructor: user specific code end

   //__PRPPERTY_PARAM_INIT__
}

/*******************************************************************************
*
* FUNCTION: dispvidctrl_tclClientDiaglogIf::
*             ~dispvidctrl_tclClientDiaglogIf(tVoid)
*
* DESCRIPTION: Destructor.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
dispvidctrl_tclClientDiaglogIf::~dispvidctrl_tclClientDiaglogIf(tVoid)
{
   ETG_TRACE_USR4(("~dispvidctrl_tclClientDiaglogIf() entered."));
   _poClientRef = OSAL_NULL;

   // dispvidctrl_tclClientDiaglogIfDestructor: user specific code start
   // dispvidctrl_tclClientDiaglogIfDestructor: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclClientDiaglogIf::vGetReferences(tVoid)
*
* DESCRIPTION: Function to get all reference needed by this class.
* A reference should always be the Interface class of the object
* 
* Example how to get a reference:
*  Declaration in 'dispvidctrl_ClientDiaglogIf.h':
*     Add forward declaration:
*         class Idispvidctrl_tclObject2Get;
*
*     Add declaration of object reference:
*         Idispvidctrl_tclObject2Get*  pIObjRef;  
*        
*  Add this snippet to the vGetReferences() method:
*     pIObjRef = dynamic_cast<Idispvidctrl_tclObject2Get*>(_cpoMain->getHandler("Idispvidctrl_tclObject2Get"));
*     DIAGLOG_NULL_POINTER_CHECK(pIObjRef);
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid dispvidctrl_tclClientDiaglogIf::vGetReferences(tVoid)
{
   ETG_TRACE_USR4(("dispvidctrl_tclClientDiaglogIf::vGetReferences() entered."));

   _poClientRef = dynamic_cast<Idispvidctrl_tclClientDiaglog*>(_cpoMain->getHandler("Idispvidctrl_tclClientDiaglog"));

   DISPVIDCTRL_NULL_POINTER_CHECK(_poClientRef);

   _poClientRef->vSetCallbackIf(this);

   //set callback interface

   // dispvidctrl_tclClientDiaglogIfvGetReferences: user specific code start
   // dispvidctrl_tclClientDiaglogIfvGetReferences: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclClientDiaglogIf::vStartCommunication(tVoid)
*
* DESCRIPTION: Function to start all dynamic objects e.g. threads, ...
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid dispvidctrl_tclClientDiaglogIf::vStartCommunication(tVoid)
{
   ETG_TRACE_USR4(("dispvidctrl_tclClientDiaglogIf::vStartCommunication() entered."));
   // dispvidctrl_tclClientDiaglogIfvStartCommunication: user specific code start
   // dispvidctrl_tclClientDiaglogIfvStartCommunication: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclClientDiaglogIf::vHandleMessage(TMsg* pMsg)
*
* DESCRIPTION: Handle worker events.
*
* PARAMETER:   dispvidctrl_tclBaseIf::TMsg* pMsg
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid dispvidctrl_tclClientDiaglogIf::vHandleMessage(dispvidctrl_tclBaseIf::TMsg* pMsg)
{
   ETG_TRACE_USR4(("dispvidctrl_tclClientDiaglogIf::vHandleMessage() entered %u -> data: %d.", ETG_CENUM(dispvidctrl_tclBaseIf::ECmdTypes , (tU32)pMsg->eCmd), pMsg->u.u32Data));
   
   // dispvidctrl_tclClientDiaglogIfvHandleMessage: user specific code start
   // dispvidctrl_tclClientDiaglogIfvHandleMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclClientDiaglogIf::vHandleTraceMessage()
*
* DESCRIPTION: Handle trace message.
*
* PARAMETER:   const tUChar* puchData
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid dispvidctrl_tclClientDiaglogIf::vHandleTraceMessage(const tUChar* puchData)
{
   DISPVIDCTRL_NULL_POINTER_CHECK(puchData);
   
   tU32 u32MsgCode = ((puchData[1]<<8) | puchData[2]);
   ETG_TRACE_USR4(("dispvidctrl_tclClientDiaglogIf::vHandleTraceMessage(): trace command %d", u32MsgCode ));

   // dispvidctrl_tclClientDiaglogIfvHandleTraceMessage: user specific code start
   // dispvidctrl_tclClientDiaglogIfvHandleTraceMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclClientDiaglogIf::vTraceInfo()
*
* DESCRIPTION: Trace information
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid dispvidctrl_tclClientDiaglogIf::vTraceInfo()
{
   // dispvidctrl_tclClientDiaglogIfvTraceInfo: user specific code start
   // dispvidctrl_tclClientDiaglogIfvTraceInfo: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclClientDiaglogIf::vOnServiceAvailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become available.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceAvailable().
*******************************************************************************/
tVoid dispvidctrl_tclClientDiaglogIf::onServiceAvailable()
{
   ETG_TRACE_USR4(("dispvidctrl_tclClientDiaglogIf::onServiceAvailable() entered."));

   // dispvidctrl_tclClientDiaglogIfvOnServiceAvailable: user specific code start
   m_bDiagLogServiceAvailable = TRUE;

   ETG_TRACE_USR4(("dispvidctrl_tclClientDiaglogIf::onAvailable() send pending Testresults"));
   _vSetPendingItcTestResult();
   // dispvidctrl_tclClientDiaglogIfvOnServiceAvailable: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclClientDiaglogIf::vOnServiceUnavailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become unavailable.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceUnavailable().
*******************************************************************************/
tVoid dispvidctrl_tclClientDiaglogIf::onServiceUnavailable()
{
   ETG_TRACE_USR4(("dispvidctrl_tclClientDiaglogIf::onServiceUnavailable() entered."));

   // dispvidctrl_tclClientDiaglogIfvOnServiceUnavailable: user specific code start
   m_bDiagLogServiceAvailable = FALSE;
   // dispvidctrl_tclClientDiaglogIfvOnServiceUnavailable: user specific code end
}

tVoid dispvidctrl_tclClientDiaglogIf::onSendNextTestResultStatus(midw_fi_tcl_SendNextTestResultStructure NextTestResultStruct, tBool Status) {
   ETG_TRACE_USR1( ( "dispvidctrl_tclClientDiaglogIf::onSendNextTestResultStatus(): CALLED" ) );

   // onSendNextTestResultStatus: user specific code start
   //(tVoid) NextTestResultStruct;
   // do we need to re-check and report the ITC status
   if (Status == TRUE && NextTestResultStruct.ITCList.empty() == TRUE)	//Log ITC when list is empty and Status is true
   {
      dispvidctrl_tclBaseIf::TMsg oMsg;
      (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
      oMsg.eCmd = dispvidctrl_tclBaseIf::eTriggerRecheckITC;
      memset(oMsg.strClassName, 0, 50);
      oMsg.u.u32Data = 0;
      
      _cpoMain->theServer()->vPostInternalMessage(&oMsg);
   }
   // onSendNextTestResultStatus: user specific code end
}

tVoid dispvidctrl_tclClientDiaglogIf::onSaveTestResultMResult(midw_fi_tcl_e8_MethodResultReply Status) {
   ETG_TRACE_USR1( ( "dispvidctrl_tclClientDiaglogIf::onSaveTestResultMResult(): CALLED" ) );

   // onSaveTestResultMResult: user specific code start
   (tVoid) Status;
   // onSaveTestResultMResult: user specific code end
}



// dispvidctrl_tclClientDiaglogIfdispvidctrl_ClientDiaglogIf: user specific code start

// Lookup Table which holds mapping of internal ITC ID and DiagLog ITC ID
// e.g.
//   const static StIdcIndexMappingTable astIdcIndexMappingTable[] =
//   {
//      // INDEX,       ITC
//      {(tU8) enITC_ID_UNDEF,                                (tU16) 0                                        },
//      {(tU8) enITC_ID_ANGLE_SENSOR_CALIBRATION,             (tU16) ITC_AIVI_ANGLE_SENSOR_CALIBRATION        },
//      ...
//      {(tU8) enITC_ID_LVDS_OUT_CP_LINE_COMM_FAILURE,        (tU16) ITC_LVDS_OUT_CP_LINE_COMM_FAILURE        },
//      {(tU8) enITC_ID_LVDS_OUT_SECOND_DISPLAY_COMM_FAILURE, (tU16) ITC_LVDS_OUT_SECOND_DISPLAY_COMM_FAILURE }
//   };
#define ONE_ITC_ITEM(EnumName,ItcName)  {(tU8) EnumName , (tU16) ItcName } ,
const static StIdcIndexMappingTable astIdcIndexMappingTable[] = { ALL_ITC_ITEMS };
#undef ONE_ITC_ITEM


/******************************************************************************/
/* FUNCTION     vSetITC                                                       */
/******************************************************************************/
/**
*  \brief       To send a Method Start with Test Result to Diaglog
*               If the Diaglog service is not available, hold the Test Result.
*
*  \param       ID of ITC, Test Result enumeration value
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclClientDiaglogIf::vSetITC(tenITC_ID enITC_ID, midw_fi_tcl_e8_TestResult::tenType enTestResult)
{

   //ETG_TRACE_FATAL(("dispvidctrl_tclClientDiaglogIf::vSetITC() set ITC[%u] with TestResult[%u]", enITC_ID, enTestResult));

   // if the diaglog service is available we can send the test result immediately,
   // otherwhise we have to hold it
   if (m_bDiagLogServiceAvailable == TRUE)
   {
      tU16 u16MappedDiagLogItc = 0;
      // get mapped DiagLog ITC from enITC_ID
      if (enITC_ID_MAX > enITC_ID)
      {
         u16MappedDiagLogItc = astIdcIndexMappingTable[enITC_ID].u16ITC;
      }
      else
      {
         //error: missing mapping entry
         ETG_TRACE_FATAL(("unequal number of entries or missing entries in enum list and lookup table"));
      }

      if (0 < u16MappedDiagLogItc)
      {
         midw_fi_tcl_TestResult  oTestResult;

         oTestResult.TroubleCode   = u16MappedDiagLogItc;
         oTestResult.Result.enType = enTestResult;

         midw_fi_tcl_TestResultList oTestResultList;
         oTestResultList.TestResultList.reserve(1);

         oTestResultList.TestResultList.push_back(oTestResult);
         sendSaveTestResultMStart(oTestResultList);
      }
      else
      {
         //not mapped, will be not reported
         ETG_TRACE_USR4(("dispvidctrl_tclClientDiaglogIf::vSetITC() ITC[%u] Not mapped -> not reported", enITC_ID));
      }
   }
   else
   {
      // hold test result - will be send to diaglog when service becomes available
      //ETG_TRACE_FATAL(("dispvidctrl_tclClientDiaglogIf::vSetITC() DiagLog Service not yet available -> will be hold"));

      // just an update of the test result value
      m_au8ItcState[enITC_ID] = (tU8) enTestResult;
   }
}

/******************************************************************************/
/* FUNCTION     _vSetPendingItcTestResult                                     */
/******************************************************************************/
/**
*  \brief       To send a Method Start with Test Result to Diaglog
*               (test result which was hold while Diaglog service was not
*               available (during start up).
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclClientDiaglogIf::_vSetPendingItcTestResult(tVoid)
{
   midw_fi_tcl_TestResultList oTestResultList;
   oTestResultList.TestResultList.reserve(1);
   tU8 u8Index;

   //ETG_TRACE_FATAL(("dispvidctrl_tclClientDiaglogIf::_vSetPendingItcTestResult()"));

   for (u8Index = 0; u8Index < enITC_ID_MAX; u8Index++)
   {
      if (m_au8ItcState[u8Index] != 0xFF)
      {
         midw_fi_tcl_TestResult  oTestResult;
         oTestResult.TroubleCode   = (tU16) astIdcIndexMappingTable[u8Index].u16ITC;
         oTestResult.Result.enType = (midw_fi_tcl_e8_TestResult::tenType) m_au8ItcState[u8Index];
         // fill into test list
         oTestResultList.TestResultList.push_back(oTestResult);

         //ETG_TRACE_FATAL(("dispvidctrl_tclClientDiaglogIf::_vSetPendingItcTestResult() ITC_Enum[%d] ITC_Diaglog[%x] Testresult[%d]", u8Index, astIdcIndexMappingTable[u8Index].u16ITC, m_au8ItcState[u8Index]));
      }
   }

   if (0 < oTestResultList.TestResultList.size())
   {
      sendSaveTestResultMStart(oTestResultList);
      ETG_TRACE_USR4(("dispvidctrl_tclClientDiaglogIf::_vSetPendingItcTestResult() TestResultList with %d elements sent", oTestResultList.TestResultList.size()));
   }
   else
   {
      //nothing to send
      ETG_TRACE_USR4(("dispvidctrl_tclClientDiaglogIf::_vSetPendingItcTestResult() No TestResultList sent"));
   }
}
// dispvidctrl_tclClientDiaglogIfdispvidctrl_ClientDiaglogIf: user specific code end

//EOF
