/*****************************************************************************
* FILE:         dispvidctrl_ClientAudioIf.h
* PROJECT:      G3G project
* SW-COMPONENT: dispvidctrl
* Template:     ClientIf.h.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*
*               Generated file
*               Do here client specific implementation
*               Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2018 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

#ifndef __dispvidctrl_ClientAudioIf__IF__H_
#define __dispvidctrl_ClientAudioIf__IF__H_

/******************************************************************************/
/* INCLUDES                                                                   */
/******************************************************************************/

//include base class
#include "I_dispvidctrl_ClientAudioIf.h"
#include "dispvidctrl_AppMain.h"
#include "dispvidctrl_ClientAudioCallbackIf.h"

// dispvidctrl_tclClientAudioIf_Include: user specific code start
// dispvidctrl_tclClientAudioIf_Include: user specific code end

/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/
class Idispvidctrl_tclClientAudio;

class dispvidctrl_tclClientAudioIf : public Idispvidctrl_tclClientAudioIf, public dispvidctrl_tclClientAudioCallbackIF
{
public:

   dispvidctrl_tclClientAudioIf(tVoid); 
   dispvidctrl_tclClientAudioIf(dispvidctrl_tclAppMain* poMainAppl);
   virtual ~dispvidctrl_tclClientAudioIf();

   virtual const tChar* getName() const { return "dispvidctrl_tclClientAudioIf"; };
   
   virtual tVoid vHandleMessage(dispvidctrl_tclBaseIf::TMsg* pMsg);
   virtual tVoid vHandleTraceMessage(const tUChar* puchData);
   virtual tVoid vGetReferences();
   virtual tVoid vStartCommunication();
   virtual tVoid vTraceInfo();

   /***************************************************************************
   * all public methods to send / getCurrentState.
   ***************************************************************************/



   virtual tBool sendBeepMStart(midw_fi_tcl_e8_AudioBeepType BeepType, midw_fi_tcl_e8_ResourceNo Resource){
       //just forward send request
       DISPVIDCTRL_NULL_POINTER_CHECK_VAL(_poClientRef);
       return _poClientRef->sendBeepMStart(BeepType, Resource);
   }
private:
   /***************************************************************************
   * handling of incomming messages
   ***************************************************************************/

   virtual tVoid onBeepMResult(midw_fi_tcl_e8_AudioServiceStatus ServiceStatus);

   // dispvidctrl_tclClientAudioIfDeclarations: user specific code start
   // dispvidctrl_tclClientAudioIfDeclarations: user specific code end

   virtual tVoid onServiceAvailable();
   virtual tVoid onServiceUnavailable();
   
private:
   Idispvidctrl_tclClientAudio* _poClientRef;

// dispvidctrl_tclClientAudioIfDeclarationsPart2: user specific code start
// dispvidctrl_tclClientAudioIfDeclarationsPart2: user specific code end

};

#endif // __dispvidctrl_ClientAudioIf__IF__H_


