
/*****************************************************************************
* FILE:         dispvidctrl_ClientAudioIf.cpp
* PROJECT:      G3G project
* SW-COMPONENT: dispvidctrl
* Template:     ClientIf.cpp.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*
*               Generated file
*               Do here client specific implementation
*               Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2018 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

// Include common fi interface
#define FI_S_IMPORT_INTERFACE_BASE_TYPES
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "common_fi_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

// dispvidctrl_tclClientAudioIfIncludes: user specific code start
// dispvidctrl_tclClientAudioIfIncludes: user specific code end

#include "dispvidctrl_ClientAudioIf.h"
#include "Idispvidctrl_ClientAudio.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_DISPVIDCTRL_CLIENT_AUDIO
#include "trcGenProj/Header/dispvidctrl_ClientAudioIf.cpp.trc.h"
#endif

/******************************************************************************/
/*                                                                            */
/* METHODS                                                                    */
/*                                                                            */
/******************************************************************************/

/*******************************************************************************
*
* FUNCTION: dispvidctrl_tclClientAudioIf::
*             dispvidctrl_tclClientAudioIf(dispvidctrl_tclAppMain* poMainAppl)
*
* DESCRIPTION: Constructor.
*
*              Create an object of the base class
*              ahl_tclBaseOneThreadClientHandler with a pointer to this
*              application, the to be used service identifier and the service
*              version as parameters.
*
* PARAMETER: [IN] poMainAppl = Pointer to the object of this application.
*
* RETURNVALUE: None.
*
*******************************************************************************/
dispvidctrl_tclClientAudioIf::dispvidctrl_tclClientAudioIf(dispvidctrl_tclAppMain* poMainAppl) : 
Idispvidctrl_tclClientAudioIf(poMainAppl)
{
   ETG_TRACE_USR4(("dispvidctrl_tclClientAudioIf() entered."));
   _poClientRef = OSAL_NULL;

   // dispvidctrl_tclClientAudioIfConstructor: user specific code start
   // dispvidctrl_tclClientAudioIfConstructor: user specific code end

   //__PRPPERTY_PARAM_INIT__
}

/*******************************************************************************
*
* FUNCTION: dispvidctrl_tclClientAudioIf::
*             ~dispvidctrl_tclClientAudioIf(tVoid)
*
* DESCRIPTION: Destructor.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
dispvidctrl_tclClientAudioIf::~dispvidctrl_tclClientAudioIf(tVoid)
{
   ETG_TRACE_USR4(("~dispvidctrl_tclClientAudioIf() entered."));
   _poClientRef = OSAL_NULL;

   // dispvidctrl_tclClientAudioIfDestructor: user specific code start
   // dispvidctrl_tclClientAudioIfDestructor: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclClientAudioIf::vGetReferences(tVoid)
*
* DESCRIPTION: Function to get all reference needed by this class.
* A reference should always be the Interface class of the object
* 
* Example how to get a reference:
*  Declaration in 'dispvidctrl_ClientAudioIf.h':
*     Add forward declaration:
*         class Idispvidctrl_tclObject2Get;
*
*     Add declaration of object reference:
*         Idispvidctrl_tclObject2Get*  pIObjRef;  
*        
*  Add this snippet to the vGetReferences() method:
*     pIObjRef = dynamic_cast<Idispvidctrl_tclObject2Get*>(_cpoMain->getHandler("Idispvidctrl_tclObject2Get"));
*     AUDIO_NULL_POINTER_CHECK(pIObjRef);
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid dispvidctrl_tclClientAudioIf::vGetReferences(tVoid)
{
   ETG_TRACE_USR4(("dispvidctrl_tclClientAudioIf::vGetReferences() entered."));

   _poClientRef = dynamic_cast<Idispvidctrl_tclClientAudio*>(_cpoMain->getHandler("Idispvidctrl_tclClientAudio"));

   DISPVIDCTRL_NULL_POINTER_CHECK(_poClientRef);

   _poClientRef->vSetCallbackIf(this);

   //set callback interface

   // dispvidctrl_tclClientAudioIfvGetReferences: user specific code start
   // dispvidctrl_tclClientAudioIfvGetReferences: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclClientAudioIf::vStartCommunication(tVoid)
*
* DESCRIPTION: Function to start all dynamic objects e.g. threads, ...
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid dispvidctrl_tclClientAudioIf::vStartCommunication(tVoid)
{
   ETG_TRACE_USR4(("dispvidctrl_tclClientAudioIf::vStartCommunication() entered."));
   // dispvidctrl_tclClientAudioIfvStartCommunication: user specific code start
   // dispvidctrl_tclClientAudioIfvStartCommunication: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclClientAudioIf::vHandleMessage(TMsg* pMsg)
*
* DESCRIPTION: Handle worker events.
*
* PARAMETER:   dispvidctrl_tclBaseIf::TMsg* pMsg
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid dispvidctrl_tclClientAudioIf::vHandleMessage(dispvidctrl_tclBaseIf::TMsg* pMsg)
{
   ETG_TRACE_USR4(("dispvidctrl_tclClientAudioIf::vHandleMessage() entered %u -> data: %d.", ETG_CENUM(dispvidctrl_tclBaseIf::ECmdTypes , (tU32)pMsg->eCmd), pMsg->u.u32Data));
   
   // dispvidctrl_tclClientAudioIfvHandleMessage: user specific code start
   // dispvidctrl_tclClientAudioIfvHandleMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclClientAudioIf::vHandleTraceMessage()
*
* DESCRIPTION: Handle trace message.
*
* PARAMETER:   const tUChar* puchData
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid dispvidctrl_tclClientAudioIf::vHandleTraceMessage(const tUChar* puchData)
{
   DISPVIDCTRL_NULL_POINTER_CHECK(puchData);
   
   tU32 u32MsgCode = ((puchData[1]<<8) | puchData[2]);
   ETG_TRACE_USR4(("dispvidctrl_tclClientAudioIf::vHandleTraceMessage(): trace command %d", u32MsgCode ));

   // dispvidctrl_tclClientAudioIfvHandleTraceMessage: user specific code start
   // dispvidctrl_tclClientAudioIfvHandleTraceMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclClientAudioIf::vTraceInfo()
*
* DESCRIPTION: Trace information
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid dispvidctrl_tclClientAudioIf::vTraceInfo()
{
   // dispvidctrl_tclClientAudioIfvTraceInfo: user specific code start
   // dispvidctrl_tclClientAudioIfvTraceInfo: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclClientAudioIf::vOnServiceAvailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become available.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceAvailable().
*******************************************************************************/
tVoid dispvidctrl_tclClientAudioIf::onServiceAvailable()
{
   ETG_TRACE_USR4(("dispvidctrl_tclClientAudioIf::onServiceAvailable() entered."));

   // dispvidctrl_tclClientAudioIfvOnServiceAvailable: user specific code start
   // dispvidctrl_tclClientAudioIfvOnServiceAvailable: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclClientAudioIf::vOnServiceUnavailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become unavailable.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceUnavailable().
*******************************************************************************/
tVoid dispvidctrl_tclClientAudioIf::onServiceUnavailable()
{
   ETG_TRACE_USR4(("dispvidctrl_tclClientAudioIf::onServiceUnavailable() entered."));

   // dispvidctrl_tclClientAudioIfvOnServiceUnavailable: user specific code start
   // dispvidctrl_tclClientAudioIfvOnServiceUnavailable: user specific code end
}


tVoid dispvidctrl_tclClientAudioIf::onBeepMResult(midw_fi_tcl_e8_AudioServiceStatus ServiceStatus) {
   ETG_TRACE_USR1( ( "dispvidctrl_tclClientAudioIf::onBeepMResult(): CALLED" ) );

   // onBeepMResult: user specific code start
   (tVoid) ServiceStatus;
   // onBeepMResult: user specific code end
}



// dispvidctrl_tclClientAudioIfdispvidctrl_ClientAudioIf: user specific code start
// dispvidctrl_tclClientAudioIfdispvidctrl_ClientAudioIf: user specific code end

//EOF
