/******************************************************************************/
/**
* \file    dispvidctrl_tclVideoPlayer.h
* \ingroup
*
* \brief
*
* \remark  Copyright : (c) 2015 Robert Bosch GmbH, Hildesheim
* \remark  Author    : Michael Niemann
* \remark  Scope     : AIVI
*
* \todo
*/
/******************************************************************************/
#ifndef _DISPVIDCTRL_TCL_VideoPlayer_H_
#define _DISPVIDCTRL_TCL_VideoPlayer_H_

/*******************************************************************************
                        Includes
*******************************************************************************/
#include <glib.h>
#include <glib-unix.h>
#include <gst/gst.h>

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "dispvidctrl_AppMain.h"
#include "I_dispvidctrl_tclVideoPlayer.h"
#include "Idispvidctrl_ClientVideomanager.h"
#include "vd_rvc_tclGraphics_DynGuideline_Types.h"

/*******************************************************************************
                        Defines
*******************************************************************************/

// VideoPlayer input ranges
#define VIDEOPLAYER_WARNINGTEXTLANGUAGE_MAX   24
#define VIDEOPLAYER_GUIDELINEVISIBILITY_MAX   15
#define VIDEOPLAYER_WARNINGTEXTVISIBILITY_MAX 1
#define VIDEOPLAYER_STEERINGWHEELANGLE_MIN    -600
#define VIDEOPLAYER_STEERINGWHEELANGLE_MAX    600
#define VIDEOPLAYER_REARWHEELANGLE_MIN        -600
#define VIDEOPLAYER_REARWHEELANGLE_MAX        600
#define VIDEOPLAYER_NIGHT_MAX                 1


class VideoPlayer;
class dispvidctrl_tclGstAnimation;
#ifdef VARIANT_S_FTR_ENABLE_DUAL_ANIMATION
class dispvidctrl_tclGstDualAnimation;
#endif
class dispvidctrl_tclGstRvc;

class I_dispvidctrl_tclSyncHandler;
class Idispvidctrl_tclClientVideomanager;

/*******************************************************************************
   Class
*******************************************************************************/
class dispvidctrl_tclVideoPlayer : public I_dispvidctrl_tclVideoPlayer
{
public:

      dispvidctrl_tclVideoPlayer(dispvidctrl_tclAppMain* poMainAppl);
      virtual ~dispvidctrl_tclVideoPlayer();

      virtual const tChar* getName() const { return "dispvidctrl_tclVideoPlayer"; };

      virtual tVoid vHandleMessage(dispvidctrl_tclBaseIf::TMsg* pMsg);
      virtual tVoid vHandleTraceMessage(const tUChar* puchData);
      virtual tVoid vGetReferences();
      virtual tVoid vStartCommunication();
      virtual tVoid vTraceInfo();

      virtual tVoid vStartCommunicationEarly();
      virtual tVoid vGetReferencesEarly();
      virtual tVoid vGetConfiguration(const TConfiguration* pStConfigurationValues);

      // Rvc interface
      virtual tVoid vActivateRvc(tBool bActivationState);
      virtual tVoid vShowRvc();
      virtual tVoid vShowBlackScreen(tU8 u8BlackScreenType);
      virtual tVoid vPreInitGraphics();

      virtual tVoid vSetWarningTextLanguage(tU8 u8Language);
      virtual tVoid vSetGuideLineVisibility(tU32 u32Visibility);
      virtual tVoid vSetWarningTextVisibility(tU32 u32Visibility);
      virtual tVoid vSetSteeringWheelAngle(tS32 s32SteeringWheelAngle);
      virtual tVoid vSetRearWheelAngle(tS32 s32RearWheelAngle);
      virtual tVoid vSetNight(tU8 u8Night);
      virtual tVoid vSetHandoverReady();
      virtual tVoid vSetCropping(tU32 u32CropUp, tU32 u32CropDown, tU32 u32CropLeft, tU32 u32CropRight);
      virtual tBool bCroppingParametersInRange(tU32 u32CropUp, tU32 u32CropDown, tU32 u32CropLeft, tU32 u32CropRight);
      virtual tVoid vSetCameraImageMirror(tU32 u32CameraImageMirror);
      virtual tVoid vSetLayerOrSurfaceSettings(tU8, tU16, tU32, tU32, tU32, tU32, tBool);
      virtual tVoid vReConfigGuidelineParams(tU8, tU8);
      
      virtual tVoid vSetHmiAvailable();
      virtual tBool bIsVideoSourceFound() const;
      virtual tBool bFindVideoSource() const;

      virtual tVoid vGetRvcState(tBool& bVideoActive, tBool& bRvcErrorVal);
      virtual tU8 u8GetCameraConnectionType();

      virtual tVoid vHandleFirstFrameRendered(tVoid);
      virtual tVoid vSetAllRvcObjects(tVoid);
      virtual tVoid vStartRVCPlaying(tVoid);

      // Animation interface
      virtual tVoid vStartAnimation(tBool bActivationState, tBool bOnlyLastFrame=FALSE);
      virtual tVoid vPrepareAnimation(tVoid);

      static tVoid vFirstFrame();
      static tVoid vNewVideoStatus();

      virtual tVoid vIndVehicleConfigChanged_DynGuideline(tVoid);
      virtual vd_rvc_tstVehicleParams* vGetVehicleConfigPtr_DynGuideline(tVoid);
      virtual tVoid vSetVehicleConfig_DynGuideline(tVoid);
      virtual tVoid vSetTemporaryCalibGuidelnStyle(tBool bActive);

      virtual tVoid vSetLVDSBrightness(tU16 u16Brightness, tU16 u16BlackLevel);
      virtual tVoid vSetLVDSColour(tU16 u16Colour);
      virtual tVoid vSetLVDSContrast(tU16 u16Contrast);
      virtual tVoid vSetLVDSHue(tU16 u16Hue);

      virtual tVoid vSetInitialblackscreen(tU8 u8BlackScreenType);
	  virtual tVoid GraphicslayerVisibility(unsigned int visibility);
private:

      tVoid vStartVideoPlayer();
      tVoid vVideoPlayerInit();

      static tVoid vVideoPlayerThread(tVoid *pvArg);

      static dispvidctrl_tclVideoPlayer*   _poMyStaticRef;

      VideoPlayer* _pVideoPlayer;

      I_dispvidctrl_tclSyncHandler* _poSyncHandler;
      
      dispvidctrl_tclGstAnimation* _poAnimationPipeline;
#ifdef VARIANT_S_FTR_ENABLE_DUAL_ANIMATION
      dispvidctrl_tclGstDualAnimation* _poDualAnimationPipeline;
#endif
      dispvidctrl_tclGstRvc*       _poRvcPipeline;

      tS32 m_s32SteeringWheelAngle;
      tS32 m_s32RearWheelAngle;
      tU8  m_u8Night;

      TEarlyConfiguration          _tEarlyConfig;
//      TConfiguration               _tConfiguration;

      tU8 m_Config_u8CameraConnectionType;

      Idispvidctrl_tclClientVideomanager* _poVideoManager;
};
#endif

