/************************************************************************
* FILE:        dispvidctrl_tclGstPipeline.h
* PROJECT:
* SW-COMPONENT:vd_dimming
*----------------------------------------------------------------------
*
* DESCRIPTION: interface of configuration manager class
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author             | Modification
* 20.08.2015| CM-AI/EPB2 Bernard | init
*
*************************************************************************/

#ifndef _dispvidctrl_tclGstPipeline_H_
#define _dispvidctrl_tclGstPipeline_H_

#include <glib.h>
#include <glib-unix.h>
#include <gst/gst.h>

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define SCALE_INPUT_RANGE_MID 50
#define SCALE_INPUT_RANGE_MAX 100

#define SCALE_OUTPUT_RANGE_MID 128
#define SCALE_OUTPUT_RANGE_MAX 255

// LVDS Setting defines
#define LVDS_SCALE_OUTPUT_RANGE_MAX 200
#define LVDS_HUE_SCALE_OUTPUT_RANGE_MAX 360
#define LVDS_SCALE_OUTPUT_OFFSET 180

class dispvidctrl_tclGstPipeline
{
protected:
    GMainLoop   *_pGstMainLoop;

    GstElement  *_pGstPipeline;
    GstElement  *_pGstQueue;
    GstElement  *_pGstQueue_Csc;
    GstElement  *_pGstSource;
    GstElement  *_pGstCsc;
    GstElement  *_pGstSink;
#ifdef ENABLE_60_TO_30_REDUCTION
    GstElement  *_pGstVideoRate;
    GstElement  *_pGstCapsFilter;
#endif //ENABLE_60_TO_30_REDUCTION
    GstBus      *_pGstBus;
    tU8         _u8CameraConnection;

public:
    // constructor
    dispvidctrl_tclGstPipeline(tVoid);

    // destructor
    virtual ~dispvidctrl_tclGstPipeline();

    virtual tBool bInit(GMainLoop *pGstMainLoop) = 0;
    virtual tVoid vStart(tU8 u8Type = 0) = 0;
    virtual tVoid vPause() = 0;
    virtual tVoid vStop() = 0;

    virtual tVoid vSetBrightness(tU16 u16Brightness, tU16 u16Blacklevel);
    virtual tVoid vSetColour(tU16 u16Colour);
    virtual tVoid vSetContrast(tU16 u16Contrast);
    virtual tVoid vSetHue(tU16 u16Hue);

    virtual tVoid vSetLVDSBrightness(tU16 u16Brightness, tU16 u16Blacklevel);
    virtual tVoid vSetLVDSColour(tU16 u16Colour);
    virtual tVoid vSetLVDSContrast(tU16 u16Contrast);
    virtual tVoid vSetLVDSHue(tU16 u16Hue);
};

#endif /* _dispvidctrl_tclGstPipeline_H_ */
