
/***************************  Parameters of the cameras Sony 2400S_W130.6 and Sony 2500S ***************************/

// core parameters of the different variants:

static const vd_rvc_tstCameraParams stCameraParams_Sony2400s_Nissan = 
{
   1.023,
   2.9838, 1.9465,  // vFOV = 92°
   0.0,    0.0,
   false
};

#ifdef DYNGL_SUPPORT_CAM_SONY2400_NISSAN_V109
static const vd_rvc_tstCameraParams stCameraParams_Sony2400s_Nissan_V109 = 
{
   1.023,
   2.9838, 2.4029,  // vFOV = 109° , used (so far) only in H60A
   0.0,    0.0,
   false
};
#endif

static const vd_rvc_tstCameraParams stCameraParams_Sony2400s_Renault = 
{
   1.023,
   2.9780, 2.3180,
   0.0,    0.0,
   false
};

static const vd_rvc_tstCameraParams stCameraParams_Sony2500s = 
{
   1.023,
   3.4320, 2.1060,
   0.0,    0.0,
   false
};

// common radial distortion model for the above variants:

static const vd_rvc_tstSplineParam astSplineParams_Sony2400s_W130_6[] =
{
   {  0.25118264, -2.266620641307e-02, +0.000000000000e+00, +1.002403615167e+00, +0.000000000000e+00 },
   {  0.50076270, -1.540699067032e-01, -1.708007256086e-02, +9.981133974840e-01, +2.514271750000e-01 },
   {  0.75082124, -1.556373851845e-01, -1.324384022384e-01, +9.607965675725e-01, +4.970772240000e-01 },
   {  1.00000000, -6.331204934196e-02, -2.491937741644e-01, +8.653661827242e-01, +7.266177910000e-01 },
   {  1.49943675, +5.025229813532e-02, -2.965218283885e-01, +7.293854444760e-01, +9.257966760000e-01 },
   {  1.99695386, +6.254369926431e-02, -2.212282957601e-01, +4.708020077479e-01, +1.222375367000e+00 },
   {  2.50017836, +3.439236309188e-02, -1.278786142400e-01, +2.971153468037e-01, +1.409550342000e+00 },
   {  3.00611090, +2.084755203155e-02, -7.595737435558e-02, +1.945400819338e-01, +1.531065494000e+00 },
   {  4.01078093, +8.699371491312e-03, -4.431500943673e-02, +1.336903691896e-01, +1.612746823000e+00 },
   {  5.00451112, +2.872357822564e-03, -1.809501598526e-02, +7.098888707660e-02, +1.711153470000e+00 },
   {  5.97576436, +1.517660952330e-03, -9.531969930968e-03, +4.353511711294e-02, +1.766647116000e+00 },
   {  8.02847962, +5.208556999393e-04, -5.109870579453e-03, +2.931418207763e-02, +1.801329423000e+00 },
   { 10.01870798, +1.663194337346e-04, -1.902365247321e-03, +1.492005858228e-02, +1.844477028000e+00 },
   { 15.05572271, +4.616515845247e-05, -9.093242878034e-04, +9.324154341207e-03, +1.867947214000e+00 },
   { 19.74029093, +6.653048015306e-06, -2.117205383897e-04, +3.677435038682e-03, +1.897741935000e+00 },
   { 28.63625325, +4.429746224233e-06, -1.182205664938e-04, +2.131803424273e-03, +1.911006843000e+00 }
};



/***************************  Parameters of the camera Sony 2200S_W130 ***************************/

// core parameters:

static const vd_rvc_tstCameraParams stCameraParams_Sony2200s = 
{
   1.176,
   3.6000, 2.2040,
   0.0,    0.0,
   false
};

// radial distortion model:

static const vd_rvc_tstSplineParam astSplineParams_Sony2200s[] =
{
   {  0.26794919, -1.469915242305e-01, +0.000000000000e+00, +9.911689087724e-01, +0.000000000000e+00 },
   {  0.50952545, +3.130453990908e-02, -1.181587804452e-01, +9.595083590244e-01, +2.627551020000e-01 },
   {  0.75355405, +8.124393908271e-03, -9.547147971019e-02, +9.079003603941e-01, +4.880952380000e-01 },
   {  1.00000000, -1.505561542480e-01, -8.952372627197e-02, +8.627562390866e-01, +7.040816330000e-01 },
   {  1.48256097, -3.783462154892e-02, -2.008355896580e-01, +7.911983616309e-01, +9.090136050000e-01 },
   {  1.96261051, +6.115429442449e-02, -2.556081244537e-01, +5.709364411116e-01, +1.239795918000e+00 },
   {  2.47508685, +4.471954570943e-02, -1.675368522816e-01, +3.678058909460e-01, +1.461734694000e+00 },
   {  3.07768354, +2.431144251277e-02, -9.878372387340e-02, +2.313228946809e-01, +1.612244898000e+00 },
   {  4.01078093, +1.244222492138e-02, -5.483373994904e-02, +1.387535203770e-01, +1.721088435000e+00 },
   {  5.14455402, +3.118494306993e-03, -2.000431692527e-02, +6.892232438585e-02, +1.812925170000e+00 },
   {  5.67128182, +5.946981955915e-03, -9.397322220359e-03, +3.558753735585e-02, +1.869897959000e+00 }
};



/***************************  Parameters of the camera Panasonic XYZ (old, not used anymore; replaced by Panasonic 7.5G) ***************************/

// core parameters:

static const vd_rvc_tstCameraParams stCameraParams_Panasonic_old = 
{
   1.1293,
   3.5824, 2.6861,  // == size of the 4:3 subarea of the sensor according to the Nissan lens parameter table
   0.0,    0.0,
   false
};

// radial distortion model:

static const vd_rvc_tstSplineParam astSplineParams_Panasonic_old[] =
{
   {  0.25118264, +7.480501240961e-02, +0.000000000000e+00, +1.006922598207e+00, +0.000000000000e+00 },
   {  0.50076270, -3.259676208979e-01, +5.636916105801e-02, +1.021081552783e+00, +2.541069690000e-01 },
   {  0.75082124, -1.605727500185e-02, -1.876958940873e-01, +9.883050188741e-01, +5.073921900000e-01 },
   {  1.00000000, -2.688365006132e-02, -1.997416703173e-01, +8.914229471780e-01, +7.425387410000e-01 },
   {  1.49943675, +6.553472977067e-03, -2.198381742383e-01, +7.868725609515e-01, +9.518445050000e-01 },
   {  1.99695386, +5.088596655604e-02, -2.100190386019e-01, +5.721860737558e-01, +1.290818206000e+00 },
   {  2.50017836, +3.127667687180e-02, -1.340691215404e-01, +4.009963267366e-01, +1.529772425000e+00 },
   {  3.00611090, +1.853075226499e-02, -8.685155064213e-02, +2.898236303914e-01, +1.701598335000e+00 },
   {  4.26352176, +8.761142762542e-03, -5.872561890193e-02, +2.161714030924e-01, +1.828398123000e+00 },
   {  5.00451112, -7.384771355697e-04, -2.567655091902e-02, +1.100431987428e-01, +2.024782132000e+00 },
   {  5.67128182, +1.365694995274e-02, -2.731816203471e-02, +7.077467993689e-02, +2.091924420000e+00 }
};



/***************************  Parameters of the cameras Semco Logo, Semco Generic VFOV109 and Semco L47 ***************************/

// core parameters of the different variants:

static const vd_rvc_tstCameraParams stCameraParams_SemcoLogo = 
{
   1.1890,
   3.8400, 2.8800,
   0.0,    0.0,
   false
};

static const vd_rvc_tstCameraParams stCameraParams_SemcoGeneric_V109 = 
{
   1.1890,
   3.5760, 2.8800,
   0.0,    0.0,
   false
};

static const vd_rvc_tstCameraParams stCameraParams_SemcoL47 =   // optically identical to Semco Logo above, but we'll give it an extra struct anyway
{
   1.1890,
   3.8400, 2.8800,
   0.0,    0.0,
   false
};

// common radial distortion model for the above variants:

static const vd_rvc_tstSplineParam astSplineParams_SemcoLogo[] =
{
    {  0.25089321, +8.689035560087e-02, +0.000000000000e+00, +1.003343311020e+00, +0.000000000000e+00 },
    {  0.50007088, -2.268145967752e-01, +6.540060044356e-02, +1.019751877536e+00, +2.531042890000e-01 },
    {  0.75131808, -2.528884392461e-01, -1.041507984762e-01, +1.010096193440e+00, +5.077552570000e-01 },
    {  1.00095690, -5.842928328920e-02, -2.947633322603e-01, +9.098701366473e-01, +7.509537430000e-01 },
    {  1.50157053, +7.610332859286e-02, -3.385219846122e-01, +7.517775361533e-01, +9.588141300000e-01 },
    {  2.00450680, +6.813580673841e-02, -2.242268938663e-01, +4.700577773198e-01, +1.259873844000e+00 },
    {  2.49781377, +3.348082627119e-02, -1.214229879742e-01, +2.962179143297e-01, +1.448233810000e+00 },
    {  3.00535783, +1.955075005340e-02, -7.187401309135e-02, +2.008631564239e-01, +1.568830950000e+00 },
    {  4.00197207, +8.052486633967e-03, -4.210541209287e-02, +1.430135765514e-01, +1.654819176000e+00 },
    {  5.02486438, +2.698671807737e-03, -1.802974345577e-02, +8.308202396649e-02, +1.763498738000e+00 },
    {  6.01347578, +1.417400828173e-03, -9.748391513440e-03, +5.466798323701e-02, +1.832506308000e+00 },
    {  8.03522555, +5.278230474355e-04, -5.544615687650e-03, +3.954914206949e-02, +1.878393608000e+00 },
    { 10.00633789, +1.680503057482e-04, -2.343237318141e-03, +2.360187709290e-02, +1.940050463000e+00 },
    { 12.32122210, +9.429027848975e-05, -1.349499221417e-03, +1.632307851295e-02, +1.978755257000e+00 },
    { 13.92856177, +6.488179560758e-06, -6.946859909195e-04, +1.159102644259e-02, +2.010479394000e+00 },
    { 16.01497025, +1.059875334571e-04, -6.633998657373e-04, +9.408121169922e-03, +2.027342304000e+00 }
};



/***************  Parameters of the camera Whetron ***************/

// core parameters:

static const vd_rvc_tstCameraParams stCameraParams_Whetron = 
{
   1.2500,
   3.8400, 2.8800,
   0.0,    0.0,
   false
};

// radial distortion model:

static const vd_rvc_tstSplineParam astSplineParams_Whetron[] =
{
   {  0.25118264, -3.086605695954e-02, +0.000000000000e+00, +9.997419007558e-01, +0.000000000000e+00 },
   {  0.50076270, -1.355940349615e-01, -2.325905283527e-02, +9.938996305073e-01, +2.506286490000e-01 },
   {  0.75082124, -1.278937390795e-01, -1.247837549792e-01, +9.569510976504e-01, +4.951293690000e-01 },
   {  1.00000000, -3.651226608270e-02, -2.207265199873e-01, +8.705533027372e-01, +7.246207820000e-01 },
   {  1.49943675, +4.311087055393e-02, -2.480207637682e-01, +7.537514348801e-01, +9.272743540000e-01 },
   {  1.99695386, +4.731054430968e-02, -1.834273051775e-01, +5.382704156893e-01, +1.247230614000e+00 },
   {  2.50017836, +2.714286845504e-02, -1.128138893451e-01, +3.908853527275e-01, +1.475452983000e+00 },
   {  3.00611090, +1.759641145977e-02, -7.183701955456e-02, +2.979644901293e-01, +1.647046582000e+00 },
   {  3.51052728, +6.327657413273e-03, -4.512922806759e-02, +2.387874592586e-01, +1.781687332000e+00 },
   {  3.73205081, +5.349906585485e-02, -3.555390608060e-02, +1.980895654500e-01, +1.891465243000e+00 }
};



/***************  Parameters of the camera Panasonic 7.5G in its two possible FOV flavours ***************/

// core parameters:

static const vd_rvc_tstCameraParams stCameraParams_Panasonic_75G_V113 = 
{
   1.0900,
   3.3006, 2.3998,
   0.0,    0.0,
   false
};

static const vd_rvc_tstCameraParams stCameraParams_Panasonic_75G_V102 = 
{
   1.0900,
   3.0020, 2.1226,
   0.0,    0.0,
   false
};

// radial distortion model:

static const vd_rvc_tstSplineParam astSplineParams_Panasonic_75G[] =
{
   {  0.25118264, -1.913121994076e-01, +0.000000000000e+00, +9.922775218473e-01, +0.000000000000e+00 },
   {  0.50076270, -1.240625819526e-01, -1.441629087864e-01, +9.560663021166e-01, +2.462110090000e-01 },
   {  0.75082124, -2.988972896153e-02, -2.370535487288e-01, +8.609222757770e-01, +4.739174310000e-01 },
   {  1.00000000, +3.220229464091e-02, -2.594760946842e-01, +7.367607980785e-01, +6.739082570000e-01 },
   {  1.49943675, +5.302990998815e-02, -2.354037109476e-01, +6.134472607723e-01, +8.418807340000e-01 },
   {  1.99695386, +3.948999989379e-02, -1.559484540512e-01, +4.179916093366e-01, +1.096146789000e+00 },
   {  2.50017836, +2.327260562849e-02, -9.700760218805e-02, +2.921416432794e-01, +1.270366972000e+00 },
   {  3.25055080, +1.221090239733e-02, -6.187356570604e-02, +2.121887458944e-01, +1.395779817000e+00 },
   {  4.01078093, +6.023422469860e-03, -3.438539186322e-02, +1.399586771275e-01, +1.525321101000e+00 },
   {  5.00451112, +3.032588186921e-03, -2.064783008516e-02, +9.812076354132e-02, +1.614495413000e+00 },
   {  5.97576436, +1.492777007029e-03, -1.160710677962e-02, +6.606805900225e-02, +1.694587156000e+00 },
   {  7.02636623, +8.348369822706e-04, -7.257513265594e-03, +4.774573566197e-02, +1.749174312000e+00 },
   {  8.51259428, +4.238696402848e-04, -4.626269396465e-03, +3.526061144584e-02, +1.792293578000e+00 },
   { 10.19878895, +2.458942662862e-04, -2.736368547117e-03, +2.431805239737e-02, +1.835871560000e+00 },
   { 10.77967268, -1.567133109775e-04, -1.492491742794e-03, +1.718737071211e-02, +1.870275229000e+00 },
   { 11.43005230, +9.049014485097e-04, -1.765588380658e-03, +1.529480497736e-02, +1.879724771000e+00 }
};



#ifdef DYNGL_SUPPORT_CAM_MVC_SEMCO
/***************  Parameters of the camera MVC Semco ***************/

// core parameters:

static const vd_rvc_tstCameraParams stCameraParams_MVC_Semco = 
{
   0.9018,
   3.5840, 2.6880,
   0.0,    0.0,
   false
};

// radial distortion model:

static const vd_rvc_tstSplineParam astSplineParams_MVC_Semco[] =
{
   {  0.25118264, +1.019792439534e-01, +0.000000000000e+00, +9.982778937998e-01, +0.000000000000e+00 },
   {  0.50076270, -1.828148156642e-01, +7.684624655239e-02, +1.017580336729e+00, +2.523662210000e-01 },
   {  0.75082124, -1.602786801640e-01, -6.003455143471e-02, +1.021776200605e+00, +5.082786400000e-01 },
   {  1.00000000, -4.387368726412e-02, -1.802717096995e-01, +9.616855677933e-01, +7.575224740000e-01 },
   {  1.49943675, -1.137093984432e-02, -2.130688829301e-01, +8.636734458775e-01, +9.852822200000e-01 },
   {  1.99695386, +4.634438405415e-02, -2.301060784804e-01, +6.423355856852e-01, +1.362068629000e+00 },
   {  2.50017836, +3.878981233019e-02, -1.609347064223e-01, +4.477861044883e-01, +1.630392138000e+00 },
   {  3.00611090, +2.498047809594e-02, -1.023747538629e-01, +3.152823311478e-01, +1.819917936000e+00 },
   {  4.01078093, +1.160146946526e-02, -6.445944358745e-02, +2.308754817061e-01, +1.956459925000e+00 },
   {  5.00451112, +4.293963358717e-03, -2.949249756032e-02, +1.364847821746e-01, +2.135115465000e+00 },
   {  5.97576436, +2.392800967060e-03, -1.669137448739e-02, +9.059047422969e-02, +2.245834383000e+00 },
   {  8.02847962, +9.231368065741e-04, -9.719327411595e-03, +6.493899443962e-02, +2.320267473000e+00 },
   { 10.01870798, +2.722083134677e-04, -4.034516379059e-03, +3.670626939314e-02, +2.420599574000e+00 },
   { 10.19878895, +4.459561100862e-03, -2.409246266452e-03, +2.388171025671e-02, +2.479818580000e+00 }
};
#endif


/***************  Parameters of a "dummy" camera with f=1mm, 4:3 sensor aspect ratio, no radial distortion, and marked as "I-am-a-dummy" ***************/

// core parameters:

static const vd_rvc_tstCameraParams stCameraParams_Dummy = 
{
   1.0,
   4.0, 3.0,
   0.0, 0.0,
   true
};

// (no radial distortion model)

