/******************************************************************************/
/**
* \file    vd_rvc_tclGraphics_DynGuideline_Types.h
* \ingroup
*
* \brief
*
* \remark  Copyright : (c) 2014 Robert Bosch GmbH, Hildesheim
* \remark  Author    :
* \remark  Scope     :
*
* \todo
*/
/******************************************************************************/

#ifndef _VD_RVC_TCL_GRAPHICS_DYNGUIDELINE_TYPES_H_
#define _VD_RVC_TCL_GRAPHICS_DYNGUIDELINE_TYPES_H_

/*******************************************************************************
                        Includes
*******************************************************************************/
#ifndef    VD_RVC_TCL_GRAPHICS_DYNGUIDELINE_OSAL_IF_IMPORTED
   #define VD_RVC_TCL_GRAPHICS_DYNGUIDELINE_OSAL_IF_IMPORTED
   #define OSAL_S_IMPORT_INTERFACE_GENERIC
   #include "osal_if.h"
#endif


/*******************************************************************************
                        Defines
*******************************************************************************/


/*******************************************************************************
                        Types
*******************************************************************************/

//////////////////// public enums /////////////////////////

// possible values for the general guideline style/layout
// (CAUTION: values are used not only inside the DynGl component itself, but also e.g. in dispvidctrl_tclControl_Video_GdlAdj.cpp,
//  so check for other places where they might be used whenever you add a new style!)
enum {
   DYN_GUIDELINE_STYLE_UNDEFINED,  // 0
   DYN_GUIDELINE_STYLE_NISSAN,     // 1
   DYN_GUIDELINE_STYLE_RENAULT,    // 2
   DYN_GUIDELINE_STYLE_MITSUBISHI, // 3 - currently mapped to Nissan because no Mitsubishi style is currently specified (only the ID is reserved in the Diag spec)
   DYN_GUIDELINE_STYLE_NISSAN_US,  // 4
   DYN_GUIDELINE_STYLES_COUNT,
};


//////////////////// public types /////////////////////////

/* a public type to hold (and pass to us) the vehicle specific guideline parameters as read from KDS */
struct vd_rvc_tstKdsVehicleConfig
{
   const tU8* pu8ConfigString;
   tU8        u8CameraId;
};

/* a public type to hold (and pass to us) the RVC image capturing parameters */
struct vd_rvc_tstCaptureAreaParams
{
   // size of the full video image as used as input for capturing (in video image - e.g. NTSC - pixels)
   tU32 u32NumVideoImgXpix;
   tU32 u32NumVideoImgYpix;
   // size of the captured part of the video image (i.e. the part which will be mapped to the output image) (in video image - e.g. NTSC - pixels)
   tU32 u32NumCaptureAreaXpix;
   tU32 u32NumCaptureAreaYpix;
   // offset of the captured part of the video image within the full video image (set to (0,0) if upper left corner of captured area == upper left corner of full video image area)
   tU32 u32CaptureAreaXoffs;  // offset from left (in video image - e.g. NTSC - pixels)
   tU32 u32CaptureAreaYoffs;  // offset from top (in video image - e.g. NTSC - pixels)
};

/* a public type to hold (and pass to us) the output screen image area */
struct vd_rvc_tstImageAreaParams
{
   // width and height of output image area (may be smaller than screen/buffer width/height if output image area doesn't cover the whole screen)
   tU32 u32NumImgXpix;
   tU32 u32NumImgYpix;
   // offset of the output image area within the screen/buffer area (in pixels; set to (0,0) if upper left corner of image area == upper left corner of screen)
   tU32 u32ImgXoffs;  // offset from left
   tU32 u32ImgYoffs;  // offset from top
};

/* a public type to hold (and pass to us) the full screen buffer's parameters */
struct vd_rvc_tstOutputBufferParams
{
   tVoid* pvBuf;          // start of buffer area
   tU32   u32NumBufXpix;  // number of logical pixels per row (usually ==screen width in pixels) 
   tU32   u32NumBufYpix;  // number of logical rows in the buffer (usually ==screen height in pixels) 
   // so total expected RAM size behind pvBuf is (u32NumBufXpix * u32NumBufYpix * NumBytesPerPixel) bytes (with e.g. NumBytesPerPixel==4 for RGBA)
};


//////////////////// component-local types /////////////////////////

/* an internally used type holding the values used to compute varying plotting line widths along a guideline */ 
struct vd_rvc_tstLineWidthDef
{
   // externally supplied input parameters;
   tU8 u8Near;  // width at near end (in pixel)
   tU8 u8Far;   // width at far end (in pixel)
   // additional internally used derived guideline width parameters:
   tS8 s8Delta; // width decrease (or maybe increase) towards the far end (in pixel)
   tU8 u8LoLim; // lower width limit = the lesser of the two widths at near and far end (in pixel)
   tU8 u8HiLim; // lower width limit = the greater of the two widths at near and far end (in pixel)
};

/* an internally used type to hold the measured offsets of the guideline reference points of one line (left or right) */
struct vd_rvc_tstTuneOffsParams
{
   tDouble dNearDx, dNearDy;   // x/y offset of near reference point (in cm)
   tDouble dFarDx;             // x offset of far reference point (in cm)
   tDouble dNearLineLen;       // required length of the line part extending from the near reference point towards the vehicle (in cm)
};

/* an internally used type to hold the guideline tuning/calibration input parameters */
struct vd_rvc_tstTuneParams
{
   tU8     u8TuneStrVersNo;              // tuning string version number
   tU8     u8Method;                     // tuning method/algorithm to use (0x00 = none)
   tDouble dCamYaw;                      // yaw   (in radians) - positive values = left if looking back
   tDouble dCamPitch;                    // pitch (in radians) - positive values = down
   tDouble dCamRoll;                     // roll  (in radians) - positive values = counter-clockwise if looking at camera lens
   vd_rvc_tstTuneOffsParams  stOffsLft;  // measured offsets of the left guideline's reference points
   vd_rvc_tstTuneOffsParams  stOffsRgt;  // measured offsets of the right guideline's reference points
   tDouble dSwaZeroOffset;               // steering wheel angle zero point offset (in degrees)
   tDouble dRwaZeroOffset;               // rear wheel angle zero point offset (in degrees)
};

/* an internally used type holding the above parameters converted to real numbers and scaled for the respective units */
struct vd_rvc_tstVehicleParams
{
   // config string version number
   tU8     u8CfgStrVersNoHi;      // major
   tU8     u8CfgStrVersNoLo;      // minor
   
   // vehicle dimensions
   tDouble dVehWidth;             // width (= distance between outer rear tire edges) in units of 1 cm
   tDouble dWheelBase;            // wheelbase (= distance between front and rear axle) in units of 1 cm
   tDouble dRearOverhang;         // rear overhang (= distance between rear axle and rear end of bumper) in units of 1 cm
   tDouble dSWAtoFWA_Coeff1;      // linear coefficient for the SWA-to-FWA conversion polynomial (SWA = Steering Wheel Angle, FWA = Front Wheel Angle) (in units of 1E-5)
   tDouble dSWAtoFWA_Coeff3;      // cubic coefficient for the SWA-to-FWA conversion polynomial (in units of 1E-10);   usage: FWA = Coeff1*SWA + Coeff3*SWA^3
   tDouble dMaxSteerWhlAngle;     // steering wheel saturation angle (= mechanically max. possible steering wheel angle) (in units of 1 degree)
   tDouble dMaxRearTireAngle;     // rear wheel saturation angle (= mechanically max. possible rear tire angle) (in degrees)   
   tDouble dRadiusTuningFact;     // empirical tuning factor theoretical=>actual steering radius 
   tBool   bFourWheelSteering;    // specifies whether or not the vehicle uses four wheel steering
   tBool   bPosTireAngleIsCcw;    // specifies whether or not a positive steering angle value indicates a counter-clockwise tire turn (i.e. to the left)
   tU8     u8TireAngleRefPoint;   // specifies whether tire angles refer to the (front) axle center (0), outer tire (1), or inner tire (2) 
   tBool   bIsATestConfig;        // flag to indicate whether or not this is a default/test configuration (<=> drawing of warning indicators)

   // camera mount position in the ground coordinate system (all coordinates in units of 1 cm);
   //   (x,y,z)=(0,0,0) is the point on the road surface below the central point of the rear edge of the bumper
   tDouble dCamXOffs;             // x - distance camera <-> vehicle center axis ; positive values = towards the right if looking back
   tDouble dCamYOffs;             // y - distance camera <-> bumper rear edge ; positive values = towards vehicle front
   tDouble dCamZOffs;             // z - height above ground (always positive, naturally)
   
   // camera mount angles, in degrees
   tDouble dCamYaw;               // yaw   - positive values = left if looking back
   tDouble dCamPitch;             // pitch - positive values = down
   tDouble dCamRoll;              // roll  - positive values = counter-clockwise if looking at camera lens

   // guideline drawing control parameters, in degrees
   tDouble dFrontTireThresh;      // minimum absolute front tire angle value required to draw dynamic guidelines (see note #1 below)
   tDouble dMinFrontTireChg;      // minimum absolute front tire angle change required to update dynamic guidelines
   tDouble dRearTireThresh;       // minimum absolute rear tire angle value required to draw dynamic guidelines (see notes #1 and #2 below)
   tDouble dMinRearTireChg;       // minimum absolute rear tire angle change required to update dynamic guidelines (see note #2 below)
   // note #1: in the 2WS case, dyn. guidelines will be hidden if FWA<dFrontTireThresh; in the 4WS case, this happens only if *both* FWA *and* RWA fall below their respectve hiding threshold
   // note #2: dRearTireThresh and dMinRearTireChg are not used directly by the component; see comments on dEffRearTireThresh and dEffMinRearTireChg further down)
   
   // general guideline layout parameters
   tU8     u8GuidelnStyle;        // brand dependent general guideline style/layout; e.g. 1=Nissan, 2=Renault, ...
   tDouble dGuidelnStartDist;     // distance from the vehicle rear end to the spot where the (untuned) static and dynamic guidelines start ("crop" distance; in cm)
   tDouble dGuidelnLatMargin;     // lateral safety margin between the left/right vehicle side and the corresponding guidelines (in cm)
   tU8     au8GuidelnRgb[5][3];   // RGB values (in that order) for (in that order) the near/middle/far end of the static side lines, the static center guideline and the dynamic guidelines

   // customer specific layout parameters
   // Renault
   tU8     au8GuidelnStatLen[4];  // single lengths of the near, middle and far parts of the static guidelines (in cm)
   tDouble dGuidelnLenHorBar;     // length of the horizontal static guideline bars (in cm; within the SW limited to the range 5...68)
   tFloat  fLineWdthWgtNearHbar;  // line width weight factor for the closest horizontal static line (range 1.0...2.0)
   // Nissan
   tFloat  fLineWdthWgtVertLines; // line width weight factor for "vertical" static lines (needed in the context of CRQ402 = US/CAN/FMVSS-specific guideline style)
   

   ////// derived values - not to be modified "from outside"!!!
   
   // camera mount angles, in radians
   tDouble dCamYawRad;            // yaw   - positive values = left if looking back
   tDouble dCamPitchRad;          // pitch - positive values = down
   tDouble dCamRollRad;           // roll  - positive values = counter-clockwise if looking at camera lens

   // effective rear wheel angle hiding threshold and hysteresis
   tDouble dEffRearTireThresh;    // set in vd_rvc_tclGraphics_DynGuideline::vInitConfig(), depending on the configured values of 2WS/4WS, dFrontTireThresh ("master" setting) and dRearTireThresh
   tDouble dEffMinRearTireChg;    // ditto, depending on the configured 2WS/4WS, dMinFrontTireChg and dMinRearTireChg
   
   // layout parameters
   tDouble dGuidelnOffs;          // lateral offset of the left resp. right guideline from the vehicle center axis (= vehicle width / 2 + lateral safety margin)
   tDouble dGuidelnLenDyn;        // length of the dynamic guidelines (i.e. the arc length of the "virtual" center guideline)
   tBool   bConnectDynGlEnds;     // controls whether or not the far ends of the left and right dynamic guideline get connected by a line
   tDouble dDistScaleForLineWidthCalc;  // a helper for calculation of distance-dependent line widths (used in vCalcLineWidth())
   vd_rvc_tstLineWidthDef  astLineWidth[3];  // guideline width parameters for static side lines, dynamic lines, and static center line (in that order)
   
   tDouble adGuidelnStatDist[4];  // accumulated lengths of the near, middle and far parts of the static guidelines (in cm)

   // tuning parameters
   vd_rvc_tstTuneParams  stTuneParams;
   
   // camera ID value from KDS
   tU8     u8CameraType;

   // further internally defined parameters
   tFloat  fLineWidthScalingFact; // used to adjust the thickness of all plotted lines to the output image area size - the smaller the guideline image, the thinner the lines)
};


#endif
