/******************************************************************************/
/**
* \file    vd_rvc_tclGraphics_DynGuideline_Calib.h
* \ingroup
*
* \brief
*
* \remark  Copyright : (c) 2015 Robert Bosch GmbH, Hildesheim
* \remark  Author    :
* \remark  Scope     :
*
* \todo
*/
/******************************************************************************/

#ifndef _VD_RVC_TCL_GRAPHICS_DYNGUIDELINE_CALIB_H_
#define _VD_RVC_TCL_GRAPHICS_DYNGUIDELINE_CALIB_H_

/*******************************************************************************
                        Includes
*******************************************************************************/
#ifndef    VD_RVC_TCL_GRAPHICS_DYNGUIDELINE_OSAL_IF_IMPORTED
   #define VD_RVC_TCL_GRAPHICS_DYNGUIDELINE_OSAL_IF_IMPORTED
   #define OSAL_S_IMPORT_INTERFACE_GENERIC
   #include "osal_if.h"
#endif

#ifndef    _VD_RVC_TCL_GRAPHICS_DYNGUIDELINE_TYPES_H_
   #include "vd_rvc_tclGraphics_DynGuideline_Types.h"
#endif
#ifndef    _VD_RVC_TCL_GRAPHICS_DYNGUIDELINE_UTIL_H_
   #include "vd_rvc_tclGraphics_DynGuideline_Util.h"
#endif

/*******************************************************************************
                        Defines 
*******************************************************************************/

// defines to identify the various available guideline tuning/calibration methods
// no tuning:
#define DYN_GUIDELINE_TUNEMETH_NONE                                    0x00
// include yaw/pitch/roll tuning angles in the ground2cam transformation matrix:
#define DYN_GUIDELINE_TUNEMETH_USE_YAW_PITCH_ROLL                      0x01
// include input pitch tuning angles in the ground2cam matrix, use input x/y offsets to shift and rotate the lines in the xy plane (=original Renault method):
#define DYN_GUIDELINE_TUNEMETH_USE_PITCH_TUNE_DXY                      0x02
// use input x/y offsets to calculate estimates for the yaw/roll tuning angles and include them plus the input pitch tuning angle in the ground2cam matrix:
#define DYN_GUIDELINE_TUNEMETH_USE_PITCH_CALC_YAW_ROLL                 0x03
// as the preceding, but additionally compute the residual dx/y offsets which remain after angle tuning and use them to shift and rotate the lines:
#define DYN_GUIDELINE_TUNEMETH_USE_PITCH_CALC_YAW_ROLL_CORR_RESID      0x04
// use input x/y offsets to calculate estimates for the yaw/pitch/roll tuning angles and include them in the ground2cam matrix:
#define DYN_GUIDELINE_TUNEMETH_CALC_YAW_PITCH_ROLL                     0x05
// as the preceding, but additionally compute the residual dx/y offsets which remain after angle tuning and use them to shift and rotate the lines:
#define DYN_GUIDELINE_TUNEMETH_CALC_YAW_PITCH_ROLL_CORR_RESID          0x06
// use input x/y offsets to calculate estimates for the yaw/roll tuning angles and to improve the input pitch tuning angle, and include them in the ground2cam matrix:
#define DYN_GUIDELINE_TUNEMETH_IMPROVE_PITCH_CALC_YAW_ROLL             0x07
// as the preceding, but additionally compute the residual dx/y offsets which remain after angle tuning and use them to shift and rotate the lines:
#define DYN_GUIDELINE_TUNEMETH_IMPROVE_PITCH_CALC_YAW_ROLL_CORR_RESID  0x08



/*******************************************************************************
   Class vd_rvc_tclGraphics_DynGuideline_Calib
*******************************************************************************/

/*** forward declarations ***/

class vd_rvc_tclCamPoint;


/*** class specific helper types ***/

struct vd_rvc_tstSingleSideCalib
{
   vd_rvc_t2Vector     oShiftDxy; // the line's linear x/y shift
   vd_rvc_t2Vector     oRotCenXy; // the "pivot point" around which the line shall be rotated after the shift
   vd_rvc_tcl2x2Matrix oRotation; // the rotation matrix
   tDouble             dNearLen;  // the length of the line's near segment from the near reference point towards the vehicle
                                  // (if 0 => not specified => derive from global crop distance)
};

//struct stTest;

/*** class declarations ***/

class vd_rvc_tclGraphics_GuidelineCalib
{
   private:
#ifdef EIS2HI_DEB_TEST_ENV
   public:
#endif
      static tBool                           m_bTuningEnabled;
      static tBool                           m_bShiftAndRot;
      static tDouble                         m_dDefaultCropDist;

      static const vd_rvc_tstVehicleParams * m_ptVehParams;
      static vd_rvc_tstTuneParams            m_stTuneParams;
      static tDouble                         m_dNearRefYpos;
      static tDouble                         m_dFarRefYpos;
      static tDouble                         m_dGuidelnOffs;
      static tDouble                         m_dInputTunePitch;
      
      static vd_rvc_tstSingleSideCalib       m_stLftCalib;
      static vd_rvc_tstSingleSideCalib       m_stRgtCalib;
   
   public:
      // constructor / desctructor
      vd_rvc_tclGraphics_GuidelineCalib(tVoid);
      ~vd_rvc_tclGraphics_GuidelineCalib();
         
      static tVoid   vSetConfig(const vd_rvc_tstVehicleParams * ptVehParams);
      
      static tDouble vGetLineCropDistance(tDouble dTuneSide);
      static tVoid   vTunePoint(vd_rvc_t3Vector *poPoint, tDouble dTuneSide); 
      
   private:
      static tBool   bEstimateYawAndRoll(tVoid);
      static tBool   bEstimateYawPitchAndRoll(tVoid);
      static tVoid   vCalcGuidelnVarianceForTuningOffsets(vd_rvc_t3Vector *poVariance);
      static tVoid   vCalcGuidelnVarianceParams(const vd_rvc_tclCamPoint &poLftFrom, const vd_rvc_tclCamPoint &poLftTo,
                                                const vd_rvc_tclCamPoint &poRgtFrom, const vd_rvc_tclCamPoint &poRgtTo, vd_rvc_t3Vector *poVariance);
      static tVoid   vCalcGuidelnVarianceWithTuningAngle(tU32 u32VarAngleId, vd_rvc_t3Vector *poVariance);
      static tVoid   vSetupVariedTuningAngle(tU32 u32VarAngleId, tDouble dVarAngleVal);
      
      static tBool   bCalcResidualXyOffsets(tVoid);
      static tBool   bCalcRequiredGroundCoordinateOffset(const vd_rvc_tclCamPoint &oPGoal, vd_rvc_t2Vector *oDxyGround);
      
      static tVoid   vResetLineShiftAndRot(tBool bLeftCurve);
      static tVoid   vSetupLineShiftAndRot(tBool bLeftCurve);

      static tVoid   vTuneXyCoords(vd_rvc_t2Vector *poPoint, tBool bLeftCurve);
};


#endif
