/******************************************************************************/
/**
* \file    vd_rvc_tclGraphics_DynGuideline.h
* \ingroup
*
* \brief
*
* \remark  Copyright : (c) 2014 Robert Bosch GmbH, Hildesheim
* \remark  Author    :
* \remark  Scope     :
*
* \todo
*/
/******************************************************************************/

#ifndef _VD_RVC_TCL_GRAPHICS_DYNGUIDELINE_H_
#define _VD_RVC_TCL_GRAPHICS_DYNGUIDELINE_H_

/*******************************************************************************
                        Includes
*******************************************************************************/
#ifndef    VD_RVC_TCL_GRAPHICS_DYNGUIDELINE_OSAL_IF_IMPORTED
   #define VD_RVC_TCL_GRAPHICS_DYNGUIDELINE_OSAL_IF_IMPORTED
   #define OSAL_S_IMPORT_INTERFACE_GENERIC
   #include "osal_if.h"
#endif

#ifndef    _VD_RVC_TCL_GRAPHICS_DYNGUIDELINE_TYPES_H_
   #include "vd_rvc_tclGraphics_DynGuideline_Types.h"
#endif

/*******************************************************************************
                        Defines
*******************************************************************************/

// to be used when calling the guideline drawing API method bDraw()
#define DYN_GUIDELINE_DRAW_NONE            0x00
#define DYN_GUIDELINE_DRAW_DYNAMIC         0x01
#define DYN_GUIDELINE_DRAW_STATIC_SIDE     0x02
#define DYN_GUIDELINE_DRAW_STATIC_CENT     0x04
#define DYN_GUIDELINE_FORCE_UPDATE         0x08


/*******************************************************************************
   Class vd_rvc_tclGraphics_DynGuideline
*******************************************************************************/


/*** forward declarations ***/

class  vd_rvc_tclGraphics_DynGuideline_Plotter;
class  vd_rvc_tclCamera;
class  vd_rvc_tclCamPoint;
struct tstDynLineTrackGeometry;

/*** class declarations ***/

class vd_rvc_tclGraphics_DynGuideline
{
   private:
      static vd_rvc_tclGraphics_DynGuideline_Plotter m_oLinePlotter;
      static vd_rvc_tstVehicleParams                 m_tVehParams;
      static vd_rvc_tstImageAreaParams               m_tImgParams;
      static vd_rvc_tstCaptureAreaParams             m_tCapParams;
      static vd_rvc_tstOutputBufferParams            m_tBufParams;
      static const vd_rvc_tclCamera *                m_poCamera;
      static tDouble                                 m_dLastUsedFrontAng;
      static tDouble                                 m_dLastUsedRearAng;
      static tU32                                    m_u32LastMode;
      
      static tBool                                   m_bBufCfgValid;
      static tBool                                   m_bVehCfgValid;
      static tBool                                   m_bImgCfgValid;
      static tBool                                   m_bCamCfgValid;
      static tBool                                   m_bCapCfgValid;
      static tBool                                   m_bCanDraw;
      static tBool                                   m_bIsRealCfg;
      static tBool                                   m_bWarnIfTestCfg;
      
      static tBool                                   m_bTempCalibStyleActive;
      static tBool                                   m_bLastTempCalibStyleActive;
      static tBool                                   m_bDoFullClearBeforeNextPlot;

   public:
      // constructor / desctructor
      vd_rvc_tclGraphics_DynGuideline(tVoid);
      ~vd_rvc_tclGraphics_DynGuideline();
      // pre-drawing configuration
      tVoid vSetOutBuffer    (const vd_rvc_tstOutputBufferParams * pstBufParams    ) const;
      tVoid vSetImageConfig  (const vd_rvc_tstImageAreaParams    * pstImgParams    ) const;
      tVoid vSetCaptureConfig(const vd_rvc_tstCaptureAreaParams  * pstCaptureParams) const;
      tVoid vSetVehicleConfig(const vd_rvc_tstKdsVehicleConfig   * pstKdsVehParams ) const;
      tVoid vSetVehicleConfig(const char                         * sPredefCfgName  ) const;
      tVoid vSetCalibConfig  (const tU8                          * pu8CalibString  ) const;
      // EOL camera selection and configuration support
      tVoid vSelectCamera                  (tU8 u8CameraType                                     ) const;
      tBool bSetParamsOfConfigurableCamera (const tU8                          * pu8EolCfgString ) const;
      
      // configuration adjustment screen support
      inline vd_rvc_tstVehicleParams* vGetVehicleConfigPtr(tVoid) const { return & m_tVehParams; }
      tVoid vIndVehicleConfigChanged(tVoid) const;
      // the guideline drawing API
      tBool bDraw(tDouble dSteerWheelAngleDeg, tU32 u32Mode=DYN_GUIDELINE_DRAW_DYNAMIC, tDouble dRearWheerAngle=0.0) const;
      // misc
      tVoid vSetTemporaryCalibGuidelnStyle(tBool bActive) const;
      tVoid vAllowWarningIndIfUsingDummyConfig(tBool bAllow) const;
      tVoid vTraceDebugInformation(tVoid) const;
      
   private:
      // configuration handling
      tVoid   vInitConfig(tVoid) const;
      tVoid   vSetupCamera(tVoid) const;
      // steering angle input evaluation
      tBool   bEvalSteerAngleInput(tDouble dSteerWheelAngleDeg, tDouble *pdFrontWheelAngleDeg, tDouble *pdRearWheelAngleDeg, tU32 *pu32Mode) const;
      // main drawing routines
      tVoid   vDrawLines(tDouble dFrontWheelAngleDeg, tDouble dRearWheelAngleDeg, tU32 u32Mode) const;
      tVoid   vDrawDynamicLines(tDouble dFrontWheelAngleDeg, tDouble dRearWheelAngleDeg) const;
      tVoid   vDrawStaticLines(tU32 u32Mode) const;
      tVoid   vDrawStaticLines_Renault(tU32 u32Mode) const;
      tVoid   vDrawStaticLines_Nissan(tU32 u32Mode) const;
      tVoid   vDrawStaticLines_NissanCalib(tU32 u32Mode) const;
      tVoid   vDrawWarningIndicator(tVoid) const;
      // helper routines used by the drawing routines
      tVoid   vCalcTrackGeometry(tstDynLineTrackGeometry *pstGeom, tDouble dFrontWheelAngleDeg, tDouble dRearWheelAngleDeg) const;
      tFloat  fCalcLineWidth(tU32 u32LwidthIdx, tDouble dYsta, tDouble dYend) const;
      tBool   bDrawConnectingLine(vd_rvc_tclCamPoint *poPSta, vd_rvc_tclCamPoint *poPEnd, tFloat fLineWidth, tU32 u32MinLen, tBool bAddHead, tBool bAddTail) const;
};


#endif
