/************************************************************************
* FILE:        I_dispvidctrl_tclVideoPlayer.h
* PROJECT:
* SW-COMPONENT:vd_dimming
*----------------------------------------------------------------------
*
* DESCRIPTION: interface of configuration manager class
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author             | Modification
* 20.08.2015| CM-AI/EPB2 Bernard | init
*
*************************************************************************/

#ifndef I_dispvidctrl_tclVideoPlayer_H_
#define I_dispvidctrl_tclVideoPlayer_H_

#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#endif //#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC

#include "dispvidctrl_AppMain.h"
#include "vd_rvc_tclGraphics_DynGuideline_Types.h"

/*******************************************************************************
                        Defines
*******************************************************************************/
#define VIDEOPLAYER_DAY                       0
#define VIDEOPLAYER_NIGHT                     1


enum {
   COMMIT_CHANGES = 0,
   LAYER_VISIBILITY,
   LAYER_OPACITY,
   LAYER_SOURCE_RECTANGLE,
   LAYER_DESTINATION_RECTANGLE,
   SURFACE_VISIBILITY,
   SURFACE_OPACITY,
   SURFACE_SOURCE_RECTANGLE,
   SURFACE_DESTINATION_RECTANGLE
};


class I_dispvidctrl_tclVideoPlayer : public dispvidctrl_tclBaseIf
{
public:
    // constructor
    I_dispvidctrl_tclVideoPlayer(tVoid);
    I_dispvidctrl_tclVideoPlayer(const dispvidctrl_tclAppMain* poMainAppl) : dispvidctrl_tclBaseIf(poMainAppl) {;};
    // destructor
    virtual ~I_dispvidctrl_tclVideoPlayer(){};

    virtual const tChar* getIfName() const { return "I_dispvidctrl_tclVideoPlayer"; };


    // Rvc interface
    virtual tVoid vActivateRvc(tBool bActivationState) = 0;
    virtual tVoid vSetWarningTextLanguage(tU8 u8Language) = 0;
    virtual tVoid vSetGuideLineVisibility(tU32 u32Visibility) = 0;
    virtual tVoid vSetWarningTextVisibility(tU32 u32Visibility) = 0;

    virtual tVoid vSetSteeringWheelAngle(tS32 s32SteeringWheelAngle) = 0;
    virtual tVoid vSetRearWheelAngle(tS32 s32RearWheelAngle) = 0;
    virtual tVoid vSetNight(tU8 u8Night) = 0;
    virtual tVoid vSetHandoverReady() = 0;
    virtual tVoid vShowRvc() = 0;
    virtual tVoid vShowBlackScreen(tU8 u8BlackScreenType) = 0;
    virtual tVoid vPreInitGraphics() = 0;
    virtual tVoid vSetCropping(tU32 u32CropUp, tU32 u32CropDown, tU32 u32CropLeft, tU32 u32CropRight) = 0;
    virtual tBool bCroppingParametersInRange(tU32 u32CropUp, tU32 u32CropDown, tU32 u32CropLeft, tU32 u32CropRight) = 0;
    virtual tVoid vSetCameraImageMirror(tU32 u32CameraImageMirror) = 0;
    virtual tVoid vSetLayerOrSurfaceSettings(tU8, tU16, tU32, tU32, tU32, tU32, tBool) = 0;
    virtual tVoid vReConfigGuidelineParams(tU8, tU8) = 0;
	virtual tVoid GraphicslayerVisibility(unsigned int visibility) = 0;

    
    virtual tVoid vSetHmiAvailable() = 0;
    
    virtual tBool bIsVideoSourceFound() const = 0;
    virtual tBool bFindVideoSource() const = 0;

    virtual tVoid vGetRvcState(tBool& bVideoActive, tBool& bRvcErrorVal) = 0;
    virtual tU8 u8GetCameraConnectionType() = 0;

    virtual tVoid vHandleFirstFrameRendered(tVoid) = 0;
    virtual tVoid vSetAllRvcObjects(tVoid) = 0;
    virtual tVoid vStartRVCPlaying(tVoid) = 0;

    virtual tVoid vIndVehicleConfigChanged_DynGuideline(tVoid) = 0;
    virtual vd_rvc_tstVehicleParams* vGetVehicleConfigPtr_DynGuideline(tVoid) = 0;
    virtual tVoid vSetVehicleConfig_DynGuideline(tVoid) = 0;
    virtual tVoid vSetTemporaryCalibGuidelnStyle(tBool bActive) = 0;

    virtual tVoid vSetLVDSBrightness(tU16 u16Brightness, tU16 u16BlackLevel) = 0;
    virtual tVoid vSetLVDSColour(tU16 u16Colour) = 0;
    virtual tVoid vSetLVDSContrast(tU16 u16Contrast) = 0;
    virtual tVoid vSetLVDSHue(tU16 u16Hue) = 0;

    // Animation interface
    virtual tVoid vStartAnimation(tBool bActivationState, tBool bOnlyLastFrame=FALSE) = 0;
    virtual tVoid vPrepareAnimation(tVoid) = 0;
//initial blackscreen in portrait
    virtual tVoid vSetInitialblackscreen(tU8 u8camConfigType) = 0;

};

#endif /* I_dispvidctrl_tclVideoPlayer_H_ */
