/* ******************************************************FileHeaderBegin** *//**
 *
 * @file        dev_spm_sys_state.c
 *  ShortInfo
 *
 *  LongInfo
 *
 * @date        2009-03-14
 *
 * @note
 *
 *  &copy; Copyright Robert Bosch Car Multimedia. All Rights reserved!
 *
 *//* ***************************************************FileHeaderEnd******* */

/* TENGINE Header */
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#include "dispvidctrl_tclSyncHandler_fsm.h"

dispvidctrl_tclSyncHandlerFsmBase::dispvidctrl_tclSyncHandlerFsmBase(tU32 u32InitFsmSTate, tU32 u32MaxTransitionEntry, TStateTransitions* paFsmTransitionTable,  tU32 u32MaxStateEntry, TFsmStateConf* paFsmStateTable, tU32 u32TraceClass) {

   _u32CurrentTrigger = 0;
   _u32Trigger = 0;
   _u32CurrentTriggerUpdate = 0;
   _u32TriggerUpdate = 0;
   _u32LastTransitionId = 0;
   _u32TimeOut = 0;
   _u32FsmState = u32InitFsmSTate;
   _u32LastFsmState = u32InitFsmSTate;

   _u32MaxStateEntry = u32MaxStateEntry;
   _paFsmStateTable = paFsmStateTable;

   _u32MaxTransitionEntry = u32MaxTransitionEntry;
   _paFsmTransitionTable = paFsmTransitionTable;

   _u32TraceClass = u32TraceClass;

}

dispvidctrl_tclSyncHandlerFsmBase::~dispvidctrl_tclSyncHandlerFsmBase(){
   _paFsmStateTable = NULL;
   _paFsmTransitionTable = NULL;
}

tVoid dispvidctrl_tclSyncHandlerFsmBase::vSendTriggerViaWorker(tU32 u32Trigger, tBool bState){
   (tVoid) u32Trigger;
   (tVoid) bState;
   return;
}
tVoid dispvidctrl_tclSyncHandlerFsmBase::vStateChangeDetected(){
   return;
}


tVoid dispvidctrl_tclSyncHandlerFsmBase::vStartFsmStateTimer(tU32 u32Time)
/*!
* \fn
*  \brief
*    Start state timer. 
*    
*  \param
*     u32Time  -> intervall time in ms
*  \return
*  \note
*  \bug
*    no bugs known
*  \todo
*    nothing left
*  \version
*    1.0   - Initial
******
*/
{
   (tVoid) u32Time;
   return;
}

tVoid dispvidctrl_tclSyncHandlerFsmBase::vActStateExit(tU32 u32FsmState)
/*!
* \fn
*  \brief
*    Called when new system state detected by state machine and current state is leaved. 
*    
*  \param
*  \return
*    tVoid
*
*  \note
*  \bug
*    no bugs known
*  \todo
*    nothing left
*  \version
*    1.0   - Initial
******
*/
{
   tBool bFound;
   const TFsmStateConf *prStateDescr;

   if (u32FsmState < _u32MaxStateEntry)
   {
      bFound = FALSE;
      prStateDescr = _paFsmStateTable;

      /* while state not found and not end of state table */
      while ( (bFound==FALSE) && (prStateDescr < (_paFsmStateTable + _u32MaxStateEntry) ) )
      {
         /* if state is active */
         if (u32FsmState == prStateDescr->u32FsmState)
         {
            /* call state exit function */
            bFound=TRUE;
            if (prStateDescr->pfnvStateExit) {
               (* prStateDescr->pfnvStateExit)();
            }
         }
         prStateDescr++;
      }
   }
}

tU32 dispvidctrl_tclSyncHandlerFsmBase::u32ActStateEntry(tU32 u32NewFsmState) 
/*!
* \fn
*  \brief
*    Called when new system state detected by state machine and current state has to be entered. 
*    
*  \param
*     u32NewSystemState -> system state detected by state machine
*  \return
*     u32Timeout -> timeout value in ms for new system state
*    
*  \note
*  \bug
*    no bugs known
*  \todo
*    nothing left
*  \version
*    1.0   - Initial
******
*/
{
   tBool bFound;
   const TFsmStateConf *prStateDescr;
   tU32 u32Timeout = 0;

   if (u32NewFsmState < _u32MaxStateEntry)
   {
      bFound = FALSE;
      prStateDescr = _paFsmStateTable;

      /* while state not found and not end of state table */
      while ( (bFound==FALSE) && (prStateDescr < (_paFsmStateTable + _u32MaxStateEntry) ) )
      {
         /* if state is active */
         if (u32NewFsmState == prStateDescr->u32FsmState)
         {
            /* call state exit function */
            bFound=TRUE;
            if (prStateDescr->pfnvStateEntry) {
               (* prStateDescr->pfnvStateEntry)();
            }
            u32Timeout = prStateDescr->u32Timeout;
         }
         prStateDescr++;
      }
   }
   return u32Timeout;
}

tVoid dispvidctrl_tclSyncHandlerFsmBase::vActStateReached(tU32 u32FsmState) 
/*!
* \fn
*  \brief
*    Called when new system state is reached -> all applications has acknowledged transition. 
*    
*  \param
*     u32SystemState -> system state entered
*  \return
*    
*  \note
*  \bug
*    no bugs known
*  \todo
*    nothing left
*  \version
*    1.0   - Initial
******
*/
{
   tBool bFound = FALSE;
   const TFsmStateConf *prStateDescr;

   if (u32FsmState < _u32MaxStateEntry)
   {
      bFound = FALSE;
      prStateDescr = _paFsmStateTable;

      /* while state not found and not end of state table */
      while ( (bFound==FALSE) && (prStateDescr < (_paFsmStateTable + _u32MaxStateEntry) ) )
      {
         /* if state is active */
         if (u32FsmState == prStateDescr->u32FsmState)
         {
            /* call state exit function */
            bFound=TRUE;
            if (prStateDescr->pfnvStateReached) {
               (* prStateDescr->pfnvStateReached)();
            }
         }
         prStateDescr++;
      }
   }

   if (bFound == FALSE) {
      // System state SPM_SYSTEM_OFF is reached --> call method directly
      //vStateReachedOff();
   } 
   return;
}

/******************************************************************************/
/* FUNCTION     vUpdateTrigger                                                */
/******************************************************************************/
/**
*  \brief       to modify "hold" trigger information without doing an state change
*
*  \param       Trigger and State
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclSyncHandlerFsmBase::vUpdateTrigger(tU32 u32Trigger, tBool bState)
{
   if (bState) {
      _u32Trigger |= u32Trigger;
   } else {
      _u32Trigger &= ~u32Trigger;
   }
}


//state handling
tU32 dispvidctrl_tclSyncHandlerFsmBase::u32CalcNewFsmState(tU32 u32Trigger, tBool bState)
/*!
* \fn
*  \brief
*    check for new system state in state transition table _arStateTable[].  
*    
*  \param
*     u32PreviousSystemState -> last valid system state
*     u32NewSystemState      -> new system state, if different to u32PreviousSystemState, system state transition is still active 
*  \return
*     u32CalcNewSystemState  -> new calculated system state
*  \note
*  \bug
*    no bugs known
*  \todo
*    nothing left
*  \version
*    1.0   - Initial
******
*/
{
   tU32 u32CalcNewSystemState = 0xffffffff;

   tU32 u32TransitionId = FSM_U32_TRANSITION_ID_INVALID;

   _u32TriggerUpdate |= u32Trigger;

   if (bState) {
      _u32Trigger |= u32Trigger;
   } else {
      _u32Trigger &= ~u32Trigger;
   }

   ET_TRACE_INFO_BIN( _u32TraceClass,
         ET_EN_T16 _  DISPVIDCTRL_FSM_TRACE_ID_TRIGGER _                  
         ET_EN_T32 _ _u32TriggerUpdate _
         ET_EN_T32 _ _u32Trigger _
         ET_EN_DONE);

   _u32CurrentTrigger = _u32Trigger;
   _u32CurrentTriggerUpdate = _u32TriggerUpdate;
   _u32TriggerUpdate = 0;

   tU32 u32TabEntries = _u32MaxTransitionEntry;
   TStateTransitions* prTransitionDescr = _paFsmTransitionTable;
   TStateTransitions* prLastTransitionEntry  = _paFsmTransitionTable + u32TabEntries;

   if ((u32TabEntries > 0) && prTransitionDescr) {
      /* while end state not found and not end of state table */
      while ( (u32TransitionId == FSM_U32_TRANSITION_ID_INVALID) && (prTransitionDescr < prLastTransitionEntry) )
      {
         // checksystem state
         if ((prTransitionDescr->u32CurrentFsmState == _u32FsmState) || (prTransitionDescr->u32CurrentFsmState == FSM_DONT_CARE)) {
            // is update detected
            if (((prTransitionDescr->u32UpdateTrigger&_u32CurrentTriggerUpdate)==prTransitionDescr->u32UpdateTrigger) || (prTransitionDescr->u32UpdateTrigger == FSM_DONT_CARE)){
               // is substate active
               if (((prTransitionDescr->u32Trigger&_u32CurrentTrigger)==prTransitionDescr->u32Trigger)|| (prTransitionDescr->u32Trigger == FSM_DONT_CARE)) {
                  // is a substate not active
                  if (((prTransitionDescr->u32TriggerNotSet & ~_u32CurrentTrigger) ==  prTransitionDescr->u32TriggerNotSet)|| (prTransitionDescr->u32TriggerNotSet == FSM_DONT_CARE)){
                     // found a table entry
                     u32CalcNewSystemState = prTransitionDescr->u32NextFsmState;

                     u32TransitionId= prTransitionDescr->u32TransitionId;
                  }
               }
            }
         }

         prTransitionDescr++;
      }
   }

   if (u32TransitionId != FSM_U32_TRANSITION_ID_INVALID)
   {
      _u32LastTransitionId = u32TransitionId;

      _u32LastFsmState = _u32FsmState;
      _u32FsmState = u32CalcNewSystemState;

      if (u32CalcNewSystemState != _u32LastFsmState) {
         vActStateExit(_u32LastFsmState);
      }

      vStateChangeDetected();

      /* call state entry function */
      /* this function may be empty (PM_MS_vStateDummy) or it may set used flags, trigger servers or whatever */
      _u32TimeOut = u32ActStateEntry(u32CalcNewSystemState);

      //_u32CurrentInternSubState &= ~SPM_INTERN_SUBSTATE_STATE_TIMEOUT;

      vStartFsmStateTimer(_u32TimeOut);

      ET_TRACE_INFO_BIN( _u32TraceClass,
         ET_EN_T16 _  DISPVIDCTRL_FSM_TRACE_ID_NEW_STATE _                  
         ET_EN_T32 _ _u32FsmState _
         ET_EN_T32 _ _u32LastFsmState _
         ET_EN_T32 _ _u32LastTransitionId _
         ET_EN_DONE);

   } else {
      //no new state found
      vStateNoTransition();

      ET_TRACE_INFO_BIN( _u32TraceClass,
         ET_EN_T16 _  DISPVIDCTRL_FSM_TRACE_ID_NO_NEW_STATE _                  
         ET_EN_DONE);
   }
     


   return(u32CalcNewSystemState);
}

tVoid dispvidctrl_tclSyncHandlerFsmBase::vStateNoTransition(tVoid){
   return;
};

tVoid dispvidctrl_tclSyncHandlerFsmBase::vTraceStatusInfo(tU32 u32RemainingTime) {
      ET_TRACE_INFO_BIN( _u32TraceClass,
         ET_EN_T16 _  DISPVIDCTRL_FSM_TRACE_ID_INFO _                  
         ET_EN_T32 _ _u32FsmState _
         ET_EN_T32 _ _u32LastFsmState _
         ET_EN_T32 _ _u32LastTransitionId _
         ET_EN_T32 _ _u32TriggerUpdate _
         ET_EN_T32 _ _u32Trigger _
         ET_EN_T32 _ _u32TimeOut _
         ET_EN_T32 _ u32RemainingTime _
         ET_EN_DONE);
}


