/************************************************************************
* FILE:        dispvidctrl_tclSyncHandler.h
* PROJECT:
* SW-COMPONENT:vd_dimming
*----------------------------------------------------------------------
*
* DESCRIPTION: definition of configuration manager class
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author             | Modification
* 20.08.2015| CM-AI/EPB2 Bernard | init
*
*************************************************************************/

#ifndef dispvidctrl_tclSyncHandler_H_
#define dispvidctrl_tclSyncHandler_H_

//include base class
#include "I_dispvidctrl_tclSyncHandler.h"
#include "dispvidctrl_tclSyncHandler_fsm.h"

class Idispvidctrl_tclServiceSyncdisplay;
class I_dispvidctrl_tclDisplaySettings;

class dispvidctrl_tclSyncHandler : public dispvidctrl_tclSyncHandlerFsmBase, public I_dispvidctrl_tclSyncHandler
{
private:
    typedef enum
    {
        eSyncFsmIdle = 0,
        eSyncFsmInit,
        eSyncFsmAnimation,
        eSyncFsmRvc,

        eSyncFsmMax,
        eSyncFsmInvalid = 0xFFFF
    }tenSyncFsmState;
    bool m_animationstatus;
    tVoid vFsmInfo();

    virtual tVoid vStartFsmStateTimer(tU32 u32Time);

    virtual tVoid vStateChangeDetected(tVoid);

    virtual tVoid _vHandleEarlyAvm(tenControl_SyncHandler enControl_SyncHandler, tU32 u32Value = 0);

    static OSAL_tpfCallback vStateTimer(tVoid *pArg);

    OSAL_tTimerHandle       _hStateTimer;

    static TStateTransitions _aFsmStateTransitionTable[];
    static TFsmStateConf     _aFsmStateTable[eSyncFsmMax];

    static tVoid             vEntryIdle(tVoid);
    static tVoid             vEntryInit(tVoid);
    static tVoid             vEntryAnimation(tVoid);
    static tVoid             vEntryRvc(tVoid);
    static tVoid             vExitAnimation(tVoid);
    static tVoid             vExitRvc(tVoid);

    Idispvidctrl_tclServiceSyncdisplay* _poSrvSync;

private:
    static dispvidctrl_tclSyncHandler*   _poMyStaticRef;

    // references
    I_dispvidctrl_tclDisplaySettings*  m_poDisplaySettings;

    OSAL_tEventHandle _hEvVideoReady;

    tBool             _bRvcWasActive;

    tBool m_bEarlyCameraScreenControlOff;
    tBool m_bEarlyIncIgnition;
    tBool m_bEarlyIncAvmInitializing;
    tBool m_bEarlyIncAvmViewChangeRequest;
    tBool m_bAvmConfigured;
    tBool m_bAvmInitFlagTx;
    tU8   m_u8AvmLanguage;
    tenBackLightState m_enBacklightState_RVC;
	tBool m_bDimmingModeRvc;

public:
    // constructors and destructors
    dispvidctrl_tclSyncHandler(tVoid);
    dispvidctrl_tclSyncHandler(const dispvidctrl_tclAppMain* poMainAppl);
    virtual ~dispvidctrl_tclSyncHandler();

    virtual const tChar* getName() const { return "dispvidctrl_tclSyncHandler"; };

    virtual tVoid vHandleMessage(dispvidctrl_tclBaseIf::TMsg* pMsg);
    virtual tVoid vHandleTraceMessage(const tUChar* puchData);
    virtual tVoid vGetReferences();
    virtual tVoid vStartCommunication();
    virtual tVoid vTraceInfo();

    virtual tVoid vStartCommunicationEarly();
    virtual tVoid vGetReferencesEarly();

    virtual tVoid vWaitVideoChain(tU32 u32Timeout);
    virtual tVoid vTriggerNotify();

    virtual tVoid vNewTrigger(eSyncFsmTrigger eTrigger, tBool bTriggerState) const;
    virtual tVoid vUpdateTriggerState(eSyncFsmTrigger eTrigger, tBool bTriggerState) const;

    virtual tVoid vHandleControl(tenControl_SyncHandler enControl_SyncHandler, tU32 u32Value = 0);
    virtual tVoid vGetAvmInitFlagTx(tBool& bAvmInitFlagTx) {bAvmInitFlagTx = m_bAvmInitFlagTx;};

    virtual tenBackLightState enGetBacklightState_RVC(tVoid) {return (m_enBacklightState_RVC);};
	virtual tBool bGetDimmingModeRvc(tVoid) {return (m_bDimmingModeRvc);};
};

#endif /* dispvidctrl_tclSyncHandler_H_ */
