/************************************************************************
* FILE:        I_dispvidctrl_tclSyncHandler.h
* PROJECT:
* SW-COMPONENT:vd_dimming
*----------------------------------------------------------------------
*
* DESCRIPTION: interface of configuration manager class
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author             | Modification
* 20.08.2015| CM-AI/EPB2 Bernard | init
*
*************************************************************************/

#ifndef I_dispvidctrl_tclSyncHandler_H_
#define I_dispvidctrl_tclSyncHandler_H_

#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#endif //#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC

#include "dispvidctrl_AppMain.h"
#include "dispvidctrl_tclTypes.h"

   // enumeration of user events.
   enum tenControl_SyncHandler
   {
      EN_CONTROL_SH__NONE  = 0,
      //------------------------------------------------------------------------
      EN_CONTROL_SH__EARLY_INC_UP,
      EN_CONTROL_SH__EARLY_INC_ACCESSORY,
      EN_CONTROL_SH__EARLY_INC_IGNITION,
      EN_CONTROL_SH__EARLY_INC_REVERSE,
      EN_CONTROL_SH__EARLY_INC_AVM_INIT_FLAG_RX,
      EN_CONTROL_SH__EARLY_INC_AVM_VIEW_CHG_REQ,
      EN_CONTROL_SH__EARLY_INC_STEERING_ANGLE,
      //------------------------------------------------------------------------
      EN_CONTROL_SH__DIMMING_INC_CAR_MODE_DAY,
      EN_CONTROL_SH__DIMMING_INC_CAR_MODE_NIGHT,
      //------------------------------------------------------------------------
      EN_CONTROL_SH__EARLY_CAMERA_SCREEN_CONTROL_OFF,
      EN_CONTROL_SH__CAMERA_SCREEN_ON,
      EN_CONTROL_SH__CAMERA_SCREEN_OFF
      //------------------------------------------------------------------------
   };


class I_dispvidctrl_tclSyncHandler : public dispvidctrl_tclBaseIf
{
public:
    typedef enum
    {
        eSyncTriggerAnimation      = 0x00000001,
        eSyncTriggerRvc            = 0x00000002,
        eSyncTriggerLayerMgrRdy    = 0x00000004,
        eSyncTriggerVideoPlayerRdy = 0x00000008,
        eSyncTriggerStateTimeOut   = 0x00000010,
        eSyncTriggerAcc            = 0x00000020,
        eSyncTriggerIgnition       = 0x00000040,
        eSyncTriggerIncUp          = 0x00000080,
        eSyncTriggerHmiReady       = 0x00000100,
        eSyncTriggerRvcDebounced   = 0x00000200,
        eSyncTriggerDrvAssCtrl     = 0x00000400
    }eSyncFsmTrigger;


    // constructor
    I_dispvidctrl_tclSyncHandler(tVoid);
    I_dispvidctrl_tclSyncHandler(const dispvidctrl_tclAppMain* poMainAppl) : dispvidctrl_tclBaseIf(poMainAppl) {;};
    // destructor
    virtual ~I_dispvidctrl_tclSyncHandler(){};

    virtual const tChar* getIfName() const { return "I_dispvidctrl_tclSyncHandler"; };

    virtual tVoid vWaitVideoChain(tU32 u32Timeout) = 0;

    virtual tVoid vNewTrigger(eSyncFsmTrigger eTrigger, tBool bTriggerState) const = 0;
    virtual tVoid vUpdateTriggerState(eSyncFsmTrigger eTrigger, tBool bTriggerState) const = 0;

    virtual tVoid vHandleControl(tenControl_SyncHandler enControl_SyncHandler, tU32 u32Value = 0) = 0;
    virtual tVoid vGetAvmInitFlagTx(tBool& bAvmInitFlagTx) = 0;

    virtual tenBackLightState enGetBacklightState_RVC(tVoid) = 0;
	virtual tBool bGetDimmingModeRvc(tVoid) = 0;
};

#endif /* I_dispvidctrl_tclSyncHandler_H_ */
