/************************************************************************
* FILE:        dispvidctrl_tclProfileManager.h
* PROJECT:
* SW-COMPONENT: dispvidctrl
*----------------------------------------------------------------------
*
* DESCRIPTION: definition of Second Screen Handler.
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author             | Modification
* 06.03.2017| RBEI/ECV Sandeep Gupta | init
*
*************************************************************************/
#ifndef dispvidctrl_tclProfileManager_H
#define dispvidctrl_tclProfileManager_H

#include "I_dispvidctrl_ProfileManager.h"
#include "Idispvidctrl_ClientDimming.h"

class dispvidctrl_tclProfileManager: public I_dispvidctrl_tclProfileManagerIf
{
private:


public:
	//Constructor
        dispvidctrl_tclProfileManager(dispvidctrl_tclAppMain* poMainAppl);
	//Destructor
        virtual ~dispvidctrl_tclProfileManager();

	//Base class virtusl functions:-
	virtual const tChar* getName() const {return "dispvidctrl_tclProfileManager";}
	virtual tVoid vHandleMessage(TMsg* pMsg);
	virtual tVoid vHandleTraceMessage(const tUChar* puchData);
	virtual tVoid vGetReferences();
	virtual tVoid vStartCommunication();
	virtual tVoid vTraceInfo();

	//User Defined Member Virtual Functions:-
	virtual tVoid vHandleProfileChangeTrigger(); //->Call this fn tVoid  vdclk_tclDataContainer::vSetDefaultSettings	(tBool bResetAllUsers)
	virtual tVoid vHandlePrepareTrigger();
	virtual tVoid vHandleResetProfileTrigger();

private:
	tVoid sync_internal_RN_Datapool(tU8 u8DaySliderVal, tU8 u8NightSliderVal, tU8 u8CockpitSliderVal);
	tVoid notify_RN_HMIDatapoolChange(tU8 u8GetDaySliderVal, tU8 u8GetNightSliderVal, tU8 u8GetCockpitSliderVal);
};



#endif /* dispvidctrl_tclProfileManager_H */
