/************************************************************************
* FILE:        dispvidctrl_tclProfileManager.cpp
* PROJECT:
* SW-COMPONENT: dispvidctrl
*----------------------------------------------------------------------
*
* DESCRIPTION: definition of Second Screen Handler.
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author             | Modification
* 06.03.2017| RBEI/ECV Sandeep Gupta | init
*
*************************************************************************/


#include "dispvidctrl_ProfileManager.h"


#define FI_S_IMPORT_INTERFACE_BASE_TYPES
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "common_fi_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_generic_if.h"

//For Accessing Datapool FI
#define DP_S_IMPORT_INTERFACE_FI
#include "dp_drvass_video_if.h"

//For External Class References
#include "dispvidctrl_ClientDimming.h"

//For Trace
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_DISPVIDCTRL_CLIENT_PROFILE
#include "trcGenProj/Header/dispvidctrl_ProfileManager.cpp.trc.h"
#endif


dispvidctrl_tclProfileManager::dispvidctrl_tclProfileManager(dispvidctrl_tclAppMain* poMainAppl):I_dispvidctrl_tclProfileManagerIf(poMainAppl)
{

	ETG_TRACE_USR4(("dispvidctrl_tclProfileManager::dispvidctrl_tclProfileManager() Constructor is entered\n"));
}

dispvidctrl_tclProfileManager::~dispvidctrl_tclProfileManager()
{

	ETG_TRACE_USR4(("dispvidctrl_tclProfileManager::dispvidctrl_tclProfileManager() Destructor is entered\n"));
}

tVoid dispvidctrl_tclProfileManager::vHandleMessage(dispvidctrl_tclBaseIf::TMsg* pMsg)
{
	(tVoid)pMsg;
}

tVoid dispvidctrl_tclProfileManager::vStartCommunication()
{
	ETG_TRACE_USR4(("dispvidctrl_tclProfileManager::vStartCommunication() is entered\n"));
}

tVoid dispvidctrl_tclProfileManager::vGetReferences()
{
	ETG_TRACE_USR4(("dispvidctrl_tclProfileManager::vGetReferences() is entered\n"));
}

tVoid dispvidctrl_tclProfileManager::vTraceInfo()
{
	ETG_TRACE_USR4(("dispvidctrl_tclProfileManager::vTraceInfo() is entered\n"));
}

 tVoid dispvidctrl_tclProfileManager::vHandleTraceMessage(const tUChar* puchData)
{
	  ETG_TRACE_USR4(("dispvidctrl_tclProfileManager::vHandleTraceMessage() is entered\n"));
	 (tVoid)puchData;
	 //Handle Profilechange
	 //Handle
}

tVoid dispvidctrl_tclProfileManager::vHandleProfileChangeTrigger()
{
	ETG_TRACE_USR4(("dispvidctrl_tclProfileManager::HandleProfileChangeTrigger() is entered\n"));
	//Call a Fn to save current User
	dp_tclDispUsrProfileDPRN_Screen1_SliderDayVal_Multi UsrDP_SLiderDay_Multi;
	dp_tclDispUsrProfileDPRN_Screen1_SliderNightVal_Multi UsrDP_SLiderNight_Multi;
	dp_tclDispUsrProfileDPRN_Screen1_SliderCockpitVal_Multi UsrDP_SLiderCockpit_Multi;

	tU8 u8GetDaySliderVal;
	tU8 u8GetNightSliderVal;
	tU8 u8GetCockpitSliderVal;
	//Three variables to display the get status
	tS32 s32DaySliderRetVal;
	tS32 s32NightSliderRetVal;
	tS32 s32CockpitSliderRetVal;
/*
	//Now Perform Read operation of Datapool
	UsrDP_SLiderDay_Multi>>u8GetDaySliderVal;  			//Same as UsrDP_SLiderDay_Multi.u8GetData(u8GetDaySliderVal);
	UsrDP_SLiderNight_Multi>>u8GetNightSliderVal; 		//Same as UsrDP_SLiderNight_Multi.u8GetData(u8GetNightSliderVal);
	UsrDP_SLiderCockpit_Multi>>u8GetCockpitSliderVal;	// Same as	UsrDP_SLiderCockpit_Multi.u8GetData(u8GetCockpitSliderVal);
*/
	s32DaySliderRetVal = UsrDP_SLiderDay_Multi.s32GetData(u8GetDaySliderVal);
	ETG_TRACE_USR4((": vHandleProfileChangeTrigger->s32DaySliderRetVal = %d returned", s32DaySliderRetVal));
	s32NightSliderRetVal = UsrDP_SLiderNight_Multi.s32GetData(u8GetNightSliderVal);
	ETG_TRACE_USR4((": vHandleProfileChangeTrigger->s32NightSliderRetVal = %d returned", s32NightSliderRetVal));
	s32CockpitSliderRetVal = UsrDP_SLiderCockpit_Multi.s32GetData(u8GetCockpitSliderVal);
	ETG_TRACE_USR4((": vHandleProfileChangeTrigger->s32CockpitSliderRetVal = %d returned", s32CockpitSliderRetVal));
	//Print the Datapool Values Read
	//Now Print Values of Datapools
	ETG_TRACE_USR4((": vHandleProfileChangeTrigger->u8GetDaySliderVal = %d", u8GetDaySliderVal));
	ETG_TRACE_USR4((": vHandleProfileChangeTrigger->u8GetNightSliderVal = %d", u8GetNightSliderVal));
	ETG_TRACE_USR4((": vHandleProfileChangeTrigger->u8GetCockpitSliderVal = %d",u8GetCockpitSliderVal));

	//Synchronize the Profile Datapool to Internal Datapool Used by HMI
	sync_internal_RN_Datapool(u8GetDaySliderVal,  u8GetNightSliderVal, u8GetCockpitSliderVal);
	//Send Update of Properties to CCA Client HMI
	notify_RN_HMIDatapoolChange(u8GetDaySliderVal,  u8GetNightSliderVal, u8GetCockpitSliderVal);
	//Code here to update the new day, night and cockpit slider values to V850 through INC after profile change
#ifdef VARIANT_S_FTR_ENABLE_AIVI_SCOPE2_1
	I_dispvidctrl_tclClientDimming* pClientDimming = dynamic_cast<I_dispvidctrl_tclClientDimming*>(_cpoMain->getHandler("dispvidctrl_tclClientDimming"));
	if(pClientDimming)
	{
		ETG_TRACE_USR4((": vHandleProfileChangeTrigger->INC update to V850 to change brightness after profile values changed"));
		pClientDimming->vReadDatapool();
		pClientDimming->vUpdateINCforBrightness();
	}
#endif
}

tVoid dispvidctrl_tclProfileManager::vHandlePrepareTrigger()
{
	ETG_TRACE_USR4(("dispvidctrl_tclProfileManager::HandlePrepareTrigger() is entered\n"));

	//Read HMI slider Offset from Original Copy of DataPool
	dp_tclDimmingDPSLIDER_Screen_DAY_Luminosity_OFFSET dpDayLuminosity_HMISlider;
	dp_tclDimmingDPSLIDER_Screen_NIGHT_Luminosity_OFFSET dpDayNightLuminosity_HMISlider;
	dp_tclDimmingDPSLIDER_COCKPIT_Brightness_OFFSET dpDimCockPitSlider_Offset;

	//Copy the Datapool values of Original ones into Multi User Ones
	dp_tclDispUsrProfileDPRN_Screen1_SliderDayVal_Multi UsrDP_SLiderDay_Multi;
	dp_tclDispUsrProfileDPRN_Screen1_SliderNightVal_Multi UsrDP_SLiderNight_Multi;
	dp_tclDispUsrProfileDPRN_Screen1_SliderCockpitVal_Multi UsrDP_SLiderCockpit_Multi;

	//Set these Values with Original ones
	UsrDP_SLiderDay_Multi << dpDayLuminosity_HMISlider.tGetData();
	UsrDP_SLiderNight_Multi << dpDayNightLuminosity_HMISlider.tGetData();
	UsrDP_SLiderCockpit_Multi << dpDimCockPitSlider_Offset.tGetData();

	//Now Print Values of Datapools
	ETG_TRACE_USR4((": HandlePrepareTrigger->UsrDP_SLiderDay_Multi = %d", UsrDP_SLiderDay_Multi.tGetData()));
	ETG_TRACE_USR4((": HandlePrepareTrigger->UsrDP_SLiderNight_Multi = %d", UsrDP_SLiderNight_Multi.tGetData()));
	ETG_TRACE_USR4((": HandlePrepareTrigger->UsrDP_SLiderCockpit_Multi = %d", UsrDP_SLiderCockpit_Multi.tGetData()));

}

tVoid dispvidctrl_tclProfileManager::vHandleResetProfileTrigger()
{
	ETG_TRACE_USR4(("dispvidctrl_tclProfileManager::HandleResetProfileTrigger() is entered\n"));

	//Call a Fn to save current User
	dp_tclDispUsrProfileDPRN_Screen1_SliderDayVal_Multi UsrDP_SLiderDay_Multi;
	dp_tclDispUsrProfileDPRN_Screen1_SliderNightVal_Multi UsrDP_SLiderNight_Multi;
	dp_tclDispUsrProfileDPRN_Screen1_SliderCockpitVal_Multi UsrDP_SLiderCockpit_Multi;

	UsrDP_SLiderDay_Multi.vSetData(9);
	UsrDP_SLiderNight_Multi.vSetData(9);
	UsrDP_SLiderCockpit_Multi.vSetData(9);

	//Now Print Values of Datapools
	ETG_TRACE_USR4((": vHandleResetProfileTrigger->UsrDP_SLiderDay_Multi = %d", UsrDP_SLiderDay_Multi.tGetData()));
	ETG_TRACE_USR4((": vHandleResetProfileTrigger->UsrDP_SLiderNight_Multi = %d", UsrDP_SLiderNight_Multi.tGetData()));
	ETG_TRACE_USR4((": vHandleResetProfileTrigger->UsrDP_SLiderCockpit_Multi = %d", UsrDP_SLiderCockpit_Multi.tGetData()));

}


//Private Functions
tVoid dispvidctrl_tclProfileManager::notify_RN_HMIDatapoolChange(tU8 u8GetDaySliderVal, tU8 u8GetNightSliderVal, tU8 u8GetCockpitSliderVal)
{
	Idispvidctrl_tclServiceDimmingIf* pDimmCCAClient =  dynamic_cast<Idispvidctrl_tclServiceDimmingIf*>(_cpoMain->getHandler("dispvidctrl_tclServiceDimmingIf"));
	if(pDimmCCAClient != NULL)
	{
		ETG_TRACE_USR4(("notify_RN_HMIDatapoolChange: (Day:%d, Night%d, Cockpit:%d", u8GetDaySliderVal, u8GetNightSliderVal, u8GetCockpitSliderVal));
		//Send to HMI
		pDimmCCAClient->sendDIM_DISP_DAY_LUMINOSITY_OFFSETStatus(u8GetDaySliderVal);
		pDimmCCAClient->sendDIM_DISP_NIGHT_LUMINOSITY_OFFSETStatus(u8GetNightSliderVal);
		pDimmCCAClient->sendDIM_DISP_COCKPIT_SLIDER_OFFSETStatus(u8GetCockpitSliderVal);
	}

}

tVoid dispvidctrl_tclProfileManager::sync_internal_RN_Datapool(tU8 u8DaySliderVal, tU8 u8NightSliderVal, tU8 u8CockpitSliderVal)
{

	//Create Original HMI datapool in Dimming User
	dp_tclDimmingDPSLIDER_Screen_DAY_Luminosity_OFFSET dpDayLuminosity_HMISlider;
	dp_tclDimmingDPSLIDER_Screen_NIGHT_Luminosity_OFFSET dpDayNightLuminosity_HMISlider;
	dp_tclDimmingDPSLIDER_COCKPIT_Brightness_OFFSET dpDimCockPitSlider_Offset;

	//Update Original Datapool with changed User Profile Datapool Values
	dpDayLuminosity_HMISlider << u8DaySliderVal;
	dpDayNightLuminosity_HMISlider << u8NightSliderVal;
	dpDimCockPitSlider_Offset << u8CockpitSliderVal;

	//Now Print Values of Datapools
	ETG_TRACE_USR4((": notify_RN_HMIDatapoolChange->dpDayLuminosity_HMISlider = %d", dpDayLuminosity_HMISlider.tGetData()));
	ETG_TRACE_USR4((": notify_RN_HMIDatapoolChange->dpDayNightLuminosity_HMISlider = %d", dpDayNightLuminosity_HMISlider.tGetData()));
	ETG_TRACE_USR4((": notify_RN_HMIDatapoolChange->dpDimCockPitSlider_Offset = %d", dpDimCockPitSlider_Offset.tGetData()));

}
