/******************************************************************************/
/**
* \file    dispvidctrl_tclFsm_Mvc.h
* \ingroup
*
* \brief
*
* \remark  Copyright : (c) 2015 Robert Bosch GmbH, Hildesheim
* \remark  Author    : deo2kor
* \remark  Scope     : A-IVI
*
* \todo
*/
/******************************************************************************/
#ifndef _DISPVIDCTRL_TCL_FSM_MVC_H_
#define _DISPVIDCTRL_TCL_FSM_MVC_H_

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "dispvidctrl_tclFsm_Base.h"

//***********************************************************************
//  CLASS
//***********************************************************************
class dispvidctrl_tclControl_Mvc;
class dispvidctrl_tclFsm_Mvc: public dispvidctrl_tclFsm_Base
{
public:

      // Available States -----------------------------------------------
      enum
      {
          eState_Uninitialized            = 0,
          eState_Off                      = 1,
          eState_On                       = 2,
          eState_View_Change_Waiting      = 3,
          eState_Off_Delay                = 4,
          eState_Max,
          eState_Invalid                  = 0xFFFF
      };

      // Available Trigger ----------------------------------------------
      enum
      {
         eTrigger_NONE                                       = 0x00000000,

         eTrigger_Init                                       = 0x00000001,
         eTrigger_DeInit                                     = 0x00000002,
         eTrigger_View_Change_Request                        = 0x00000004,
         
         eTrigger_VisualisationOff                           = 0x00000010,
         eTrigger_VisualisationOn                            = 0x00000020,
         eTrigger_Frame_Timeout_True                         = 0x00000040,
         eTrigger_Frame_Timeout_False                        = 0x00000080,
         
         eTrigger_VisualisationSettingsOff                   = 0x00000100,
         eTrigger_VisualisationSettingsOn                    = 0x00000200,
         eTrigger_SpeedTooHighTrue                           = 0x00000400,
         eTrigger_SpeedTooHighFalse                          = 0x00000800,
         
         eTrigger_IgnitionOff                                = 0x00001000,
         eTrigger_IgnitionOn                                 = 0x00002000,

         eTrigger_StateTimeout                               = 0x01000000
      };

      static dispvidctrl_tclFsm_Mvc* tclCreateInstance(dispvidctrl_tclControl_Mvc* poControl_Mvc);

      dispvidctrl_tclFsm_Mvc();                                      // constructor
      dispvidctrl_tclFsm_Mvc(dispvidctrl_tclControl_Mvc* poControl_Mvc);  // constructor
      virtual ~dispvidctrl_tclFsm_Mvc();                             // destructor

      tVoid vNewTrigger(tU32 u32Trigger, tBool bTriggerState);
      tVoid vUpdateTriggerState(tU32 u32Trigger, tBool bTriggerState);

protected:
   virtual tVoid vStateChangeDetected(tVoid);
   virtual tVoid vStartFsmStateTimer(tU32 u32Time); // overwrites FsmBase class function
   virtual tVoid vUpdateRelatedTrigger(tU32 u32Trigger);

   static  tVoid vExit_Uninitialized(tVoid);
   
   static  tVoid vEntry_Off(tVoid);
   static  tVoid vDo_Off(tVoid);

   static  tVoid vEntry_On(tVoid);
   static  tVoid vExit_On(tVoid);
   static  tVoid vDo_On(tVoid);

   static  tVoid vEntry_View_Change_Waiting(tVoid);
   static  tVoid vDo_View_Change_Waiting(tVoid);

   static  tVoid vEntry_Off_Delay(tVoid);
   static  tVoid vDo_Off_Delay(tVoid);
   static  tVoid vExit_Off_Delay(tVoid);

private:


   static OSAL_tpfCallback _pfCallbackTimer_FsmStateTimeout(tVoid* pArg);
   OSAL_tTimerHandle  m_hTimerHandle_FsmStateTimeout;

   tBool _bSetTimer_FsmStateChange( OSAL_tMSecond msTimeout ) const;
   
   static OSAL_tpfCallback _pfCallbackTimer_SpeedSupervisionTimeout(tVoid* pArg);
   OSAL_tTimerHandle  m_hTimerHandle_SpeedSupervisionTimeout;

   tBool _bSetTimer_SpeedSupervision( OSAL_tMSecond msTimeout ) const;

   static TFsmStateConf     aFsm_Mvc_StateTable[eState_Max];
   static TStateTransitions aFsm_Mvc_StateTransitionTable[];

   dispvidctrl_tclControl_Mvc* m_poMvcControl;
   static dispvidctrl_tclFsm_Mvc* m_poInstance;
};

#endif // _DISPVIDCTRL_TCL_FSM_MVC_H_
