/******************************************************************************/
/**
* \file    dispvidctrl_tclFsm_Mvc.cpp
* \ingroup
*
* \brief
*
* \remark  Copyright : (c) 2015 Robert Bosch GmbH, Hildesheim
* \remark  Author    : deo2kor
* \remark  Scope     : AIVI
*
* \todo
*/
/******************************************************************************/
/*
*
*/
#include "dispvidctrl_AppMain.h"
#include "dispvidctrl_tclFsm_Mvc.h"
#include "dispvidctrl_tclControl_Mvc.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"  //Lint537 repeatedly included
#ifndef ET_TRACE_INFO_ON // reference to define ET_TRACE_INFO_ON because of lint Info 750
// Info 750: prio2: local macro 'ET_TRACE_INFO_ON' not referenced
// (this lint error is related to the ETG framework and can't be solved here)
#endif

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_DISPVIDCTRL_APPLICATION
#include "trcGenProj/Header/dispvidctrl_tclFsm_Mvc.cpp.trc.h"
#endif

#define ELEMENTE(array)       ((tU16)(sizeof(array)/sizeof(array[0])))

#define DISPVIDCTRL_TRACE_ID_FSM_MVC           (tU8) 0x08

//Timeout for MVC_Toggle_Waiting mode
#define DISPVIDCTRL_MVC_SPEED_SUPERVISION_TIME_IN_MS                1000
#define DISPVIDCTRL_MVC_VIEW_CHANGE_RESPONSE_WAITING_TIME_IN_MS     3000
#define DISPVIDCTRL_MVC_CAN_FRAME_RECOVERY_WAITING_TIME_IN_MS      15000

dispvidctrl_tclFsm_Mvc*  dispvidctrl_tclFsm_Mvc::m_poInstance = OSAL_NULL;

/*******************************************************************************
*                                  STATE TABLE
*******************************************************************************/
dispvidctrl_tclFsm_Mvc::TFsmStateConf dispvidctrl_tclFsm_Mvc::aFsm_Mvc_StateTable[eState_Max]=
{
    {
       eState_Uninitialized,
       0,                                              //u32Timeout
       NULL,                                           //tFsmStateEntryFunc
       NULL,                                           //tFsmStateDoFunc
       vExit_Uninitialized                             //tFsmStateExitFunc
    },
    {
       eState_Off,
       0,                                              //u32Timeout
       vEntry_Off,                                     //tFsmStateEntryFunc
       vDo_Off,                                        //tFsmStateDoFunc
       NULL                                            //tFsmStateExitFunc
    },
    {
       eState_On,
       0,                                              //u32Timeout
       vEntry_On,                                      //tFsmStateEntryFunc
       vDo_On,                                         //tFsmStateDoFunc
       vExit_On                                        //tFsmStateExitFunc
    },
    {
       eState_View_Change_Waiting,
       3000,                                           //u32Timeout
       vEntry_View_Change_Waiting,                     //tFsmStateEntryFunc
       vDo_View_Change_Waiting,                        //tFsmStateDoFunc
       NULL                                            //tFsmStateExitFunc
    },
    {
       eState_Off_Delay,
       15000,                                          //u32Timeout
       vEntry_Off_Delay,                               //tFsmStateEntryFunc
       vDo_Off_Delay,                                  //tFsmStateDoFunc
       vExit_Off_Delay                                 //tFsmStateExitFunc
    }
};


/*******************************************************************************
*                             STATE TRANSITION TABLE
*******************************************************************************/
dispvidctrl_tclFsm_Mvc::TStateTransitions dispvidctrl_tclFsm_Mvc::aFsm_Mvc_StateTransitionTable[] =
{
    //  ===== eState_Uninitialized =====
    {   100,                                            // transitionId
        eState_Uninitialized,                           // current FSM State
        eTrigger_Init,                                  // trigger update
        FSM_DONT_CARE,                                  // current active trigger(s)
        FSM_DONT_CARE,                                  // current not active trigger(s)
        eState_Off                                      // next FSM State
    },
    {   101,                                            // transitionId
        FSM_DONT_CARE,                                  // current FSM State
        eTrigger_DeInit,                                // trigger update
        FSM_DONT_CARE,                                  // current active trigger(s)
        FSM_DONT_CARE,                                  // current not active trigger(s)
        eState_Uninitialized                            // next FSM State
    },
    //  ===== eState_Off =====
    {   200,                                            // transitionId
        eState_Off,                                     // current FSM State
        eTrigger_VisualisationOn,                       // trigger update
        FSM_DONT_CARE,                                  // current active trigger(s)
        FSM_DONT_CARE,                                  // current not active trigger(s)
        eState_On                                       // next FSM State
    },
    {   201,                                            // transitionId
        eState_Off,                                     // current FSM State
        eTrigger_View_Change_Request,                   // trigger update
        FSM_DONT_CARE,                                  // current active trigger(s)
        FSM_DONT_CARE,                                  // current not active trigger(s)
        eState_View_Change_Waiting                      // next FSM State
    },
    {   202,                                            // transitionId
        eState_Off,                                     // current FSM State
        eTrigger_IgnitionOn,                            // trigger update
        eTrigger_VisualisationOn,                       // current active trigger(s)
        FSM_DONT_CARE,                                  // current not active trigger(s)
        eState_On                                       // next FSM State
    },
    // do actions
    {   210,                                            // transitionId
        eState_Off,                                     // current FSM State
        eTrigger_Frame_Timeout_False,                   // trigger update
        FSM_DONT_CARE,                                  // current active trigger(s)
        FSM_DONT_CARE,                                  // current not active trigger(s)
        eState_Off                                      // next FSM State
    },
    {   211,                                            // transitionId
        eState_Off,                                     // current FSM State
        eTrigger_SpeedTooHighFalse,                     // trigger update
        FSM_DONT_CARE,                                  // current active trigger(s)
        FSM_DONT_CARE,                                  // current not active trigger(s)
        eState_Off                                      // next FSM State
    },
    {   212,                                            // transitionId
        eState_Off,                                     // current FSM State
        eTrigger_VisualisationOff,                      // trigger update
        FSM_DONT_CARE,                                  // current active trigger(s)
        FSM_DONT_CARE,                                  // current not active trigger(s)
        eState_Off                                      // next FSM State
    },
    //  ===== eState_On =====
    {   300,                                            // transitionId
        eState_On,                                      // current FSM State
        eTrigger_View_Change_Request,                   // trigger update
        FSM_DONT_CARE,                                  // current active trigger(s)
        FSM_DONT_CARE,                                  // current not active trigger(s)
        eState_View_Change_Waiting                      // next FSM State
    },
    {   301,                                            // transitionId
        eState_On,                                      // current FSM State
        eTrigger_VisualisationOff,                      // trigger update
        FSM_DONT_CARE,                                  // current active trigger(s)
        FSM_DONT_CARE,                                  // current not active trigger(s)
        eState_Off                                      // next FSM State
    },
    {   302,                                            // transitionId
        eState_On,                                      // current FSM State
        eTrigger_SpeedTooHighTrue,                      // trigger update
        FSM_DONT_CARE,                                  // current active trigger(s)
        FSM_DONT_CARE,                                  // current not active trigger(s)
        eState_Off                                      // next FSM State
    },
    // do actions
    {   310,                                            // transitionId
        eState_On,                                      // current FSM State
        eTrigger_StateTimeout,                          // trigger update
        FSM_DONT_CARE,                                  // current active trigger(s)
        FSM_DONT_CARE,                                  // current not active trigger(s)
        eState_On                                       // next FSM State
    },
    {   311,                                            // transitionId
        eState_On,                                      // current FSM State
        eTrigger_VisualisationOn,                       // trigger update
        FSM_DONT_CARE,                                  // current active trigger(s)
        FSM_DONT_CARE,                                  // current not active trigger(s)
        eState_On                                       // next FSM State
    },
    {   312,                                            // transitionId
        eState_On,                                      // current FSM State
        eTrigger_VisualisationSettingsOff,              // trigger update
        FSM_DONT_CARE,                                  // current active trigger(s)
        FSM_DONT_CARE,                                  // current not active trigger(s)
        eState_On                                       // next FSM State
    },
    {   313,                                            // transitionId
        eState_On,                                      // current FSM State
        eTrigger_VisualisationSettingsOn,               // trigger update
        FSM_DONT_CARE,                                  // current active trigger(s)
        FSM_DONT_CARE,                                  // current not active trigger(s)
        eState_On                                       // next FSM State
    },
    //  ===== eState_View_Change_Waiting =====
    {   400,                                            // transitionId
        eState_View_Change_Waiting,                     // current FSM State
        eTrigger_VisualisationOn,                       // trigger update
        FSM_DONT_CARE,                                  // current active trigger(s)
        FSM_DONT_CARE,                                  // current not active trigger(s)
        eState_On                                       // next FSM State
    },
    {   401,                                            // transitionId
        eState_View_Change_Waiting,                     // current FSM State
        eTrigger_VisualisationOff,                      // trigger update
        FSM_DONT_CARE,                                  // current active trigger(s)
        FSM_DONT_CARE,                                  // current not active trigger(s)
        eState_Off                                      // next FSM State
    },
    {   401,                                            // transitionId
        eState_View_Change_Waiting,                     // current FSM State
        eTrigger_SpeedTooHighTrue,                      // trigger update
        FSM_DONT_CARE,                                  // current active trigger(s)
        FSM_DONT_CARE,                                  // current not active trigger(s)
        eState_Off                                      // next FSM State
    },
    // do actions
    {   410,                                            // transitionId
        eState_View_Change_Waiting,                     // current FSM State
        eTrigger_StateTimeout,                          // trigger update
        FSM_DONT_CARE,                                  // current active trigger(s)
        FSM_DONT_CARE,                                  // current not active trigger(s)
        eState_View_Change_Waiting                      // next FSM State
    },
    //  ===== eState_Off_Delay =======
    {   500,                                            // transitionId
        eState_Off_Delay,                               // current FSM State
        eTrigger_StateTimeout,                          // trigger update
        FSM_DONT_CARE,                                  // current active trigger(s)
        FSM_DONT_CARE,                                  // current not active trigger(s)
        eState_Off                                      // next FSM State
    },
    {   501,                                            // transitionId
        eState_Off_Delay,                               // current FSM State
        eTrigger_VisualisationOn,                       // trigger update
        FSM_DONT_CARE,                                  // current active trigger(s)
        FSM_DONT_CARE,                                  // current not active trigger(s)
        eState_On                                       // next FSM State
    },
    {   502,                                            // transitionId
        eState_Off_Delay,                               // current FSM State
        eTrigger_VisualisationOff,                      // trigger update
        FSM_DONT_CARE,                                  // current active trigger(s)
        FSM_DONT_CARE,                                  // current not active trigger(s)
        eState_Off                                      // next FSM State
    },
    {   503,                                            // transitionId
        eState_Off_Delay,                               // current FSM State
        eTrigger_SpeedTooHighTrue,                      // trigger update
        FSM_DONT_CARE,                                  // current active trigger(s)
        FSM_DONT_CARE,                                  // current not active trigger(s)
        eState_Off                                      // next FSM State
    },
    // do actions
    {   510,                                            // transitionId
        eState_Off_Delay,                               // current FSM State
        eTrigger_Frame_Timeout_False,                   // trigger update
        FSM_DONT_CARE,                                  // current active trigger(s)
        FSM_DONT_CARE,                                  // current not active trigger(s)
        eState_Off_Delay                                // next FSM State
    },

    // This State is maintained because only after 15s after CAN Frame Timeout confirmation we can Exit MVC view
    {   600,                                            // transitionId
        FSM_DONT_CARE,                                  // current FSM State
        eTrigger_Frame_Timeout_True,                    // trigger update
        eTrigger_VisualisationOn,                       // current active trigger(s)
        FSM_DONT_CARE,                                  // current not active trigger(s)
        eState_Off_Delay                                // next FSM State
    },
    //  == In all states > eState_Off ===
    {   601,                                            // transitionId
        FSM_DONT_CARE,                                  // current FSM State
        eTrigger_IgnitionOff,                           // trigger update
        FSM_DONT_CARE,                                  // current active trigger(s)
        FSM_DONT_CARE,                                  // current not active trigger(s)
        eState_Off                                      // next FSM State
    }
};

/******************************************************************************/
/* FUNCTION     dispvidctrl_tclFsm_Hmi                                             */
/******************************************************************************/
/**
*  \brief       default constructor
*
*  \param       none
*  \return      none
*/
/******************************************************************************/

/******************************************************************************/
/* FUNCTION     dispvidctrl_tclFsm_Mvc(dispvidctrl_tclFsm_Mvc* poMvcControl)  */
/******************************************************************************/
/**
*  \brief       constructor
*
*  \param       pointer to control application
*  \return      none
*/
/******************************************************************************/
dispvidctrl_tclFsm_Mvc::dispvidctrl_tclFsm_Mvc(dispvidctrl_tclControl_Mvc* poMvcControl):
    dispvidctrl_tclFsm_Base( eState_Uninitialized,
               ELEMENTE(aFsm_Mvc_StateTransitionTable),    aFsm_Mvc_StateTransitionTable,
               ELEMENTE(aFsm_Mvc_StateTable),              aFsm_Mvc_StateTable,
               (tU32) TR_CLASS_DISPVIDCTRL_APPLICATION,
               DISPVIDCTRL_TRACE_ID_FSM_MVC)
, m_poMvcControl(poMvcControl)
{
    ETG_TRACE_USR4((" FSM Mvc  :: dispvidctrl_tclFsm_Mvc(): ................... entered!                                "));

    // create timer for FSM state timeouts used for state verification
    if( OSAL_s32TimerCreate( (OSAL_tpfCallback)_pfCallbackTimer_FsmStateTimeout, (tPVoid)this, &m_hTimerHandle_FsmStateTimeout) != OSAL_OK)
    {
       ETG_TRACE_USR4(("ERROR - Could not create FSM timer!"));
       m_hTimerHandle_FsmStateTimeout = OSAL_C_INVALID_HANDLE;
    }
    
    // start timer for Speed Supervision
    if( OSAL_s32TimerCreate( (OSAL_tpfCallback)_pfCallbackTimer_SpeedSupervisionTimeout, (tPVoid)this, &m_hTimerHandle_SpeedSupervisionTimeout) != OSAL_OK)
    {
       ETG_TRACE_USR4(("ERROR - Could not create FSM timer!"));
       m_hTimerHandle_SpeedSupervisionTimeout = OSAL_C_INVALID_HANDLE;
    }
}

/******************************************************************************/
/* FUNCTION     ~dispvidctrl_tclFsm_Mvc                                       */
/******************************************************************************/
/**
*  \brief       destructor
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
dispvidctrl_tclFsm_Mvc::~dispvidctrl_tclFsm_Mvc(tVoid)
{
    ETG_TRACE_USR4((" FSM Mvc  :: ~dispvidctrl_tclFsm_Mvc(): .................. entered!                                "));

    //stop and delete all timer
    if (OSAL_C_INVALID_HANDLE != m_hTimerHandle_FsmStateTimeout)
    {
       (void) OSAL_s32TimerSetTime(m_hTimerHandle_FsmStateTimeout, 0, 0);
       (void) OSAL_s32TimerDelete(m_hTimerHandle_FsmStateTimeout);
    }
    if (OSAL_C_INVALID_HANDLE != m_hTimerHandle_SpeedSupervisionTimeout)
    {
       (void) OSAL_s32TimerSetTime(m_hTimerHandle_SpeedSupervisionTimeout, 0, 0);
       (void) OSAL_s32TimerDelete(m_hTimerHandle_SpeedSupervisionTimeout);
    }

    m_poMvcControl = NULL;
}

/******************************************************************************/
/* FUNCTION     tclCreateInstance                                             */
/******************************************************************************/
/**
*  \brief       Create instance (singleton pattern)
*
*  \param       pointer to control application
*  \return      instance pointer
*/
/******************************************************************************/
dispvidctrl_tclFsm_Mvc* dispvidctrl_tclFsm_Mvc::tclCreateInstance(dispvidctrl_tclControl_Mvc* poControl_Mvc)
{
    if (m_poInstance == NULL)
    {
        m_poInstance = OSAL_NEW dispvidctrl_tclFsm_Mvc(poControl_Mvc);
    }
    return m_poInstance;
}

/******************************************************************************/
/* FUNCTION     vNewTrigger                                                   */
/******************************************************************************/
/**
*  \brief       To be called to enter a new Trigger
*
*  \param       trigger and state
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclFsm_Mvc::vNewTrigger(tU32 u32Trigger, tBool bTriggerState)
{
    (tVoid) u32CalcNewFsmState(u32Trigger, bTriggerState);
}


/******************************************************************************/
/* FUNCTION     vUpdateTriggerState                                           */
/******************************************************************************/
/**
*  \brief       To be called to correct Trigger states
*
*  \param       Trigger and State
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclFsm_Mvc::vUpdateTriggerState(tU32 u32Trigger, tBool bTriggerState)
{
    vUpdateTrigger(u32Trigger, bTriggerState);
}


/******************************************************************************/
/* FUNCTION     vStateChangeDetected                                          */
/******************************************************************************/
/**
*  \brief       called when a state change happens
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclFsm_Mvc::vStateChangeDetected(tVoid)
{
    vTraceStatusInfo(0);
}


/******************************************************************************/
/* FUNCTION     vStartFsmStateTimer                                           */
/******************************************************************************/
/**
*  \brief       Called to start the state-timer
*
*  \param       time out value in milliseconds
*  \return      none
*/
/******************************************************************************/
// overwrites tclFsmBase class function
tVoid dispvidctrl_tclFsm_Mvc::vStartFsmStateTimer(tU32 u32Time)
{
   (tVoid) _bSetTimer_FsmStateChange((OSAL_tMSecond) u32Time);
}

/******************************************************************************/
/* FUNCTION     _bSetTimer_FsmStateChange                                     */
/******************************************************************************/
/**
*  \brief       start or stop the timer
*
*  \param       time out value in millisecond
*  \return      tBool - timer start/stop success state
*/
/******************************************************************************/
tBool  dispvidctrl_tclFsm_Mvc::_bSetTimer_FsmStateChange( OSAL_tMSecond msTimeout ) const
{
    tBool bSuccess = TRUE;
    if ( OSAL_C_INVALID_HANDLE != m_hTimerHandle_FsmStateTimeout ) {
        if ( OSAL_s32TimerSetTime( m_hTimerHandle_FsmStateTimeout, msTimeout, 0 ) != OSAL_OK )
        {
            bSuccess = FALSE;
        }
    }
    return(bSuccess);
}

/******************************************************************************/
/* FUNCTION     _pfCallbackTimer_FsmStateTimeout                              */
/******************************************************************************/
/**
*  \brief
*
*  \param       pArg - pointer to this class
*  \return      none
*/
/******************************************************************************/
OSAL_tpfCallback dispvidctrl_tclFsm_Mvc::_pfCallbackTimer_FsmStateTimeout(tVoid* pArg)
{
   (tVoid) pArg;

   if ((m_poInstance) && (m_poInstance->m_poMvcControl) ) {
      m_poInstance->m_poMvcControl->vHandleFsmOutEvent_Mvc( FSM_MVC_OUT__FSM_MVC_INPUT_EVENT,
                                                            (tU32) eTrigger_StateTimeout );
   }
   return 0;
}

/******************************************************************************/
/* FUNCTION     _bSetTimer_SpeedSupervision                                   */
/******************************************************************************/
/**
*  \brief       start or stop the timer
*
*  \param       time out value in millisecond
*  \return      tBool - timer start/stop success state
*/
/******************************************************************************/
tBool  dispvidctrl_tclFsm_Mvc::_bSetTimer_SpeedSupervision( OSAL_tMSecond msTimeout ) const
{
    tBool bSuccess = TRUE;
    if ( OSAL_C_INVALID_HANDLE != m_hTimerHandle_SpeedSupervisionTimeout ) {
        if ( OSAL_s32TimerSetTime( m_hTimerHandle_SpeedSupervisionTimeout, msTimeout, msTimeout ) != OSAL_OK )
        {
            bSuccess = FALSE;
        }
    }
    return(bSuccess);
}

/******************************************************************************/
/* FUNCTION     _pfCallbackTimer_SpeedSupervisionTimeout                      */
/******************************************************************************/
/**
*  \brief
*
*  \param       pArg - pointer to this class
*  \return      none
*/
/******************************************************************************/
OSAL_tpfCallback dispvidctrl_tclFsm_Mvc::_pfCallbackTimer_SpeedSupervisionTimeout(tVoid* pArg)
{
   (tVoid) pArg;

   if ((m_poInstance) && (m_poInstance->m_poMvcControl) ) {
      m_poInstance->m_poMvcControl->vHandleFsmOutEvent_Mvc( FSM_MVC_OUT__MVC_CHECK_CURRENT_SPEED, (tU32) 0 );
   }
   return 0;
}

/******************************************************************************/
/* FUNCTION     vUpdateRelatedTrigger                                         */
/******************************************************************************/
/**
*  \brief       to correct "hold" trigger states which are related to actual
*               trigger,
*               overwritten base class function
*
*  \param       actual Trigger
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclFsm_Mvc::vUpdateRelatedTrigger(tU32 u32Trigger)
{
    switch (u32Trigger)
    {
    case dispvidctrl_tclFsm_Mvc::eTrigger_VisualisationOff:
        vUpdateTrigger(dispvidctrl_tclFsm_Mvc::eTrigger_VisualisationOn, FALSE);
        break;
    case dispvidctrl_tclFsm_Mvc::eTrigger_VisualisationOn:
        vUpdateTrigger(dispvidctrl_tclFsm_Mvc::eTrigger_VisualisationOff, FALSE);
        vUpdateTrigger(dispvidctrl_tclFsm_Mvc::eTrigger_Frame_Timeout_True, FALSE);
        break;
    case dispvidctrl_tclFsm_Mvc::eTrigger_StateTimeout:
        vUpdateTrigger(dispvidctrl_tclFsm_Mvc::eTrigger_StateTimeout, FALSE);
        break;
    case dispvidctrl_tclFsm_Mvc::eTrigger_View_Change_Request:
        vUpdateTrigger(dispvidctrl_tclFsm_Mvc::eTrigger_View_Change_Request, FALSE);
        break;
    case eTrigger_Frame_Timeout_True:
        vUpdateTrigger(dispvidctrl_tclFsm_Mvc::eTrigger_Frame_Timeout_False, FALSE);
        break;
    case eTrigger_Frame_Timeout_False:
        vUpdateTrigger(dispvidctrl_tclFsm_Mvc::eTrigger_Frame_Timeout_True, FALSE);
        break;
    case eTrigger_VisualisationSettingsOn:
        vUpdateTrigger(dispvidctrl_tclFsm_Mvc::eTrigger_VisualisationSettingsOff, FALSE);
        break;
    case eTrigger_VisualisationSettingsOff:
        vUpdateTrigger(dispvidctrl_tclFsm_Mvc::eTrigger_VisualisationSettingsOn, FALSE);
        break;
    case eTrigger_SpeedTooHighTrue:
        vUpdateTrigger(dispvidctrl_tclFsm_Mvc::eTrigger_SpeedTooHighFalse, FALSE);
        break;
    case eTrigger_SpeedTooHighFalse:
        vUpdateTrigger(dispvidctrl_tclFsm_Mvc::eTrigger_SpeedTooHighTrue, FALSE);
        break;
    
    default:
        break;
    }
}

/******************************************************************************/
/* FUNCTION     vExit_Uninitialized                                           */
/******************************************************************************/
/**
*  \brief       to correct "hold" trigger states which are related to actual
*               trigger,
*               overwritten base class function
*
*  \param       actual Trigger
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclFsm_Mvc::vExit_Uninitialized(tVoid)
{
    // post event MVC to update MVC mode to HMI
    if (NULL != m_poInstance && NULL != m_poInstance->m_poMvcControl)
    {
        m_poInstance->m_poMvcControl->vHandleFsmOutEvent_Mvc(FSM_MVC_OUT__MVC_CHECK_MVC_VIEW_REQUEST);
    }
}

/******************************************************************************/
/* FUNCTION     vEntry_Off                                                    */
/******************************************************************************/
/**
*  \brief       to correct "hold" trigger states which are related to actual
*               trigger,
*               overwritten base class function
*
*  \param       actual Trigger
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclFsm_Mvc::vEntry_Off(tVoid)
{
    // post event MVC to update MVC mode to HMI
    if (NULL != m_poInstance && NULL != m_poInstance->m_poMvcControl)
    {
        // Clear the request to No View when we receive any response
        m_poInstance->m_poMvcControl->vHandleFsmOutEvent_Mvc(FSM_MVC_OUT__MVC_CLEAR_VIEW_REQUEST);
    }
}

/******************************************************************************/
/* FUNCTION     vDo_Off                                                       */
/******************************************************************************/
/**
*  \brief       to correct "hold" trigger states which are related to actual
*               trigger,
*               overwritten base class function
*
*  \param       actual Trigger
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclFsm_Mvc::vDo_Off(tVoid)
{
// eTrigger_Frame_Timeout_False
// eTrigger_SpeedTooHighFalse
// eTrigger_VisualisationOff

   if (NULL != m_poInstance)
   {
       if (m_poInstance->m_poMvcControl)
       {
           tU32 u32CurrentTrigger = m_poInstance->u32GetCurrentTrigger();
           
           // additional state specific entry actions
           switch (u32CurrentTrigger)
           {
              case dispvidctrl_tclFsm_Mvc::eTrigger_Frame_Timeout_False:
              case dispvidctrl_tclFsm_Mvc::eTrigger_SpeedTooHighFalse:
                 m_poInstance->m_poMvcControl->vHandleFsmOutEvent_Mvc( FSM_MVC_OUT__MVC_CHECK_MVC_VIEW_REQUEST );
                 break;
                 
              case dispvidctrl_tclFsm_Mvc::eTrigger_VisualisationOff:
                 m_poInstance->_bSetTimer_SpeedSupervision(0);
                 break;
           
              default:
                 break;
           }
       }
   }
}

/******************************************************************************/
/* FUNCTION     vEntry_On                                                     */
/******************************************************************************/
/**
*  \brief       to correct "hold" trigger states which are related to actual
*               trigger,
*               overwritten base class function
*
*  \param       actual Trigger
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclFsm_Mvc::vEntry_On(tVoid)
{
   if (NULL != m_poInstance)
   {
      if (m_poInstance->m_poMvcControl)
      {
          m_poInstance->m_poMvcControl->vHandleFsmOutEvent_Mvc(FSM_MVC_OUT__HMI_VISUALISATION_ON);
          // Clear the request to No View when we receive any response
          m_poInstance->m_poMvcControl->vHandleFsmOutEvent_Mvc(FSM_MVC_OUT__MVC_SEND_REQUEST);
          
          // Start speed supervision
          m_poInstance->_bSetTimer_SpeedSupervision(DISPVIDCTRL_MVC_SPEED_SUPERVISION_TIME_IN_MS);
      }
   }
}

/******************************************************************************/
/* FUNCTION     vExit_On                                                      */
/******************************************************************************/
/**
*  \brief       
*
*  \param       actual Trigger
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclFsm_Mvc::vExit_On(tVoid)
{
// Triggers:
// eTrigger_View_Change_Request
// eTrigger_IgnitionOff
// eTrigger_VisualisationOff
// eTrigger_Frame_Timeout_True
// eTrigger_SpeedTooHighTrue

   if (NULL != m_poInstance)
   {
      tU32 u32CurrentTrigger = m_poInstance->u32GetCurrentTrigger();
      
      // additional state specific entry actions
      switch (u32CurrentTrigger)
      {
         case dispvidctrl_tclFsm_Mvc::eTrigger_IgnitionOff:
         case dispvidctrl_tclFsm_Mvc::eTrigger_VisualisationOff:
         case dispvidctrl_tclFsm_Mvc::eTrigger_SpeedTooHighTrue:
            {
                if ( m_poInstance->m_poMvcControl ) {
                  // Visualisation is on -> switch off
                  m_poInstance->m_poMvcControl->vHandleFsmOutEvent_Mvc( FSM_MVC_OUT__HMI_VISUALISATION_OFF );
                }
            }
            break;

         default:
            break;
      }

      if ( TRUE == m_poInstance->bGetTriggerState( dispvidctrl_tclFsm_Mvc::eTrigger_VisualisationOff ) )
      {
         m_poInstance->_bSetTimer_SpeedSupervision(0);
      }
   }
}

/******************************************************************************/
/* FUNCTION     vDo_On                                                        */
/******************************************************************************/
/**
*  \brief       Currently only possible when View Mode Status Changes
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclFsm_Mvc::vDo_On(tVoid)
{
// Triggers:
// eTrigger_VisualisationOn : Change of View, update HMI with the new view info
// eTrigger_VisualisationSettingsOn : 
// eTrigger_VisualisationSettingsOff :

   if (NULL != m_poInstance)
   {
       if (m_poInstance->m_poMvcControl)
       {
          switch ( m_poInstance->u32GetCurrentTrigger() )
          {
              case eTrigger_VisualisationSettingsOn:
                m_poInstance->m_poMvcControl->vHandleFsmOutEvent_Mvc(FSM_MVC_OUT__HMI_VISUALISATION_ON_SETTINGS);
                break;

              case eTrigger_VisualisationOn:
              case eTrigger_VisualisationSettingsOff:
                m_poInstance->m_poMvcControl->vHandleFsmOutEvent_Mvc(FSM_MVC_OUT__HMI_VISUALISATION_ON);
                break;

              default:
                break;
          }
       }
   }
}

/******************************************************************************/
/* FUNCTION     vEntry_View_Change_Waiting                                    */
/******************************************************************************/
/**
*  \brief       Currently only possible when View Mode Status Changes
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclFsm_Mvc::vEntry_View_Change_Waiting(tVoid)
{
   if (NULL != m_poInstance)
   {
       if (m_poInstance->m_poMvcControl)
       {
           // Send the request to MVC ECU
           m_poInstance->m_poMvcControl->vHandleFsmOutEvent_Mvc(FSM_MVC_OUT__MVC_SEND_REQUEST);
       }
   }
}

/******************************************************************************/
/* FUNCTION     vDo_View_Change_Waiting                                       */
/******************************************************************************/
/**
*  \brief       Do Actions
*
*  \param       actual Trigger
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclFsm_Mvc::vDo_View_Change_Waiting(tVoid)
{
// Triggers:
// eTrigger_StateTimeout

   if (NULL != m_poInstance)
   {
       if (m_poInstance->m_poMvcControl)
       {
           // Maximum waiting time for HMI View Change Request has expired, check the current View Mode
           m_poInstance->m_poMvcControl->vHandleFsmOutEvent_Mvc(FSM_MVC_OUT__MVC_CLEAR_VIEW_REQUEST);
           m_poInstance->m_poMvcControl->vHandleFsmOutEvent_Mvc(FSM_MVC_OUT__MVC_CHECK_MVC_VIEW_REQUEST);
       }
   }
}

/******************************************************************************/
/* FUNCTION     vEntry_Off_Delay                                              */
/******************************************************************************/
/**
*  \brief       Do Actions
*
*  \param       actual Trigger
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclFsm_Mvc::vEntry_Off_Delay(tVoid)
{
   if (NULL != m_poInstance)
   {
       if (m_poInstance->m_poMvcControl)
       {
           m_poInstance->m_poMvcControl->vHandleFsmOutEvent_Mvc(FSM_MVC_OUT__MVC_CAN_SIGNAL_TIMEOUT);
       }
   }
}

/******************************************************************************/
/* FUNCTION     vDo_Off_Delay                                                 */
/******************************************************************************/
/**
*  \brief       Do Actions
*
*  \param       actual Trigger
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclFsm_Mvc::vDo_Off_Delay(tVoid)
{
// eTrigger_Frame_Timeout_False

    if (NULL != m_poInstance)
    {
        if (m_poInstance->m_poMvcControl)
        {
            // CAN Frame Recovered before timeout
            m_poInstance->m_poMvcControl->vHandleFsmOutEvent_Mvc(FSM_MVC_OUT__MVC_CHECK_MVC_VIEW_REQUEST);
        }
    }
}

/******************************************************************************/
/* FUNCTION     vExit_Off_Delay                                               */
/******************************************************************************/
/**
*  \brief       
*
*  \param       actual Trigger
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclFsm_Mvc::vExit_Off_Delay(tVoid)
{
    if ( m_poInstance && m_poInstance->m_poMvcControl )
    {
       // Visualisation is on -> switch off
       m_poInstance->m_poMvcControl->vHandleFsmOutEvent_Mvc( FSM_MVC_OUT__HMI_VISUALISATION_OFF );
    }
}
