/******************************************************************************/
/**
* \file    dispvidctrl_tclFsm_IpaSwitchOperation.h
* \ingroup
*
* \brief
*
* \remark  Copyright : (c) 2012 Robert Bosch GmbH, Hildesheim
* \remark  Author    : Michael Niemann CM-AI/PJ-CB32
* \remark  Scope     :
*
* \todo
*/
/******************************************************************************/
#ifndef _DISPVIDCTRL_TCL_FSM_IPASWITCHOPERATION_H_
#define _DISPVIDCTRL_TCL_FSM_IPASWITCHOPERATION_H_

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "dispvidctrl_tclFsm_Base.h"

//***********************************************************************
//  CLASS dispvidctrl_tclFsm_IpaSwitchOperation
//***********************************************************************

class dispvidctrl_tclFsm_IpaSwitchOperation: public dispvidctrl_tclFsm_Base
{
public:

    // Available States -------------------------------------------------------
    enum
    {
        eState_ReadyForSwitchOperation               = 0,
        eState_Send_NoSwitchOperation                = 1,
        eState_Send_SwitchOperated_KeyValue          = 2,
        eState_ReadyForSwitchAndLongPressOperation   = 3,
        eState_Send_LongPressOperation               = 4,
        eState_ReadyForSwitchAndNoLongPressOperation = 5,
        eState_Send_NoLongPressOperation             = 6,
        eState_Max,
        eState_Invalid                               = 0xFFFF
    };

    // Available Trigger ------------------------------------------------------
    enum
    {
        eTrigger_None                  = 0x00000000,
        eTrigger_KeyPress              = 0x00000001,
        eTrigger_KeyLongPress          = 0x00000002,
        eTrigger_KeyRelease            = 0x00000004,
        eTrigger_StateTimeout          = 0x00000008
    };

    static dispvidctrl_tclFsm_IpaSwitchOperation* tclCreateInstance(dispvidctrl_tclControl_Avm* poControl_Avm);

    dispvidctrl_tclFsm_IpaSwitchOperation();                                // constructor
    dispvidctrl_tclFsm_IpaSwitchOperation( dispvidctrl_tclControl_Avm *poControl_Avm);      // constructor
    virtual ~dispvidctrl_tclFsm_IpaSwitchOperation();                       // destructor

    tVoid vNewTrigger(tU32 u32Trigger, tBool bTriggerState, tU8 u8Key = 0);

    tVoid vFsmInfo();

protected:
    virtual tVoid vStartFsmStateTimer(tU32 u32Time); // overwrites FsmBase class function
    virtual tVoid vStateChangeDetected(tVoid); // overwrites FsmBase class function

private:
    static tVoid vEntry_Send_NoSwitchOperation(tVoid);
    static tVoid vEntry_Send_SwitchOperated_KeyValue(tVoid);
    static tVoid vEntry_Send_LongPressOperation(tVoid);
    static tVoid vEntry_Send_NoLongPressOperation(tVoid);

    static OSAL_tpfCallback _pfCallbackTimer_FsmStateTimeout(tVoid* pArg);
    OSAL_tTimerHandle  m_hTimerHandle_FsmStateTimeout;


    static TFsmStateConf     aFsm_IpaSwitchOperation_StateTable[eState_Max];
    static TStateTransitions aFsm_IpaSwitchOperation_StateTransitionTable[];

    dispvidctrl_tclControl_Avm*                    m_poControl_Avm;
    static dispvidctrl_tclFsm_IpaSwitchOperation*  m_poInstance;

    tBool m_bStateTimeout;

    tU8  m_u8KeyValue_Trigger;  // to hold the key value of the current received trigger
    tU8  m_u8KeyValue_SwitchOperation; // to hold the key value of the current operation
    tU8  m_u8KeyValue_LongPressSwitchOperation; // to hold the key value for an possible long press operation
};


#endif // _DISPVIDCTRL_TCL_FSM_IPASWITCHOPERATION_H_

/*******************************************************************************
*                                       E O F
*******************************************************************************/
