/*****************************************************************************
* FILE:         dispvidctrl_tclFsm_HmiAvm3.h
* PROJECT:      G3G project
* SW-COMPONENT: DisplayVideoController
* Template:     appl_tclFsm.cpp.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  Generated file
*               User specific implementations are possible only between these tags:
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2018 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

#ifndef _DISPVIDCTRL_TCL_FSM_HMIAVM3_H_
#define _DISPVIDCTRL_TCL_FSM_HMIAVM3_H_

/*******************************************************************************
                        Includes
*******************************************************************************/
#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC
   #define OSAL_S_IMPORT_INTERFACE_GENERIC
   #include "osal_if.h"
#endif

#include "dispvidctrl_tclFsm_Base.h"

// dispvidctrl_tclFsm_HmiAvm3::Includes: user specific code start
// dispvidctrl_tclFsm_HmiAvm3::Includes: user specific code end

/*******************************************************************************
                        Defines
*******************************************************************************/

// dispvidctrl_tclFsm_HmiAvm3::Defines: user specific code start
// dispvidctrl_tclFsm_HmiAvm3::Defines: user specific code end


class dispvidctrl_tclControl_HmiAvm3;
//******************************************************************************
//  CLASS dispvidctrl_tclFsm_HmiAvm3
//******************************************************************************

class dispvidctrl_tclFsm_HmiAvm3: public dispvidctrl_tclFsm_Base
{
   public:
      // available FSM states ------------------------------------------
      typedef enum
      {
         eStateHmiAvm3_OFF = 0,   // <== initial state
         eStateHmiAvm3_WAIT_FOR_BLANK_IN = 1,
         eStateHmiAvm3_BLANK_IN_ACTIVE = 2,
         eStateHmiAvm3_ON = 3,
         eStateHmiAvm3_WAIT_FOR_BLANK_OUT = 4,
         eStateHmiAvm3_BLANK_OUT_ACTIVE = 5,
         eStateHmiAvm3_DIAG_BLANK_IN_ACTIVE = 6,
         eStateHmiAvm3_ON_DIAG = 7,
         eStateHmiAvm3_DIAG_BLANK_OUT_ACTIVE = 8,
         eStateHmiAvm3_ON_VID_SETTINGS = 9,
         eStateHmiAvm3_EXEC_FSM_RESET = 10,

         eStateHmiAvm3_MAX,
         eStateHmiAvm3_INVALID = FSM_STATE_ID_NONE
      } tenFsmHmiAvm3State;

      // available FSM input triggers -----------------------------------
      typedef enum
      {
         eTriggerHmiAvm3_NONE = FSM_TRIGGER_ID_NONE,

         eTriggerHmiAvm3_HMI_AVAILABLE = 0x00000001,
         eTriggerHmiAvm3_AVM_REQ_VISUAL_ON = 0x00000002,
         eTriggerHmiAvm3_VIDSET_REQ_VISUAL_ON = 0x00000004,
         eTriggerHmiAvm3_DIAG_REQ_VISUAL_ON = 0x00000008,
         eTriggerHmiAvm3_AVM_REQ_VISUAL_OFF = 0x00000010,
         eTriggerHmiAvm3_AVM_REQ_BLANK_IN_END = 0x00000020,
         eTriggerHmiAvm3_AVM_REQ_BLANK_OUT_END = 0x00000040,
         eTriggerHmiAvm3_AVM_REQ_BLANKLESS_CHG = 0x00000080,
         eTriggerHmiAvm3_HMI_CONF_BLANK_IN = 0x00000100,
         eTriggerHmiAvm3_HMI_CONF_ON = 0x00000200,
         eTriggerHmiAvm3_HMI_CONF_BLANK_OUT = 0x00000400,
         eTriggerHmiAvm3_HMI_CONF_OFF = 0x00000800,
         eTriggerHmiAvm3_HMI_CONF_ON_CAM_SETTINGS = 0x00001000,
         eTriggerHmiAvm3_AVM_CONF_VIEW_SETUP = 0x00002000,
         eTriggerHmiAvm3_STATE_TOUT_WAIT_FOR_BLANK_IN = 0x00004000,
         eTriggerHmiAvm3_STATE_TOUT_WAIT_FOR_BLANK_OUT = 0x00008000,
         eTriggerHmiAvm3_STATE_TOUT_DIAG_BLANK_IN = 0x00010000,
         eTriggerHmiAvm3_STATE_TOUT_DIAG_BLANK_OUT = 0x00020000,
         eTriggerHmiAvm3_REQ_FSM_RESET = 0x00040000,
      } tenFsmHmiAvm3Trigger;

      // available FSM transition actions ------------------------------
      typedef enum
      {
         eActionHmiAvm3_NONE = FSM_TRANSITION_ACTION_ID_NONE,

         eActionHmiAvm3_SetTimer = 1,
         eActionHmiAvm3_RequestViewSetup = 2,
         eActionHmiAvm3_RequestViewSetupUpdate = 3,
      } tenFsmHmiAvm3Action;

      // available symbolic FSM transition ID names ------------------------------
      typedef enum
      {
         eTransIdHmiAvm3_NONE = FSM_TRANSITION_ID_NONE,


      } tenFsmHmiAvm3TransId;
      
      // available FSM timers ------------------------------
      typedef enum
      {
         eTimerHmiAvm3_NONE = FSM_TIMER_ID_NONE,

         eTimerHmiAvm3_StateToutWaitForBlankIn = 1,
         eTimerHmiAvm3_StateToutWaitForBlankOut = 2,
         eTimerHmiAvm3_StateToutDiagBlankIn = 3,
         eTimerHmiAvm3_StateToutDiagBlankOut = 4,
      } tenFsmHmiAvm3Timer;
      
      static dispvidctrl_tclFsm_HmiAvm3* tclCreateInstance(dispvidctrl_tclControl_HmiAvm3* poControl);

      dispvidctrl_tclFsm_HmiAvm3();                           // default constructor
      dispvidctrl_tclFsm_HmiAvm3(dispvidctrl_tclControl_HmiAvm3* poControl);  // constructor
      virtual ~dispvidctrl_tclFsm_HmiAvm3(tVoid);             // destructor


      tVoid vNewTrigger(tU32 u32Trigger, tBool bTriggerState);
      tVoid vUpdateTriggerState(tU32 u32Trigger, tBool bTriggerState);

   protected:
      virtual tVoid vStateChangeDetected(tVoid);             // overwrites FsmBase class function
      virtual tVoid vStartFsmStateTimer(tU32 u32Time);       // overwrites FsmBase class function
      virtual tVoid vUpdateRelatedTrigger(tU32 u32Trigger);  // overwrites FsmBase class function
      virtual tVoid vTransitionAction(tU32 u32ActionId, tU32 u32Param1=0, tU32 u32Param2=0);  // overwrites FsmBase class function

   private:
      static tVoid vEntry_OFF(tVoid);
      static tVoid vEntry_WAIT_FOR_BLANK_IN(tVoid);
      static tVoid  vExit_WAIT_FOR_BLANK_IN(tVoid);
      static tVoid vEntry_BLANK_IN_ACTIVE(tVoid);
      static tVoid  vExit_BLANK_IN_ACTIVE(tVoid);
      static tVoid vEntry_ON(tVoid);
      static tVoid vEntry_WAIT_FOR_BLANK_OUT(tVoid);
      static tVoid  vExit_WAIT_FOR_BLANK_OUT(tVoid);
      static tVoid vEntry_BLANK_OUT_ACTIVE(tVoid);
      static tVoid  vExit_BLANK_OUT_ACTIVE(tVoid);
      static tVoid vEntry_DIAG_BLANK_IN_ACTIVE(tVoid);
      static tVoid vEntry_ON_DIAG(tVoid);
      static tVoid vEntry_DIAG_BLANK_OUT_ACTIVE(tVoid);
      static tVoid vEntry_ON_VID_SETTINGS(tVoid);


      // user-managed timer StateToutWaitForBlankIn:
      OSAL_tTimerHandle          _hTimerHandle_StateToutWaitForBlankIn;
      tBool                         _bSetTimer_StateToutWaitForBlankIn(OSAL_tMSecond msTimeout) const;
      static OSAL_tpfCallback _pfCallbackTimer_StateToutWaitForBlankIn(tVoid* pArg);

      // user-managed timer StateToutWaitForBlankOut:
      OSAL_tTimerHandle          _hTimerHandle_StateToutWaitForBlankOut;
      tBool                         _bSetTimer_StateToutWaitForBlankOut(OSAL_tMSecond msTimeout) const;
      static OSAL_tpfCallback _pfCallbackTimer_StateToutWaitForBlankOut(tVoid* pArg);

      // user-managed timer StateToutDiagBlankIn:
      OSAL_tTimerHandle          _hTimerHandle_StateToutDiagBlankIn;
      tBool                         _bSetTimer_StateToutDiagBlankIn(OSAL_tMSecond msTimeout) const;
      static OSAL_tpfCallback _pfCallbackTimer_StateToutDiagBlankIn(tVoid* pArg);

      // user-managed timer StateToutDiagBlankOut:
      OSAL_tTimerHandle          _hTimerHandle_StateToutDiagBlankOut;
      tBool                         _bSetTimer_StateToutDiagBlankOut(OSAL_tMSecond msTimeout) const;
      static OSAL_tpfCallback _pfCallbackTimer_StateToutDiagBlankOut(tVoid* pArg);

      tBool bSetTimer(tU32 u32TimerId, tU32 u32MilliSec) const;  // pass one of the tenFsmHmiAvm3Timer values as u32TimerId, and 0 as u32MilliSec to stop the timer


      static TFsmStateConf     aFsm_HmiAvm3_StateTable[eStateHmiAvm3_MAX];
      static TStateTransitions aFsm_HmiAvm3_StateTransitionTable[];

      dispvidctrl_tclControl_HmiAvm3*     m_poControl;
      static dispvidctrl_tclFsm_HmiAvm3*  m_poInstance;

   // dispvidctrl_tclFsm_HmiAvm3::ClassDeclaration: user specific code start
   public:
      enum tenHmiVisualisationOffReason
      {
         EN_VD_RVC_HMI_VISUALISATION_OFF__NOT_SPEZIFIED = 0,
         EN_VD_RVC_HMI_VISUALISATION_OFF__REQUEST_OFF,
         EN_VD_RVC_HMI_VISUALISATION_OFF__ON_REQUEST_AFTER_BLACKOUT,
         EN_VD_RVC_HMI_VISUALISATION_OFF__SERVICE_REQUEST_OFF, // Used for Ignition, Speed, Disable triggers
         EN_VD_RVC_HMI_VISUALISATION_OFF__VIDEO_SIGNAL_FAILURE,
         EN_VD_RVC_HMI_VISUALISATION_OFF__RVC_ELECTRIC_FAILURE,
         EN_VD_RVC_HMI_VISUALISATION_OFF__SYSTEM_MALFUNCTION,
         EN_VD_RVC_HMI_VISUALISATION_OFF__APPLICATION_STATE_NOT_NORMAL,
         EN_VD_RVC_HMI_VISUALISATION_OFF__CRITICAL_UNDERVOLTAGE,
         EN_VD_RVC_HMI_VISUALISATION_OFF__HMI_NOT_AVAILABLE,
         EN_VD_RVC_HMI_VISUALISATION_OFF__DIAG_VIDEO_LAYER_OFF,
         EN_VD_RVC_HMI_VISUALISATION_OFF__GUIDELINE_ADJUSTMENT_OFF,
         EN_VD_RVC_HMI_VISUALISATION_OFF__INITIAL_OFF
      };
      
      tenHmiVisualisationOffReason m_enHmiVisualisationOffReason;
      
      void bSetVideoCapturingOnOrOff(tBool bOn);
   // dispvidctrl_tclFsm_HmiAvm3::ClassDeclaration: user specific code end
};

// dispvidctrl_tclFsm_HmiAvm3::Tail: user specific code start
// dispvidctrl_tclFsm_HmiAvm3::Tail: user specific code end

#endif

