/******************************************************************************/
/**
* \file    dispvidctrl_tclFsm_CameraSupplySupervision.h
* \ingroup
*
* \brief
*
* \remark  Copyright : (c) 2015 Robert Bosch GmbH, Hildesheim
* \remark  Author    : Michael Niemann
* \remark  Scope     : A-IVI
*
* \todo
*/
/******************************************************************************/
#ifndef _DISPVIDCTRL_TCL_FSM_CAMERASUPPLYSUPERVISION_H_
#define _DISPVIDCTRL_TCL_FSM_CAMERASUPPLYSUPERVISION_H_

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "dispvidctrl_tclFsm_Base.h"

//***********************************************************************
//  CLASS
//***********************************************************************

class dispvidctrl_tclFsm_CameraSupplySupervision: public dispvidctrl_tclFsm_Base
{
   public:

      // Available States -----------------------------------------------
      enum
      {
         eState_Off                       = 0,
         eState_On                        = 1,
         eState_DiagControlCamera         = 2,
         eState_DiagControlMicrophone     = 3,
         eState_Max,
         eState_Invalid                   = 0xFFFF
      };

      // Available Trigger ----------------------------------------------
      enum
      {
         eTrigger_None                        = 0x00000000,

         eTrigger_StateTimeout                = 0x00000001,
         eTrigger_SupervisionOff              = 0x00000002,
         eTrigger_SupervisionOn               = 0x00000004,
         eTrigger_SupervisionTimeout          = 0x00000008,

         eTrigger_SendNextTestResult          = 0x00000010,
         eTrigger_CameraSupplyError           = 0x00000020,

         eTrigger_DiagCameraSupervisionOn     = 0x00000100,
         eTrigger_DiagCameraSupervisionOff    = 0x00000200,
         eTrigger_DiagMicSupervisionOn        = 0x00000400,
         eTrigger_DiagMicSupervisionOff       = 0x00000800,

         eTrigger_SpeedSupervisionActive      = 0x00001000
      };

      static dispvidctrl_tclFsm_CameraSupplySupervision* tclCreateInstance(dispvidctrl_tclControl_Rvc* poControl_Rvc);

      dispvidctrl_tclFsm_CameraSupplySupervision();                                     // default constructor
      dispvidctrl_tclFsm_CameraSupplySupervision(dispvidctrl_tclControl_Rvc* poControl_Rvc); // constructor
      virtual ~dispvidctrl_tclFsm_CameraSupplySupervision();                            // destructor

      tVoid vNewTrigger(tU32 u32Trigger, tBool bTriggerState) const;
      tVoid vUpdateTriggerState(tU32 u32Trigger, tBool bTriggerState);

   protected:
      virtual tVoid vStartFsmStateTimer(tU32 u32Time); // overwrites FsmBase class function
      virtual tVoid vStateChangeDetected(tVoid);
      virtual tVoid vUpdateRelatedTrigger(tU32 u32Trigger);

   private:
      static tVoid vEntry_Off(tVoid);
      static tVoid    vDo_Off(tVoid);
      static tVoid  vExit_Off(tVoid);
      static tVoid vEntry_On(tVoid);
      static tVoid    vDo_On(tVoid);
      static tVoid  vExit_On(tVoid);
      static tVoid    vDo_DiagControlCamera(tVoid);
      static tVoid    vDo_DiagControlMicrophone(tVoid);

      static OSAL_tpfCallback _pfCallbackTimer_FsmStateTimeout(tVoid* pArg);
      static OSAL_tpfCallback _pfCallbackTimer_FsmSupervisionTimeout(tVoid* pArg);
      tVoid vStartFsmSupervisionTimer(tU32 u32Time);
      OSAL_tTimerHandle  m_hTimerHandle_FsmStateTimeout;
      OSAL_tTimerHandle  m_hTimerHandle_FsmSupervisionTimeout;

      static TFsmStateConf     aFsm_CameraSupplySupervision_StateTable[eState_Max];
      static TStateTransitions aFsm_CameraSupplySupervision_StateTransitionTable[];

      dispvidctrl_tclControl_Rvc*           m_poControl_Rvc;
      static dispvidctrl_tclFsm_CameraSupplySupervision*  m_poInstance;
};


#endif // _DISPVIDCTRL_TCL_FSM_REVERSESIGNAL_H_

/*******************************************************************************
*                                       E O F
*******************************************************************************/

