/******************************************************************************/
/**
* \file    dispvidctrl_tclFsm_Avm.h
* \ingroup
*
* \brief
*
* \remark  Copyright : (c) 2015 Robert Bosch GmbH, Hildesheim
* \remark  Author    : Michael Niemann
* \remark  Scope     : A-IVI
*
* \todo
*/
/******************************************************************************/
#ifndef _DISPVIDCTRL_TCL_FSM_AVM_H_
#define _DISPVIDCTRL_TCL_FSM_AVM_H_

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "dispvidctrl_tclFsm_Base.h"

//***********************************************************************
//  CLASS
//***********************************************************************
class dispvidctrl_tclControl_Avm;
class dispvidctrl_tclFsm_Avm: public dispvidctrl_tclFsm_Base
{
public:

      // Available States -----------------------------------------------
      enum
      {
         eState_AVM_UNINITIALISED                     =  0,
         eState_AVM_OFF                               =  1,
         eState_AVM_ON                                =  2,
         eState_AVM_ON_WAIT_FOR_REVERSE_OFF           =  3,
         eState_AVM_OFF_CAMERA_SETTINGS_WAIT_FOR_ON   =  4,
         eState_AVM_ON_CAMERA_SETTINGS                =  5,
         eState_AVM_ON_CAMERA_SETTINGS_TEMPORAL       =  6, // special settings state, we can enter here only from AVM_ON and fall back to either AVM_ON or AVM_OFF

          eState_Max,
          eState_Invalid                  = 0xFFFF
      };

      // Available Trigger ----------------------------------------------
      enum
      {
         eTrigger_NONE                                       = 0x00000000,
         eTrigger_AVM_EV_INIT_DONE                           = 0x00000001,
         eTrigger_AVM_EV_INIT_ACTIVE                         = 0x00000002,
         eTrigger_AVM_EV_IGNITION_ON                         = 0x00000004,
         eTrigger_AVM_EV_IGNITION_OFF                        = 0x00000008,

         eTrigger_AVM_EV_REINIT_TIMEOUT                      = 0x00000010,
         eTrigger_AVM_EV_CAN_MSG_TIMEOUT_FALSE               = 0x00000020,
         eTrigger_AVM_EV_CAN_MSG_TIMEOUT_TRUE                = 0x00000040,
         eTrigger_AVM_EV_CAMERA_BUTTON_PRESS                 = 0x00000080,

         eTrigger_AVM_EV_CAMERA_BUTTON_LONG_PRESS            = 0x00000100,
         eTrigger_AVM_EV_NORMAL_BEEP                         = 0x00000200,
         eTrigger_AVM_EV_ERROR_BEEP                          = 0x00000400,
         eTrigger_AVM_EV_CAMERA_SCREEN_ON                    = 0x00000800,

         eTrigger_AVM_EV_CAMERA_SCREEN_OFF                   = 0x00001000,
         eTrigger_AVM_EV_CAMERA_SETTINGS_ON                  = 0x00002000,
         eTrigger_AVM_EV_PURPOSE_SWITCH                      = 0x00004000,
         eTrigger_AVM_EV_AFFORDABLE_ITS                      = 0x00008000,

         eTrigger_AVM_EV_REVERSE_ON_DEBOUNCED                = 0x00010000,
         eTrigger_AVM_EV_REVERSE_OFF                         = 0x00020000,
         eTrigger_AVM_EV_DEBOUNCE_STATE                      = 0x00040000,
         eTrigger_AVM_EV_TIMEOUT_VIEW_CHANGE_REQUEST_WAIT    = 0x00080000,

         eTrigger_AVM_EV_VIDEO_SIGNAL_FAILURE                = 0x00100000,
         eTrigger_AVM_EV_VIDEO_SIGNAL_RESTORED               = 0x00200000,
         eTrigger_AVM_EV_TIMEOUT_CAMERA_OFF_REQUEST_DELAY    = 0x00400000,
         eTrigger_AVM_EV_VERIFY_AFTER_VIEW_STATUS_STOPPED    = 0x00800000,
         
         eTrigger_AVM_EV_CAMERA_SETTINGS_OFF                 = 0x01000000,
         eTrigger_AVM_EV_VIEW_STATUS_UPDATE                  = 0x02000000,
         eTrigger_AVM_EV_ERROR_TRUE                          = 0x04000000,
         eTrigger_AVM_EV_ERROR_FALSE                         = 0x08000000,
         eTrigger_StateTimeout                               = 0x80000000
      };

      static dispvidctrl_tclFsm_Avm* tclCreateInstance(dispvidctrl_tclControl_Avm* poControl_Avm);

      dispvidctrl_tclFsm_Avm();                                      // constructor
      dispvidctrl_tclFsm_Avm(dispvidctrl_tclControl_Avm* poControl_Avm);  // constructor
      virtual ~dispvidctrl_tclFsm_Avm();                             // destructor

      tVoid vNewTrigger(tU32 u32Trigger, tBool bTriggerState) const;
      tVoid vUpdateTriggerState(tU32 u32Trigger, tBool bTriggerState);
      inline tBool bGetSetTimer_AvmReinit(OSAL_tMSecond msTimeout)  {return _bSetTimer_AvmReinit(msTimeout);}


   protected:
      virtual tVoid vStartFsmStateTimer(tU32 u32Time); // overwrites FsmBase class function
      virtual tVoid vStateChangeDetected(tVoid);       // overwrites FsmBase class function
      virtual tVoid vUpdateRelatedTrigger(tU32 u32Trigger);

   private:
      tVoid vTransitionActionHandler(tU32 u32Trigger);

      static tVoid vEntry_AvmUninitialised(tVoid);
      static tVoid vExit_AvmUninitialised(tVoid);
      static tVoid vDo_AvmUnitialized(tVoid);

      static tVoid vEntry_AvmOff(tVoid);
      static tVoid vExit_AvmOff(tVoid);
      static tVoid vDo_AvmOff(tVoid);

      static tVoid vEntry_AvmOn(tVoid);
      static tVoid vExit_AvmOn(tVoid);
      static tVoid vDo_AvmOn(tVoid);

      static tVoid vEntry_AvmOnWaitForReverseOff(tVoid);
      static tVoid vExit_AvmOnWaitForReverseOff(tVoid);
      static tVoid vDo_AvmOnWaitForReverseOff(tVoid);

      static tVoid vEntry_AvmOffCameraSettingsWaitForOn(tVoid);
      static tVoid vExit_AvmOffCameraSettingsWaitForOn(tVoid);
      static tVoid vDo_AvmOffCameraSettingsWaitForOn(tVoid);

      static tVoid vEntry_AvmOnCameraSettings(tVoid);
      static tVoid vExit_AvmOnCameraSettings(tVoid);
      static tVoid vDo_AvmOnCameraSettings(tVoid);
      
      static tVoid vEntry_AvmOnCameraSettingsTemporal(tVoid);
      static tVoid vExit_AvmOnCameraSettingsTemporal(tVoid);
      static tVoid vDo_AvmOnCameraSettingsTemporal(tVoid);

      static TFsmStateConf     aFsm_Avm_StateTable[eState_Max];
      static TStateTransitions aFsm_Avm_StateTransitionTable[];

      static OSAL_tpfCallback _pfCallbackTimer_AvmReinit(tVoid* pArg);
      static OSAL_tpfCallback _pfCallbackTimer_ViewChangeRequestWait(tVoid* pArg);
      static OSAL_tpfCallback _pfCallbackTimer_CameraOffRequestDelay(tVoid* pArg);
      static OSAL_tpfCallback _pfCallbackTimer_FsmStateChange(tVoid* pArg);
      //static OSAL_tpfCallback _pfCallbackTimer_FsmStateTimeout(tVoid* pArg);
      tBool  _bSetTimer_AvmReinit(OSAL_tMSecond msTimeout);
      tBool  _bSetTimer_ViewChangeRequestWait(OSAL_tMSecond msTimeout);
      tBool  _bSetTimer_CameraOffRequestDelay(OSAL_tMSecond msTimeout);
      tBool  _bSetTimer_FsmStateChange(OSAL_tMSecond msTimeout);
      OSAL_tTimerHandle  m_hTimerHandle_AvmReinit;
      OSAL_tTimerHandle  m_hTimerHandle_ViewChangeRequestWait;
      OSAL_tTimerHandle  m_hTimerHandle_CameraOffRequestDelay;
      OSAL_tTimerHandle  m_hTimerHandle_FsmStateChange;

      dispvidctrl_tclControl_Avm*     m_poControl_Avm;
      static dispvidctrl_tclFsm_Avm*  m_poInstance;

//      tBool  m_bStateTimeout;
};


#endif // _DISPVIDCTRL_TCL_FSM_AVM_H_

/*******************************************************************************
*                                       E O F
*******************************************************************************/

