/******************************************************************************/
/**
* \file    dispvidctrl_tclDiagRoutineControlListener.cpp
* \ingroup
*
* \brief
*
* \remark  Copyright : (c) 2012 Robert Bosch GmbH, Hildesheim
* \remark  Author    :
* \remark  Scope     :
*
* \todo
*/
/******************************************************************************/
/* DESCRIPTION: Example implementation of a routine control listener
* that provides access to demodata. The difference of this example
* compared to a real world use case is the fact, that usually for a routine
* control you would have longer running tests.
* In case of longer running tests you probably delegate a test request to
* a worker thread. It is no problem to send the response from this worker
* thread instead of how it is done in this example. When you have a worker
* thread the RoutineControlAbort functionality also makes more sense :)
* See general documentation, when you have questions on the sequence of
* a test that you have to implement or consult diagnosis team.
* Anyway take this class as a template for your own listener classes and
* adjust the parts marked with
*************************************************************************/
#include "dispvidctrl_AppMain.h"
#include "dispvidctrl_tclDiagRoutineControlListener.h"
#include "dispvidctrl_tclFsm_Hmi.h"
#include "dispvidctrl_tclControl_Hmi.h"
#include "dispvidctrl_tclFsm_HmiAvm3.h"
#include "dispvidctrl_tclControl_HmiAvm3.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_DISPVIDCTRL_APPLICATION
#include "trcGenProj/Header/dispvidctrl_tclDiagRoutineControlListener.cpp.trc.h"
#endif


/******************************************************************************/
/* FUNCTION     dispvidctrl_tclDiagRoutineControlListener                          */
/******************************************************************************/
/**
*  \brief       default constructor
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
// Private, can not be called
dispvidctrl_tclDiagRoutineControlListener::dispvidctrl_tclDiagRoutineControlListener()
: m_poRoutineCtrlIF(OSAL_NULL)
, m_poAppMain(OSAL_NULL)
{
}


/******************************************************************************/
/* FUNCTION     dispvidctrl_tclDiagRoutineControlListener(..)                      */
/******************************************************************************/
/**
*  \brief       constructor
*
*  \param       pointer to routine control interface
*  \return      none
*/
/******************************************************************************/
dispvidctrl_tclDiagRoutineControlListener::dispvidctrl_tclDiagRoutineControlListener(diaglib::tclRoutineControlIF* poIF, dispvidctrl_tclAppMain* poAppMain)
{
   // +++ Init your data here +++
   m_poRoutineCtrlIF = OSAL_NULL;
   m_poAppMain = OSAL_NULL;
   
   if(OSAL_NULL == poIF)
   {
      // +++ Trace Error +++
   }
   else
   {
      // +++ Store the interface pointer +++
      m_poRoutineCtrlIF = poIF;
   }

   if(OSAL_NULL == poAppMain)
   {
      // +++ Trace Error +++
   }
   else
   {
      // +++ Store the main App pointer +++
      m_poAppMain = poAppMain;
   }
}


/******************************************************************************/
/* FUNCTION     ~dispvidctrl_tclControlAssistant_Rvc()                             */
/******************************************************************************/
/**
*  \brief       destructor
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
dispvidctrl_tclDiagRoutineControlListener::~dispvidctrl_tclDiagRoutineControlListener()
{
   // +++ Free resources you might have created/used +++
   m_poRoutineCtrlIF = OSAL_NULL;
   m_poAppMain = OSAL_NULL;
}


/***********************************************************************//**
* \brief Incoming Get Routine result event handler
*
* Is called on incoming "Get Routine Result" requests. Components reaction
* should be one of the following:
* \li You found the routine results: Send back a RoutineResult message
*     containing poMsgContext, tenRoutineCtrlResult (PASSED or
*     FAILED)and the result vector as specified in the ID spec.
* \li You can't find the routine results: Send back a RoutineResult
*     message containing poMsgContext, tenRoutineCtrlResult
*     (NO_RESULT_AVAILABLE) and an ResultVector containing exactly one
*     parameter of type U8_ERROR and the value ROUTINE_NEVER_RAN or
*     ROUTINE_STILL_RUNNING.
*
* \param[in]      u32RoutineId Routine control ID of the incoming request
* \param[in]      poMsgContext Internal message context. Just return exactly
*                 this context when you answer to this request.
*
* \return         tU32 ResultCode, currently not checked. Please return 0.
* \todo           Insert scenario description and link sequence diagrams
*//*************************************************************************/
tU32 dispvidctrl_tclDiagRoutineControlListener::vOnGetRoutineResult (
                                      tU32 u32RoutineId,
                                      diaglib::tContext MsgContext
                                    )
{

   OSAL_C_PARAMETER_INTENTIONALLY_UNUSED( u32RoutineId );

   // we have a short running test
   vSendError(diaglib::EN_ERROR_ID_NOT_SUPPORTED, MsgContext);
   return diaglib::U32_DIAGLIB_RETURN_NOT_OK;
}


/***********************************************************************//**
* \brief Incoming Routine control abort event handler
*
* Is called on incoming "Abort routine control" requests. Components
* reaction should be one of the following:
* \li The routine is running: Inform the routine (Worker Thread) that is
*     supposed to stop. After it stopped in fact or immediately before it
*     does, send a RoutineResult message containing the following:
*     poMsgContext, tenRoutineCtrlResult (ABORTED) and an empty
*     result vector.
* \li The routine is NOT running: Send back a RoutineResult message
*     containing poMsgContext, tenRoutineCtrlResult
*     (COULD_NOT_BE_ABORTED) and a ResultVector containing exactly one
*     parameter of type U8_ERROR and the value ROUTINE_NOT_RUNNING.
*
* \param[in]      u32RoutineId RoutineID diagnosis wants to be aborted
* \param[in]      poMsgContext Internal message context. Just return exactly
*                 this context when you answer to this request.
*
* \return         tU32 ResultCode, currently not checked. Please return 0.
* \todo           Insert scenario description and link sequence diagrams
*//*************************************************************************/
tU32 dispvidctrl_tclDiagRoutineControlListener::vOnRoutineControlAbort (
                                         tU32 u32RoutineId,
                                         diaglib::tContext MsgContext
                                       )
{
   OSAL_C_PARAMETER_INTENTIONALLY_UNUSED( u32RoutineId );


   // we have a short running test
   vSendError(diaglib::EN_ERROR_ID_NOT_SUPPORTED, MsgContext);
   return diaglib::U32_DIAGLIB_RETURN_NOT_OK;
}



/***********************************************************************//**
* \brief Incoming Routine control start event handler
*
* Is called on incoming "Start routine control" requests. Components
* reaction should be one of the following:
* \li Start long running test and answer with ROUTINE_CONTROL_STARTED
* \li Execute short running test (one second or less) and respond with
*     ROUTINE_CONTROL_OK and result
* \li In case of error answer with ROUTINE_CONTROL_NOT_OK and provide
*     internal error code in vector.
*
* \param[in]      u32RoutineId Routine ID diagnosis wants to be started
* \param[in]      u32Bitmask Bitmask containing flags that specify how the
*                 routine should be run. The ID dependent part of this
*                 bitmask is described in the ID spec.
* \param[in]      oParamVector Parameter vector for the routine that should
*                 be started. Defined in the ID spec.
* \param[in]      poMsgContext Internal message context. Just return exactly
*                 this context when you answer to this request.
*
* \return         tU32 ResultCode, currently not checked. Please return 0.
* \todo           Insert scenario description and link sequence diagrams
*//*************************************************************************/
tU32 dispvidctrl_tclDiagRoutineControlListener::vOnRoutineControlStart (
                                         tU32 u32RoutineId,
                                         tU32 u32Bitmask,
                                         const diaglib::tclParameterVector& oParamVector,
                                         diaglib::tContext MsgContext
                                       )
{
   tU8 u8ResultParam1;
   tU8 u8ResultParam2;

   OSAL_C_PARAMETER_INTENTIONALLY_UNUSED( u32RoutineId );
   OSAL_C_PARAMETER_INTENTIONALLY_UNUSED( u32Bitmask );
    ETG_TRACE_USR4(("Entered dispvidctrl_tclDiagRoutineControlListener"));
   // +++ Run the requested test, with the provided parameters +++
   // +++ If test already running restart with new parameters or +++
   // +++ send error as described below +++

   /*
      Response can be one of the following:
      EN_ROUTINE_CONTROL_OK      -> Result vector as specified in test spec
      EN_ROUTINE_CONTROL_NOT_OK  -> One vector entry: EN_ERROR_INCOMPATIBLE_PARAMETER_SIGNATURE
      EN_ROUTINE_CONTROL_NOT_OK  -> One vector entry: EN_ERROR_ROUTINE_STILL_RUNNING
      EN_ROUTINE_CONTROL_NOT_OK  -> One vector entry: EN_ERROR_DEFSET_IN_PROGRESS

      Actually the diaglib already checks if ID is supported, so we don't need
      to do it here again.
   */

   if(diaglib::bCheckParameterSignature(oParamVector, ROUTINEID_VIDE_SOUR_SELE_START_LEN, ROUTINEID_VIDE_SOUR_SELE_START_PARAM1, ROUTINEID_VIDE_SOUR_SELE_START_PARAM2) == FALSE)
   {
	   ETG_TRACE_USR4(("Entered dispvidctrl_tclDiagRoutineControlListener 1"));
      vSendError(diaglib::EN_ERROR_INCOMPATIBLE_PARAMETER_SIGNATURE, MsgContext);
      return diaglib::U32_DIAGLIB_RETURN_OK;
   }
   
   if (OSAL_NULL == m_poAppMain) {
	    ETG_TRACE_USR4(("Entered dispvidctrl_tclDiagRoutineControlListener 2"));
      vSendError(diaglib::EN_ERROR_FATAL_INTERNAL, MsgContext);
      return diaglib::U32_DIAGLIB_RETURN_NOT_OK;
   }
   
   // check if no hmi visualisation is pending
   tBool bAvmPhase3 = m_poAppMain->pGetConfiguration()->bAvmType_Phase3;
#ifndef VARIANT_S_FTR_ENABLE_SMART
   /*if (bAvmPhase3)
   {
	  ETG_TRACE_USR4(("Entered dispvidctrl_tclDiagRoutineControlListener 3"));
     dispvidctrl_tclControl_HmiAvm3* poControl_HmiAvm3 = dynamic_cast<dispvidctrl_tclControl_HmiAvm3*>(m_poAppMain->getHandler("dispvidctrl_tclControl_HmiAvm3"));
     DISPVIDCTRL_NULL_POINTER_CHECK_VAL(poControl_HmiAvm3);
     dispvidctrl_tclFsm_HmiAvm3* poFsm_HmiAvm3 = poControl_HmiAvm3->vGetPoFsm_Hmi();
     if (poFsm_HmiAvm3 != OSAL_NULL)
     {
        if(  (poFsm_HmiAvm3->u32GetFsmState() != dispvidctrl_tclFsm_HmiAvm3::eStateHmiAvm3_OFF     )
          && (poFsm_HmiAvm3->u32GetFsmState() != dispvidctrl_tclFsm_HmiAvm3::eStateHmiAvm3_ON_DIAG ) )
        {
           // if it would not be possible to post the event for activation return with error code
			 ETG_TRACE_USR4(("Entered dispvidctrl_tclDiagRoutineControlListener 4"));
           vSendError(diaglib::EN_ERROR_ROUTINE_STILL_RUNNING, MsgContext);
           return diaglib::U32_DIAGLIB_RETURN_NOT_OK;
        }
     }
   }
   else
   {
     dispvidctrl_tclControl_Hmi* poControl_Hmi = dynamic_cast<dispvidctrl_tclControl_Hmi*>(m_poAppMain->getHandler("dispvidctrl_tclControl_Hmi"));
     DISPVIDCTRL_NULL_POINTER_CHECK_VAL(poControl_Hmi);
	 ETG_TRACE_USR4(("Entered dispvidctrl_tclDiagRoutineControlListener 5"));
     dispvidctrl_tclFsm_Hmi* poTclFsm_Hmi = poControl_Hmi->vGetPoFsm_Hmi();
     if (poTclFsm_Hmi != OSAL_NULL)
     {
        if((poTclFsm_Hmi->u32GetFsmState() != dispvidctrl_tclFsm_Hmi::eState_OFF)
          && (poTclFsm_Hmi->u32GetFsmState() != dispvidctrl_tclFsm_Hmi::eState_ON_CAMERA_DIAG))
        {
           // if it would not be possible to post the event for activation return with error code
			ETG_TRACE_USR4(("Entered dispvidctrl_tclDiagRoutineControlListener 6"));
           vSendError(diaglib::EN_ERROR_ROUTINE_STILL_RUNNING, MsgContext);
           return diaglib::U32_DIAGLIB_RETURN_NOT_OK;
        }
     }
   }*/
   
   // analyse parameter content
   if (oParamVector[ROUTINEID_VIDE_SOUR_SELE_START_u8RequestedVideoSource].u8Value == EN_VideoSourceEXTERNAL)
   {
      ETG_TRACE_USR4(("Diagnosis Request to switch Video ON"));

      // switch video on
      // send HMI Visualisation On event (to avoid visualisation of overlay-graphics we don't use the camera settings request)
      //const tChar* strIfName = bAvmPhase3 ? "dispvidctrl_tclControl_HmiAvm3" : "dispvidctrl_tclControl_Hmi";
      //dispvidctrl_tclAppMain::theServer()->vPostMsgDiagVideoLayer(strIfName, (tU32) TRUE);///
	   tChar strIfName[] = "";
	  dispvidctrl_tclAppMain::theServer()->vPostMsgReverseOnDebounced(strIfName);


	  // tChar strIfName[] = "dispvidctrl_tclControl_Rvc";
      //poThis->_cpoMain->theServer()->vPostMsgControlRvc(strIfName, (tU32) EN_CONTROL_RVC__STATE_CHANGE_REVERSE);
     // dispvidctrl_tclAppMain::theServer()->vPostMsgControlRvc(strIfName, (tU32)6);
	 // const tChar* strIfName = "dispvidctrl_tclControl_Hmi";
	 // dispvidctrl_tclAppMain::theServer()->vPostMsgHmiVisualisationOn(strIfName);

      // if it would not be possible to post the event for activation return with error code
      //   vSendError(diaglib::EN_ERROR_FATAL_INTERNAL, MsgContext);
      //   return diaglib::U32_DIAGLIB_RETURN_NOT_OK;

      u8ResultParam1 = (tU8) EN_VideoSourceEXTERNAL;
   }
   else
   {
      ETG_TRACE_USR4(("Diagnosis Request to switch Video OFF"));

      // switch video off
      // send msg for diagVideoLayer is now disabled -> HMI Visualization Off event
      //const tChar* strIfName = bAvmPhase3 ? "dispvidctrl_tclControl_HmiAvm3" : "dispvidctrl_tclControl_Hmi";
      //dispvidctrl_tclAppMain::theServer()->vPostMsgDiagVideoLayer(strIfName, (tU32) FALSE);
	   tChar strIfName[] = "";
	  dispvidctrl_tclAppMain::theServer()->vPostMsgReverseOff(strIfName);

      // if it would not be possible to post the event for activation return with error code
      //   vSendError(diaglib::EN_ERROR_FATAL_INTERNAL, MsgContext);
      //   return diaglib::U32_DIAGLIB_RETURN_NOT_OK;

      u8ResultParam1 = (tU8) EN_VideoSourceINTERNAL;
   }
#endif
#ifdef VARIANT_S_FTR_ENABLE_SMART

 if (bAvmPhase3)
   {
     dispvidctrl_tclControl_HmiAvm3* poControl_HmiAvm3 = dynamic_cast<dispvidctrl_tclControl_HmiAvm3*>(m_poAppMain->getHandler("dispvidctrl_tclControl_HmiAvm3"));
     DISPVIDCTRL_NULL_POINTER_CHECK_VAL(poControl_HmiAvm3);
     dispvidctrl_tclFsm_HmiAvm3* poFsm_HmiAvm3 = poControl_HmiAvm3->vGetPoFsm_Hmi();
     if (poFsm_HmiAvm3 != OSAL_NULL)
     {
        if(  (poFsm_HmiAvm3->u32GetFsmState() != dispvidctrl_tclFsm_HmiAvm3::eStateHmiAvm3_OFF     )
          && (poFsm_HmiAvm3->u32GetFsmState() != dispvidctrl_tclFsm_HmiAvm3::eStateHmiAvm3_ON_DIAG ) )
        {
           // if it would not be possible to post the event for activation return with error code
           vSendError(diaglib::EN_ERROR_ROUTINE_STILL_RUNNING, MsgContext);
           return diaglib::U32_DIAGLIB_RETURN_NOT_OK;
        }
     }
   }
   else
   {
     dispvidctrl_tclControl_Hmi* poControl_Hmi = dynamic_cast<dispvidctrl_tclControl_Hmi*>(m_poAppMain->getHandler("dispvidctrl_tclControl_Hmi"));
     DISPVIDCTRL_NULL_POINTER_CHECK_VAL(poControl_Hmi);
     dispvidctrl_tclFsm_Hmi* poTclFsm_Hmi = poControl_Hmi->vGetPoFsm_Hmi();
     if (poTclFsm_Hmi != OSAL_NULL)
     {
        if((poTclFsm_Hmi->u32GetFsmState() != dispvidctrl_tclFsm_Hmi::eState_OFF)
          && (poTclFsm_Hmi->u32GetFsmState() != dispvidctrl_tclFsm_Hmi::eState_ON_CAMERA_DIAG))
        {
           // if it would not be possible to post the event for activation return with error code
           vSendError(diaglib::EN_ERROR_ROUTINE_STILL_RUNNING, MsgContext);
           return diaglib::U32_DIAGLIB_RETURN_NOT_OK;
        }
     }
   }
   
   // analyse parameter content
   if (oParamVector[ROUTINEID_VIDE_SOUR_SELE_START_u8RequestedVideoSource].u8Value == EN_VideoSourceEXTERNAL)
   {
      ETG_TRACE_USR4(("Diagnosis Request to switch Video ON"));

      // switch video on
      // send HMI Visualisation On event (to avoid visualisation of overlay-graphics we don't use the camera settings request)
      //const tChar* strIfName = bAvmPhase3 ? "dispvidctrl_tclControl_HmiAvm3" : "dispvidctrl_tclControl_Hmi";
      //dispvidctrl_tclAppMain::theServer()->vPostMsgDiagVideoLayer(strIfName, (tU32) TRUE);
	    tChar strIfName[] = "";
	  dispvidctrl_tclAppMain::theServer()->vPostMsgReverseOnDebounced(strIfName);

      // if it would not be possible to post the event for activation return with error code
      //   vSendError(diaglib::EN_ERROR_FATAL_INTERNAL, MsgContext);
      //   return diaglib::U32_DIAGLIB_RETURN_NOT_OK;

      u8ResultParam1 = (tU8) EN_VideoSourceEXTERNAL;
   }
   else
   {
      ETG_TRACE_USR4(("Diagnosis Request to switch Video OFF"));

      // switch video off
      // send msg for diagVideoLayer is now disabled -> HMI Visualization Off event
      //const tChar* strIfName = bAvmPhase3 ? "dispvidctrl_tclControl_HmiAvm3" : "dispvidctrl_tclControl_Hmi";
      //dispvidctrl_tclAppMain::theServer()->vPostMsgDiagVideoLayer(strIfName, (tU32) FALSE);
	  tChar strIfName[] = "";
	  dispvidctrl_tclAppMain::theServer()->vPostMsgReverseOff(strIfName);

      // if it would not be possible to post the event for activation return with error code
      //   vSendError(diaglib::EN_ERROR_FATAL_INTERNAL, MsgContext);
      //   return diaglib::U32_DIAGLIB_RETURN_NOT_OK;

      u8ResultParam1 = (tU8) EN_VideoSourceINTERNAL;
   }

#endif
   
   u8ResultParam2 = (tU8) oParamVector[ROUTINEID_VIDE_SOUR_SELE_START_u8RequestedVideoNorm].u8Value;


   //prepare result
   diaglib::tclParameterVector oResultVector;

   vBuildResultVector(oResultVector, u8ResultParam1, u8ResultParam2 );


   if(OSAL_NULL == m_poRoutineCtrlIF)
   {
	   ETG_TRACE_USR4(("Entered dispvidctrl_tclDiagRoutineControlListener 7"));
      // +++ Error Trace +++
      return diaglib::U32_DIAGLIB_RETURN_NOT_OK;
   }

   // +++ Send the response +++
   if(TRUE == m_poRoutineCtrlIF->bSendRoutineCtrlMethodResult( diaglib::EN_ROUTINE_CONTROL_OK,
                                                              oResultVector,
                                                              MsgContext
                                                            ))
   {
	   ETG_TRACE_USR4(("Entered dispvidctrl_tclDiagRoutineControlListener 8"));
      // +++ Trace info +++
   }
   else
   {
	   ETG_TRACE_USR4(("Entered dispvidctrl_tclDiagRoutineControlListener 9"));
      // +++ Trace error +++
   }

   return diaglib::U32_DIAGLIB_RETURN_OK;
}


/******************************************************************************/
/* FUNCTION     vBuildResultVector(..)                                        */
/******************************************************************************/
/**
*  \brief       prepare message data for result message
*
*  \param       reference to result vector, result data
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclDiagRoutineControlListener::vBuildResultVector (diaglib::tclParameterVector &oResultVector, tU8 u8Param1, tU8 u8Param2) const
{
   diaglib::trParameter rParam;

   rParam.enType = diaglib::EN_PARAMETER_TYPE_U8;
   rParam.u8Value = u8Param1;
   oResultVector.push_back(rParam);

   rParam.u8Value = u8Param2;
   oResultVector.push_back(rParam);
}


/******************************************************************************/
/* FUNCTION     vSendError(..)                                                */
/******************************************************************************/
/**
*  \brief       send error
*
*  \param       error code, message context
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclDiagRoutineControlListener::vSendError (diaglib::tenInternalError enErrorCode, diaglib::tContext MsgContext)
{
   diaglib::tclParameterVector oResultVector;

   oResultVector = diaglib::oCreateErrorVector(enErrorCode);

   if(OSAL_NULL != m_poRoutineCtrlIF)
   {
      m_poRoutineCtrlIF->bSendRoutineCtrlMethodResult( diaglib::EN_ROUTINE_CONTROL_NOT_OK,
                                                      oResultVector,
                                                      MsgContext
                                                    );
   }
   else
   {
      // +++ Error Trace +++
   }
}



