/******************************************************************************/
/**
* \file    dispvidctrl_tclControl_Video_trace.cpp
* \ingroup
*
* \brief
*
* \remark  Copyright : (c) 2015 Robert Bosch GmbH, Hildesheim
* \remark  Author    : Ian Lisney, Michael Niemann
* \remark  Scope     : AIVI
*
* \todo
*/
/******************************************************************************/
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

#include "dispvidctrl_tclControl_Video.h"
#include "dispvidctrl_tclPersistentData.h"
#include "I_dispvidctrl_tclSyncHandler.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_DISPVIDCTRL_APPLICATION
#include "trcGenProj/Header/dispvidctrl_tclControl_Video_trace.cpp.trc.h"
#endif

/******************************************************************************/
/* FUNCTION     vHandleTraceMessage                                           */
/******************************************************************************/
/**
*  \brief       handle TTFis commands
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclControl_Video::vHandleTraceMessage(const tUChar* puchData)
{
   DISPVIDCTRL_NULL_POINTER_CHECK(puchData);

   tU32 u32MsgCode = ((puchData[1]<<8) | puchData[2]);
   ETG_TRACE_USR4(("dispvidctrl_tclControl_Video::vHandleTraceMessage(): trace command %d", u32MsgCode ));

   switch (u32MsgCode)
   {
    case DISPVIDCTRL_DISPVIDCTRL_STIMULATE_CONTROL_VIDEO:
        {
            // Stimulate tclControl_Video, Parameter = control name and u32Data value)
            tU8 param1 = puchData[3];
            tU32 param2 = ((tU32)puchData[4] << 24) | ((tU32)puchData[5] << 16) | ((tU32)puchData[6] <<  8) | (tU32)puchData[7];

            vHandleControl((tenControl_Video) param1, param2);
        }
        break;
    case DISPVIDCTRL_DISPVIDCTRL_VIDEO_GUARDTIMEREMAINING:
        {
            // If reverse gear is switched off, RVC has to be shown for a further period of time. In case early video is active, the early video component informs the system about the time left.
            tU8 param1 = puchData[3];
            tU32 param2 = ((tU32)puchData[4] << 24) | ((tU32)puchData[5] << 16) | ((tU32)puchData[6] <<  8) | (tU32)puchData[7];

            tBool bValueChanged = FALSE;
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(param1);

            vSetGuardTimeRemaining(param2, bValueChanged);

        }
        break;
    case DISPVIDCTRL_DISPVIDCTRL_VIDEO_GUIDELINEBLACKWARNINGTEXTBACKGROUND:
        {
            // GuidelineBlackWarningTextBackground
            tU8 param1 = puchData[3];
            tU32 param2 = ((tU32)puchData[4] << 24) | ((tU32)puchData[5] << 16) | ((tU32)puchData[6] <<  8) | (tU32)puchData[7];

            //if(m_poClient_VideoPlayer && m_poPersistentData)
            if(m_poPersistentData)
            {
               m_poPersistentData->vSet_WarningTextBackground((tU32) param2);
               if (param1) //store persistent
               {
                  (tVoid) m_poPersistentData->bSetEarlyNorConfigurationPersistent();
               }
               //(tVoid) m_poClient_VideoPlayer->bSend_WarningTextBackground((tU32) param2);
            }
        }
        break;
    case DISPVIDCTRL_DISPVIDCTRL_VIDEO_GUIDELINECAMERASYSTEMTYPE:
        {
            // GuidelineCameraSystemType
            tU8 param1 = puchData[3];
            tU32 param2 = ((tU32)puchData[4] << 24) | ((tU32)puchData[5] << 16) | ((tU32)puchData[6] <<  8) | (tU32)puchData[7];

            //if(m_poClient_VideoPlayer && m_poPersistentData)
            if(m_poPersistentData)
            {
               m_poPersistentData->vSet_CameraSystemType((tU32) param2);
               if (param1) //store persistent
               {
                  (tVoid) m_poPersistentData->bSetEarlyNorConfigurationPersistent();
               }
               //(tVoid) m_poClient_VideoPlayer->bSend_CameraSystemType((tU32) param2);
            }
        }
        break;
    case DISPVIDCTRL_DISPVIDCTRL_VIDEO_GUIDELINECAMERATYPE:
        {
            // GuidelineCameraType
            tU8 param1 = puchData[3];
            tU32 param2 = ((tU32)puchData[4] << 24) | ((tU32)puchData[5] << 16) | ((tU32)puchData[6] <<  8) | (tU32)puchData[7];

            //if(m_poClient_VideoPlayer && m_poPersistentData)
            if(m_poPersistentData)
            {
               m_poPersistentData->vSet_GuidelineCameraType((tU32) param2);
               if (param1) //store persistent
               {
                  (tVoid) m_poPersistentData->bSetEarlyNorConfigurationPersistent();
               }
               //(tVoid) m_poClient_VideoPlayer->bSend_CameraType((tU32) param2);
            }
        }
        break;
    case DISPVIDCTRL_DISPVIDCTRL_VIDEO_GUIDELINEVISIBILITY:
        {
            // GuidelineVisibility - true or false
            tU8 param1 = puchData[3];
            tU32 param2 = ((tU32)puchData[4] << 24) | ((tU32)puchData[5] << 16) | ((tU32)puchData[6] <<  8) | (tU32)puchData[7];

            if(m_poClient_VideoPlayer && m_poPersistentData)
            {
               m_poPersistentData->vSet_GuideLineVisibilityMode((tU32) param2);
               if (param1) //store persistent
               {
                  (tVoid) m_poPersistentData->bSetEarlyNorConfigurationPersistent();
               }
               m_poClient_VideoPlayer->vSetGuideLineVisibility((tU32) param2);
            }
        }
        break;
    case DISPVIDCTRL_DISPVIDCTRL_VIDEO_GUIDELINEWARNINGLANGUAGE:
        {
            // GuidelineWarningLanguage
            tU8 param1 = puchData[3];
            tU32 param2 = ((tU32)puchData[4] << 24) | ((tU32)puchData[5] << 16) | ((tU32)puchData[6] <<  8) | (tU32)puchData[7];

            if(m_poClient_VideoPlayer && m_poPersistentData)
            {
               m_poPersistentData->vSet_WarningTextLanguage((tU32) param2);
               if (param1) //store persistent
               {
                  (tVoid) m_poPersistentData->bSetEarlyNorConfigurationPersistent();
               }
               m_poClient_VideoPlayer->vSetWarningTextLanguage((tU8) param2);
            }
        }
        break;
    case DISPVIDCTRL_DISPVIDCTRL_VIDEO_GUIDELINEWARNINGTEXT:
        {
            // GuidelineWarningText  true is ON, false is OFF
            tU8 param1 = puchData[3];
            tU32 param2 = ((tU32)puchData[4] << 24) | ((tU32)puchData[5] << 16) | ((tU32)puchData[6] <<  8) | (tU32)puchData[7];

            if(m_poClient_VideoPlayer && m_poPersistentData)
            {
               m_poPersistentData->vSet_WarningTextVisibility((tU32) param2);
               if (param1) //store persistent
               {
                  (tVoid) m_poPersistentData->bSetEarlyNorConfigurationPersistent();
               }
               m_poClient_VideoPlayer->vSetWarningTextVisibility((tU32) param2);
            }
        }
        break;
    case DISPVIDCTRL_DISPVIDCTRL_VIDEO_RVCBLACKLEVEL:
        {
            // Sets the BlackLevel setting for the RVC. 0 to 100 percent
            tU8 param1 = puchData[3];
            tU32 param2 = ((tU32)puchData[4] << 24) | ((tU32)puchData[5] << 16) | ((tU32)puchData[6] <<  8) | (tU32)puchData[7];

            if(m_poClient_DevVideo && m_poPersistentData)
            {
               m_poPersistentData->vSet_BlackLevel_Day((tU32) param2);
               m_poPersistentData->vSet_BlackLevel_Night((tU32) param2);
               if (param1) //store persistent
               {
                  (tVoid) m_poPersistentData->bSetEarlyNorConfigurationPersistent();
               }
               m_poClient_DevVideo->vSet_BlackLevel((tU8) param2);
            }
        }
        break;
    case DISPVIDCTRL_DISPVIDCTRL_VIDEO_RVCBRIGHTNESS:
        {
            // Sets the Brightness setting for the RVC. 0 to 100 percent
            tU8 param1 = puchData[3];
            tU32 param2 = ((tU32)puchData[4] << 24) | ((tU32)puchData[5] << 16) | ((tU32)puchData[6] <<  8) | (tU32)puchData[7];

            if(m_poClient_DevVideo && m_poPersistentData)
            {
               m_poPersistentData->vSet_Brightness_Day((tU32) param2);
               m_poPersistentData->vSet_Brightness_Night((tU32) param2);
               if (param1) //store persistent
               {
                  (tVoid) m_poPersistentData->bSetEarlyNorConfigurationPersistent();
               }
               m_poClient_DevVideo->vSet_Brightness((tU8) param2);
            }
        }
        break;
    case DISPVIDCTRL_DISPVIDCTRL_VIDEO_RVCCOLOUR:
        {
            // Sets the Colour setting for the RVC. 0 to 100 percent
            tU8 param1 = puchData[3];
            tU32 param2 = ((tU32)puchData[4] << 24) | ((tU32)puchData[5] << 16) | ((tU32)puchData[6] <<  8) | (tU32)puchData[7];

            if(m_poClient_DevVideo && m_poPersistentData)
            {
               m_poPersistentData->vSet_Colour_Day((tU32) param2);
               m_poPersistentData->vSet_Colour_Night((tU32) param2);
               if (param1) //store persistent
               {
                  (tVoid) m_poPersistentData->bSetEarlyNorConfigurationPersistent();
               }
               m_poClient_DevVideo->vSet_Colour((tU8) param2);
            }
        }
        break;
    case DISPVIDCTRL_DISPVIDCTRL_VIDEO_RVCCONTRAST:
        {
            // Sets the Contrast setting for the RVC. 0 to 100 percent
            tU8 param1 = puchData[3];
            tU32 param2 = ((tU32)puchData[4] << 24) | ((tU32)puchData[5] << 16) | ((tU32)puchData[6] <<  8) | (tU32)puchData[7];

            if(m_poClient_DevVideo && m_poPersistentData)
            {
               m_poPersistentData->vSet_Contrast_Day((tU32) param2);
               m_poPersistentData->vSet_Contrast_Night((tU32) param2);
               if (param1) //store persistent
               {
                  (tVoid) m_poPersistentData->bSetEarlyNorConfigurationPersistent();
               }
               m_poClient_DevVideo->vSet_Contrast((tU8) param2);
            }
        }
        break;
    case DISPVIDCTRL_DISPVIDCTRL_VIDEO_RVCHUE:
        {
            // Sets the Hue/Tint setting for the RVC. 0 to 100 percent
            tU8 param1 = puchData[3];
            tU32 param2 = ((tU32)puchData[4] << 24) | ((tU32)puchData[5] << 16) | ((tU32)puchData[6] <<  8) | (tU32)puchData[7];

            if(m_poClient_DevVideo && m_poPersistentData)
            {
               m_poPersistentData->vSet_Hue_Day((tU32) param2);
               m_poPersistentData->vSet_Hue_Night((tU32) param2);
               if (param1) //store persistent
               {
                  (tVoid) m_poPersistentData->bSetEarlyNorConfigurationPersistent();
               }
               m_poClient_DevVideo->vSet_Hue((tU8) param2);
            }
        }
        break;
    case DISPVIDCTRL_DISPVIDCTRL_VIDEO_RVCHIGHSPEEDTHRESHOLD:
        {
            // [km/h * 100] threshold for Parking System Darken Screen
            tU8 param1 = puchData[3];
            tU32 param2 = ((tU32)puchData[4] << 24) | ((tU32)puchData[5] << 16) | ((tU32)puchData[6] <<  8) | (tU32)puchData[7];

            //if(m_poClient_VideoPlayer && m_poPersistentData)
            if(m_poPersistentData)
            {
               m_poPersistentData->vSet_RVCHighSpeedThreshold((tU32) param2);
               if (param1) //store persistent
               {
                  (tVoid) m_poPersistentData->bSetEarlyNorConfigurationPersistent();
               }
               //(tVoid) m_poClient_VideoPlayer->bSend_HighSpeedThreshold((tU32) param2);
            }
        }
        break;
    case DISPVIDCTRL_DISPVIDCTRL_VIDEO_RVCLOWSPEEDTHRESHOLD:
        {
            // [km/h * 100] threshold for Parking System Normal Screen (Un-Darken Screen)
            tU8 param1 = puchData[3];
            tU32 param2 = ((tU32)puchData[4] << 24) | ((tU32)puchData[5] << 16) | ((tU32)puchData[6] <<  8) | (tU32)puchData[7];

            //if(m_poClient_VideoPlayer && m_poPersistentData)
            if(m_poPersistentData)
            {
               m_poPersistentData->vSet_RVCLowSpeedThreshold((tU32) param2);
               if (param1) //store persistent
               {
                  (tVoid) m_poPersistentData->bSetEarlyNorConfigurationPersistent();
               }
               //(tVoid) m_poClient_VideoPlayer->bSend_LowSpeedThreshold((tU32) param2);
            }
        }
        break;
    case DISPVIDCTRL_DISPVIDCTRL_VIDEO_RVCREVERSEOFFGUARDTIME:
        {
            // [ms] follow-up time for camera screen after reverse gear off
            tU8 param1 = puchData[3];
            tU32 param2 = ((tU32)puchData[4] << 24) | ((tU32)puchData[5] << 16) | ((tU32)puchData[6] <<  8) | (tU32)puchData[7];

            //if(m_poClient_VideoPlayer && m_poPersistentData)
            if(m_poPersistentData)
            {
               m_poPersistentData->vSet_RVCReverseOffGuardTime((tU32) param2);
               if (param1) //store persistent
               {
                  (tVoid) m_poPersistentData->bSetEarlyNorConfigurationPersistent();
               }
               //(tVoid) m_poClient_VideoPlayer->bSend_ReverseOffGuardTime((tU32) param2);
            }
        }
        break;
    case DISPVIDCTRL_DISPVIDCTRL_VIDEO_RVCSTATUSINFO:
        {
            //
            tU8 param1 = puchData[3];
            tU8 param2 = puchData[4];
            tU32 param3 = ((tU32)puchData[5] << 24) | ((tU32)puchData[6] << 16) | ((tU32)puchData[7] <<  8) | (tU32)puchData[8];

            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(param1);
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(param2);
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(param3);
//todo
        }
        break;
    case DISPVIDCTRL_DISPVIDCTRL_VIDEO_SPMAUTOMODE:
        {
            // Indicates that the user switched off during the last power cycle.
            tU8 param1 = puchData[3];
            tU32 param2 = ((tU32)puchData[4] << 24) | ((tU32)puchData[5] << 16) | ((tU32)puchData[6] <<  8) | (tU32)puchData[7];

            //if(m_poClient_VideoPlayer && m_poPersistentData)
            if(m_poPersistentData)
            {
               m_poPersistentData->vSet_SPMAutoMode((tU32) param2);
               if (param1) //store persistent
               {
                  (tVoid) m_poPersistentData->bSetEarlyNorConfigurationPersistent();
               }
               //(tVoid) m_poClient_VideoPlayer->bSend_SpmAutoMode((tU32) param2);
            }
        }
        break;
    case DISPVIDCTRL_DISPVIDCTRL_VIDEO_VIDEOCAPTURE:
        {
            // Controls the Reverse Video Camera - Start/Stop Video Picture Capture
            tU8 param1 = puchData[3];
            tChar strIfName[] = "I_dispvidctrl_tclSyncHandler";
            if ((tBool) param1)
            {
               dispvidctrl_tclAppMain::theServer()->vPostMsgControlSyncHandler(strIfName, EN_CONTROL_SH__CAMERA_SCREEN_ON);
            }
            else
            {
               dispvidctrl_tclAppMain::theServer()->vPostMsgControlSyncHandler(strIfName, EN_CONTROL_SH__CAMERA_SCREEN_OFF);
            }
        }
        break;
//    case DISPVIDCTRL_DISPVIDCTRL_VIDEO_VEHICLECONFIG:
//        {
//            // Selects hardcoded vehicle configuration within guideline calculation software part
//            const tChar* pString1 = (const tChar*)&puchData[3];
//
//            if(m_poPersistentData)
//            {
//               (tVoid) m_poPersistentData->bSetPersistent_GuidelineVehicleParameter(pString1);
//            }
//        }
//        break;
 //   case DISPVIDCTRL_DISPVIDCTRL_VIDEO_DEINTERLACING:
 //       {
 //           // To change the Deinterlacing/motion value of the gStreamer plugin
 //           tU8 param1 = puchData[3];
 //
 //           (tVoid) param1;
 //           //if(m_poClient_VideoPlayer != 0)
 //           //{
 //           //   (tVoid) m_poClient_VideoPlayer->bSend_Deinterlacing((tU32) param1);
 //           //}
 //       }
 //       break;

   case DISPVIDCTRL_DISPVIDCTRL_VIDEO_RESETCONFIG:
      {
         // Command to reset the early and RVC configuration back to its initial values
         tU32 param1 = ((tU32)puchData[3] << 24) | ((tU32)puchData[4] << 16) | ((tU32)puchData[5] <<  8) | (tU32)puchData[6];

         OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(param1);
         vResetConfig();
      }
      break;
   case DISPVIDCTRL_DISPVIDCTRL_VIDEO_PRINTCONFIG:
      {
         // Command to list the current early and RVC configuration values
         tU32 param1 = ((tU32)puchData[3] << 24) | ((tU32)puchData[4] << 16) | ((tU32)puchData[5] <<  8) | (tU32)puchData[6];

         OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(param1);
         vTraceInfo();
      }
      break;
   case DISPVIDCTRL_DISPVIDCTRL_VIDEO_STEERINGWHEELANGLE:
      {
         // Command to change steering wheel angle
         tU32 param1 = ((tU32)puchData[3] << 24) | ((tU32)puchData[4] << 16) | ((tU32)puchData[5] <<  8) | (tU32)puchData[6];

         if(m_poClient_VideoPlayer != 0)
         {
            m_poClient_VideoPlayer->vSetSteeringWheelAngle((tS32) param1);
         }
      }
      break;
   case DISPVIDCTRL_DISPVIDCTRL_VIDEO_REARWHEELANGLE:
      {
         // Command to change rear wheel angle
         tU32 param1 = ((tU32)puchData[3] << 24) | ((tU32)puchData[4] << 16) | ((tU32)puchData[5] <<  8) | (tU32)puchData[6];

         if(m_poClient_VideoPlayer != 0)
         {
            m_poClient_VideoPlayer->vSetRearWheelAngle((tS32) param1);
         }
      }
      break;
   case DISPVIDCTRL_DISPVIDCTRL_VIDEO_ADV_REGISTER_READ:
      {
         // read a value from ADV register.
         tU8 param1 = puchData[3];
         tU8 param2 = puchData[4];

         tU8 u8Value;
         (tVoid) _bReadAdvRegister(param1, param2, u8Value);
      }
      break;
   case DISPVIDCTRL_DISPVIDCTRL_VIDEO_ADV_REGISTER_WRITE:
      {
         // write a value into ADV register.
         tU8 param1 = puchData[3];
         tU8 param2 = puchData[4];

         (tVoid) _bWriteAdvRegister(param1, param2);
      }
      break;
   case DISPVIDCTRL_DISPVIDCTRL_VIDEO_SET_CROPPING_PARAMETER:
      {
         // capturing width and hight, cropping start from left (x), from top (y), cropping width, hight).
         tU32 param1 = ((tU32)puchData[3] << 24) | ((tU32)puchData[4] << 16) | ((tU32)puchData[5] <<  8) | (tU32)puchData[6];
         tU32 param2 = ((tU32)puchData[7] << 24) | ((tU32)puchData[8] << 16) | ((tU32)puchData[9] <<  8) | (tU32)puchData[10];
         tU32 param3 = ((tU32)puchData[11] << 24) | ((tU32)puchData[12] << 16) | ((tU32)puchData[13] <<  8) | (tU32)puchData[14];
         tU32 param4 = ((tU32)puchData[15] << 24) | ((tU32)puchData[16] << 16) | ((tU32)puchData[17] <<  8) | (tU32)puchData[18];

         if(m_poClient_VideoPlayer != 0)
         {
            // vSetCropping(tU32 u32CropUp, tU32 u32CropDown, tU32 u32CropLeft, tU32 u32CropRight);
            m_poClient_VideoPlayer->vSetCropping(param1, param2, param3, param4);
         }
      }
      break;

   case DISPVIDCTRL_DISPVIDCTRL_VIDEO_SET_CAMERAIMAGEMIRROR:
      {
         // Set CameraImageMirror
         // 0 - None
         // 1 - Vertical
         // 2 - Horizontal
         // 3 - Horizontal + Vertical

         tU8 param1 = puchData[3];

         if(m_poClient_VideoPlayer != 0)
         {
            // vSetCameraImageMirror(tU8 u8CameraimageMirror);
            m_poClient_VideoPlayer->vSetCameraImageMirror(param1);
         }
      }
      break;

   case DISPVIDCTRL_DISPVIDCTRL_VIDEO_LAYER_OR_SURFACE_SETTING:
      {
         // kind of setting, surface id, scaling: x, y, width, hight.
            tU8 param1 = puchData[3];
            tU32 param2 = ((tU32)puchData[4] << 24) | ((tU32)puchData[5] << 16) | ((tU32)puchData[6] <<  8) | (tU32)puchData[7];
            tU32 param3 = ((tU32)puchData[8] << 24) | ((tU32)puchData[9] << 16) | ((tU32)puchData[10] <<  8) | (tU32)puchData[11];
            tU32 param4 = ((tU32)puchData[12] << 24) | ((tU32)puchData[13] << 16) | ((tU32)puchData[14] <<  8) | (tU32)puchData[15];
            tU32 param5 = ((tU32)puchData[16] << 24) | ((tU32)puchData[17] << 16) | ((tU32)puchData[18] <<  8) | (tU32)puchData[19];
            tU32 param6 = ((tU32)puchData[20] << 24) | ((tU32)puchData[21] << 16) | ((tU32)puchData[22] <<  8) | (tU32)puchData[23];

         if(m_poClient_VideoPlayer != 0)
         {
            m_poClient_VideoPlayer->vSetLayerOrSurfaceSettings(param1, (tU16) param2, param3, param4, param5, param6, TRUE);
         }
      }
      break;

      default:
      break;
   }
}

