/******************************************************************************/
/**
* \file    dispvidctrl_tclControl_Video.h
* \ingroup
*
* \brief
*
* \remark  Copyright : (c) 2015 Robert Bosch GmbH, Hildesheim
* \remark  Author    : Michael Niemann, Ian Lisney
* \remark  Scope     : AIVI
*
* \todo
*/
/******************************************************************************/
#ifndef _DISPVIDCTRL_TCL_CONTROL_VIDEO_H_
#define _DISPVIDCTRL_TCL_CONTROL_VIDEO_H_

/*******************************************************************************
                        Includes
*******************************************************************************/
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include <stdio.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/ioctl.h>
#include <linux/i2c-dev.h>
#include <linux/i2c.h>

#include "dispvidctrl_AppMain.h"

#include "dispvidctrl_tclClient_DevVideo.h"
#include "I_dispvidctrl_tclVideoPlayer.h"
/*******************************************************************************
                        Defines
*******************************************************************************/
   // enumeration of user action events.
   enum tenControl_Video
   {
      EN_CONTROL_VIDEO__NONE  = 0,
      //------------------------------------ from Control (OnOff)
      EN_CONTROL_VIDEO__DISABLE,
      EN_CONTROL_VIDEO__ENABLE,
      EN_CONTROL_VIDEO__EARLY_VIDEO_CONTROL_OFF,
      EN_CONTROL_VIDEO__HMI_AVAILABLE,
      //------------------------------------ from Control_Hmi
      EN_CONTROL_VIDEO__DIRECT_ON, // transition to late while early Video is active
      EN_CONTROL_VIDEO__PREPARE_GRAPHICS,
      EN_CONTROL_VIDEO__CAPTURING_OFF,
      EN_CONTROL_VIDEO__CAPTURING_ON,
      EN_CONTROL_VIDEO__CAPTURING_ON_DIAG,
      EN_CONTROL_VIDEO__CAPTURING_ON_GDL_ADJ,
      EN_CONTROL_VIDEO__GRAPHICS_OFF,
      EN_CONTROL_VIDEO__GRAPHICS_ON,
      EN_CONTROL_VIDEO__SET_VIDEO_CONTROLS,
      EN_CONTROL_VIDEO__SET_VIDEO_GAMMA_OFF,
      EN_CONTROL_VIDEO__SET_VIDEO_GAMMA_ON,
      EN_CONTROL_VIDEO__TOGGLE_GUIDELINE,
      EN_CONTROL_VIDEO__SET_B_HANDOVER_READY,
      EN_CONTROL_VIDEO__BLACK_SCREEN_ON,
      EN_CONTROL_VIDEO__SHOW_RVC,
      EN_CONTROL_VIDEO__DEVICE_OPEN,
      EN_CONTROL_VIDEO__DEVICE_CLOSE,
      EN_CONTROL_VIDEO__RESIZE_VIDEO,
      //------------------------------------ from Service_Rvc/Parkas for User Setting updates
      EN_CONTROL_VIDEO__USER_SETTING_UPDATE__GUIDELINE,
      EN_CONTROL_VIDEO__USER_SETTING_UPDATE__LANGUAGE,
      EN_CONTROL_VIDEO__USER_SETTING_UPDATE__VIDEO_CONTROL,
      EN_CONTROL_VIDEO__USER_SETTING_UPDATE__VIDEO_CONTROL_DIMMING,
      EN_CONTROL_VIDEO__USER_SETTING_VALUE__GUIDELINE_DYNAMIC,
      EN_CONTROL_VIDEO__USER_SETTING_VALUE__GUIDELINE_STATIC_CENTRE,
      EN_CONTROL_VIDEO__USER_SETTING_VALUE__GUIDELINE_STATIC_SIDE,
      EN_CONTROL_VIDEO__USER_SETTING_VALUE__LANGUAGE,
      EN_CONTROL_VIDEO__USER_SETTING_VALUE__DISPLAY_DIMMING_MODE,
      EN_CONTROL_VIDEO__USER_SETTING_VALUE__BLACKLEVEL_NIGHT,
      EN_CONTROL_VIDEO__USER_SETTING_VALUE__BLACKLEVEL_DAY,
      EN_CONTROL_VIDEO__USER_SETTING_VALUE__BRIGHTNESS_NIGHT,
      EN_CONTROL_VIDEO__USER_SETTING_VALUE__BRIGHTNESS_DAY,
      EN_CONTROL_VIDEO__USER_SETTING_VALUE__COLOUR_NIGHT,
      EN_CONTROL_VIDEO__USER_SETTING_VALUE__COLOUR_DAY,
      EN_CONTROL_VIDEO__USER_SETTING_VALUE__CONTRAST_NIGHT,
      EN_CONTROL_VIDEO__USER_SETTING_VALUE__CONTRAST_DAY,
      EN_CONTROL_VIDEO__USER_SETTING_VALUE__HUE_NIGHT,
      EN_CONTROL_VIDEO__USER_SETTING_VALUE__HUE_DAY,
      EN_CONTROL_VIDEO__USER_SETTING_VALUE__DIMMING_NIGHT,
      EN_CONTROL_VIDEO__USER_SETTING_VALUE__DIMMING_DAY,
      //------------------------------------
      EN_CONTROL_VIDEO__DYNAMIC_GUIDELINE_UPDATE,
      EN_CONTROL_VIDEO__STEERING_ANGLE_ADJUSTMENT,
      EN_CONTROL_VIDEO__IGNITION,
      //------------------------------------
      EN_CONTROL_VIDEO__GUIDELINE_ADJUSTMENT,
      EN_CONTROL_VIDEO__GUIDELINE_ADJUSTMENT_UPDATE,
      EN_CONTROL_VIDEO__STATIC_GUIDELINE_UPDATE
   };

   // enumeration of Blackscreen type for EN_CONTROL_VIDEO__BLACK_SCREEN_ON trigger
   enum tenControl_Video_BlackScreenType
   {
      EN_CONTROL_VIDEO__BLACKSCREENTYPE_NONE  = 0,
      EN_CONTROL_VIDEO__BLACKSCREENTYPE_FULL  = 1,
      EN_CONTROL_VIDEO__BLACKSCREENTYPE_LHD   = 2, // AVM - Front Camera part of combined view (Front + Side)
      EN_CONTROL_VIDEO__BLACKSCREENTYPE_RHD   = 3, // AVM - Front Camera part of combined view (Front + Side)
      EN_CONTROL_VIDEO__BLACKSCREENTYPE_WIDE  = 4  // AVM - Front Wide View
   };


   typedef struct
   {
      tU8 u8HmiValue;
      tU8 u8DevVideoValue_Hue;
      tU8 u8DevVideoValue_Brightness;
      tU8 u8DevVideoValue_Blacklevel;
      tU8 u8DevVideoValue_Color;
      tU8 u8DevVideoValue_Contrast;
   }StVideoSettingHmiToDevVideoValueMapping;

   enum tenControl_Video_GdlAdj
   {
      EN_CTRL_GDLADJ__NONE = 0,
      EN_CTRL_GDLADJ__SERVICE_REQUEST_VISUALISATION_ON_GUIDELINE_ADJUSTMENT,
      EN_CTRL_GDLADJ__SERVICE_REQUEST_VISUALISATION_OFF,
      EN_CTRL_GDLADJ__ADJ_SCREEN_ON_CONFIRMATION,
      EN_CTRL_GDLADJ__ADJ_SCREEN_OFF_CONFIRMATION,
      EN_CTRL_GDLADJ__COMPLETE,
      EN_CTRL_GDLADJ__ADJUST_BUTTON_UP,
      EN_CTRL_GDLADJ__ADJUST_BUTTON_DOWN,
      EN_CTRL_GDLADJ__ADJUST_BUTTON_LEFT,
      EN_CTRL_GDLADJ__ADJUST_BUTTON_RIGHT,
      EN_CTRL_GDLADJ__ADJUST_BUTTON_ROTATION_LEFT,
      EN_CTRL_GDLADJ__ADJUST_BUTTON_ROTATION_RIGHT,
      EN_CTRL_GDLADJ__ADJUST_COMPLETE_CONFIRM,
      EN_CTRL_GDLADJ__ADJUST_COMPLETE_REFUSED,
      EN_CTRL_GDLADJ__ADJUST_COMPLETE_RESET,
      //------------------------------------
      EN_CTRL_GDLADJ__UPDATE_STEERING_ANGLE
   };

   struct stGdlAdj_ConfigurationData
   {
      tU8  u8Item;
      tF64 f64Value;
   };

   #define DISPVIDCTRL_VIDEO__NUMBER_OFF_CONFIGURATION_DATA 68
   enum tenControl_Video_GdlAdjConfigurationDataItem
   {
      EN_GDLADJ__NONE = 0UL,
      EN_GDLADJ__ANTICIPATORYLINE = 1UL,
      EN_GDLADJ__VEHICLEWIDTH = 2UL,
      EN_GDLADJ__WHEELBASE = 3UL,
      EN_GDLADJ__REAROVERHANG = 4UL,
      EN_GDLADJ__STEERWHEELCALIB_F1 = 5UL,
      EN_GDLADJ__STEERWHEELCALIB_F3 = 6UL,
      EN_GDLADJ__MAXSTEERWHEELANGLE = 7UL,
      EN_GDLADJ__MAXREARWHEELANGLE = 8UL,
      EN_GDLADJ__RADIUSTUNINGFACT = 9UL,
      EN_GDLADJ__FOURWHEELSTEERING = 10UL,
      EN_GDLADJ__TIREANGLETURNSENSE = 11UL,
      EN_GDLADJ__TIREANGLEREFERENCEPOINT = 12UL,
      EN_GDLADJ__GUIDELINESTYLE = 13UL,
      EN_GDLADJ__CAMXOFFSET = 14UL,
      EN_GDLADJ__CAMYOFFSET = 15UL,
      EN_GDLADJ__CAMZOFFSET = 16UL,
      EN_GDLADJ__CAMYAW = 17UL,
      EN_GDLADJ__CAMPITCH = 18UL,
      EN_GDLADJ__CAMROLL = 19UL,
      EN_GDLADJ__FRONTTIRETHRESH = 20UL,
      EN_GDLADJ__MINFRONTTIRECHANGE = 21UL,
      EN_GDLADJ__REARTIRETHRESH = 22UL,
      EN_GDLADJ__MINREARTIRECHANGE = 23UL,
      EN_GDLADJ__GUIDELINESTARTDISTANCE = 24UL,
      EN_GDLADJ__GUIDELINESIDEMARGIN = 25UL,
      EN_GDLADJ__RGBCOLORSTATICSIDENEAR_RED = 26UL,
      EN_GDLADJ__RGBCOLORSTATICSIDENEAR_GREEN = 27UL,
      EN_GDLADJ__RGBCOLORSTATICSIDENEAR_BLUE = 28UL,
      EN_GDLADJ__RGBCOLORSTATICSIDEMID_RED = 29UL,
      EN_GDLADJ__RGBCOLORSTATICSIDEMID_GREEN = 30UL,
      EN_GDLADJ__RGBCOLORSTATICSIDEMID_BLUE = 31UL,
      EN_GDLADJ__RGBCOLORSTATICSIDEFAR_RED = 32UL,
      EN_GDLADJ__RGBCOLORSTATICSIDEFAR_GREEN = 33UL,
      EN_GDLADJ__RGBCOLORSTATICSIDEFAR_BLUE = 34UL,
      EN_GDLADJ__RGBCOLORSTATICCENTER_RED = 35UL,
      EN_GDLADJ__RGBCOLORSTATICCENTER_GREEN = 36UL,
      EN_GDLADJ__RGBCOLORSTATICCENTER_BLUE = 37UL,
      EN_GDLADJ__RGBCOLORDYNAMIC_RED = 38UL,
      EN_GDLADJ__RGBCOLORDYNAMIC_GREEN = 39UL,
      EN_GDLADJ__RGBCOLORDYNAMIC_BLUE = 40UL,
      EN_GDLADJ__LINEWIDTHSTATICSIDENEAR = 41UL,
      EN_GDLADJ__LINEWIDTHSTATICSIDEFAR = 42UL,
      EN_GDLADJ__LINEWIDTHDYNAMICNEAR = 43UL,
      EN_GDLADJ__LINEWIDTHDYNAMICFAR = 44UL,
      EN_GDLADJ__LINEWIDTHSTATICCENTERNEAR = 45UL,
      EN_GDLADJ__LINEWIDTHSTATICCENTERFAR = 46UL,
      EN_GDLADJ__STATICLINELENGTHNEAR = 47UL,
      EN_GDLADJ__STATICLINELENGTHMID = 48UL,
      EN_GDLADJ__STATICLINELENGHTFAR1 = 49UL,
      EN_GDLADJ__STATICLINELENGHTFAR2 = 50UL,
      EN_GDLADJ__STATICHORIZLINELENGHT = 51UL,
      EN_GDLADJ__LINEWIDTHFACTORNEARHLINE = 52UL,
      EN_GDLADJ__TUNINGMETHOD = 53UL,
      EN_GDLADJ__TUNINGDELTACAMYAW = 54UL,
      EN_GDLADJ__TUNINGDELTACAMPITCH = 55UL,
      EN_GDLADJ__TUNINGDELTACAMROLL = 56UL,
      EN_GDLADJ__TUNINGDELTAXNEARLEFT = 57UL,
      EN_GDLADJ__TUNINGDELTAYNEARLEFT = 58UL,
      EN_GDLADJ__TUNINGDELTAXFARLEFT = 59UL,
      EN_GDLADJ__TUNINGNEARLINELENGTHLEFT = 60UL,
      EN_GDLADJ__TUNINGDELTAXNEARRIGHT = 61UL,
      EN_GDLADJ__TUNINGDELTAYNEARRIGHT = 62UL,
      EN_GDLADJ__TUNINGDELTAXFARRIGHT = 63UL,
      EN_GDLADJ__TUNINGNEARLINELENGHTRIGHT = 64UL,
      EN_GDLADJ__TUNINGSWAZEROPOINTOFFSET = 65UL,
      EN_GDLADJ__TUNINGRWAZEROPOINTOFFSET = 66UL,
      EN_GDLADJ__RVCLENSPARAMETER = 67UL,
      EN_GDLADJ__LINEWIDTHFACTORVERTLINES = 68UL,
   };

//------------------------------------------------------------------------------
#define DISPVIDCTRL_VIDEO__DISPLAY_DIMMING_MODE_DAY       0x01
#define DISPVIDCTRL_VIDEO__DISPLAY_DIMMING_MODE_NIGHT     0x02
//------------------------------------------------------------------------------

class I_dispvidctrl_tclClientVcan;
class dispvidctrl_tclPersistentData;
class I_dispvidctrl_tclVideoPlayer;
class I_dispvidctrl_tclSyncHandler;
class dispvidctrl_tclControl_Hmi;
class Idispvidctrl_tclServiceRvcIf;
class dispvidctrl_tclControl_Mvc;

/*******************************************************************************
   Class
*******************************************************************************/
class dispvidctrl_tclControl_Video : public dispvidctrl_tclBaseIf
{
   public:

      dispvidctrl_tclControl_Video(dispvidctrl_tclAppMain* poMainAppl);
      dispvidctrl_tclControl_Video(); // default constructor
      virtual ~dispvidctrl_tclControl_Video();

   private:
      // declare (but hide and don't implement, i.e. effectively disable) copy contructor and assignment operator to make Coverity happy
      dispvidctrl_tclControl_Video(const dispvidctrl_tclControl_Video&);
      dispvidctrl_tclControl_Video& operator=(const dispvidctrl_tclControl_Video&);
   public:
    
      virtual const tChar* getName() const { return ""; };
      virtual const tChar* getIfName() const { return "dispvidctrl_tclControl_Video"; };

      virtual tVoid vHandleMessage(dispvidctrl_tclBaseIf::TMsg* pMsg);
      virtual tVoid vHandleTraceMessage(const tUChar* puchData);
      virtual tVoid vGetReferences();
      virtual tVoid vStartCommunication();
      virtual tVoid vTraceInfo();
      virtual tVoid vGetConfiguration(const TConfiguration* pStConfigurationValues);
	  void setGraphicslayerVisibility(unsigned int visibility);

      tVoid vHandleControl(tenControl_Video enControl, tU32 u32Value = 0);


      tVoid vResetConfig(tVoid);

      //tVoid vSetRvcStatusInfo(tBool new_video_active, dispvidctrlsist_fi_tcl_e32_dispvidctrlsist_VideoSignalState::tenType new_rvc_error_val, tBool& bValueChanged);
      tVoid vSetGuardTimeRemaining(tU32 new_guard_time_remaining, tBool& bValueChanged);

      // Functions for Incoming Status Handling
      tBool bSetRVCSTATUSINFO(tBool video_active, tBool rvc_error_state);
      tBool bSetGUARDTIMEREMAINING(tU32 time_remaining);
      tBool bSetANIMATIONSTATUS(tU32 u32AnimationStatus);

      // Guideline Adjustment
      tBool bGdlAdj_ConfigurationDataGetAll(tU8 au8Item[], tF64 af64Value[]);
      tBool bGdlAdj_ConfigurationDataGet(tU8 u8Item, tF64& f64Value);
      tBool bGdlAdj_ConfigurationDataSet(tU8 u8Item, tF64& f64Value);
      
      tBool bIsVideoSourceFound() const;
      tBool bFindVideoSource() const;

      tVoid _vOnStaticGuidelineUpdate(tU32 u32StaticGuidelineVisibility);

private:
      tVoid _vOnUserSettingValue(tenControl_Video enControl, tU32 u32Value);
      tVoid _vOnUserSettingUpdate_VideoControl(tVoid);
      tVoid _vOnUserSettingUpdate_DimmingMode(tVoid);
      tVoid _vOnUserSettingUpdate_GuideLine(tVoid);
      tVoid _vOnUserSettingUpdate_Language(tVoid);

      tVoid _vStartStopSteeringAngleAdjustment(tVoid);
      tVoid _vOnSteeringAngleAdjustment(tVoid);
      tVoid _vOnDynamicGuidelineUpdate(tVoid);

      tVoid _vGuidelineToggleSequence_Initialize();
      tVoid _vGuidelineToggleSequence_ToggleIndex();
      tVoid _vGuidelineToggleSequence_ResetIndex();

      tVoid _vSetVideoControls(tVoid);
      tVoid _vSetVisibility_Guideline(tVoid);
      tVoid _vSetVisibility_WarningText(tVoid);
      
      tVoid _vSetLayerSetting(const tU32 VideoState);

      tVoid _vGetPersistentData(tVoid);

      static OSAL_tpfCallback _pfCallbackTimer_DynGuidelineUpdate(tVoid* pArg);
      static OSAL_tpfCallback _pfCallbackTimer_SteeringAngleAdjustment(tVoid* pArg);
      static OSAL_tpfCallback _pfCallbackTimer_SteeringAngleGuidelineAdjustment(tVoid* pArg);
      tBool  _bSetTimer_DynGuidelineUpdate(OSAL_tMSecond msTimeout);
      tBool  _bSetTimer_SteeringAngleGuidelineAdjustment(OSAL_tMSecond msTimeout);

      tBool _bReadAdvRegister(const tU8 u8SlaveAddress, const tU8 u8RegisterAddress, tU8& u8RegisterData);
      tBool _bWriteAdvRegister(const tU8 u8RegisterAddress, tU8 u8RegisterData) const;

      // reset function for diagnose
      tVoid _vResetVideoControls(tVoid);

      // swap template
      template<typename T> tVoid _vSwapContents(T& a, T& b);

      //guideline Adjustment
      tVoid _vGdlAdj_HandleControl(tenControl_Video_GdlAdj enGdlAdjControl, tU32 u32Value = 0);
      tVoid _vGdlAdj_HandleComplete(tVoid);
      tVoid _vGdlAdj_HandleRefused(tVoid);
      tVoid _vGdlAdj_HandleReset(tVoid);
      tVoid _vGdlAdj_HandleAdjustButton(tenControl_Video_GdlAdj enGdlAdjControl);
      tVoid _vGdlAdj_UpdateProperty_CameraAngle(tVoid);
      tVoid _vGdlAdj_UpdateProperty_SteeringAngle(tVoid);
      tBool _bGdlAdj_DoRangeCorrectionForElementDataValue(tU8 u8Item, tF64& f64Value);
      tBool _bGdlAdj_SetDynGdlVehicleParamsElement(tU8 u8Item, tF64 f64Value);
      tBool _bGdlAdj_GetDynGdlVehicleParamsElement(tU8 u8Item, tF64& f64Value);
      tBool _bGdlAdj_GetAllDynGdlVehicleParamsElement(tU8 au8Item[], tF64 af64Value[]);
      tVoid _vGdlAdj_TraceInfo(tVoid);

      // references
      I_dispvidctrl_tclClientVcan*       m_poClientVcan;
      dispvidctrl_tclClient_DevVideo*    m_poClient_DevVideo;
      I_dispvidctrl_tclVideoPlayer*      m_poClient_VideoPlayer;
      dispvidctrl_tclPersistentData*     m_poPersistentData;
      dispvidctrl_tclControl_Hmi*        m_poControl_Hmi;
      Idispvidctrl_tclServiceRvcIf*      m_poServiceRvcIf;
      dispvidctrl_tclControl_Mvc*        m_poControl_Mvc;

      OSAL_tTimerHandle  m_hTimerHandle_DynGuidelineUpdate;
      OSAL_tTimerHandle  m_hTimerHandle_SteeringAngleAdjustment;
      OSAL_tTimerHandle  m_hTimerHandle_SteeringAngleGuidelineAdjustment;

      #define GUIDELINE_TOGGLE_SEQ_MAXLEN 4
      tU32  m_au32GuidelineToggleSequence[GUIDELINE_TOGGLE_SEQ_MAXLEN];
      tU8   m_u8CurrentGuidelineIndex;
      tU8   m_u8MaxGuidelineTogglesAvailable;
      
      tU8   m_u8DisplayOrientation;

      // video specific
      tU32 m_u32DisplayDimmingMode;
      tU32 m_u32VideoBrightnessDay;
      tU32 m_u32VideoBrightnessNight;
      tU32 m_u32VideoContrastDay;
      tU32 m_u32VideoContrastNight;
      tU32 m_u32VideoColourDay;
      tU32 m_u32VideoColourNight;
      tU32 m_u32VideoHueDay;
      tU32 m_u32VideoHueNight;
      tU32 m_u32VideoBlackLevelDay;
      tU32 m_u32VideoBlackLevelNight;
      tU32 m_u32VideoDimmingDay;
      tU32 m_u32VideoDimmingNight;

      // graphic specific
      tU32 m_u32GuidelineWarningLanguage;
      tU32 m_u32GuidelineStaticSide;
      tU32 m_u32GuidelineDynamic;

      // runtime states and values
      tBool m_bDiagScreenRequest;
      tBool m_bGraphicsVisibility;
      tU32  rvc_guard_time_remaining;
      tBool rvc_video_active;
      tBool rvc_video_status;
      tU32  u32CurrentAnimationStatus; // animation state
      tBool m_SteeringAngleAdjust_bIgnition;
      tBool m_SteeringAngleAdjust_bRecheck;
      tBool m_SteeringAngleAdjust_bBackupAvailable;
      tU32  m_SteeringAngleAdjust_u32RecheckTimeInMs;
      tS32  m_SteeringAngleAdjust_s32SteeringAngleOffset;
      tBool m_SteeringAngleAdjust_bActive;
      tBool m_bAnticipatoryLine;
      //------------------------------ system (KDS) configuration info
      tBool m_Config_bAvmMode;
      tBool m_Config_bAvmRenaultMode;
      tBool m_Config_bRvcMode;
      tBool m_Config_bRvcRenaultMode;
      tBool m_Config_bMvcMode;
      tBool m_Config_bCentreGuideline;
      tBool m_Config_bAnticipatoryLine;
      tU8   m_Config_u8CameraSteeringMessageType;
      tBool m_Config_bLeftHandSteeringPosition;
      tU8   m_Config_u8BrightnessValueDay;
      tU8   m_Config_u8BrightnessValueNight;
      tBool m_Config_bBlackWarningTextBackground;
      tU8   m_Config_u8RvcLensParameterSet;
      tU8   m_Config_aVehicleParameter[80];
      tU8   m_Config_u8Brand;
      tU16  m_Config_u16VehicleType;
      //------------------------------ HMI user setting values
      tU8   m_HmiUserSetting_u8GuidelineStaticSide;
      tU8   m_HmiUserSetting_u8GuidelineDynamic;
      tU8   m_HmiUserSetting_u8Language;
      tU8   m_HmiUserSetting_u8DisplayDimmingMode;
      tU8   m_HmiUserSetting_u8VideoBlackLevelDay;
      tU8   m_HmiUserSetting_u8VideoBlackLevelNight;
      tU8   m_HmiUserSetting_u8VideoBrightnessDay;
      tU8   m_HmiUserSetting_u8VideoBrightnessNight;
      tU8   m_HmiUserSetting_u8VideoColourDay;
      tU8   m_HmiUserSetting_u8VideoColourNight;
      tU8   m_HmiUserSetting_u8VideoContrastDay;
      tU8   m_HmiUserSetting_u8VideoContrastNight;
      tU8   m_HmiUserSetting_u8VideoHueDay;
      tU8   m_HmiUserSetting_u8VideoHueNight;
      tU8   m_HmiUserSetting_u8VideoDimmingDay;
      tU8   m_HmiUserSetting_u8VideoDimmingNight;

      //------------------------------ Guideline Adjustment
      tBool m_GdlAdj_bCorrectDrawLineScreen_Active;
      std::vector<stGdlAdj_ConfigurationData, std::allocator<stGdlAdj_ConfigurationData> > vecConfigurationDataSet;
      tF32 m_f32CameraRollAngle;
      tF32 m_f32CameraYawAngle;
      tF32 m_f32CameraPitchAngle;
      
      //------------------------------ Video re-sizing parameters to adapt to various type of camera system and displays 
      tU8 m_u8ConfiguredVideoType;
};    
#endif

