/******************************************************************************/
/**
* \file    dispvidctrl_tclControl_Rvc.h
* \ingroup
*
* \brief
*
* \remark  Copyright : (c) 2015 Robert Bosch GmbH, Hildesheim
* \remark  Author    : Michael Niemann
* \remark  Scope     : AIVI
*
* \todo
*/
/******************************************************************************/
#ifndef _DISPVIDCTRL_TCL_CONTROL_RVC_H_
#define _DISPVIDCTRL_TCL_CONTROL_RVC_H_

/*******************************************************************************
                        Includes
*******************************************************************************/
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include <stdio.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/ioctl.h>
#include <linux/i2c-dev.h>
#include <linux/i2c.h>
#include "dispvidctrl_Parser.h"
#include "dispvidctrl_AppMain.h"

/*******************************************************************************
                        Defines
*******************************************************************************/
   // enumeration of user action events.
   enum tenControl_Rvc
   {
      EN_CONTROL_RVC__NONE  = 0,
      EN_CONTROL_RVC__DISABLE,
      EN_CONTROL_RVC__ENABLE,
      //------------------------------------------------------------------------
      EN_CONTROL_RVC__FSM_CAMERASUPPLY_INPUT_EVENT,  // for direct events to FSM
      EN_CONTROL_RVC__FSM_CAMERASUPPLYSUPERVISION_INPUT_EVENT,  // for direct events to FSM
      EN_CONTROL_RVC__FSM_REVERSESIGNAL_INPUT_EVENT, // for direct event to FSM
      //------------------------------------------------------------------------
      EN_CONTROL_RVC__STATE_CHANGE_REVERSE,
      EN_CONTROL_RVC__REVERSE_OFF,
      EN_CONTROL_RVC__REVERSE_ON,
      EN_CONTROL_RVC__REVERSE_ON_DEBOUNCED,
      EN_CONTROL_RVC__VIDEO_SIGNAL_FALSE,
      EN_CONTROL_RVC__VIDEO_SIGNAL_TRUE,
      EN_CONTROL_RVC__CAMERA_MICROPHONE_SUPPLY_ERROR, //Elmos IC Error GPIO Callback
      //------------------------------------------------------------------------
      EN_CONTROL_RVC__SERVICE_REQUEST_VISUALISATION_OFF,  // from HMI via RVC service
      EN_CONTROL_RVC__SERVICE_REQUEST_VISUALISATION_ON,   // from HMI via RVC service
      EN_CONTROL_RVC__USER_SETTING_UPDATE__REAR_VIEW_CAMERA,
      EN_CONTROL_RVC__USER_SETTING_VALUE__REAR_VIEW_CAMERA,
      //------------------------------------------------------------------------
      EN_CONTROL_RVC__CAMERA_OFF,                         // request from HMI state machine
      EN_CONTROL_RVC__VERIFY_AFTER_VIEW_STATUS_STOPPED,
      EN_CONTROL_RVC__IGNITION,
      EN_CONTROL_RVC__IGNITION_ON,
      EN_CONTROL_RVC__IGNITION_OFF,
      //------------------------------------------------------------------------
      EN_CONTROL_RVC__SEND_NEXT_TESTRESULT,                // request via Diag-Log CCA Client
      //------------------------------------------------------------------------
      // request from production diag session via IO control service
      EN_CONTROL_RVC__DIAG_IOCONTROL_CAMERA_VCC_FREEZE_STATE_CHANGED,
      EN_CONTROL_RVC__DIAG_IOCONTROL_CAMERA_VCC_STATE_CHANGED,

      EN_CONTROL_RVC__DIAG_IOCONTROL_MICROPHONE_VCC_FREEZE_STATE_CHANGED,
      EN_CONTROL_RVC__DIAG_IOCONTROL_MICROPHONE_VCC_STATE_CHANGED,
      //------------------------------------------------------------------------
      // request from Control_Hmi when Diagnosis Video Screen will be switched On and OFF
      EN_CONTROL_RVC__DIAG_VIDEO_SCREEN_CAMERA_SUPPLY,
      //------------------------------------------------------------------------
      EN_CONTROL_RVC__ELMOS_INIT_TIMEOUT,
      //------------------------------------------------------------------------
      EN_CONTROL_RVC__TAILGATE_OPEN,
      EN_CONTROL_RVC__TAILGATE_CLOSE
   };

   // FSM output events
   enum tenFsmOutEvent_ReverseSignal
   {
      FSM_REVERSESIGNAL_OUT__NONE = 0,
      FSM_REVERSESIGNAL_OUT__FSM_REVERSESIGNAL_INPUT_EVENT,
      FSM_REVERSESIGNAL_OUT__REVERSE_OFF,
      FSM_REVERSESIGNAL_OUT__REVERSE_ON,
      FSM_REVERSESIGNAL_OUT__REVERSE_ON_DEBOUNCED
   };
   enum tenFsmOutEvent_CameraSupply
   {
      FSM_CAMERASUPPLY_OUT__NONE = 0,
      FSM_CAMERASUPPLY_OUT__FSM_CAMERASUPPLY_INPUT_EVENT,
      FSM_CAMERASUPPLY_OUT__SWITCH_CAMERA_VCC_OFF,
      FSM_CAMERASUPPLY_OUT__SWITCH_CAMERA_VCC_ON,
      FSM_CAMERASUPPLY_OUT__HMI_EV_VISUALISATION_OFF,
      FSM_CAMERASUPPLY_OUT__HMI_EV_VISUALISATION_ON,
      FSM_CAMERASUPPLY_OUT__HMI_EV_VISUALISATION_ON_CAMERA_SETTINGS
   };
   enum tenFsmOutEvent_CameraSupplySupervision
   {
      FSM_CAMERASUPPLYSUPERVISION_OUT__NONE = 0,
      FSM_CAMERASUPPLYSUPERVISION_OUT__FSM_CAMERASUPPLYSUPERVISION_INPUT_EVENT,
      FSM_CAMERASUPPLYSUPERVISION_OUT__CHECK_CURRENT_CONSUMPTION,
      FSM_CAMERASUPPLYSUPERVISION_OUT__CHECK_CURRENT_SPEED,
      FSM_CAMERASUPPLYSUPERVISION_OUT__SEND_NEXT_TEST_RESULT,
      FSM_CAMERASUPPLYSUPERVISION_OUT__SEND_NO_RESULT,

      FSM_CAMERASUPPLYSUPERVISION_OUT__DIAG_CAMERA_VCC_MONITOR_TIMEOUT,
      FSM_CAMERASUPPLYSUPERVISION_OUT__DIAG_MICROPHONE_VCC_MONITOR_TIMEOUT
   };

   enum tenReverseSignal_State
   {
      DISPVIDCTRL_REVERSE_SIGNAL_STATE__OFF = 0,
      DISPVIDCTRL_REVERSE_SIGNAL_STATE__ON,
      DISPVIDCTRL_REVERSE_SIGNAL_STATE__ON_DEBOUNCED
   };

   enum tenFsmControl_Rvc_SuperState
   {
      DISPVIDCTRL_CONTROL_RVC__DISABLED = 0,
      DISPVIDCTRL_CONTROL_RVC__ENABLED
   };

   enum tenCurrentState
   {
      EN_CurrentStateUNKNOWN = 0x00,
      EN_CurrentStateUNDER = 0x01, // Current too low.
      EN_CurrentStateOKAY = 0x02,  // Current okay.
      EN_CurrentStateOVER = 0x03   // Current too high.
   };

   enum tenVccState
   {
      EN_VccStateUNKNOWN = 0x00,
      EN_VccStateUNDER = 0x01, // Voltage too low.
      EN_VccStateOKAY = 0x02,  // Voltage okay.
      EN_VccStateOVER = 0x03   // Voltage too high.
   };

   enum tenSpeedStatus
   {
      EN_SpeedUNKNOWN = 0x00,  //vehicleSpeed is unknown/invalid
      EN_SpeedLOW     = 0x01,  //vehicleSpeed < slow limit
      EN_SpeedMID     = 0x02,  //slow limit < vehicleSpeed < fast limit
      EN_SpeedHIGH    = 0x03   //vehicleSpeed > fast limit
   };

class dispvidctrl_tclFsm_ReverseSignal;
class dispvidctrl_tclFsm_CameraSupply;
class dispvidctrl_tclFsm_CameraSupplySupervision;
class I_dispvidctrl_tclClientVcan;
class Idispvidctrl_tclClientDiaglogIf;
class Idispvidctrl_tclServiceRvcIf;
class rvc_ccafi_tclMsgMicrophone_PwrSupplyStatusStatus;
/*******************************************************************************
   Class
*******************************************************************************/
class dispvidctrl_tclControl_Rvc : public dispvidctrl_tclBaseIf
{
   public:

      dispvidctrl_tclControl_Rvc(dispvidctrl_tclAppMain* poMainAppl);
      dispvidctrl_tclControl_Rvc(); // default constructor
      virtual ~dispvidctrl_tclControl_Rvc();

   private:
      // declare (but hide and don't implement, i.e. effectively disable) copy contructor and assignment operator to make Coverity happy
      dispvidctrl_tclControl_Rvc(const dispvidctrl_tclControl_Rvc&);
      dispvidctrl_tclControl_Rvc& operator=(const dispvidctrl_tclControl_Rvc&);
   public:
      
      virtual const tChar* getName() const { return ""; };
      virtual const tChar* getIfName() const { return "dispvidctrl_tclControl_Rvc"; };

      virtual tVoid vHandleMessage(dispvidctrl_tclBaseIf::TMsg* pMsg);
      virtual tVoid vHandleTraceMessage(const tUChar* puchData);
      virtual tVoid vGetReferences();
      virtual tVoid vStartCommunication();
      virtual tVoid vTraceInfo();
      virtual tVoid vGetConfiguration(const TConfiguration* pStConfigurationValues);

      tVoid vHandleControl(tenControl_Rvc enControl, tU32 u32Value = 0);
      
      tBool bGetReverseState(tVoid);
      tBool bGetReverseDebouncedState(tVoid) const;
      tBool bGetSpeedStatus(tenSpeedStatus& enSpeedStatus);

      tVoid vHandleFsmOutEvent_ReverseSignal(tenFsmOutEvent_ReverseSignal enFsmOutEvent_ReverseSignal, tU32 u32Value = 0);
      tVoid vHandleFsmOutEvent_CameraSupply(tenFsmOutEvent_CameraSupply enFsmOutEvent_CameraSupply, tU32 u32Value = 0);
      tVoid vHandleFsmOutEvent_CameraSupplySupervision(tenFsmOutEvent_CameraSupplySupervision enFsmOutEvent_CameraSupplySupervision, tU32 u32Value = 0);

      tBool bSetMicrophoneVccOn(tBool bOnOff);
      tVoid _vCheckMicCurrentConsumption(rvc_ccafi_tclMsgMicrophone_PwrSupplyStatusStatus& oStatus);

   private:
      tVoid _vCheckCameraCurrentConsumption(tBool bElmosErrorIndication = FALSE);
      tVoid _vCheckMicCurrentConsumption(tBool bElmosErrorIndication = FALSE);
      tVoid _vOnEvent_FsmControl_Rvc(tenControl_Rvc enControl, tU32 u32Value = 0);


      tVoid _vConfigureGpio_Reverse(tVoid);
      tVoid _vCloseGpio_Reverse(tVoid);
      static OSAL_tpfGPIOCallback _pfCallbackGpioStateChange_Reverse(tVoid* pArg);
      tBool _bGetGPIOState_Reverse(tVoid);
      tVoid _vConfigureGpio_CameraSupplyError(tVoid);
      tVoid _vCloseGpio_CameraSupplyError(tVoid);
      static OSAL_tpfGPIOCallback _pfCallbackGpioStateChange_CameraSupplyError(tVoid* pArg);

      tVoid _vConfigureElmos_CameraVccOn(tVoid);
      tBool _bSetCameraVccOn(tBool bOnOff);
      tBool _bResetElmosErrorRegister(tVoid);
      tBool _bReadRegister(const tU8 u8RegisterAddress, tU8& u8RegisterData);
      tBool _bReadRegisters(const tU8 u8RegisterStartAddress, tU8 u8NumberOfRegisters, tU8* au8RegisterDataBuffer);
      tBool _bWriteRegister(const tU8 u8RegisterAddress, tU8 u8RegisterData) const;

      tBool _bCalcGpio_CameraVccOn(tBool bOnOff);
      tBool _bCalcGpio_MicrophoneVccOn(tBool bOnOff);

      tVoid _vResetCameraCurrentState();
      tVoid _vResetMicrophoneCurrentState();

      static OSAL_tpfCallback _pfCallbackTimer_ElmosInit(tVoid* pArg);
      OSAL_tTimerHandle  m_hTimerHandle_ElmosInit;

      dispvidctrl_tclFsm_ReverseSignal*            m_poFsm_ReverseSignal;
      dispvidctrl_tclFsm_CameraSupply*             m_poFsm_CameraSupply;
      dispvidctrl_tclFsm_CameraSupplySupervision*  m_poFsm_CameraSupplySupervision;
      I_dispvidctrl_tclClientVcan*                 m_poClientVcan;
      Idispvidctrl_tclClientDiaglogIf*             m_poClientDiaglogIf;
      Idispvidctrl_tclServiceRvcIf*                m_poServiceRvcIf;

      tenReverseSignal_State        m_enReverseSignal_State;
      tenFsmControl_Rvc_SuperState  m_enFsmControl_Rvc_SuperState;

      OSAL_tGPIODevID    m_GpioId_Reverse;
      OSAL_tIODescriptor m_hGpioHandle_Reverse;
      tBool              m_bReverseSignal_InputSignalState;
      tBool              m_bReverseStateUpdatePending;
      tBool              m_bReverseSimulationModeViaTTFis;
      OSAL_tGPIODevID    m_GpioId_CameraSupplyError;
      OSAL_tIODescriptor m_hGpioHandle_CameraSupplyError;
      tBool              m_bCameraSupplyError_InputSignalState;

      tenCurrentState m_enCameraVccCurrentState_ShortGnd;
      tenCurrentState m_enCameraVccCurrentState_OpenLoad;
      tenVccState     m_enCameraVccVccState;

      tenCurrentState m_enMicVccCurrentState_ShortGnd;
      tenCurrentState m_enMicVccCurrentState_OpenLoad;
      tenVccState     m_enMicVccVccState;

      tBool m_bCameraState;
      tBool m_bDiagCameraReq;
      tBool m_bDiagCameraFreeze;

      tBool m_bMicState;
      tBool m_bDiagMicReq;
      tBool m_bDiagMicFreeze;

      tBool m_bCameraSupplyFreeze;

      tBool m_bRvcMode;
      tBool m_bRvcType_Renault;
      tBool m_bVideoSignalState;
      tBool m_bAccState;
      tBool m_bIgnition;
      tBool m_bCameraSupplyHardwareInitDone;
      
      tU8   m_Config_u8VCANDiversity;
      tU8   m_tU8CntVerificationShortToBattery;
      tU8   m_u8CameraSupplyHardwareInitRetryCounter;
#ifdef VARIANT_S_FTR_ENABLE_AIVI_SCOPE2_1
// RENAULT
      tBool m_bOverSpeed;
      tBool m_bRecoverCameraAllow;
#endif
};
#endif

