/******************************************************************************/
/**
* \file    dispvidctrl_tclControl_Mvc.h
* \ingroup
*
* \brief
*
* \remark  Copyright : (c) 2015 Robert Bosch GmbH, Hildesheim
* \remark  Author    : deo2kor
* \remark  Scope     : AIVI
*
* \todo
*/
/******************************************************************************/
#ifndef _DISPVIDCTRL_TCL_CONTROL_MVC_H_
#define _DISPVIDCTRL_TCL_CONTROL_MVC_H_

/*******************************************************************************
                        Includes
*******************************************************************************/
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "dispvidctrl_AppMain.h"

/*******************************************************************************
                        Defines
*******************************************************************************/
// enumeration of user action events.
enum tenControl_Mvc
{
   EN_CONTROL_MVC__NONE  = 0,
   EN_CONTROL_MVC__DISABLE,
   EN_CONTROL_MVC__ENABLE,
   //------------------------------------ direct event(s) to FSM(s), i.e. timeouts
   EN_CONTROL_MVC__FSM_MVC_INPUT_EVENT,
   //------------------------------------ csm Mvc callbacks
   EN_CONTROL_MVC__VIEW_MODE_CHANGED,
   EN_CONTROL_MVC__WARNING_DISPLAY_STATUS_UPDATE,
   //------------------------------------ HMI requests      
   EN_CONTROL_MVC__HMI_VIEW_CHANGE_REQUEST,
   EN_CONTROL_MVC__SERVICE_REQUEST_VISUALISATION_ON,
   EN_CONTROL_MVC__SERVICE_REQUEST_VISUALISATION_OFF,
   EN_CONTROL_MVC__SETTINGS_ON,
   EN_CONTROL_MVC__SETTINGS_OFF,
   EN_CONTROL_MVC__STATIC_GUIDELINE_USER_SETTING_CHANGE,

   EN_CONTROL_MVC__IGNITION,
   EN_CONTROL_MVC__IGNITION_ON,
   EN_CONTROL_MVC__IGNITION_OFF,

   EN_CONTROL_MVC__CAN_MSG_TIMEOUT_TRUE,
   EN_CONTROL_MVC__CAN_MSG_TIMEOUT_FALSE,
   EN_CONTROL_MVC__CAN_MSG_TIMEOUT_CONFIRMED
};

enum ten_Mvc_ViewMode
{
   EN_MVC_VIEW_MODE_NO_VIEW = 0,
   EN_MVC_VIEW_MODE_FRONT,
   EN_MVC_VIEW_MODE_REAR,
   EN_MVC_VIEW_MODE_RIGHT,
   EN_MVC_VIEW_MODE_LEFT
};

// FSM output events
enum tenFsmOutEvent_Mvc
{
   FSM_MVC_OUT__NONE   = 0,
   FSM_MVC_OUT__FSM_MVC_INPUT_EVENT,
   FSM_MVC_OUT__HMI_VISUALISATION_ON,
   FSM_MVC_OUT__HMI_VISUALISATION_OFF,
   FSM_MVC_OUT__HMI_VISUALISATION_ON_SETTINGS,
   FSM_MVC_OUT__MVC_CLEAR_VIEW_REQUEST,
   FSM_MVC_OUT__MVC_CHECK_MVC_VIEW_REQUEST,
   FSM_MVC_OUT__MVC_SEND_REQUEST,
   FSM_MVC_OUT__MVC_CAN_SIGNAL_TIMEOUT,
   FSM_MVC_OUT__MVC_CHECK_CURRENT_SPEED,
   FSM_MVC_OUT__MVC_OFF_DELAY_TIME_OUT
};

enum tenFsmControl_Mvc_SuperState
{
   DISPVIDCTRL_CONTROL_MVC__DISABLED = 0,
   DISPVIDCTRL_CONTROL_MVC__ENABLED
};

/*******************************************************************************
   Class
*******************************************************************************/

class dispvidctrl_tclFsm_Mvc;
class I_dispvidctrl_tclClientVcan;
class dispvidctrl_tclControl_Video;
class Idispvidctrl_tclServiceRvcIf;

class dispvidctrl_tclControl_Mvc : public dispvidctrl_tclBaseIf
{
public:
   dispvidctrl_tclControl_Mvc(dispvidctrl_tclAppMain* poMainAppl);
   dispvidctrl_tclControl_Mvc(); // default constructor
   virtual ~dispvidctrl_tclControl_Mvc();

   virtual const tChar* getName() const { return ""; };
   virtual const tChar* getIfName() const { return "dispvidctrl_tclControl_Mvc"; };

   virtual tVoid vHandleMessage(dispvidctrl_tclBaseIf::TMsg* pMsg);
   virtual tVoid vHandleTraceMessage(const tUChar* puchData);
   virtual tVoid vGetReferences();
   virtual tVoid vStartCommunication();
   virtual tVoid vTraceInfo();
   virtual tVoid vGetConfiguration(const TConfiguration* pStConfigurationValues);

   tVoid vHandleControl(tenControl_Mvc enControl, tU32 u32Value = 0);
   tVoid vHandleFsmOutEvent_Mvc(tenFsmOutEvent_Mvc enFsmMvcOutEvent, tU32 u32Value = 0);
   dispvidctrl_tclFsm_Mvc* vGetPoFsm_Mvc() const { return m_poFsm_Mvc;};

   tBool IsMvcViewModeRear();

private:
   tVoid _vHandleFrameStatusUpdate(tenControl_Mvc enControl, tU32 u32Value = 0);
   tVoid _vOnEvent_FsmControl_Mvc(tenControl_Mvc enControl, tU32 u32Value = 0);
   
   tVoid _vUpdateGuidelineState(const tU8 u8NewStatus);
   tBool _bCheckAndUpdateMvcViewState(tVoid);
   tBool _bIsVehicleSpeedHigh() const;

   dispvidctrl_tclFsm_Mvc* m_poFsm_Mvc;
   I_dispvidctrl_tclClientVcan* m_poClientVcan;
   dispvidctrl_tclControl_Video* m_poControl_Video;
   Idispvidctrl_tclServiceRvcIf* m_poServiceRvcIf;
   
   tenFsmControl_Mvc_SuperState m_enFsmControl_Mvc_SuperState;
   
   ten_Mvc_ViewMode m_enRequestedView;
   ten_Mvc_ViewMode m_enCurrentView;

   tBool m_bAccState;
   tBool m_bIgnition;
   tBool m_bStaticGuidelineVisible;
   tBool m_bStaticGuidelineUserSetting;
   tBool m_bMvcMode;
   tBool m_bSpeedHigh;
};

#endif // _DISPVIDCTRL_TCL_CONTROL_MVC_H_
