/******************************************************************************/
/**
* \file    dispvidctrl_tclControl_HmiAvm3.cpp
* \ingroup
*
* \brief
*
* \remark  Copyright : (c) 2015 Robert Bosch GmbH, Hildesheim
* \remark  Author    : Michael Niemann, Harry Wentland
* \remark  Scope     : AIVI
*
* \todo
*/
/******************************************************************************/

/*******************************************************************************
                        Includes
*******************************************************************************/
#include "dispvidctrl_tclControl.h"

#include "Idispvidctrl_ClientAvm.h"
#include "Idispvidctrl_ClientAvmFsm.h"
#include "dispvidctrl_tclControl_HmiAvm3.h"
#include "dispvidctrl_tclFsm_HmiAvm3.h"
#include "I_dispvidctrl_tclSyncHandler.h"

#include "dispvidctrl_tclControl_Video.h"
//#include "I_dispvidctrl_ClientDimmingIf.h"
#include "I_dispvidctrl_ServiceRvcIf.h"


#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_DISPVIDCTRL_APPLICATION
#include "trcGenProj/Header/dispvidctrl_tclControl_HmiAvm3.cpp.trc.h"
#endif

/*******************************************************************************
                        Defines
*******************************************************************************/


//------------------------------------------------------------------------------
// //display back-light level for Video screen (Dimming)
// #define DISPVIDCTRL_VIDEO_BACKLIGHT_LEVEL_DAY   (tU8) 18
// #define DISPVIDCTRL_VIDEO_BACKLIGHT_LEVEL_NIGHT (tU8) 18
// #define DISPVIDCTRL_VIDEO_BACKLIGHT_REQUEST_OFF (tU8) 255

/******************************************************************************/
/* FUNCTION     dispvidctrl_tclControl_HmiAvm3()                                       */
/******************************************************************************/
/**
*  \brief       default constructor
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
dispvidctrl_tclControl_HmiAvm3::dispvidctrl_tclControl_HmiAvm3()
: dispvidctrl_tclBaseIf(OSAL_NULL)
//, m_poClientDimmingIf(OSAL_NULL)
, m_poFsm_Hmi(OSAL_NULL)
, m_poControl_Video(OSAL_NULL)
, m_poRvcServiceIf(OSAL_NULL)
, m_poMcanClientAvm(OSAL_NULL)
, m_poMcanClientAvmFsm(OSAL_NULL)
, m_poSyncHandler(OSAL_NULL)
, m_enFsmControl_Hmi_SuperState(DISPVIDCTRL_CONTROL_HMIAVM3__DISABLED)
, m_bHmiAppVehicleReady(FALSE)
{
}

/******************************************************************************/
/* FUNCTION     dispvidctrl_tclControl_HmiAvm3()                                       */
/******************************************************************************/
/**
*  \brief       constructor
*
*  \param       pointer to control //main application
*  \return      none
*/
/******************************************************************************/
dispvidctrl_tclControl_HmiAvm3::dispvidctrl_tclControl_HmiAvm3(dispvidctrl_tclAppMain* poMainAppl)
: dispvidctrl_tclBaseIf(poMainAppl)
//, m_poClientDimmingIf(OSAL_NULL)
, m_poFsm_Hmi(OSAL_NULL)
, m_poControl_Video(OSAL_NULL)
, m_poRvcServiceIf(OSAL_NULL)
, m_poMcanClientAvm(OSAL_NULL)
, m_poMcanClientAvmFsm(OSAL_NULL)
, m_poSyncHandler(OSAL_NULL)
, m_enFsmControl_Hmi_SuperState(DISPVIDCTRL_CONTROL_HMIAVM3__DISABLED)
, m_bHmiAppVehicleReady(FALSE)
{
   ETG_TRACE_USR4(("dispvidctrl_tclControl_HmiAvm3() entered."));

   // create new Hmi FSM
   m_poFsm_Hmi = dispvidctrl_tclFsm_HmiAvm3::tclCreateInstance(this); // this: dispvidctrl_tclControl_HmiAvm3*;
   DISPVIDCTRL_NULL_POINTER_CHECK(m_poFsm_Hmi);
}


/******************************************************************************/
/* FUNCTION     ~dispvidctrl_tclControl_HmiAvm3                                        */
/******************************************************************************/
/**
*  \brief       destructor
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
dispvidctrl_tclControl_HmiAvm3::~dispvidctrl_tclControl_HmiAvm3(tVoid)
{
   ETG_TRACE_USR4(("~dispvidctrl_tclControl_HmiAvm3() entered."));

   //m_poClientDimmingIf = OSAL_NULL;
   m_poFsm_Hmi  = OSAL_NULL;
   m_poMcanClientAvm = OSAL_NULL;
   m_poMcanClientAvmFsm = OSAL_NULL;
   m_poSyncHandler = OSAL_NULL;
}

/******************************************************************************/
/* FUNCTION     vGetConfiguration                                             */
/******************************************************************************/
/**
*  \brief       Function to get all configuration values needed by this class.
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
//tVoid dispvidctrl_tclControl_HmiAvm3::vGetConfiguration(const TConfiguration* pStConfigurationValues)
//{
//   TConfiguration_Fsm_Hmi StConfiguration_Fsm_Hmi;
//
//   ETG_TRACE_USR4(("dispvidctrl_tclControl_HmiAvm3::vGetConfiguration() entered."));
//
//   m_bAvmMode = pStConfigurationValues->bAvmMode;
//   m_bRvcMode = pStConfigurationValues->bRvcMode;
//   m_bMvcMode = pStConfigurationValues->bMvcMode;
//   m_bFapConfigured = pStConfigurationValues->bAvmType_Fap;   
//
//   if (m_bAvmMode)
//   {
//      StConfiguration_Fsm_Hmi.u32BlackInTime = DISPVIDCTRL_BLACK_IN_TIME_IN_MS_AVM;
//      StConfiguration_Fsm_Hmi.u32BlackOutTime = DISPVIDCTRL_BLACK_OUT_TIME_IN_MS_AVM;
//   }
//   else if (m_bMvcMode)
//   {
//      StConfiguration_Fsm_Hmi.u32BlackInTime = DISPVIDCTRL_BLACK_IN_TIME_IN_MS_MVC;
//      StConfiguration_Fsm_Hmi.u32BlackOutTime = DISPVIDCTRL_BLACK_OUT_TIME_IN_MS_MVC;
//   }
//   else
//   {
//      StConfiguration_Fsm_Hmi.u32BlackInTime = DISPVIDCTRL_BLACK_IN_TIME_IN_MS_RVC;
//      StConfiguration_Fsm_Hmi.u32BlackOutTime = DISPVIDCTRL_BLACK_OUT_TIME_IN_MS_RVC;
//   }
//   if (m_poFsm_Hmi)
//   {
//      m_poFsm_Hmi->vConfigure(&StConfiguration_Fsm_Hmi);
//   }
//}

/******************************************************************************/
/* FUNCTION     vGetReferencesEarly                                           */
/******************************************************************************/
/**
*  \brief       Function to get all reference needed by this class.
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclControl_HmiAvm3::vGetReferencesEarly(tVoid)
{
   ETG_TRACE_FATAL(("dispvidctrl_tclControl_HmiAvm3::vGetReferencesEarly() entered."));
   
   m_poMcanClientAvm = dynamic_cast<I_dispvidctrl_tclMCanClientAvm*>(_cpoMain->getHandler("I_dispvidctrl_tclMCanClientAvm"));
   DISPVIDCTRL_NULL_POINTER_CHECK(m_poMcanClientAvm);

   m_poMcanClientAvmFsm = dynamic_cast<I_dispvidctrl_tclMCanClientAvmFsm*>(_cpoMain->getHandler("I_dispvidctrl_tclMCanClientAvmFsm"));
   DISPVIDCTRL_NULL_POINTER_CHECK(m_poMcanClientAvmFsm);

   m_poSyncHandler = dynamic_cast<I_dispvidctrl_tclSyncHandler*>(_cpoMain->getHandler("I_dispvidctrl_tclSyncHandler"));
   DISPVIDCTRL_NULL_POINTER_CHECK(m_poSyncHandler);
}

/******************************************************************************/
/* FUNCTION     vGetReferences                                                */
/******************************************************************************/
/**
*  \brief       Function to get all reference needed by this class.
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclControl_HmiAvm3::vGetReferences(tVoid)
{
   ETG_TRACE_USR4(("dispvidctrl_tclControl_HmiAvm3::vGetReferences() entered."));

//   m_poClientDimmingIf = dynamic_cast<Idispvidctrl_tclClientDimmingIf*>(_cpoMain->getHandler("Idispvidctrl_tclClientDimmingIf"));
//   DISPVIDCTRL_NULL_POINTER_CHECK(m_poClientDimmingIf);

   m_poControl_Video = dynamic_cast<dispvidctrl_tclControl_Video*>(_cpoMain->getHandler("dispvidctrl_tclControl_Video"));
   DISPVIDCTRL_NULL_POINTER_CHECK(m_poControl_Video);

   m_poRvcServiceIf = dynamic_cast<Idispvidctrl_tclServiceRvcIf*>(_cpoMain->getHandler("Idispvidctrl_tclServiceRvcIf"));
   DISPVIDCTRL_NULL_POINTER_CHECK(m_poRvcServiceIf);
}


/******************************************************************************/
/* FUNCTION     vStartCommunicationEarly                                      */
/******************************************************************************/
/**
*  \brief       Function to start all dynamic objects e.g. threads, ...
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclControl_HmiAvm3::vStartCommunicationEarly(tVoid)
{
   ETG_TRACE_FATAL(("dispvidctrl_tclControl_HmiAvm3::vStartCommunicationEarly() entered."));
   _vOnEvent_FsmControl_Hmi(EN_CONTROL_HMIAVM3__ENABLE);
}

/******************************************************************************/
/* FUNCTION     vStartCommunication                                           */
/******************************************************************************/
/**
*  \brief       Function to start all dynamic objects e.g. threads, ...
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclControl_HmiAvm3::vStartCommunication(tVoid)
{
   ETG_TRACE_USR4(("dispvidctrl_tclControl_HmiAvm3::vStartCommunication() entered."));
}


/******************************************************************************/
/* FUNCTION     vHandleMessage(TMsg* pMsg)                                    */
/******************************************************************************/
/**
*  \brief       Handle worker events.
*
*  \param       message pointer
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclControl_HmiAvm3::vHandleMessage(dispvidctrl_tclBaseIf::TMsg* pMsg)
{
   ETG_TRACE_USR4(("dispvidctrl_tclControl_HmiAvm3::vHandleMessage() entered %u -> data: %d.", ETG_CENUM(dispvidctrl_tclBaseIf::ECmdTypes , (tU32)pMsg->eCmd), pMsg->u.u32Data));

   switch (pMsg->eCmd)
   {
      case dispvidctrl_tclBaseIf::eControlHmiAvm3:
         vHandleControl((tenControl_HmiAvm3) pMsg->u.u32Data);
         break;
      case dispvidctrl_tclBaseIf::eFsmHmiAvm3:
         vHandleControl(EN_CONTROL_HMIAVM3__FSM_HMI_INPUT_EVENT, pMsg->u.u32Data);
         break;
      case dispvidctrl_tclBaseIf::eDiagVideoLayer:
         vHandleControl( EN_CONTROL_HMIAVM3__DIAG_VIDEO_LAYER, pMsg->u.u32Data);
         break;

      case dispvidctrl_tclBaseIf::eControlModeEnabled:
         vHandleControl(EN_CONTROL_HMIAVM3__ENABLE, pMsg->u.u32Data);
         break;
      case dispvidctrl_tclBaseIf::eControlModeDisabled:
         vHandleControl(EN_CONTROL_HMIAVM3__DISABLE, pMsg->u.u32Data);
         break;

      case dispvidctrl_tclBaseIf::eHmiVisualisationOff:
         vHandleControl( EN_CONTROL_HMIAVM3__VISUALISATION_OFF, pMsg->u.u32Data);
         break;
      case dispvidctrl_tclBaseIf::eHmiVisualisationOn:
         vHandleControl( EN_CONTROL_HMIAVM3__VISUALISATION_ON, pMsg->u.u32Data);
         break;

      default:
         break;
   }
}

/******************************************************************************/
/* FUNCTION     vHandleTraceMessage                                           */
/******************************************************************************/
/**
*  \brief       handle TTFis commands
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclControl_HmiAvm3::vHandleTraceMessage(const tUChar* puchData)
{
   DISPVIDCTRL_NULL_POINTER_CHECK(puchData);

   tU32 u32MsgCode = ((puchData[1]<<8) | puchData[2]);
   ETG_TRACE_USR4(("dispvidctrl_tclControl_HmiAvm3::vHandleTraceMessage(): trace command %d", u32MsgCode ));

   switch (u32MsgCode)
   {
      case DISPVIDCTRL_DISPVIDCTRL_STIMULATE_FSM_HMIAVM3:
         {
            // Set once eTrigger for FSM_Hmi
            tU32 param1 = ((tU32)puchData[3] << 24) | ((tU32)puchData[4] << 16) | ((tU32)puchData[5] <<  8) | (tU32)puchData[6];

            vHandleControl(EN_CONTROL_HMIAVM3__FSM_HMI_INPUT_EVENT, param1);
         }
         break;
      case DISPVIDCTRL_DISPVIDCTRL_STIMULATE_CONTROL_HMIAVM3:
         {
            tU8 param1 = puchData[3];
            tU32 param2 = ((tU32)puchData[4] << 24) | ((tU32)puchData[5] << 16) | ((tU32)puchData[6] <<  8) | (tU32)puchData[7];

            vHandleControl((tenControl_HmiAvm3) param1, param2);
         }
         break;
      default:
         break;
   }
}


/******************************************************************************/
/* FUNCTION     vHandleControl()                                              */
/******************************************************************************/
/**
*  \brief       trace information
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclControl_HmiAvm3::vHandleControl(tenControl_HmiAvm3 enControl, tU32 u32Value)
{
   //OSAL_C_PARAMETER_INTENTIONALLY_UNUSED( u32Value );

   ETG_TRACE_USR4(("   CA-HMIAVM3 :: ............vHandleControl(): %d     ", ETG_CENUM(tenControl_HmiAvm3, enControl)));
      
   switch (enControl)
   {
      case EN_CONTROL_HMIAVM3__DISABLE:
      case EN_CONTROL_HMIAVM3__ENABLE:
         _vOnEvent_FsmControl_Hmi(enControl, u32Value);
         break;
      //-------------------------------------------------------------------------------------------
      case EN_CONTROL_HMIAVM3__FSM_HMI_INPUT_EVENT:
         if (m_poFsm_Hmi) {m_poFsm_Hmi->vNewTrigger(u32Value, TRUE);}
         break;
      //-------------------------------------------------------------------------------------------
      case EN_CONTROL_HMIAVM3__VISUALISATION_OFF:
      case EN_CONTROL_HMIAVM3__VISUALISATION_ON:
      case EN_CONTROL_HMIAVM3__VISUALISATION_ON_CAMERA_DIAG:
      case EN_CONTROL_HMIAVM3__VISUALISATION_ON_VIDEO_SETTINGS:
      case EN_CONTROL_HMIAVM3__BLANKOFFREQ_BLACK_IN:
      case EN_CONTROL_HMIAVM3__BLANKOFFREQ_BLACK_OUT:
      case EN_CONTROL_HMIAVM3__BLANKLESS_CHG_REQ:
      case EN_CONTROL_HMIAVM3__CONF_VIEW_SETUP:
         _vOnEvent_FsmControl_Hmi(enControl, u32Value);
         break;
      //-------------------------------------------------------------------------------------------
      case EN_CONTROL_HMIAVM3__HMI_AVAILABLE:
         if (m_poControl_Video) {
            m_poControl_Video->vHandleControl(EN_CONTROL_VIDEO__SET_B_HANDOVER_READY);
         }
         if (m_poFsm_Hmi)
         {
            _vSend_SetStatusHmiMResult(m_poFsm_Hmi->u32GetFsmState());
         }
         _vOnEvent_FsmControl_Hmi(enControl, u32Value);
         break;
      //-------------------------------------------------------------------------------------------
      case EN_CONTROL_HMIAVM3__SYSTEMSTATUS_CONFIRMATION:
         if (m_bHmiAppVehicleReady == FALSE) {
            m_bHmiAppVehicleReady = TRUE;
            if (m_poControl_Video) {
               m_poControl_Video->vHandleControl(EN_CONTROL_VIDEO__HMI_AVAILABLE);
            }
         }
         _vHandleHMIConfirmationStatus(u32Value);
         break;
      //-------------------------------------------------------------------------------------------
      case EN_CONTROL_HMIAVM3__DIAG_VIDEO_LAYER:
         _vOnEvent_FsmControl_Hmi(enControl, u32Value);
         break;
      //-------------------------------------------------------------------------------------------
      case EN_CONTROL_HMIAVM3__SERVICE_REQUEST_VISUALISATION:
         _vOnEvent_FsmControl_Hmi(enControl, u32Value);
         break;
      default:
         break;
   }
}

/******************************************************************************/
/* FUNCTION     vHandleFsmOutEvent_HmiAvm3()                                 */
/******************************************************************************/
/**
*  \brief       handle function to post output events from FSM HMI
*
*  \param       event
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclControl_HmiAvm3::vHandleFsmOutEvent_HmiAvm3(tenFsmOutEvent_HmiAvm3 enFsmOutEvent_Hmi, tU32 u32Value)
{
   // FSM_HMIAVM3_OUT__FSM...       // input events for FSM HMI (Loopback to FSM HMI)
   // FSM_HMIAVM3_OUT__EVENTNAME... // input events for other FSM/Target

   ETG_TRACE_USR4(("   CA-HMIAVM3 :: vHandleFsmOutEvent_HmiAvm3(): %d     ", ETG_CENUM(tenFsmOutEvent_HmiAvm3, enFsmOutEvent_Hmi)));

   switch (enFsmOutEvent_Hmi)
   {
      case FSM_HMIAVM3_OUT__FSM_HMIAVM3_INPUT_EVENT:
         // post loop-back message to Hmi FSM, u32Value will be eTrigger... value
         _cpoMain->theServer()->vPostMsgFsmHmiAvm3("dispvidctrl_tclControl_HmiAvm3", u32Value);
         break;
      //-------------------------------------------------------------------------------------------
      case FSM_HMIAVM3_OUT__HMI_VISUALISATION_OFF:
         _vSetSystemStatus(enFsmOutEvent_Hmi);
         break;
      case FSM_HMIAVM3_OUT__HMI_VISUALISATION_ON:
      case FSM_HMIAVM3_OUT__HMI_VISUALISATION_ON_CAMERA_SETTINGS:
//         if (m_poControl_Video) {
//            m_poControl_Video->vHandleControl(EN_CONTROL_VIDEO__SHOW_RVC);
//         }
         if (m_poMcanClientAvm)
         {
            m_poMcanClientAvm->vHandleControlOutput(I_dispvidctrl_tclMCanClientAvm::eHmiReqShowRvc,1);
         }
         _vSetSystemStatus(enFsmOutEvent_Hmi);
         break;
      case FSM_HMIAVM3_OUT__AVM_REQ_BLANKLESS_CHG:
         if (m_poMcanClientAvm)
         {
            m_poMcanClientAvm->vHandleControlOutput(I_dispvidctrl_tclMCanClientAvm::eHmiReqShowRvc,0);
         }      
         break;
      case FSM_HMIAVM3_OUT__HMI_VISUALISATION_BLACK_OUT:
      case FSM_HMIAVM3_OUT__HMI_VISUALISATION_BLACK_OUT_CAMERA_SETTINGS:
          if (m_poControl_Video) {
              m_poControl_Video->vHandleControl(EN_CONTROL_VIDEO__SET_B_HANDOVER_READY);
              m_poControl_Video->vHandleControl(EN_CONTROL_VIDEO__BLACK_SCREEN_ON);
          }
          _vSetSystemStatus(enFsmOutEvent_Hmi);
          break;
      case FSM_HMIAVM3_OUT__HMI_VISUALISATION_BLACK_IN:
      case FSM_HMIAVM3_OUT__HMI_VISUALISATION_BLACK_IN_CAMERA_SETTINGS:
         //if (m_poControl_Video) {
         //   m_poControl_Video->vHandleControl(EN_CONTROL_VIDEO__SET_B_HANDOVER_READY);
         //   m_poControl_Video->vHandleControl(EN_CONTROL_VIDEO__BLACK_SCREEN_ON);
         //}
         _vSetSystemStatus(enFsmOutEvent_Hmi);
         break;
      //-------------------------------------------------------------------------------------------
      case FSM_HMIAVM3_OUT__VIDEO_SET_GAMMA_OFF:
            
            if (m_poControl_Video) {  // via video interface
//todo: HMI FSM is not sending Gamma off currently
               m_poControl_Video->vHandleControl(EN_CONTROL_VIDEO__SET_VIDEO_GAMMA_OFF);
            }
         break;
      case FSM_HMIAVM3_OUT__VIDEO_SET_GAMMA_ON:
            if (m_poControl_Video) {  // via video interface
               m_poControl_Video->vHandleControl(EN_CONTROL_VIDEO__SET_VIDEO_GAMMA_ON);
            }
         break;
      case FSM_HMIAVM3_OUT__VIDEO_CAPTURING_STOP:
            if (m_poControl_Video) {
               m_poControl_Video->vHandleControl(EN_CONTROL_VIDEO__CAPTURING_OFF);
            }
// currently undefined            _vOnEvent_FsmVideoSignalCheck(EN_HMIAVM3_VID_TIMER__STOP);  // stop video signal detection check
         break;
      case FSM_HMIAVM3_OUT__VIDEO_CAPTURING_START:
            if (m_poControl_Video) {
               m_poControl_Video->vHandleControl(EN_CONTROL_VIDEO__CAPTURING_ON);
            }
         break;
         
      case FSM_HMIAVM3_OUT__VIDEO_SET_VIDEO_CONTROLS:
            if (m_poControl_Video) {
               m_poControl_Video->vHandleControl(EN_CONTROL_VIDEO__SET_VIDEO_CONTROLS);
            }
         break;

      case FSM_HMIAVM3_OUT__VIDEO_GRAPHICS_OFF:
            if (m_poControl_Video) {
               m_poControl_Video->vHandleControl(EN_CONTROL_VIDEO__GRAPHICS_OFF);
            }
         break;
      case FSM_HMIAVM3_OUT__VIDEO_GRAPHICS_ON:
            if (m_poControl_Video) {
               m_poControl_Video->vHandleControl(EN_CONTROL_VIDEO__GRAPHICS_ON);
            }
         break;

      case FSM_HMIAVM3_OUT__HMI_CONFIRM_VISUALISATION_BLACK_IN:
      case FSM_HMIAVM3_OUT__HMI_CONFIRM_VISUALISATION_BLACK_OUT:
            if (m_poControl_Video) {
               m_poControl_Video->vHandleControl(EN_CONTROL_VIDEO__SET_B_HANDOVER_READY);
               m_poControl_Video->vHandleControl(EN_CONTROL_VIDEO__BLACK_SCREEN_ON);
            }
         break;

      case FSM_HMIAVM3_OUT__AVM_REQ_VIEW_SETUP:  // need to send as message because client sends its confirmation synch to vHandleControl(), from where it goes back into our FSM
         _cpoMain->theServer()->vPostMsgClientMcanAvm3("I_dispvidctrl_tclMCanClientAvm", I_dispvidctrl_tclMCanClientAvm::eHmiReqViewSetup);
         break;
         
      case FSM_HMIAVM3_OUT__AVM_REQ_DIRECT_CAM_OFF:
         if (m_poMcanClientAvm)
         {
            m_poMcanClientAvm->vHandleControlOutput(I_dispvidctrl_tclMCanClientAvm::eHmiReqDirectCamOff,0);
         }      
         break;
         
      default:
         break;
   }
}

/******************************************************************************/
/* FUNCTION     _vOnEvent_FsmControl_Hmi                                      */
/******************************************************************************/
/**
*  \brief
*
*  \param       event, data
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclControl_HmiAvm3::_vOnEvent_FsmControl_Hmi(tenControl_HmiAvm3 enControl, tU32 u32Value)
{
   ETG_TRACE_USR4(("   CA-HMIAVM3 :: ........._vOnEvent_FsmControl_Hmi(): %d     ", ETG_CENUM(tenControl_HmiAvm3, enControl)));
   ETG_TRACE_USR4(("   CA-HMIAVM3 :: . FSM Control_Hmi Super State Entry: %u     ", ETG_CENUM(tenFsmControl_HmiAvm3_SuperState, m_enFsmControl_Hmi_SuperState)));

   tBool bEventProcessed = TRUE;

   OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(u32Value);

   switch (m_enFsmControl_Hmi_SuperState)
   {
      /* ------------------------------------------------------------- */
      /*                                      D I S A B L E D          */
      /* ------------------------------------------------------------- */
      case DISPVIDCTRL_CONTROL_HMIAVM3__DISABLED:
         {
            switch (enControl)
            {
            case EN_CONTROL_HMIAVM3__ENABLE:
               {
                  // first LATE transition after EARLY: use direct transition
                  if ((u32Value & DISPVIDCTRL_VIDEO__MASK_EARLY_ACTIV) > 0)
                  {
                     // nothing special to do in case of AVM phase3
                  }
                  else
                  {
                     // If we did stop because of critical under voltage or
                     // application state not normal, we have to clean up this
                     // remembered off trigger.
                     // Otherwise we will not change to black in if an new
                     // Visualization ON Request because of Screen reactivation will be received.
                     // Required only as long as we are in black out.
// not sure if it's required for the AVM phase3 FSM either
//                     if (m_poFsm_Hmi)
//                     {
//                        m_poFsm_Hmi->vNewTrigger(dispvidctrl_tclFsm_HmiAvm3::eTriggerHmiAvm3_OFF_REASON_CLEAN_UP, TRUE);
//                     }
                  }
                  // new super state
                  m_enFsmControl_Hmi_SuperState = DISPVIDCTRL_CONTROL_HMIAVM3__ENABLED;
               }
               break;
            case EN_CONTROL_HMIAVM3__DISABLE:
               {
                  if (((dispvidctrl_tclFsm_HmiAvm3::tenHmiVisualisationOffReason) u32Value) == dispvidctrl_tclFsm_HmiAvm3::EN_VD_RVC_HMI_VISUALISATION_OFF__INITIAL_OFF)
                  {
                     _vSetSystemStatus(FSM_HMIAVM3_OUT__HMI_VISUALISATION_OFF);
                  }
               }
               break;
            default:
               {
                  bEventProcessed = FALSE;
               }
               break;
            }
         }
         break;
      /* ------------------------------------------------------------- */
      /*                                        E N A B L E D          */
      /* ------------------------------------------------------------- */
      case DISPVIDCTRL_CONTROL_HMIAVM3__ENABLED:
      {
         if (EN_CONTROL_HMIAVM3__DISABLE == enControl)
         {
            // remember off reason with highest priority
            if (m_poFsm_Hmi) {
               if (((dispvidctrl_tclFsm_HmiAvm3::tenHmiVisualisationOffReason) u32Value) > m_poFsm_Hmi->m_enHmiVisualisationOffReason)
               {
                  m_poFsm_Hmi->m_enHmiVisualisationOffReason = (dispvidctrl_tclFsm_HmiAvm3::tenHmiVisualisationOffReason) u32Value;
               }
               m_poFsm_Hmi->vNewTrigger(dispvidctrl_tclFsm_HmiAvm3::eTriggerHmiAvm3_AVM_REQ_VISUAL_OFF, TRUE);
            }
            // new super state
            m_enFsmControl_Hmi_SuperState = DISPVIDCTRL_CONTROL_HMIAVM3__DISABLED;
         }
//         else if (m_bDiagVideoLayer == TRUE)
//         {
//            bEventProcessed = TRUE;
//            switch (enControl)
//            {
//               //Diagnose is not longer activ -> disable VideoLayer and DiagVideoLayer mode
//               case EN_CONTROL_HMIAVM3__DIAG_VIDEO_LAYER:
//                  {
//                     if ((u32Value == 0) && (m_poFsm_Hmi != OSAL_NULL))
//                     {
//                        m_poFsm_Hmi->m_enHmiVisualisationOffReason = (dispvidctrl_tclFsm_HmiAvm3::tenHmiVisualisationOffReason) dispvidctrl_tclFsm_HmiAvm3::EN_VD_RVC_HMI_VISUALISATION_OFF__DIAG_VIDEO_LAYER_OFF;
//                        m_poFsm_Hmi->vNewTrigger(dispvidctrl_tclFsm_HmiAvm3::eTriggerHmiAvm3_AVM_REQ_VISUAL_OFF, TRUE);
//                        m_bDiagVideoLayer = FALSE;
//
//                        // we can deactivate the camera power supply (was propably switched to ON in RVC mode only)
//                        if (m_poControl_Rvc) {
//                           m_poControl_Rvc->vHandleControl(EN_CONTROL_RVC__DIAG_VIDEO_SCREEN_CAMERA_SUPPLY, 0);
//                        }
//                        // we can send "Camera OFF Request" CAN signal to AVM unit
//                        if (m_bAvmMode) {
//                           if (m_poControl_Avm) {
//                              m_poControl_Avm->vHandleControl(EN_CONTROL_AVM__PURPOSE_SWITCH);
//                           }
//                        }
//                     }
//                  }
//                  break;
//              default:
//               {
//                    ETG_TRACE_USR4(("   CA-HMIAVM3 :: ... event blocked due to activated video layer from diagnose!"));
//                    bEventProcessed = FALSE;
//               }
//               break;
//            }
//         }
         else if (EN_CONTROL_HMIAVM3__DIAG_VIDEO_LAYER == enControl)
         {
            if (m_poMcanClientAvm)
            {
               m_poMcanClientAvm->vHandleControlOutput(I_dispvidctrl_tclMCanClientAvm::eDiagReqShowVideo,u32Value);
            }
         }
         else if (EN_CONTROL_HMIAVM3__SERVICE_REQUEST_VISUALISATION == enControl)
         {
            if (m_poMcanClientAvm && m_poFsm_Hmi)
            {
               if (rvc_fi_tcl_e8_RVC_SystemStatus::FI_EN_VISUALISATION_OFF == u32Value)
               {
                  if (dispvidctrl_tclFsm_HmiAvm3::eStateHmiAvm3_ON_VID_SETTINGS==m_poFsm_Hmi->u32GetFsmState() )
                  {
                     m_poMcanClientAvm->vHandleControlOutput(I_dispvidctrl_tclMCanClientAvm::eServiceReqShowVideo, FALSE);
                  }
               }
               else
               {
                  if (dispvidctrl_tclFsm_HmiAvm3::eStateHmiAvm3_OFF==m_poFsm_Hmi->u32GetFsmState() )
                  {
                     m_poMcanClientAvm->vHandleControlOutput(I_dispvidctrl_tclMCanClientAvm::eServiceReqShowVideo, TRUE);
                  }
               }
            }
         }
         else
         {
            tU32 u32FSM_Event;

            bEventProcessed = TRUE;
            switch (enControl)
            {
               case EN_CONTROL_HMIAVM3__FSM_HMI_INPUT_EVENT              : u32FSM_Event = u32Value; break;
               
               case EN_CONTROL_HMIAVM3__HMI_AVAILABLE                    : u32FSM_Event = dispvidctrl_tclFsm_HmiAvm3::eTriggerHmiAvm3_HMI_AVAILABLE;           break;
               case EN_CONTROL_HMIAVM3__VISUALISATION_ON                 : u32FSM_Event = dispvidctrl_tclFsm_HmiAvm3::eTriggerHmiAvm3_AVM_REQ_VISUAL_ON;       break;
               case EN_CONTROL_HMIAVM3__VISUALISATION_ON_CAMERA_DIAG     : u32FSM_Event = dispvidctrl_tclFsm_HmiAvm3::eTriggerHmiAvm3_DIAG_REQ_VISUAL_ON;      break;
               case EN_CONTROL_HMIAVM3__VISUALISATION_ON_VIDEO_SETTINGS  : u32FSM_Event = dispvidctrl_tclFsm_HmiAvm3::eTriggerHmiAvm3_VIDSET_REQ_VISUAL_ON;    break;
               case EN_CONTROL_HMIAVM3__BLANKOFFREQ_BLACK_IN             : u32FSM_Event = dispvidctrl_tclFsm_HmiAvm3::eTriggerHmiAvm3_AVM_REQ_BLANK_IN_END;    break;
               case EN_CONTROL_HMIAVM3__BLANKOFFREQ_BLACK_OUT            : u32FSM_Event = dispvidctrl_tclFsm_HmiAvm3::eTriggerHmiAvm3_AVM_REQ_BLANK_OUT_END;   break;
               case EN_CONTROL_HMIAVM3__BLANKLESS_CHG_REQ                : u32FSM_Event = dispvidctrl_tclFsm_HmiAvm3::eTriggerHmiAvm3_AVM_REQ_BLANKLESS_CHG;   break;
               case EN_CONTROL_HMIAVM3__CONF_VIEW_SETUP                  : u32FSM_Event = dispvidctrl_tclFsm_HmiAvm3::eTriggerHmiAvm3_AVM_CONF_VIEW_SETUP;     break;
//               case EN_CONTROL_HMIAVM3__VIDEO_SIGNAL_FALSE_CONFIRMED     : u32FSM_Event = dispvidctrl_tclFsm_HmiAvm3::eTriggerHmiAvm3_VIDEO_SIGNAL_FALSE;      break;
//               case EN_CONTROL_HMIAVM3__VIDEO_SIGNAL_TRUE                : u32FSM_Event = dispvidctrl_tclFsm_HmiAvm3::eTriggerHmiAvm3_VIDEO_SIGNAL_TRUE;       break;

               case EN_CONTROL_HMIAVM3__VISUALISATION_OFF                : u32FSM_Event = dispvidctrl_tclFsm_HmiAvm3::eTriggerHmiAvm3_AVM_REQ_VISUAL_OFF;   // no break
                  {
                     // remember off reason with highest priority
                     if (m_poFsm_Hmi) {
                        if (((dispvidctrl_tclFsm_HmiAvm3::tenHmiVisualisationOffReason) u32Value) > m_poFsm_Hmi->m_enHmiVisualisationOffReason) {
                           m_poFsm_Hmi->m_enHmiVisualisationOffReason = (dispvidctrl_tclFsm_HmiAvm3::tenHmiVisualisationOffReason) u32Value;
                        }
                     }
                  }
                  break;
//               case EN_CONTROL_HMIAVM3__DIAG_VIDEO_LAYER:
//                  {
//                     if (u32Value == 1)
//                     {
//                        u32FSM_Event = dispvidctrl_tclFsm_HmiAvm3::eTriggerHmiAvm3_VISUALISATION_ON_CAMERA_DIAG;
//                        //Diagnose is activ -> show hard VideoLayer, disable all video signal and video ITC control mechanism
//                        m_bDiagVideoLayer = TRUE;
//                     }
//                     else
//                     {
//                        u32FSM_Event = dispvidctrl_tclFsm_HmiAvm3::eTriggerHmiAvm3_NONE;
//                     }
//                  }
//                  break;
               
               default:
               {
                    bEventProcessed = FALSE;
                    u32FSM_Event = dispvidctrl_tclFsm_HmiAvm3::eTriggerHmiAvm3_NONE;
               }
               break;
            }

            if (bEventProcessed == TRUE) {
               if (m_poFsm_Hmi) {
                  m_poFsm_Hmi->vNewTrigger(u32FSM_Event, TRUE);
               }
            }
         }
      }
      break;

      default:
         break;
   } // switch super state

   ETG_TRACE_USR4(("   CA-HMIAVM3 :: ................... Event Processed: %u     ", ETG_ENUM(DISPVIDCTRL_NoYes, bEventProcessed)));
   ETG_TRACE_USR4(("   CA-HMIAVM3 :: .. FSM Control_Hmi Super State Exit: %u     ", ETG_CENUM(tenFsmControl_HmiAvm3_SuperState, m_enFsmControl_Hmi_SuperState)));
}



/******************************************************************************/
/* FUNCTION     _vSend_SetStatusHmiMResult                                    */
/******************************************************************************/
/**
*  \brief       send system status corresponding to configuration (AVM or RVC)
*
*  \param       tU32 u32Fsm_HmiState
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclControl_HmiAvm3::_vSend_SetStatusHmiMResult(tU32 u32Fsm_HmiState)
{
   rvc_fi_tcl_e8_RVC_SystemStatus e8SystemStatus;

   switch(u32Fsm_HmiState)
   {
      case dispvidctrl_tclFsm_HmiAvm3::eStateHmiAvm3_BLANK_IN_ACTIVE:
         e8SystemStatus.enType = rvc_fi_tcl_e8_RVC_SystemStatus::FI_EN_AVM_VISUALISATION_BLACK_IN;
         break;
      case dispvidctrl_tclFsm_HmiAvm3::eStateHmiAvm3_ON:
         e8SystemStatus.enType = rvc_fi_tcl_e8_RVC_SystemStatus::FI_EN_AVM_VISUALISATION_ON;
         break;
      case dispvidctrl_tclFsm_HmiAvm3::eStateHmiAvm3_BLANK_OUT_ACTIVE:
         e8SystemStatus.enType = rvc_fi_tcl_e8_RVC_SystemStatus::FI_EN_AVM_VISUALISATION_BLACK_OUT;
         break;
      case dispvidctrl_tclFsm_HmiAvm3::eStateHmiAvm3_OFF:
      default:
         e8SystemStatus.enType = rvc_fi_tcl_e8_RVC_SystemStatus::FI_EN_VISUALISATION_OFF;
         break;
   }

   // send MethodResult for SetStatusHmi
   // NCG3D-33462: Do not use the NULL_CHECK macro here, because, during Early Video Service Handler might not be ready to handle this request
   if (m_poRvcServiceIf) {
      m_poRvcServiceIf->sendSetStatusHmiMResult(e8SystemStatus);
   }
}

/******************************************************************************/
/* FUNCTION     _vSetSystemStatus                                             */
/******************************************************************************/
/**
*  \brief       send system status corresponding to configuration (AVM or RVC)
*
*  \param       tenFsmOutEvent_HmiAvm3 enFsmHmiOutEvent
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclControl_HmiAvm3::_vSetSystemStatus(tenFsmOutEvent_HmiAvm3 enFsmHmiOutEvent)
{
   rvc_fi_tcl_e8_RVC_SystemStatus e8SystemStatus;

   switch (enFsmHmiOutEvent)
   {
      case FSM_HMIAVM3_OUT__HMI_VISUALISATION_OFF:
         e8SystemStatus.enType = rvc_fi_tcl_e8_RVC_SystemStatus::FI_EN_VISUALISATION_OFF;
         break;
      case FSM_HMIAVM3_OUT__HMI_VISUALISATION_ON:
         e8SystemStatus.enType = rvc_fi_tcl_e8_RVC_SystemStatus::FI_EN_AVM_VISUALISATION_ON;
         break;
      case FSM_HMIAVM3_OUT__HMI_VISUALISATION_BLACK_IN:
         e8SystemStatus.enType = rvc_fi_tcl_e8_RVC_SystemStatus::FI_EN_AVM_VISUALISATION_BLACK_IN;
         break;
      case FSM_HMIAVM3_OUT__HMI_VISUALISATION_BLACK_OUT:
         e8SystemStatus.enType = rvc_fi_tcl_e8_RVC_SystemStatus::FI_EN_AVM_VISUALISATION_BLACK_OUT;
         break;
         
      case FSM_HMIAVM3_OUT__HMI_VISUALISATION_ON_CAMERA_SETTINGS:
         e8SystemStatus.enType = rvc_fi_tcl_e8_RVC_SystemStatus::FI_EN_AVM_VISUALISATION_ON_CAMERA_SETTINGS;
         break;
      case FSM_HMIAVM3_OUT__HMI_VISUALISATION_BLACK_IN_CAMERA_SETTINGS:
         e8SystemStatus.enType = rvc_fi_tcl_e8_RVC_SystemStatus::FI_EN_VISUALISATION_BLACK_IN_CAMERA_SETTINGS;
         break;
      case FSM_HMIAVM3_OUT__HMI_VISUALISATION_BLACK_OUT_CAMERA_SETTINGS:
         e8SystemStatus.enType = rvc_fi_tcl_e8_RVC_SystemStatus::FI_EN_VISUALISATION_BLACK_OUT_CAMERA_SETTINGS;
         break;
         
      default:
         e8SystemStatus.enType = rvc_fi_tcl_e8_RVC_SystemStatus::FI_EN_VISUALISATION_OFF;
         break;
   }

   // NCG3D-33462: Do not use the NULL_CHECK macro here, because, during Early Video Service Handler might not be ready to handle this request
   if (m_poRvcServiceIf) {
      ETG_TRACE_USR4(("   CA-HMIAVM3 :: _vSetSystemStatus(%u)", ETG_ENUM(DISPVIDCTRL_E8_RVC_SYSTEMSTATUS,e8SystemStatus.enType) ));
      m_poRvcServiceIf->sendSystemStatusStatus(e8SystemStatus);      
   }
}


/******************************************************************************/
/* FUNCTION     _vHandleHMIConfirmationStatus()                               */
/******************************************************************************/
/**
*  \brief       HMI has entered into the SystemStatus as decided by the FSM HMI 
*
*  \param       System Status in which HMI as entered
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclControl_HmiAvm3::_vHandleHMIConfirmationStatus(const tU32 u32Value)
{
   tU32 u32Trigger = dispvidctrl_tclFsm_HmiAvm3::eTriggerHmiAvm3_NONE;

   switch (u32Value)
   {
   case EN_HMIAVM3_CONFIRM_SYSTEMSTATUS__OFF:
     u32Trigger = dispvidctrl_tclFsm_HmiAvm3::eTriggerHmiAvm3_HMI_CONF_OFF;
     break;

   case EN_HMIAVM3_CONFIRM_SYSTEMSTATUS__AVM_BLACK_IN:
   case EN_HMIAVM3_CONFIRM_SYSTEMSTATUS__BLACK_IN_CAM_SETTINGS:
     u32Trigger = dispvidctrl_tclFsm_HmiAvm3::eTriggerHmiAvm3_HMI_CONF_BLANK_IN;
     break;

   case EN_HMIAVM3_CONFIRM_SYSTEMSTATUS__AVM_ON:
     u32Trigger = dispvidctrl_tclFsm_HmiAvm3::eTriggerHmiAvm3_HMI_CONF_ON;
     break;

   case EN_HMIAVM3_CONFIRM_SYSTEMSTATUS__AVM_ON_CAMERA_SETTINGS:
     u32Trigger = dispvidctrl_tclFsm_HmiAvm3::eTriggerHmiAvm3_HMI_CONF_ON_CAM_SETTINGS;
     break;
     
   case EN_HMIAVM3_CONFIRM_SYSTEMSTATUS__AVM__BLACK_OUT:
   case EN_HMIAVM3_CONFIRM_SYSTEMSTATUS__BLACK_OUT_CAM_SETTINGS:
     u32Trigger = dispvidctrl_tclFsm_HmiAvm3::eTriggerHmiAvm3_HMI_CONF_BLANK_OUT;
     break;

   default:
     break;
   }

   if (dispvidctrl_tclFsm_HmiAvm3::eTriggerHmiAvm3_NONE != u32Trigger) {
      DISPVIDCTRL_NULL_POINTER_CHECK(m_poFsm_Hmi);
      m_poFsm_Hmi->vNewTrigger(u32Trigger, TRUE);
   }
}

/******************************************************************************/
/* FUNCTION     vTraceInfo()                                                  */
/******************************************************************************/
/**
*  \brief       trace information
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclControl_HmiAvm3::vTraceInfo()
{
   ETG_TRACE_FATAL(("   CA-HMIAVM3 :: vTraceInfo() *********** CA-HMIAVM3 states ******************************************"));
   ETG_TRACE_FATAL(("   CA-HMIAVM3 :: m_bHmiAppVehicleReady : ................... %-40u", m_bHmiAppVehicleReady));
   ETG_TRACE_FATAL(("   CA-HMIAVM3 :: FSM Control_Hmi : Super State ............. %-40u", ETG_CENUM(tenFsmControl_HmiAvm3_SuperState, m_enFsmControl_Hmi_SuperState)));
   ETG_TRACE_FATAL(("   CA-HMIAVM3 :: *********************************************************************************"));
}
