/******************************************************************************/
/**
* \file    dispvidctrl_tclControl_Avm.h
* \ingroup
*
* \brief
*
* \remark  Copyright : (c) 2015 Robert Bosch GmbH, Hildesheim
* \remark  Author    : Michael Niemann
* \remark  Scope     : AIVI
*
* \todo
*/
/******************************************************************************/
#ifndef _DISPVIDCTRL_TCL_CONTROL_AVM_H_
#define _DISPVIDCTRL_TCL_CONTROL_AVM_H_

/*******************************************************************************
                        Includes
*******************************************************************************/
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "dispvidctrl_AppMain.h"

/*******************************************************************************
                        Defines
*******************************************************************************/
   // enumeration of user action events.
   enum tenControl_Avm
   {
      EN_CONTROL_AVM__NONE  = 0,
      EN_CONTROL_AVM__DISABLE,
      EN_CONTROL_AVM__ENABLE,
      //------------------------------------ direct event(s) to FSM(s), i.e. timeouts
      EN_CONTROL_AVM__FSM_AVM_INPUT_EVENT,
      EN_CONTROL_AVM__FSM_IPASWITCHOPERATION_INPUT_EVENT,

      EN_CONTROL_AVM__TIMEOUT_VIEW_CHANGE_REQUEST_WAIT,
      //------------------------------------ csm Avm callbacks
      EN_CONTROL_AVM__VIEW_CHANGE_REQUEST_CHANGE,
      EN_CONTROL_AVM__NORMAL_BEEP,
      EN_CONTROL_AVM__ERROR_BEEP,
      EN_CONTROL_AVM__AOD_BEEP_1,
      EN_CONTROL_AVM__CAN_MSG_TIMEOUT_FALSE,
      EN_CONTROL_AVM__CAN_MSG_TIMEOUT_TRUE,
      EN_CONTROL_AVM__INIT_CHANGE,
      EN_CONTROL_AVM__AFFORDABLE_ITS,
      //------------------------------------ csm AVM Renault callbacks
      EN_CONTROL_AVM__CURRENT_VIEW_STATUS,
      EN_CONTROL_AVM__VIEW_EXIT_ALLOWED_STATUS,
      EN_CONTROL_AVM__CAN_MSG_TIMEOUT_CONFIRMED,
      //------------------------------------ csm IPA callbacks
      EN_CONTROL_AVM__IPA_CONFIGURATION_CHANGE,
      EN_CONTROL_AVM__IPA_REQUEST_NORMAL,
      EN_CONTROL_AVM__IPA_REQUEST_IPA,
      EN_CONTROL_AVM__IPA_OPERATION_NORMAL,
      EN_CONTROL_AVM__IPA_OPERATION_MALFUNCTION,
      EN_CONTROL_AVM__IPA_SWITCHES_CHANGE,
      EN_CONTROL_AVM__IPA_REQUEST_CHANGE,
      EN_CONTROL_AVM__IPA_MSG_COUNT_ERR,
      EN_CONTROL_AVM__IPA_DIRECTION_CHANGE,
      EN_CONTROL_AVM__IPA_SOUND_OUTPUT_REQUEST,
      EN_CONTROL_AVM__IPA_VOICE_OUTPUT_REQUEST,
      //------------------------------------ csm FAP callbacks
      EN_CONTROL_AVM__FAP_MODE_CHANGE,
      EN_CONTROL_AVM__FAP_PURPOSE_SWITCH_AVAILABLE,
      EN_CONTROL_AVM__FAP_CAMERA_SETTING_AVAILABLE,
      EN_CONTROL_AVM__FAP_SETTING_STATUS,
      EN_CONTROL_AVM__FAP_AVM_SETTING_STATUS,
      EN_CONTROL_AVM__FAP_SOUND_DIRECTION,
      EN_CONTROL_AVM__FAP_SOUND_LEVEL_CONTROL,
      EN_CONTROL_AVM__FAP_SOUND_PATTERN_REQUEST,
      EN_CONTROL_AVM__FAP_VOICE_PATTERN_REQUEST,
      //------------------------------------ csm signals
      EN_CONTROL_AVM__INIT_DONE,
      EN_CONTROL_AVM__INIT_ACTIVE,
      EN_CONTROL_AVM__CAMERA_SCREEN_OFF,
      EN_CONTROL_AVM__CAMERA_SCREEN_ON,
      EN_CONTROL_AVM__CAMERA_SETTINGS_ON,
      EN_CONTROL_AVM__CAMERA_SETTINGS_OFF,
      //------------------------------------ via service from HMI
      EN_CONTROL_AVM__SWITCH_PRESS_MOD,
      EN_CONTROL_AVM__SWITCH_PRESS_LDW,
      EN_CONTROL_AVM__SWITCH_PRESS_BSW,
      EN_CONTROL_AVM__CAMERA_BUTTON_PRESS,
      EN_CONTROL_AVM__CAMERA_BUTTON_RELEASE,
      EN_CONTROL_AVM__CAMERA_BUTTON_LONG_PRESS,
      EN_CONTROL_AVM__PURPOSE_SWITCH,
      EN_CONTROL_AVM__UPDATE_LANGUAGE,
      EN_CONTROL_AVM__SERVICE_REQUEST_VISUALISATION_OFF,
      EN_CONTROL_AVM__SERVICE_REQUEST_VISUALISATION_ON,
      EN_CONTROL_AVM__IPA_ACTIVATION_CHANGE,
      EN_CONTROL_AVM__IPA_BUTTON_CHANGE,
      EN_CONTROL_AVM__IPA_VOICE_TEXTS_UPDATE,
      EN_CONTROL_AVM__VIEW_CHANGE_REQUEST_FROM_HMI,
      EN_CONTROL_AVM__AVM_BEEPS_STATUS_CHANGE,

      //------------------------------------ Inputs from other FSM(s): IPA, HMI
      EN_CONTROL_AVM__VIDEO_SIGNAL_FAILURE,              // HMI
      EN_CONTROL_AVM__VIDEO_SIGNAL_RESTORED,             // HMI
      EN_CONTROL_AVM__VERIFY_AFTER_VIEW_STATUS_STOPPED,  // HMI, todo not used
      EN_CONTROL_AVM__ERROR_CONFIRM_TIMEOUT,             // local timeout for AVM error confirm

      EN_CONTROL_AVM__REVERSE_ON_DEBOUNCED,              // ReverseSignal
      EN_CONTROL_AVM__REVERSE_OFF,                       // ReverseSignal
      EN_CONTROL_AVM__IGNITION,                          // GPIO
      EN_CONTROL_AVM__IGNITION_ON,
      EN_CONTROL_AVM__IGNITION_OFF,
      
      //--------------------------------------- AvmIpa Error Handler
      EN_CONTROL_AVM__ERROR_ACTIVE,
      EN_CONTROL_AVM__ERROR_DEACTIVE,
      EN_CONTROL_AVM__ERROR_HANDLER_ON,
      EN_CONTROL_AVM__ERROR_HANDLER_OFF,

      EN_CONTROL_AVM__TIMEOUT_CAMERA_BUTTON_LONG_PRESS,  // todo unused
      EN_CONTROL_AVM__NORMAL_TO_PAUSE,                   // todo unused
      EN_CONTROL_AVM__PAUSE_TO_NORMAL                    // todo unused
   };

   // FSM output events
   enum tenFsmOutEvent_Avm
   {
      FSM_AVM_OUT__NONE                    = 0,
      FSM_AVM_OUT__FSM_AVM_INPUT_EVENT,

      FSM_AVM_OUT__AVM_UPDATE_AFFORDABLE_ITS,
      FSM_AVM_OUT__AVM_VIEW_CHANGE_REQUEST_CHANGE,

      FSM_AVM_OUT__HMI_VISUALISATION_OFF,
      FSM_AVM_OUT__HMI_VISUALISATION_ON,
      FSM_AVM_OUT__HMI_VISUALISATION_ON_CAMERA_SETTINGS,
      // -----------------------
      FSM_AVM_OUT__INVALIDATE_CSM_RX,
      // ---- AVM related CSM Tx
      FSM_AVM_OUT__CSM_WRITE_INITIALISING_DISPLAY_SWITCH_STATUS,
      FSM_AVM_OUT__CSM_WRITE_CAMERA_SWITCH_KEEP_DISPLAY_SWITCH_STATUS,
      FSM_AVM_OUT__CSM_WRITE_CAMERA_SWITCH_PRESS_DISPLAY_SWITCH_STATUS,
      FSM_AVM_OUT__CSM_WRITE_CAMERA_OFF_REQUEST_DISPLAY_SWITCH_STATUS,

      FSM_AVM_OUT__CSM_WRITE_CLEAR_DISPLAY_REQUESTS,
      // ---- IPA related CSM Tx
      FSM_AVM_OUT__CSM_WRITE_IPA_ACTIVATION_FLAG_STATUS,
      FSM_AVM_OUT__CSM_WRITE_IPA_SETTING_CHANGE_REQUEST_STATUS,

      FSM_AVM_OUT__CSM_REINIT_DISPLAY_SWITCH_STATUS,
      FSM_AVM_OUT__CSM_CHECK_INTIALISING_SIGNAL,

      FSM_AVM_OUT__AUDIO_SEND_ERROR_BEEP,
      FSM_AVM_OUT__AUDIO_SEND_OPERATION_BEEP,

      FSM_AVM_OUT__AVM_UPDATE_IPA_STATUS,

      FSM_AVM_OUT__AVM_FAP_FAIL_SAFE_OPERATON,

      // --- AVM ERROR CONFIRM
      FSM_AVM_OUT__AVM_ERROR_ACTIVE,
      FSM_AVM_OUT__AVM_ERROR_DEACTIVE
   };

   // FSM output events
   enum tenFsmOutEvent_IpaSwitchOperation
   {
      FSM_IPASWITCHOPERATION_OUT__NONE                    = 0,
      FSM_IPASWITCHOPERATION_OUT__FSM_IPASWITCHOPERATION_INPUT_EVENT,

      FSM_AVM_OUT__CSM_WRITE_IPA_SW_LONG_PRESS_STATUS,
      FSM_AVM_OUT__CSM_WRITE_IPA_SW_OPERATION_PRESS_STATUS
   };

   // IPA Sound Requests over CSM
   enum tenCSMInput_IPASoundRequests
   {
      IPA_CSM_SOUND_REQUEST__IPA_NO_SOUND = 0,
      IPA_CSM_SOUND_REQUEST__IPA_DOUBLE_CAUTION = 2,
      IPA_CSM_SOUND_REQUEST__IPA_LONG_SINGLE_CAUTION = 7,
      IPA_CSM_SOUND_REQUEST__IPA_LONG_DOUBLE_CAUTION = 8,
      IPA_CSM_SOUND_REQUEST__IPA_STOP_SOUND = 15
   };

   // IPA Voice Requests over CSM
   enum tenCSMInput_IPAVoiceRequests
   {
      IPA_CSM_VOICE_REQUEST__IPA_NO_VOICE = 0,
      IPA_CSM_VOICE_REQUEST__IPA_START_PARK_ASSIST = 1,
      IPA_CSM_VOICE_REQUEST__IPA_PARK_ASSIST_FINISHED = 4,
      IPA_CSM_VOICE_REQUEST__IPA_PARK_ASSIST_CANCELED = 5,
      IPA_CSM_VOICE_REQUEST__IPA_PARK_ASSIST_COULD_NOT_START = 6,
      IPA_CSM_VOICE_REQUEST__IPA_SELECT_REVERSE_GEAR = 7,
      IPA_CSM_VOICE_REQUEST__IPA_SELECT_DRIVE_GEAR = 8,
      IPA_CSM_VOICE_REQUEST__IPA_DRIVE_FORWARD = 11,
      IPA_CSM_VOICE_REQUEST__IPA_DRIVE_REARWARD = 12,
      IPA_CSM_VOICE_REQUEST__IPA_STOP_VOICE = 15
   };


   enum tenFsmControl_Avm_SuperState
   {
      DISPVIDCTRL_CONTROL_AVM__DISABLED = 0,
      DISPVIDCTRL_CONTROL_AVM__ENABLED
      //todo
      //VD_RVC_SUPERSTATE_AVM__DEACTIVATED    0
      //VD_RVC_SUPERSTATE_AVM__STOPPED        1
      //VD_RVC_SUPERSTATE_AVM__STARTED        2
   };

   enum tenIPAStatus
   {
      DISPVIDCTRL_CONTROL_IPA__NOTAVAILABLE = 0,
      DISPVIDCTRL_CONTROL_IPA__INITIALIZING = 1,
      DISPVIDCTRL_CONTROL_IPA__AVAILABLE = 2,
      DISPVIDCTRL_CONTROL_IPA__ERROR = 3,
      DISPVIDCTRL_CONTROL_IPA_VIDEO_SIGNAL_FAIL = 4
   };
   
   enum tenIPAErrorType
   {
     DISPVIDCTRL_CONTROL_IPA_NO_ERROR = 0,
     DISPVIDCTRL_CONTROL_IPA_VIDEO_SIGNAL = 1, // 0b001
     DISPVIDCTRL_CONTROL_IPA_MALFUNCTION = 2,  // 0b010
     DISPVIDCTRL_CONTROL_IPA_CAN_TIMEOUT = 4   // 0b100
   };

   // FAP Settings
   enum tenCsmFapSettingType
   {
      FAP_SETTING_TYPE__FAP_SETTING_AVAILABLE = 0,
      FAP_SETTING_TYPE__FAP_SETTING01,
      FAP_SETTING_TYPE__FAP_SETTING02,
      FAP_SETTING_TYPE__FAP_SETTING03,
      FAP_SETTING_TYPE__FAP_SETTING04,
      FAP_SETTING_TYPE__FAP_SETTING05,
      FAP_SETTING_TYPE__FAP_SETTING06,
      FAP_SETTING_TYPE__FAP_SETTING07,
      FAP_SETTING_TYPE__FAP_SETTING08,
      FAP_SETTING_TYPE__FAP_SETTING09,
      FAP_SETTING_TYPE__FAP_SETTING10
   };

   enum tenCsmFapAvmSettingType
   {
      FAP_SETTING_TYPE__AVM_SETTING_AVAILABLE = 0,
      FAP_SETTING_TYPE__AVM_SETTING01,
      FAP_SETTING_TYPE__AVM_SETTING02,
      FAP_SETTING_TYPE__AVM_SETTING03,
      FAP_SETTING_TYPE__AVM_SETTING04,
      FAP_SETTING_TYPE__AVM_SETTING05,
      FAP_SETTING_TYPE__AVM_SETTING06,
      FAP_SETTING_TYPE__AVM_SETTING07,
      FAP_SETTING_TYPE__AVM_SETTING08,
      FAP_SETTING_TYPE__AVM_SETTING09
   };
   enum tenCsmInput_FapSettingType
   {
	   FAP_CSMINPUT_SETTING_TYPE__VOICE_GUIDANCE = 30,
	   FAP_CSMINPUT_SETTING_TYPE__AUTO_SELECTION = 31,
	   FAP_CSMINPUT_SETTING_TYPE__BAYPARKING = 32,
	   FAP_CSMINPUT_SETTING_TYPE__SLOTPARKING = 33,
	   FAP_CSMINPUT_SETTING_TYPE__FORWARDPARKING = 34,
	   FAP_CSMINPUT_SETTING_TYPE__ANGLE_BACKWARD_PARKING = 35,
	   FAP_CSMINPUT_SETTING_TYPE__ANGLE_FORWARD_PARKING = 36,
	   FAP_CSMINPUT_SETTING_TYPE__PREVIOUS_PARKING_TYPE = 37,
	   FAP_CSMINPUT_SETTING_TYPE__LEFT_RIGHT_PARKING_TYPE = 38,


   };
   typedef struct
   {
      tU8 u8HmiLanguageCode;
      tU8 u8AvmLanguageCode;
   }StLanguageMappingEntryAvm;

   typedef struct
   {
	   tU8 u8FAPKeyCode;
      tU8 u8IPAKeyID;
   }StCSMFapInputKeyCode;

class dispvidctrl_tclFsm_Avm;
class dispvidctrl_tclControl_Rvc;
class Idispvidctrl_tclClientAudioIf;
class I_dispvidctrl_tclClientVcan;
class Idispvidctrl_tclServiceRvcIf;
class dispvidctrl_tclAudio_Routing;
class sds_fi_tclString;
class rvc_fi_tcl_IPA_Voice_Text_Strings;
class dispvidctrl_tclFsm_IpaSwitchOperation;

/*******************************************************************************
   Class
*******************************************************************************/
class dispvidctrl_tclControl_Avm : public dispvidctrl_tclBaseIf
{
   public:

      dispvidctrl_tclControl_Avm(dispvidctrl_tclAppMain* poMainAppl);
      dispvidctrl_tclControl_Avm(); // default constructor
      virtual ~dispvidctrl_tclControl_Avm();

   private:
      // declare (but hide and don't implement, i.e. effectively disable) copy contructor and assignment operator to make Coverity happy
      dispvidctrl_tclControl_Avm(const dispvidctrl_tclControl_Avm&);
      dispvidctrl_tclControl_Avm& operator=(const dispvidctrl_tclControl_Avm&);
   public:

      virtual const tChar* getName() const { return ""; };
      virtual const tChar* getIfName() const { return "dispvidctrl_tclControl_Avm"; };

      virtual tVoid vHandleMessage(dispvidctrl_tclBaseIf::TMsg* pMsg);
      virtual tVoid vHandleTraceMessage(const tUChar* puchData);
      virtual tVoid vGetReferences();
      virtual tVoid vStartCommunication();
      virtual tVoid vTraceInfo();
      virtual tVoid vGetConfiguration(const TConfiguration* pStConfigurationValues);

      tVoid vHandleControl(tenControl_Avm enControl, tU32 u32Value = 0);

      tVoid vHandleFsmOutEvent_IpaSwitchOperation(tenFsmOutEvent_IpaSwitchOperation enFsmOutEvent_IpaSwitchoperation, tU32 u32Value = 0);

      tBool bRequestForAudioChannel(tBool bRequest);
      tVoid vHandleAudioChannelStateChange(tU8 u8NewState);

      tVoid vHandleFsmOutEvent_Avm(tenFsmOutEvent_Avm enFsmOutEvent_Avm, tU32 u32Value = 0);
      tVoid vUpdateAffordableIts(tBool bSetToUnknown = FALSE);
      tBool bOnUpdate_Language(tU32 u32NewLanguage);

      tBool bIsAvmGraphicsOn();
      tVoid vRequestAudioRoute();

private:
      tVoid _vOnEvent_FsmControl_Avm(tenControl_Avm enControl, tU32 u32Value = 0);
      tBool _bReinitCsmMessage_DisplaySwitchStatus(tVoid);
      tVoid _vUpdate_AVM_CurrentViewStatus(const tU8 u8CurrentView);
      tVoid _vUpdate_AVM_ExitViewStatus(const tU8 u8ExitAllowed);
      tVoid _vUpdateCANFrameStatus(const tU32 u32FrameState);

      tVoid _vUpdateFapSetting(const tenCsmFapSettingType FapSettingType) const;
      tVoid _vUpdateAvmSetting(const tenCsmFapAvmSettingType AvmSettingType) const;
      tVoid _vUpdateFapAvmSettings(const tenCsmFapSettingType FapSettingType, const tenCsmFapAvmSettingType AvmSettingType) const;
      tVoid _vUpdateFapAvmSettings(tVoid) const;
      tVoid _vUpdateFapSettingkey(tU32 u32Value);

      tVoid _vUpdate_IPAConfiguration(tVoid);
      tVoid _vUpdate_IPAStatus(tVoid);
      tVoid _vUpdate_IPASwitches(tVoid);
      tVoid _vUpdate_IPARequests(tVoid);
      tVoid _vUpdate_IPADirectionIndicator(tVoid);
      tVoid _vHandleIPAButtonChange(tU32 u32Value);

      tVoid _vHandleIpa_Voice_Request_Texts(tVoid);
      tVoid _vHandleIPA_VoiceOutputRequest(const tU32 u32Request);
      tVoid _vHandleIPA_AudioBeepRequest(const tU32 u32Request);
      
      // For IPA (Nissan only) a special screen is shown for 5s after detecting 
      // (Video Signal Failure "OR" 0x5C2 CAN Timeout "OR" IPA Malfunction CAN Bit)      
      // Issue valid also for Renault Entry AVM
      static OSAL_tpfCallback _pfCallbackTimer_AvmErrorConfirm(tVoid* pArg);
      tBool  _bSetTimer_AvmErrorConfirm(OSAL_tMSecond msTimeout);

      OSAL_tTimerHandle  m_hTimerHandle_AvmErrorConfirm;
      
      dispvidctrl_tclFsm_IpaSwitchOperation*  m_poFsm_IpaSwitchOperation;

      std::vector<rvc_fi_tcl_IPA_Voice_Text_Strings> tIPA_Voice_Texts;

      dispvidctrl_tclFsm_Avm*             m_poFsm_Avm;
      Idispvidctrl_tclClientAudioIf*      m_poClientAudioIf;
      I_dispvidctrl_tclClientVcan*        m_poClientVcan;
      dispvidctrl_tclControl_Rvc*         m_poControlRvc;
      Idispvidctrl_tclServiceRvcIf*       m_poServiceRvcIf;
      dispvidctrl_tclAudio_Routing*       m_poAudioRouting;

      tenFsmControl_Avm_SuperState  m_enFsmControl_Avm_SuperState;
      tenIPAStatus   m_u8IPAStatus;

      tBool m_bAvmMode;
      tBool m_bAvmTypeIpa;
      tBool m_bAvmTypeRenault;
      tBool m_bAvmTypeFap;
      tBool m_bDaVariant; // Non-navi variant

      tBool m_bFapModeActive;
      tBool m_bFapPurposeSwitchAvailable;

      tBool m_bAvmRGraphicsOn;

      tBool m_bAccState;
      tBool m_bIgnition;
      tBool m_bIgnitionStateValid;
      tBool m_bCanMsgTimeOutState;
      tBool m_bReverseGearState;
      tU32  m_u32HmiLanguage;
      tU8   m_u8AvmLanguage;
      tU8   m_u8VCANDiversity;

      tBool m_bAudioBeepsMuted;
      tBool m_bAudioChannelAvailable;
      
      tU8   m_u8FAPKeyCode;
      tBool m_bAvmFapSourceAvailable;
      
      tU8   m_u8IpaErrorCode;
      tBool m_bTimerErrorConfirmRunning;
      tBool m_bIpaErrorHandlerON;
};
#endif

