/******************************************************************************/
/**
* \file    dispvidctrl_tclClient_DevVideo.h
* \ingroup
*
* \brief
*
* \remark  Copyright : (c) 2015 Robert Bosch GmbH, Hildesheim
* \remark  Author    : Michael Niemann
* \remark  Scope     : AIVI
*
* \todo
*/
/******************************************************************************/
#ifndef _DISPVIDCTRL_TCL_CLIENT_DEV_VIDEO_H_
#define _DISPVIDCTRL_TCL_CLIENT_DEV_VIDEO_H_

/*******************************************************************************
                        Includes
*******************************************************************************/
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "dispvidctrl_AppMain.h"
#include "I_dispvidctrl_tclVideoPlayer.h"

/*******************************************************************************
                        Defines
*******************************************************************************/
class I_dispvidctrl_tclVideoPlayer;

/*******************************************************************************
   Class
*******************************************************************************/
class dispvidctrl_tclClient_DevVideo : public dispvidctrl_tclBaseIf
{
   public:

      dispvidctrl_tclClient_DevVideo(const dispvidctrl_tclAppMain* poMainAppl);
      virtual ~dispvidctrl_tclClient_DevVideo();

   private:
      // declare (but hide and don't implement, i.e. effectively disable) copy contructor and assignment operator to make Coverity happy
      dispvidctrl_tclClient_DevVideo(const dispvidctrl_tclClient_DevVideo&);
      dispvidctrl_tclClient_DevVideo& operator=(const dispvidctrl_tclClient_DevVideo&);
   public:
    
      virtual const tChar* getName() const { return ""; };
      virtual const tChar* getIfName() const { return "dispvidctrl_tclClient_DevVideo"; };

      virtual tVoid vHandleMessage(dispvidctrl_tclBaseIf::TMsg* pMsg);
      virtual tVoid vHandleTraceMessage(const tUChar* puchData);
      virtual tVoid vGetReferences();
      virtual tVoid vStartCommunication();
      virtual tVoid vTraceInfo();
      virtual tVoid vGetConfiguration(const TConfiguration* pStConfigurationValues);

      // set functions
      tVoid vSet_BlackLevel(tU8 u8Value);
      tVoid vSet_Brightness(tU8 u8Value);
      tVoid vSet_Colour(tU8 u8Value) const;
      tVoid vSet_Contrast(tU8 u8Value) const;
      tVoid vSet_Hue(tU8 u8Value) const;
      // set functions for ADAPTIVE CONTRAST ENHANCEMENT (ACE)
      tVoid vSet_AceEnable(tBool bEnable) const;
      tVoid vSet_AceLumeGain(tU8 u8Value) const;
      tVoid vSet_AceResponseSpeed(tU8 u8Value) const;
      tVoid vSet_AceChromaGain(tU8 u8Value) const;
      tVoid vSet_AceChromeMax(tU8 u8Value) const;
      tVoid vSet_AceGammaGain(tU8 u8Value) const;
      
      tVoid vOpenDevVideo(tVoid);
      tVoid vCloseDevVideo(tVoid);

   private:

      tBool _bFindDevVideo(tVoid);
      tBool _bReadDevVideo(const tU32 u32Control, tS32& s32ControlData) const;
      tBool _bWriteDevVideo(const tU32 u32Control, tS32 s32ControlData) const;

      tS32  m_fd_DevVideo;
      char* m_pocdevVideo_In;
      tU8   m_Config_u8CameraConnectionType;

      tU16 _u16Brightness;
      tU16 _u16BlackLevel;

      I_dispvidctrl_tclVideoPlayer* m_poClient_VideoPlayer;
};

#endif

