/*
 * Copyright (C) Robert Bosch Car Multimedia GmbH, 2020
 * This software is property of Robert Bosch GmbH. Unauthorized
 * duplication and disclosure to third parties is prohibited.
 *
 * @file               : dispvidctrl_Parser.h
 * @brief	       :  dispvidctrl_tclControl_Rvc
 * @detail             :
 * @author             : Sathiya
 * @Date               : 27.10.2021
 * Revision History    : 1.0
 */

#include "dispvidctrl_Parser.h"
#include <iostream>
#include <bits/stdc++.h>
#include <string>
using namespace std;

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_DISPVIDCTRL_APPLICATION
#include "trcGenProj/Header/dispvidctrl_Parser.cpp.trc.h"
#endif

#define ROOT_TAG "avdecc_routing_adapter"
#define ENT_CONF_TAG "avdecc_entity_cfg"
#define ENT_TAG  "tENTITY"
#define ATTR_NAME "name"
#define ATTR_MATCH 0
#define ENT_NAME_CMP "CMP"
#define SRC_TAG "tSOURCE"
#define ATTR_SRCNAM "srcNam"
#define CAMTEXTID "camTextID"
#define rvcCam "CMP1_CAM1"
#define rvcConfig 35

DispvidctrlParser*  DispvidctrlParser::m_pInstance = OSAL_NULL;

tCString  XML_PATH = "/usr/lib/avdecc/plugins/AVRoutingAdapter.xml";

/*******************************************************************************
* FUNCTION   : dispvidctrlParser Constructor
* DESCRIPTION:
* PARAMETER  :Void
* RETURNVALUE: Void
*******************************************************************************/
DispvidctrlParser::DispvidctrlParser()
{
	m_caminfo.clear();
	_avRoutingParser = tclAvRoutingParser::pGetInstance();
	if(_avRoutingParser != NULL)
	{
	   bool m_bParseState = _avRoutingParser->bParseXml();
	   if(m_bParseState == true)
	   {
	         ETG_TRACE_USR4(("Dispvidctrl Parse state is true"));
		 dispvidctrl_tclAppMain::vWriteStartupLog("Parser state is true");
                 readCameraConfig();
	   }
	   else
	   {  
	         ETG_TRACE_USR4(("Dispvidctrl Parse state is false"));
		 dispvidctrl_tclAppMain::vWriteStartupLog("Parser state is false");
	   }
	}

}

/*******************************************************************************
* FUNCTION   : dispvidctrlParser pGetInstance
* DESCRIPTION:
* PARAMETER  :Void
* RETURNVALUE: DispvidctrlParer*
*******************************************************************************/
DispvidctrlParser* DispvidctrlParser::pGetInstance()
{
	if(m_pInstance == OSAL_NULL)
	{
		m_pInstance = new DispvidctrlParser();
                if(m_pInstance)
                {
	        	ETG_TRACE_USR4(("Dispvidctrl Parser Instance created"));
			dispvidctrl_tclAppMain::vWriteStartupLog("Parser Instance created");
                }
	}
	return m_pInstance;
}
/*******************************************************************************
* FUNCTION   : dispvidctrlParser Destructor
* DESCRIPTION:
* PARAMETER  :Void
* RETURNVALUE: Void
*******************************************************************************/
DispvidctrlParser::~DispvidctrlParser()
{
	delete _avRoutingParser;
	_avRoutingParser = OSAL_NULL;
}

/*******************************************************************************
* FUNCTION   : dispvidctrlParser bParseXml
* DESCRIPTION:
* PARAMETER  :Void
* RETURNVALUE: Bool
*******************************************************************************/
void DispvidctrlParser::readCameraConfig()
{
  if(_avRoutingParser != NULL)
  {
     dispvidctrl_tclAppMain::vWriteStartupLog("Read Camera config");
     m_caminfo = _avRoutingParser->vecGetCamSrc();
     if(m_caminfo.size() > 0)
     {
        for(tU8 u8Index= 0 ; u8Index < m_caminfo.size();u8Index++ )
	{
            if((ATTR_MATCH == strcmp(rvcCam,m_caminfo[u8Index].srcNam.c_str())) && (m_caminfo[u8Index].camtextid == rvcConfig))
	    {
	       dispvidctrl_tclAppMain::vWriteStartupLog("Reverse is configured in Container");
               ETG_TRACE_USR4(("DispvidctrlParser: Reverse is configured in Container"));
	       dispvidctrl_tclAppMain::theServer()->SetAvroutingRvcConfiguration(true);
               dispvidctrl_tclAppMain::theServer()->checkAndSetReverseConfiguration();
                 break;
	    }
	}
     }
   }
}
/*******************************************************************************
* FUNCTION   : dispvidctrlParser vDeleteInstance
* DESCRIPTION:
* PARAMETER  :Void
* RETURNVALUE: Void
*******************************************************************************/
void DispvidctrlParser::vDeleteInstance()
{
 if(m_pInstance != OSAL_NULL)
 {
	 delete m_pInstance;
	 m_pInstance = OSAL_NULL;
 } 
}
