/*
 * dispvidctrl_tclEventObserver.h
 *
 *  Created on: Aug 25, 2015
 *      Author: sgt4kor
 */

#ifndef EVKEYOBSERVER_H_
#define EVKEYOBSERVER_H_

#include "dispvidctrl_AppMain.h"
#include "dispvidctrl_ThreadHandler.h"
#include "dispvidctrl_TouchDataHandler.h"

#define MAX_INPUT_DEVICES 14

class EpollInput;

class dispvidctrl_tclEventObserver : public dispvidctrl_tclBaseIf
{
public:    
    //Constructor
    dispvidctrl_tclEventObserver(dispvidctrl_tclAppMain* poMainAppl);    
    virtual ~dispvidctrl_tclEventObserver();
    
    virtual const tChar* getName() const { return "dispvidctrl_tclEventObserver"; };
    virtual const tChar* getIfName() const { return "dispvidctrl_tclEventObserver"; };
    
    virtual tVoid vHandleMessage(dispvidctrl_tclBaseIf::TMsg* pMsg);
    virtual tVoid vHandleTraceMessage(const tUChar* puchData);
    virtual tVoid vGetReferences();
    virtual tVoid vStartCommunication();
    virtual tVoid vTraceInfo();
    
    virtual tVoid vStartCommunicationEarly();
    virtual tVoid vGetReferencesEarly();
    virtual tVoid vGetConfiguration(const TConfiguration* pStConfigurationValues);
    
    tS32 startObserver();
    tVoid stopObserver();
    
    inline tBool isObsRunning() { return bIsObserverActive; }
    
    tVoid startJammingCheckThread();
    tBool StartStopRecording(tU8 u8StartStop);

    tVoid lockTouchList();
    tVoid unlockTouchList();
    
    //Thread common callback function for All key Events
    static tVoid* EvObserverCallback(tVoid* pData);
    static tVoid* TouchJammingCallback(tVoid*);
    
    //Set of Methods to be used by CCA Service Class to provide Ev Info to Client Diagnostics
    Touchlist* getTouchInfoList();
    tVoid getTouchEvInfo(tS32* X, tS32* Y, tS32* Status);

private:
    //Member Variables
    tS8 _s8ActivityCounter;
    tS32 _s32EventTypeHistory;
    tU8 _u8StartStopRecording;
    
    static dispvidctrl_tclEventObserver* m_poEventObserver;

    static tBool bIsJammingCheckActive;
    static tBool bIsObserverActive;

    static dispvidctrl_tclTouchDataHandler* m_poTouchDataHandler;  //For Handling and storing Touch Data
    static EpollInput* m_poEpollInput;

    //Alok
    //TouchDataHandler _tEvTouchJamDataHandler;
    ThreadHandler _oThreadHandler;
    //Alok
    //ThreadHandler _oJammingHandler;
    //Alok

    std::vector<std::string> m_stlAllDevNameList;
    std::vector<int> m_FileDescList;
    
    tVoid updateDeviceActivityCounter();
    
    //Private Member Functions
    tS32 createDevFileList();
    tS32 addDevicesToMonitor();
    tVoid removeDevicesToMonitor();
    tVoid HandleInputEvent(struct input_event Event);
    //CSM_C_ASIG_TX_MMCustomerAction
    tVoid sendDeviceActivity();
};

#endif /* EVKEYOBSERVER_H_ */
