/*
 * dispvidctrl_tcldispvidctrl_EventObserver.cpp
 *
 *  Created on: Aug 25, 2015
 *      Author: sgt4kor
 */

#include <stdio.h>
#include <stdint.h>
#include <string.h>
#include <stdlib.h>
#include <fcntl.h>
#include <unistd.h>
#include <linux/input.h>
#include <dirent.h>
#include <pthread.h>
#include <errno.h>

#include "dispvidctrl_EventObserver.h"
#include "dispvidctrl_EpollInput.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_DISPVIDCTRL_APPLICATION_INPUT
#include "trcGenProj/Header/dispvidctrl_EventObserver.cpp.trc.h"
#endif

#define DEV_INPUT_EVENT "/dev/input"
#define EVENT_DEV_NAME "event"
#define MAX_EVENTS  (sizeof(struct input_event)*3)
#define TIME_OUT    (tS32) (7000) //milliseconds


tBool dispvidctrl_tclEventObserver::bIsJammingCheckActive = FALSE;
tBool dispvidctrl_tclEventObserver::bIsObserverActive = FALSE;

dispvidctrl_tclEventObserver*    dispvidctrl_tclEventObserver::m_poEventObserver = NULL;
EpollInput*                      dispvidctrl_tclEventObserver::m_poEpollInput = NULL;
dispvidctrl_tclTouchDataHandler* dispvidctrl_tclEventObserver::m_poTouchDataHandler = NULL;



// function called by scandir to allow only files with "EVENT_DEV_NAME" to pass
static int is_event_device(const struct dirent *dir) {
    return strncmp(EVENT_DEV_NAME, dir->d_name, 5) == 0;
}

dispvidctrl_tclEventObserver::dispvidctrl_tclEventObserver(dispvidctrl_tclAppMain* poMainAppl)
: dispvidctrl_tclBaseIf(poMainAppl)
, _s8ActivityCounter(-1)
, _s32EventTypeHistory(0)
, _u8StartStopRecording(0)
{
   dispvidctrl_tclEventObserver::m_poEventObserver = this;
   dispvidctrl_tclEventObserver::m_poEpollInput = EpollInput::createInstance();
   
   m_stlAllDevNameList.clear();
   m_stlAllDevNameList.reserve(MAX_INPUT_DEVICES);

   m_FileDescList.clear();
   m_FileDescList.reserve(MAX_INPUT_DEVICES);
   
   ETG_TRACE_FATAL(("dispvidctrl_tclEventObserver::dispvidctrl_tclEventObserver() Initialized"));
}

dispvidctrl_tclEventObserver::~dispvidctrl_tclEventObserver()
{
   ETG_TRACE_FATAL(("dispvidctrl_tclEventObserver::~dispvidctrl_tclEventObserver()-> No of THREADS to KILL = %d", m_stlAllDevNameList.size()));

   removeDevicesToMonitor();
   
   dispvidctrl_tclEventObserver::m_poEventObserver = NULL;
   EpollInput::deleteInstance();
   dispvidctrl_tclEventObserver::m_poEpollInput = NULL;

   dispvidctrl_tclEventObserver::bIsObserverActive = FALSE;

   _oThreadHandler.waitObserverThreadEnd();
   _oThreadHandler.exitMainThread();

   //Alok
   dispvidctrl_tclEventObserver::bIsJammingCheckActive = FALSE;
   //Alok
}

/******************************************************************************/
/* FUNCTION     vGetReferences                                                */
/******************************************************************************/
/**
*  \brief       Function to get all reference needed by this class.
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclEventObserver::vGetReferences(tVoid)
{
   ETG_TRACE_FATAL(("[%d ms] dispvidctrl_tclInputEventObserver::vGetReferences() entered.", OSAL_ClockGetElapsedTime()));
   
   m_poTouchDataHandler = dynamic_cast<dispvidctrl_tclTouchDataHandler*>(_cpoMain->getHandler("dispvidctrl_tclTouchDataHandler"));
   DISPVIDCTRL_NULL_POINTER_CHECK(m_poTouchDataHandler);
}

/******************************************************************************/
/* FUNCTION     vStartCommunication                                           */
/******************************************************************************/
/**
*  \brief       Function to start all dynamic objects e.g. threads, ...
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclEventObserver::vStartCommunication(tVoid)
{
   ETG_TRACE_FATAL(("[%d ms] dispvidctrl_tclEventObserver::vStartCommunication() entered.", OSAL_ClockGetElapsedTime()));
}

/******************************************************************************/
/* FUNCTION     vGetReferences                                                */
/******************************************************************************/
/**
*  \brief       Function to get all reference needed by this class.
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclEventObserver::vGetReferencesEarly(tVoid)
{
   ETG_TRACE_FATAL(("[%d ms] dispvidctrl_tclEventObserver::vGetReferencesEarly() entered.", OSAL_ClockGetElapsedTime()));
}

/******************************************************************************/
/* FUNCTION     vStartCommunication                                           */
/******************************************************************************/
/**
*  \brief       Function to start all dynamic objects e.g. threads, ...
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclEventObserver::vStartCommunicationEarly(tVoid)
{
   ETG_TRACE_FATAL(("[%d ms] dispvidctrl_tclEventObserver::vStartCommunicationEarly() entered.", OSAL_ClockGetElapsedTime()));
}

/******************************************************************************/
/* FUNCTION     vHandleMessage(TMsg* pMsg)                                    */
/******************************************************************************/
/**
*  \brief       Handle worker events.
*
*  \param       message pointer
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclEventObserver::vHandleMessage(dispvidctrl_tclBaseIf::TMsg* pMsg)
{
   ETG_TRACE_FATAL(("[%d ms] dispvidctrl_tclEventObserver::vHandleMessage() entered %u -> data: %d.", \
                     OSAL_ClockGetElapsedTime(), ETG_CENUM(dispvidctrl_tclBaseIf::ECmdTypes , (tU32)pMsg->eCmd), pMsg->u.u32Data));

   switch (pMsg->eCmd)
   {
      default:
         break;
   }   
}

/******************************************************************************/
/* FUNCTION     vHandleTraceMessage                                           */
/******************************************************************************/
/**
*  \brief       handle TTFis commands
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclEventObserver::vHandleTraceMessage(const tUChar* puchData)
{
   DISPVIDCTRL_NULL_POINTER_CHECK(puchData);
   
   tU32 u32MsgCode = ((puchData[1]<<8) | puchData[2]);
   vTraceInfo();
}

/******************************************************************************/
/* FUNCTION     vTraceInfo()                                                  */
/******************************************************************************/
/**
*  \brief       trace information
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclEventObserver::vTraceInfo()
{
   ETG_TRACE_USR4(("dispvidctrl_tclEventObserver::vTraceInfo() entered."));
   ETG_TRACE_USR4(("dispvidctrl_tclEventObserver::bIsObserverActive.............. %d", dispvidctrl_tclEventObserver::bIsObserverActive));
}

/******************************************************************************/
/* FUNCTION     vGetConfiguration()                                           */
/******************************************************************************/
/**
*  \brief       trace information
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclEventObserver::vGetConfiguration(const TConfiguration* pStConfigurationValues)
{
   ETG_TRACE_USR4(("dispvidctrl_tclEventObserver::vGetConfiguration() entered."));
}


//Alok
tVoid dispvidctrl_tclEventObserver::startJammingCheckThread()
{
   //int status = -1;
   //bIsJammingCheckActive = TRUE;
   //status = _oJammingHandler.createObserverThread( &(dispvidctrl_tclEventObserver::TouchJammingCallback), reinterpret_cast<tVoid*>(this) );
   //if(status == -1)
   //{
   //   ETG_TRACE_FATAL(("dispvidctrl_tclEventObserver::startJammingCheck()createJammingCheckThread FAILED"));
   //}
   //else
   //{
   //   ETG_TRACE_FATAL(("dispvidctrl_tclEventObserver::startJammingThreadCheck()createJammingCheckThread SUCCESS!...."));
   //   ETG_TRACE_FATAL(("dispvidctrl_tclEventObserver::startJammingThreadCheck() THREAD_ID = %d",_oJammingHandler.ObserverThread));
   //}
}

tVoid* dispvidctrl_tclEventObserver::TouchJammingCallback(tVoid* pData)
{
   Touchlist* _tTouchlist = NULL;
   ETG_TRACE_FATAL((": TouchJammingCallback: ------------------------------->Enter"));
   while(TRUE == dispvidctrl_tclEventObserver::bIsJammingCheckActive)
   {
       sleep(15);
      _tTouchlist = dispvidctrl_tclEventObserver::m_poEventObserver->getTouchInfoList();

      if (TRUE == _tTouchlist->empty()) //If List is Empty
      {
         ETG_TRACE_FATAL((":TouchJammingCallback()-> Touch List is empty-> Waiting to capture Touch Events !!"))
      }
      //End of If

   }//End of While loop Thread
   return (tVoid*)(NULL);
}
//Alok
//*********************************************************************************************************************************
//    Public Methods
//*********************************************************************************************************************************

tS32 dispvidctrl_tclEventObserver::startObserver()
{
   int status = -1;

   if ( FALSE == dispvidctrl_tclEventObserver::bIsObserverActive )
   {
      dispvidctrl_tclEventObserver::bIsObserverActive = TRUE;
      
      // Add Devices to be Monitored
      if ( 0 == addDevicesToMonitor() )
      {
         ETG_TRACE_FATAL(("dispvidctrl_tclEventObserver::startObserver() addDevicesToMonitor FAILED"));
         return status;
      }

      //Now Create Observer Thread to Monitor the Devices
      status = _oThreadHandler.createObserverThread(&(dispvidctrl_tclEventObserver::EvObserverCallback), NULL);
      if(status == -1)
      {
         ETG_TRACE_FATAL(("dispvidctrl_tclEventObserver::startObserver() createObserverThread FAILED"));
      }
      else
      {
         ETG_TRACE_FATAL(("dispvidctrl_tclEventObserver::startObserver() createObserverThread SUCCESS!.. Devices[%d]", m_FileDescList.size()));
         ETG_TRACE_FATAL(("dispvidctrl_tclEventObserver::startObserver() THREAD_ID = %d",_oThreadHandler.ObserverThread));
      }
   }
   else
   {
      ETG_TRACE_FATAL(("dispvidctrl_tclEventObserver::startObserver()->Already Started"));
   }

   return status;
}

tVoid dispvidctrl_tclEventObserver::stopObserver()
{
   if( TRUE == dispvidctrl_tclEventObserver::bIsObserverActive )
   {
      dispvidctrl_tclEventObserver::bIsObserverActive = FALSE;
      
      removeDevicesToMonitor();
      ETG_TRACE_FATAL(("dispvidctrl_tclEventObserver::stopObserver()->Observer Thread is Ended"));
   }
}

Touchlist* dispvidctrl_tclEventObserver::getTouchInfoList()
{
   if (m_poTouchDataHandler)
   {
      return(m_poTouchDataHandler->getUpdatedTouchList());
   }
   else 
   {
      return 0;
   }
}

tBool dispvidctrl_tclEventObserver::StartStopRecording(tU8 u8StartStop)
{
   tBool bSuccess= FALSE;
   if(   dispvidctrl_tclEventObserver::bIsObserverActive == TRUE){
      _u8StartStopRecording = u8StartStop;
      bSuccess = TRUE;
   }
   else
   {
      _u8StartStopRecording = 0;
   }
   return bSuccess;
}

tVoid dispvidctrl_tclEventObserver::lockTouchList() 
{ 
   if (m_poTouchDataHandler) 
      m_poTouchDataHandler->lockTouchList(); 
}

tVoid dispvidctrl_tclEventObserver::unlockTouchList() 
{ 
   if (m_poTouchDataHandler) 
      m_poTouchDataHandler->unlockTouchList(); 
}

//**********************************************************************************************************************************
// EvObserver Thread Call Back Static Function
//**********************************************************************************************************************************

tVoid* dispvidctrl_tclEventObserver::EvObserverCallback(tVoid* pData)
{
   ETG_TRACE_USR4(("dispvidctrl_tclEventObserver::EvObserverCallback Observer Thread entered"));
   struct input_event EvData;
   memset(&EvData, 0, sizeof(struct input_event));
   struct epoll_event EpollEvent[MAX_EVENTS];
   memset(EpollEvent, 0, sizeof(EpollEvent));
   int ready = 0;
   tSize rstatus = 0;
   (tVoid) pData;

   if (m_poEventObserver && m_poEventObserver->m_poEpollInput)
   {   
      while (dispvidctrl_tclEventObserver::bIsObserverActive == TRUE)
      {
         // Wait for input to become ready or until the time out; the first parameter is
         // Buffer of EpollData where Event Data will come from File Descriptor in Sets being monitored
         ready = m_poEventObserver->m_poEpollInput->waitForEvent(EpollEvent, TIME_OUT, MAX_EVENTS);
         //ETG_TRACE_FATAL(("dispvidctrl_tclEventObserver::EvObserverCallback: waitForEvent No of Events = %d", ready));
         if((ready == -1)/*Indicates Epoll Error*/ || (ready == 0)/*Indicates Timeout*/)
         {
            ETG_TRACE_FATAL(("dispvidctrl_tclEventObserver::Error occured in Epoll or Timeout happened"));
            //Check if observer is stopped by user then break else continue
            if(dispvidctrl_tclEventObserver::bIsObserverActive == FALSE)
            {  //This shall help exit thread gracefully after any epoll error or timeout
               break;   //Exit the thread loop if Observer is Stopped
            }
         }
         else
         {
            for (int i=0; i<ready; i++)
            {               
               // If No epoll Error then read the next event fd
               int fd = EpollEvent[i].data.fd;
               // Read the FD
               rstatus = (tSize)read(fd, &EvData, sizeof(struct input_event));
               
               if ( (EpollEvent[i].events & EPOLLERR)||(EpollEvent[i].events & EPOLLHUP)||(!(EpollEvent[i].events & EPOLLIN)) )
               {
                  ETG_TRACE_USR4(("dispvidctrl_tclEventObserver::EvObserverCallback()-> EpollError Continue"));
                  continue;
               }
               
               if (errno != EAGAIN)
               {  
                  // If Data is available for read then handle it/store it in file or variables
                  if (rstatus >= sizeof(struct input_event))
                  {
                     m_poEventObserver->HandleInputEvent(EvData);
                  }
               }
               else
               {
                  ETG_TRACE_FATAL(("dispvidctrl_tclEventObserver::EvObserverCallback()->Error EAGAIN occured in read"));
               }
            }
         }
      }
   }
   //Exit The Loop of thread
   ETG_TRACE_USR4(("dispvidctrl_tclEventObserver::EvObserverCallback()->Exitting Pthread for Observer"));
   return (tVoid*)(NULL); //to solve Lint warning
}

//*******************************************************************************************************************************
// Private Functions
//*******************************************************************************************************************************

tS32 dispvidctrl_tclEventObserver::createDevFileList()
{
   struct dirent** namelist;
   int ndev;
   // get list of files in dir DEV_INPUT_EVENT. Only event files will pass (see is_event_device filter)
   ndev = scandir(DEV_INPUT_EVENT, &namelist, is_event_device, versionsort);
   if (ndev <= 0) {
      return 0;
   }
   
   // Now parse the list and store filenames in Vector
   for (int i = 0; i < ndev; i++)
   {
      // iterating above all event device files
      char fname[64];
      // create file name from dir and found file
      snprintf(fname, sizeof(fname), "%s/%s", DEV_INPUT_EVENT, namelist[i]->d_name);
      //Store file name /dev/input/eventX name in vector X is no of device
      m_stlAllDevNameList.push_back(fname);
      free(namelist[i]);
   }

   return m_stlAllDevNameList.size();
}

tS32 dispvidctrl_tclEventObserver::addDevicesToMonitor()
{
   int NumOfDevices = createDevFileList();
   int fd = 0;

   // Clear FileDescList to ensure no previous data
   m_FileDescList.clear();
   
   ETG_TRACE_FATAL(("dispvidctrl_tclEventObserver::addDevicesToMonitor NumOfDevices = %d", NumOfDevices));
   
   if ( 0 == NumOfDevices )
   {
      return 0;
   }

   // Create Threads depending on Number of devices to read each device
   for (int i=0; i<NumOfDevices; i++)
   {
      fd = open(m_stlAllDevNameList.at(i).c_str(), O_RDONLY | O_NONBLOCK); //open device file
      if (fd == -1)
      {
         ETG_TRACE_FATAL(("EV Observer: addDevicesToMonitor() Error opening file so skip to add in Observer= %d", fd));
         continue;
      }
      else
      {
         ETG_TRACE_FATAL(("dispvidctrl_tclEventObserver::addDevicesToMonitor() Adding device: %s to Observer List", m_stlAllDevNameList.at(i).c_str()));
         m_FileDescList.push_back(fd);
      }

      if (dispvidctrl_tclEventObserver::m_poEpollInput) 
      {
         if (-1 == dispvidctrl_tclEventObserver::m_poEpollInput->addFileDescriptor(fd))
         {
            ETG_TRACE_FATAL(("EV Observer: addDevicesToMonitor() Failed to add FD to Epoll= %d", fd));
         }
      }
   }
   
   return NumOfDevices;
}

tVoid dispvidctrl_tclEventObserver::removeDevicesToMonitor()
{
   int NumOfDevices = m_FileDescList.size();
   // Create Threads depending on Number of devices to read each device
   for(int i=0; i<NumOfDevices; i++)
   {
      //ETG_TRACE_USR4(("dispvidctrl_tclEventObserver::removeDevicesToMonitor() call removeFileDescriptor for [%d]", i));
      if (dispvidctrl_tclEventObserver::m_poEpollInput) {
         dispvidctrl_tclEventObserver::m_poEpollInput->removeFileDescriptor(m_FileDescList[i]);
      }
      if( -1 == close(m_FileDescList[i]) )
      {
         ETG_TRACE_FATAL(("Failed to CLOSE FD = %d", m_FileDescList.at(i)));
      }
   }
   // Clear FileDescList
   m_FileDescList.clear();
   // Clear device name List as well
   m_stlAllDevNameList.clear();
}

tVoid dispvidctrl_tclEventObserver::HandleInputEvent(struct input_event Event)
{
   if (m_poTouchDataHandler) 
   {   
      if(_u8StartStopRecording == 1)
      {
      }
      else
      {
         // Update Counter to indicate some Input Event Activity on Device
         updateDeviceActivityCounter();
      
         if(Event.type == EV_KEY && Event.code != BTN_TOUCH)
         {
         }
         else if(Event.type == EV_REL)
         {
         }
         else if(Event.type == EV_ABS || Event.code == BTN_TOUCH)
         {
            // Call MultitouchEvDataHandler for storing
            _s32EventTypeHistory = EV_ABS;
            m_poTouchDataHandler->handleTouchEvData(Event);
         }
         else if(Event.type == EV_SYN)
         {
            switch(_s32EventTypeHistory)
            {
               case EV_ABS:
                 m_poTouchDataHandler->handleTouchEvData(Event);
                 break;
               case EV_KEY:
               case EV_REL:
               default:
                 break;
            }
         }
      }
   }
}

tVoid dispvidctrl_tclEventObserver::updateDeviceActivityCounter()
{
   if(_s8ActivityCounter >= 7)
    {
      _s8ActivityCounter = 0;
    }
    else
    {
      _s8ActivityCounter++;
    }
}



//*************************************************************************************************************************************************
// E O F
//*************************************************************************************************************************************************
