/*
* dispvidctrl_TouchDataHandler.cpp
*
*  Created on: March 02, 2017
*      Author: deo2kor
*/

#include "I_dispvidctrl_InputHandler.h"
#include "dispvidctrl_TouchDataHandler.h"
#include "dispvidctrl_AppMain.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_DISPVIDCTRL_APPLICATION
#include "trcGenProj/Header/dispvidctrl_TouchDataHandler.cpp.trc.h"
#endif

dispvidctrl_tclTouchDataHandler::dispvidctrl_tclTouchDataHandler(dispvidctrl_tclAppMain* poMainAppl)
: dispvidctrl_tclBaseIf(poMainAppl)
, m_poInputHandler(NULL)
{
   // Initialize all Member variables to 0
   
   memset(&_sTouchData,  0, sizeof(sTouchListElement));
   memset(&_sEvent, 0, sizeof(input_event));

   _sTouchData1.clear();
   _sTouchData1.reserve(10); // Remember Max 5 touch (press + release) entries and then process it
   
   _sTouchData2.clear();
   _sTouchData2.reserve(10); // Remember Max 5 touch (press + release) entries and then process it   
   
   m_rawTouchlist.clear();
   m_rawTouchlist.reserve(10); // Remember Max 5 touch (press + release) entries and then process it

   // initialise the mutex
   pthread_mutex_init(&_MutexTouchList, NULL);
}

dispvidctrl_tclTouchDataHandler::~dispvidctrl_tclTouchDataHandler()
{
   m_poInputHandler = NULL;

   // De-Initialization or cleanup
   _sTouchData.s64EvTime = 0;
   _sTouchData.u8TouchStatus = 0;
   _sTouchData.u16XCoord = 0;
   _sTouchData.u16YCoord = 0;

   m_rawTouchlist.clear();
   //Destroy the mutex
   pthread_mutex_destroy(&_MutexTouchList);
}

/******************************************************************************/
/* FUNCTION     vGetReferences                                                */
/******************************************************************************/
/**
*  \brief       Function to get all reference needed by this class.
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclTouchDataHandler::vGetReferences(tVoid)
{
   ETG_TRACE_FATAL(("[%d ms] dispvidctrl_tclTouchDataHandler::vGetReferences() entered.", OSAL_ClockGetElapsedTime()));
   
   m_poInputHandler = dynamic_cast<I_dispvidctrl_tclInputHandler*>(_cpoMain->getHandler("I_dispvidctrl_tclInputHandler"));
   DISPVIDCTRL_NULL_POINTER_CHECK(m_poInputHandler);
}

/******************************************************************************/
/* FUNCTION     vStartCommunication                                           */
/******************************************************************************/
/**
*  \brief       Function to start all dynamic objects e.g. threads, ...
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclTouchDataHandler::vStartCommunication(tVoid)
{
   ETG_TRACE_FATAL(("[%d ms] dispvidctrl_tclTouchDataHandler::vStartCommunication() entered.", OSAL_ClockGetElapsedTime()));
}

/******************************************************************************/
/* FUNCTION     vGetReferences                                                */
/******************************************************************************/
/**
*  \brief       Function to get all reference needed by this class.
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclTouchDataHandler::vGetReferencesEarly(tVoid)
{
   ETG_TRACE_FATAL(("[%d ms] dispvidctrl_tclTouchDataHandler::vGetReferencesEarly() entered.", OSAL_ClockGetElapsedTime()));
}

/******************************************************************************/
/* FUNCTION     vStartCommunication                                           */
/******************************************************************************/
/**
*  \brief       Function to start all dynamic objects e.g. threads, ...
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclTouchDataHandler::vStartCommunicationEarly(tVoid)
{
   ETG_TRACE_FATAL(("[%d ms] dispvidctrl_tclTouchDataHandler::vStartCommunicationEarly() entered.", OSAL_ClockGetElapsedTime()));
}

/******************************************************************************/
/* FUNCTION     vHandleMessage(TMsg* pMsg)                                    */
/******************************************************************************/
/**
*  \brief       Handle worker events.
*
*  \param       message pointer
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclTouchDataHandler::vHandleMessage(dispvidctrl_tclBaseIf::TMsg* pMsg)
{
   ETG_TRACE_FATAL(("[%d ms] dispvidctrl_tclTouchDataHandler::vHandleMessage() entered %u -> data: %d.", \
                     OSAL_ClockGetElapsedTime(), ETG_CENUM(dispvidctrl_tclBaseIf::ECmdTypes , (tU32)pMsg->eCmd), pMsg->u.u32Data));

   switch (pMsg->eCmd)
   {
      default:
         break;
   }   
}

/******************************************************************************/
/* FUNCTION     vHandleTraceMessage                                           */
/******************************************************************************/
/**
*  \brief       handle TTFis commands
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclTouchDataHandler::vHandleTraceMessage(const tUChar* puchData)
{
   DISPVIDCTRL_NULL_POINTER_CHECK(puchData);
   
   tU32 u32MsgCode = ((puchData[1]<<8) | puchData[2]);
}

/******************************************************************************/
/* FUNCTION     vTraceInfo()                                                  */
/******************************************************************************/
/**
*  \brief       trace information
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclTouchDataHandler::vTraceInfo()
{
   ETG_TRACE_USR4(("dispvidctrl_tclTouchDataHandler::vTraceInfo() entered."));
   vTraceDebugInformation();
}

/******************************************************************************/
/* FUNCTION     vGetConfiguration()                                           */
/******************************************************************************/
/**
*  \brief       trace information
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclTouchDataHandler::vGetConfiguration(const TConfiguration* pStConfigurationValues)
{
   ETG_TRACE_USR4(("dispvidctrl_tclTouchDataHandler::vGetConfiguration() entered."));
}




tVoid dispvidctrl_tclTouchDataHandler::handleTouchEvData(struct input_event sEvent)
{
   /*
   
   // Event Type

   #define EV_SYN          0x00
   #define EV_KEY          0x01
   #define EV_REL          0x02
   #define EV_ABS          0x03
   #define EV_MSC          0x04
   #define EV_SW           0x05
   #define EV_LED          0x11
   #define EV_SND          0x12
   #define EV_REP          0x14
   #define EV_FF           0x15
   #define EV_PWR          0x16
   #define EV_FF_STATUS    0x17
   #define EV_MAX          0x1f
   #define EV_CNT          (EV_MAX+1)
   
   // Event Type Synchronization events.
   
   #define SYN_REPORT      0
   #define SYN_CONFIG      1
   #define SYN_MT_REPORT   2
   #define SYN_DROPPED     3
   #define SYN_MAX         0xf
   #define SYN_CNT         (SYN_MAX+1)

   // Event Code

   #define ABS_X                  0x00
   #define ABS_Y                  0x01
   #define ABS_Z                  0x02
   #define ABS_RX                 0x03
   #define ABS_RY                 0x04
   #define ABS_RZ                 0x05
   #define ABS_THROTTLE           0x06
   #define ABS_RUDDER             0x07
   #define ABS_WHEEL              0x08
   #define ABS_GAS                0x09
   #define ABS_BRAKE              0x0a
   #define ABS_HAT0X              0x10
   #define ABS_HAT0Y              0x11
   #define ABS_HAT1X              0x12
   #define ABS_HAT1Y              0x13
   #define ABS_HAT2X              0x14
   #define ABS_HAT2Y              0x15
   #define ABS_HAT3X              0x16
   #define ABS_HAT3Y              0x17
   #define ABS_PRESSURE           0x18
   #define ABS_DISTANCE           0x19
   #define ABS_TILT_X             0x1a
   #define ABS_TILT_Y             0x1b
   #define ABS_TOOL_WIDTH         0x1c
   #define ABS_VOLUME             0x20
   #define ABS_MISC               0x28
   #define ABS_MT_SLOT            0x2f     // MT slot being modified 
   #define ABS_MT_TOUCH_MAJOR     0x30     // Major axis of touching ellipse
   #define ABS_MT_TOUCH_MINOR     0x31     // Minor axis (omit if circular) 
   #define ABS_MT_WIDTH_MAJOR     0x32     // Major axis of approaching ellipse
   #define ABS_MT_WIDTH_MINOR     0x33     // Minor axis (omit if circular)
   #define ABS_MT_ORIENTATION     0x34     // Ellipse orientation
   #define ABS_MT_POSITION_X      0x35     // Center X touch position
   #define ABS_MT_POSITION_Y      0x36     // Center Y touch position
   #define ABS_MT_TOOL_TYPE       0x37     // Type of touching device
   #define ABS_MT_BLOB_ID         0x38     // Group a set of packets as a blob
   #define ABS_MT_TRACKING_ID     0x39     // Unique ID of initiated contact
   #define ABS_MT_PRESSURE        0x3a     // Pressure on contact area
   #define ABS_MT_DISTANCE        0x3b     // Contact hover distance
   #define ABS_MT_TOOL_X          0x3c     // Center X tool position
   #define ABS_MT_TOOL_Y          0x3d     // Center Y tool position
   #define ABS_MAX                0x3f
   #define ABS_CNT                (ABS_MAX+1)
   
   */ 
   
   if ( 0 != memcmp(&_sEvent, &sEvent, sizeof(input_event)) )
   {
      memcpy(&_sEvent, &sEvent, sizeof(input_event));

      ETG_TRACE_USR4(("dispvidctrl_tclTouchDataHandler::handleTouchEvData()-> Event Time = %d.%ds, Code 0x%02x, Type 0x%02x Data 0x%04x",
                        sEvent.time.tv_sec, sEvent.time.tv_usec, sEvent.code, sEvent.type, sEvent.value));
      
      pthread_mutex_lock (&_MutexTouchList); //lock the mutex
      tU16 EventCode = sEvent.code;
      //_sTouchData.s64EvTime  = (tS64) sEvent.time.tv_sec;
      
      switch(EventCode)
      {
      case ABS_MT_POSITION_X:
         _sTouchData.u16XCoord = sEvent.value;
         break;
      case ABS_MT_POSITION_Y:
         _sTouchData.u16YCoord = sEvent.value;
         break;
      case BTN_TOUCH:
         {
            //_sTouchData.u8SlotID = 0;
            //simply apply value filter to make sure we fill either 1 or 0
            //_sTouchData.u8TouchStatus = (sEvent.value == 1) ? 1:0;
            //ETG_TRACE_FATAL(("dispvidctrl_tclTouchDataHandler::handleTouchEvData()-> BTN_TOUCH X=%d, Y=%d, Status=%d, Time=%d",_sTouchData.u16XCoord,
            //_sTouchData.u16YCoord, _sTouchData.u8TouchStatus, _sTouchData.s64EvTime));
         }
         break;
      case ABS_MT_SLOT: // Slot Change (Multi Touch point change)
         {
            _sTouchData.u8SlotID = sEvent.value;
            //ETG_TRACE_FATAL(("dispvidctrl_tclTouchDataHandler::handleTouchEvData():ABS_MT_SLOT-> Slot ID= %d, X=%d, Y=%d, Status=%d, Time=%d", _sTouchData.u8SlotID, _sTouchData.u16XCoord,
            //_sTouchData.u16YCoord, _sTouchData.u8TouchStatus, _sTouchData.s64EvTime));
         }
         break;
      case ABS_MT_TRACKING_ID:
         _sTouchData.u8TouchStatus = (sEvent.value != -1) ? 1:0;
         //ETG_TRACE_FATAL(("dispvidctrl_tclTouchDataHandler::handleTouchEvData():ABS_MT_TRACKING_ID -> Slot ID= %d, X=%d, Y=%d, Status=%d, Time=%d", _sTouchData.u8SlotID, _sTouchData.u16XCoord,
         //_sTouchData.u16YCoord, _sTouchData.u8TouchStatus, _sTouchData.s64EvTime));
         break;
      default:
         {
            //Do Nothing
         }
         break;
      }
      
      if (sEvent.type == EV_SYN)
      {
         _sTouchData.s64EvTime = (tS64) sEvent.time.tv_sec; //Update Event Time in TouchData
         // send TouchData Structure to store in list
         // Coverity says that the .push_back() used in addNewTouchEntry() may throw bad_alloc, so catch that 
         try {
            addNewTouchEntry(_sTouchData);  // Coverity says that the .push_back() used in addNewTouchEntry() may throw bad_alloc ...
         }
         catch(std::bad_alloc) {            // ... so catch bad_alloc here, so that we don't leave the method prematurely
            // do nothing special - just make sure that we can proceed to the code below to unlock the mutex again
         }
      }
      
      pthread_mutex_unlock (&_MutexTouchList);//unlock the mutex
   }
}

Touchlist* dispvidctrl_tclTouchDataHandler::getUpdatedTouchList()
{
   pthread_mutex_lock (&_MutexTouchList); //lock the mutex
   //Do List clean up & then Send this to requesting client
   delObsoleteTouchEntries();
   pthread_mutex_unlock (&_MutexTouchList);//unlock the mutex
   return(&m_rawTouchlist);
}


tVoid dispvidctrl_tclTouchDataHandler::storeTouchData(sTouchListElement& TouchData)
{
   //if(FALSE == changeTouchEntry(TouchData))
   {
      //add New Touch Entry
      //addNewTouchEntry(TouchData);
   }
}

tVoid dispvidctrl_tclTouchDataHandler::addNewTouchEntry(sTouchListElement& TouchData)
{
   //Indicates one Touch operation
   ETG_TRACE_USR4(("dispvidctrl_tclTouchDataHandler::addNewTouchEntry() SlotID(%d), X=%d, Y=%d, Status=%d, Time=%d", \
                     TouchData.u8SlotID ,TouchData.u16XCoord, TouchData.u16YCoord, TouchData.u8TouchStatus, TouchData.s64EvTime));
   
   // add touch entry depending on the slot
   if (TouchData.u8SlotID == 0)
   {
      _sTouchData1.push_back(TouchData);
   }
   else if (TouchData.u8SlotID == 1) // 2nd Touch point
   {
      _sTouchData2.push_back(TouchData);
   }
   else
   {
      ETG_TRACE_USR4(("dispvidctrl_tclTouchDataHandler::addNewTouchEntry 3 Finger Touch not Supported yet!!!"))
   }
   
   if ( m_poInputHandler )
   {
      m_poInputHandler->vUpdateTouchInfo(&TouchData, TouchData.u8SlotID);
   }
   
   // after adding a touch entry, 
   // if timer running already re-start
   // if timer not running re-start
}

tBool dispvidctrl_tclTouchDataHandler::changeTouchEntry(sTouchListElement& TouchData)
{
   tBool bTouchEntryExist = FALSE;
   Touchlist::iterator tIterator;

   if (FALSE == m_rawTouchlist.empty())
   {
      for (tIterator = m_rawTouchlist.begin(); tIterator != m_rawTouchlist.end(); tIterator++)
      {
         // Check if Same X,Y Coord is present just update status and time
         if((tIterator->u16XCoord == TouchData.u16XCoord) && (tIterator->u16YCoord == TouchData.u16YCoord) && (tIterator->u8SlotID == TouchData.u8SlotID))
         {
            bTouchEntryExist = TRUE; //Element Exist in List
            tIterator->u8TouchStatus = TouchData.u8TouchStatus; //update Status
            tIterator->s64EvTime = TouchData.s64EvTime; //update time
         }
      }
   }

   return bTouchEntryExist;
}

tVoid dispvidctrl_tclTouchDataHandler::delObsoleteTouchEntries()
{
   Touchlist::iterator tIterator;
   struct timeval CurrTime;
   gettimeofday (&CurrTime, NULL); //get current time from system

   if (FALSE == m_rawTouchlist.empty()) //If List is filled
   {
      ETG_TRACE_USR4(("dispvidctrl_tclTouchDataHandler::delObsoleteTouchEntries() -> m_rawTouchlist No Of Entries = %d",m_rawTouchlist.size()));
      //parse the list and check Time with current time
      for (tIterator = m_rawTouchlist.begin(); tIterator != m_rawTouchlist.end(); /**/)
      {
         //If time difference is greater than 2Sec than delete the element
         if((CurrTime.tv_sec - tIterator->s64EvTime) > 2)
         {
            //If touch is till pressed don't delete --fix for NCG3D-17794
            if(tIterator->u8TouchStatus == 1)
            {
               if((CurrTime.tv_sec - tIterator->s64EvTime) > 30){
                  ETG_TRACE_USR4((":dispvidctrl_tclTouchDataHandler:WARNING!: Touch (Slot ID = %d) is PRESSED State at [X(%d), Y(%d)]: Status=(%d) more than 30 secs:Ev Occurence Time=%ld", tIterator->u8SlotID,
                  tIterator->u16XCoord, tIterator->u16YCoord, tIterator->u8TouchStatus, tIterator->s64EvTime));
                  tIterator = m_rawTouchlist.erase(tIterator);
                  ETG_TRACE_USR4((":dispvidctrl_tclTouchDataHandler:INFO: ERASING.... this touch Entry from Input List!"));
               }
               else
               {
                  ETG_TRACE_USR4((":dispvidctrl_tclTouchDataHandler:INFO: Touch Entry Found : State Pressed < 30 secs, So No Action Taken!"));
                  tIterator++; //just move to next element
               }
            }
            else {
               tIterator = m_rawTouchlist.erase(tIterator);
            }
         }
         else
         {
            tIterator++;
         }
      } // for
   } // if (FALSE == m_rawTouchlist.empty())
}


tVoid dispvidctrl_tclTouchDataHandler::vTraceDebugInformation() const
{
   Touchlist::const_iterator cit;
   
   ETG_TRACE_FATAL(("dispvidctrl_tclTouchDataHandler: TraceDebugInformation Slot1 Touch Entry Begin ------------------------------------"));
   for (cit = _sTouchData1.begin(); cit != _sTouchData1.end(); cit++)
   {
      ETG_TRACE_FATAL(("dispvidctrl_tclTouchDataHandler: TraceDebugInformation Slot %d x = %d  y = %d time = %d", cit->u8SlotID, cit->u16XCoord, cit->u16YCoord, cit->s64EvTime));
   }
   ETG_TRACE_FATAL(("dispvidctrl_tclTouchDataHandler: TraceDebugInformation Slot1 Touch Entry End --------------------------------------"));
   
   ETG_TRACE_FATAL(("dispvidctrl_tclTouchDataHandler: TraceDebugInformation Slot2 Touch Entry Begin ------------------------------------"));
   for (cit = _sTouchData2.begin(); cit != _sTouchData2.end(); cit++)
   {
      ETG_TRACE_FATAL(("dispvidctrl_tclTouchDataHandler: TraceDebugInformation Slot %d x = %d  y = %d time = %d", cit->u8SlotID, cit->u16XCoord, cit->u16YCoord, cit->s64EvTime));
   }
   ETG_TRACE_FATAL(("dispvidctrl_tclTouchDataHandler: TraceDebugInformation Slot2 Touch Entry End --------------------------------------"));
}
