/*
 * dispvidctrl_tclEarlyIf.cpp
 *
 *  Created on: Aug 24, 2015
 *      Author: kol2hi
 */
/************************************************************************
* FILE:        dispvidctrl_tclEarlyIf.cpp
* PROJECT:
* SW-COMPONENT:vd_dimming
*----------------------------------------------------------------------
*
* DESCRIPTION: implementation of configuration manager class
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author             | Modification
* 20.08.2015| RBEI/ECV3 Sandeep Gupta | init
*
*************************************************************************/

/*******************************************************************************
| includes: system- and project- includes
|-----------------------------------------------------------------------------*/
// Basic OSAL includes
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define AHL_S_IMPORT_INTERFACE_GENERIC
#include "ahl_if.h"         // use Application Help Library

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

/*******************************************************************************
| set own module id
|-----------------------------------------------------------------------------*/

/*******************************************************************************
| includes: needed interfaces from external components
|-----------------------------------------------------------------------------*/


/*******************************************************************************
| includes: internal and external interfaces from this component
|-----------------------------------------------------------------------------*/

#include "dispvidctrl_tclSecondDisp.h"
#include "dispvidctrl_ClientDimming.h"
#include "dispvidctrl_ServiceDimmingIf.h"
#include "dispvidctrl_ClientDimmingIncFiDef.h"
#define VD_DIAGLOG_S_IMPORT_INTERFACE_MSG
#include "vd_diaglog_if.h"
using namespace dimming_inc_fi;

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_DISPVIDCTRL_APPLICATION
#include "trcGenProj/Header/dispvidctrl_tclSecondDisp.cpp.trc.h"
#endif

/*******************************************************************************
| defines and macros (scope: module-local)
|-----------------------------------------------------------------------------*/


/*******************************************************************************
| typedefs (scope: module-local)
|-----------------------------------------------------------------------------*/


/*******************************************************************************
| variable definition (scope: global)
|-----------------------------------------------------------------------------*/


/*******************************************************************************
| variable definition (scope: module-local)
|-----------------------------------------------------------------------------*/


/*******************************************************************************
| function prototype (scope: module-local)
|-----------------------------------------------------------------------------*/

/*******************************************************************************
| function implementation (scope: module-local)
|-----------------------------------------------------------------------------*/

/*******************************************************************************
*
* FUNCTION:    dispvidctrl_tclSecondDisp()
*
* DESCRIPTION: constructor
*
* PARAMETER:   const dispvidctrl_tclAppMain*
*
* RETURNVALUE: none
*
*******************************************************************************/
dispvidctrl_tclSecondDisp::dispvidctrl_tclSecondDisp(const dispvidctrl_tclAppMain* poMainAppl):I_dispvidctrl_tclSecondDispIf(poMainAppl)
{
   ETG_TRACE_USR4(("dispvidctrl_tclSecondDisp() entered."));
	 _poDimmIncClientIf = NULL;
	 _poDImmCCASrvIf=NULL;
	 m_poClientDiaglogIf = OSAL_NULL;
}

/*******************************************************************************
*
* FUNCTION:    ~dispvidctrl_tclSecondDisp()
*
* DESCRIPTION: destructor
*
* PARAMETER:   none
*
* RETURNVALUE: none
*
*******************************************************************************/
dispvidctrl_tclSecondDisp::~dispvidctrl_tclSecondDisp()
{
   ETG_TRACE_USR4(("~dispvidctrl_tclEarlyIf() entered."));
   m_poClientDiaglogIf = OSAL_NULL;
}

/*******************************************************************************
*
* FUNCTION:    vHandleMessage()
*
* DESCRIPTION: handle internal message
*
* PARAMETER:   dispvidctrl_tclBaseIf::TMsg* pMsg
*
* RETURNVALUE: none
*
*******************************************************************************/
tVoid dispvidctrl_tclSecondDisp::vHandleMessage(dispvidctrl_tclBaseIf::TMsg* pMsg)
{
  (tVoid)pMsg; // Not used
}

/*******************************************************************************
*
* FUNCTION: 	vHandleTraceMessage()
*
* DESCRIPTION: 	handler for trace command
*
* PARAMETER:   	const tUChar* puchData: reference of received message
*
* RETURNVALUE: 	None.
*
*******************************************************************************/
tVoid dispvidctrl_tclSecondDisp::vHandleTraceMessage(const tUChar* puchData)
{
	ETG_TRACE_USR4(("vHandleTraceMessage() entered (data: 0x%08x).", puchData ));
}

/*******************************************************************************
*
* FUNCTION: 	vGetReferences(tVoid)
*
* DESCRIPTION: 	Function to get all reference needed by this class.
* 				A reference should always be the Interface class of the object
*
* PARAMETER: 	None.
*
* RETURNVALUE: 	None.
*
*******************************************************************************/
tVoid dispvidctrl_tclSecondDisp::vGetReferences(tVoid)
{
   ETG_TRACE_USR4(("vGetReferences() entered."));
   DISPVIDCTRL_NULL_POINTER_CHECK(_cpoMain);
   //Get Reference of INC CLient from Main Object
   _poDimmIncClientIf = dynamic_cast<I_dispvidctrl_tclClientDimming*>(_cpoMain->getHandler("dispvidctrl_tclClientDimming"));
   DISPVIDCTRL_NULL_POINTER_CHECK(_poDimmIncClientIf);
   //Get Reference of CCA Server from Main Object
   _poDImmCCASrvIf = dynamic_cast<Idispvidctrl_tclServiceDimmingIf*>(_cpoMain->getHandler("dispvidctrl_tclServiceDimmingIf"));
   DISPVIDCTRL_NULL_POINTER_CHECK(_poDImmCCASrvIf);

   m_poClientDiaglogIf = dynamic_cast<Idispvidctrl_tclClientDiaglogIf*>(_cpoMain->getHandler("Idispvidctrl_tclClientDiaglogIf"));
   DISPVIDCTRL_NULL_POINTER_CHECK(m_poClientDiaglogIf)
}

/*******************************************************************************
*
* FUNCTION: 	tVoid vStartCommunication()
*
* DESCRIPTION: 	Function to start all dynamic objects e.g. threads, ...
*
* PARAMETER: 	None.
*
* RETURNVALUE: 	None.
*
*******************************************************************************/
tVoid dispvidctrl_tclSecondDisp::vStartCommunication(tVoid)
{
   ETG_TRACE_USR4(("vStartCommunication() entered."));
}

/*******************************************************************************
*
* FUNCTION: 	vTraceInfo()
*
* DESCRIPTION: 	Trace information
*
* PARAMETER: 	None.
*
* RETURNVALUE: 	None.
*
*******************************************************************************/
tVoid dispvidctrl_tclSecondDisp::vTraceInfo()
{
	ETG_TRACE_USR4(("vTraceInfo() entered."));
}


//************************************************************************************************************************
//	Set of Interfaces that shall be sending update/status to HMI
//************************************************************************************************************************

/*******************************************************************************
*
* FUNCTION: 	update_HWVersionInfo()
*
* DESCRIPTION: 	send updated Version info received from V850 to CCA
*
* PARAMETER: 	HWVersion
*
* RETURNVALUE: 	None.
*
*******************************************************************************/

tVoid dispvidctrl_tclSecondDisp::update_HWVersionInfo(tU32 HWVersion)
{
	dimming_fi_tcl_SecondDisp_VersionInfo HWVersion_Info;
	//Extract Bytes and Extract to FI Data Object
	HWVersion_Info.u8Upper = (tU8)(HWVersion>>24);
	HWVersion_Info.u8Mid =  (tU8)(HWVersion>>16);
	HWVersion_Info.u8Lower = (tU8)(HWVersion>>8);
	
    ETG_TRACE_USR1(("SECOND_DISP: Msg From V850 : update_HWVersionInfo(): %d.%d.%d.", HWVersion_Info.u8Upper, HWVersion_Info.u8Mid, HWVersion_Info.u8Lower ));	
	//Forward to CCA Client
	if(_poDImmCCASrvIf != NULL)
		_poDImmCCASrvIf->sendDIM_SECOND_DISP_HardwareVersionMResult(HWVersion_Info);
}

/*******************************************************************************
*
* FUNCTION: 	update_SWVersionInfo()
*
* DESCRIPTION: 	send updated Version info received from V850 to CCA
*
* PARAMETER: 	SWVersion
*
* RETURNVALUE: 	None.
*
*******************************************************************************/
tVoid dispvidctrl_tclSecondDisp::update_SWVersionInfo(tU32 SWVersion)
{
	dimming_fi_tcl_SecondDisp_VersionInfo SWVersion_Info;
	//Extract bytes and add to FI Data Object
	SWVersion_Info.u8Upper = (tU8)(SWVersion>>24);
	SWVersion_Info.u8Mid =  (tU8)(SWVersion>>16);
	SWVersion_Info.u8Lower = (tU8)(SWVersion>>8);
    ETG_TRACE_USR1(("SECOND_DISP: Msg From V850 : update_SWVersionInfo(): %d.%d.%d.", SWVersion_Info.u8Upper, SWVersion_Info.u8Mid, SWVersion_Info.u8Lower ));	
	//Forward To CCA Client
	if(_poDImmCCASrvIf != NULL)
		_poDImmCCASrvIf->sendDIM_SECOND_DISP_SoftwareVersionMResult(SWVersion_Info);
}

/*******************************************************************************
*
* FUNCTION: 	update_DisplayParam()
*
* DESCRIPTION: 	send updated Display Property update Rx from V850 to CCA
*
* PARAMETER: 	u16FunctionId: Enum informing Brightness, Contrast etc
* 				u16ParameterValue: Value of Display property.
* 				u8ErrorCode: if some error happened.
*
* RETURNVALUE: 	None.
*
*******************************************************************************/

tVoid dispvidctrl_tclSecondDisp::update_DisplayParam(tU16 u16FunctionId, tU16 u16ParameterValue, tU8 u8ErrorCode)
{
	::dimming_fi_tcl_SecondDispFunctionID oFunctionID; //CCA FI Object

	//Map FUnction Ids from V850 to HMI logical Parameter IDs
	switch(u16FunctionId)
	{
		case  ::dimming_inc_fi::eSensitivity_Setting:
			oFunctionID.enType = ::dimming_fi_tcl_SecondDispFunctionID::FI_EN_SENSITIVITY_SETTING;
		break;
		case ::dimming_inc_fi::eBlack_Level:
			oFunctionID.enType = ::dimming_fi_tcl_SecondDispFunctionID::FI_EN_BLACK_LEVEL;
		break;
		case  ::dimming_inc_fi::eBrightness:
			oFunctionID.enType = ::dimming_fi_tcl_SecondDispFunctionID::FI_EN_BRIGHTNESS;
		break;
		case ::dimming_inc_fi::eContrast:
			oFunctionID.enType = ::dimming_fi_tcl_SecondDispFunctionID::FI_EN_CONTRAST;
		break;
		case ::dimming_inc_fi::eGamma_Level:
			oFunctionID.enType = ::dimming_fi_tcl_SecondDispFunctionID::FI_EN_GAMMA_LEVEL;
		break;
		case ::dimming_inc_fi::eTint:
			oFunctionID.enType = ::dimming_fi_tcl_SecondDispFunctionID::FI_EN_TINT;
		break;
		default:
		break;
	}

    ETG_TRACE_USR1(("SECOND_DISP: Msg From V850 : update_DisplayParam(): FunctionID = %x,  Value = %d, ErrorCode=%d",u16FunctionId,  u16ParameterValue, u8ErrorCode));		
	//Send Method Result to HMI via CCA
	if(_poDImmCCASrvIf != NULL) {
		_poDImmCCASrvIf->sendDIM_SECOND_DISP_SetDispParameterMResult(oFunctionID, u16ParameterValue);
	}
	(tVoid)u8ErrorCode;
}

/*******************************************************************************
*
* FUNCTION: 	update_AllDisplayParam()
*
* DESCRIPTION: 	send updated All Display Properties Rx from V850 to CCA
*
* PARAMETER: 	Multiple self explanatory
*
* RETURNVALUE: 	None.
*
*******************************************************************************/

tVoid dispvidctrl_tclSecondDisp::update_AllDisplayParam(tU8 u8BlackLevel, tU8 u8Brightness, tU8 u8Color,
		                                                tU8 u8Contrast, tU8 u8Tint, tU16 u8GammaLevel)
{
	//Update Status of All Display Parameters received from V850 via CCA
	if(_poDImmCCASrvIf != NULL) {
		_poDImmCCASrvIf->sendDIM_SECOND_DISP_AllDisplayParamStatus(u8BlackLevel, u8Brightness, u8Color,
		                                                       u8Contrast, u8Tint, u8GammaLevel);
         ETG_TRACE_USR1(("SECOND_DISP: Msg From V850 : update_AllDisplayParam(): u8BlackLevel=%d\nu8Brightness=%d,\nu8Color=%d,\nu8Contrast=%d,\nu8Tint=%d,\nu8GammaLevel=%d",u8BlackLevel,  u8Brightness, u8Color, u8Contrast, u8Tint, u8GammaLevel));																   
	}
}

/*******************************************************************************
*
* FUNCTION: 	update_DisplayState()
*
* DESCRIPTION: 	send updated DisplayState Rx from V850 to CCA
*
* PARAMETER: 	u8DisplayState: 0-> Display OFF, 1 -> Display ON
* 				u8ErrorCode: If any error happened.
*
* RETURNVALUE: 	None.
*
*******************************************************************************/

tVoid dispvidctrl_tclSecondDisp::update_DisplayState(tU8 u8DisplayState, tU8 u8ErrorCode)
{
    ETG_TRACE_USR1(("SECOND_DISP: Msg From V850 : update_DisplayState(): u8DisplayState = %d, ErrorCode=%d",u8DisplayState, u8ErrorCode));
	//Send Method Result to HMI via CCA
	//Send Method Result in response to prev MStart for Display STate on / off via CCA
	if(_poDImmCCASrvIf != NULL) {
		_poDImmCCASrvIf->sendDIM_SECOND_DISP_SetDispOnOffMResult(u8DisplayState);
		(tVoid)u8ErrorCode;
	}
}

/*******************************************************************************
*
* FUNCTION: 	update_SelfDiagResult()
*
* DESCRIPTION: 	send updated SelfDiagResult Rx from V850 to CCA
*
* PARAMETER: 	u16SelfDiagResult: 2 byte value
*
* RETURNVALUE: 	None.
*
*******************************************************************************/

tVoid dispvidctrl_tclSecondDisp::update_SelfDiagResult(tU16 u16SelfDiagResult)
{
    ETG_TRACE_USR1(("SECOND_DISP: Msg From V850 : update_SelfDiagResult(): u16SelfDiagResult = %d",u16SelfDiagResult));	
	//Send Method Result in response to prev MStart for Diagnosis Result via CCA
	if(_poDImmCCASrvIf != NULL) {
	_poDImmCCASrvIf->sendDIM_SECOND_DISP_SelfDiagnosisResultStatus(u16SelfDiagResult);
	}

	// Send ITCs for selfDiagResult
	sendITC_SelfDiagResult(u16SelfDiagResult);
}

/*******************************************************************************
*
* FUNCTION:       sendITC_SelfDiagResult()
*
* DESCRIPTION:    send ITCs based on SelfDiagResult
*
* PARAMETER:      u16SelfDiagResult: 2 byte value
*
* RETURNVALUE:    None.
*
*******************************************************************************/
tVoid dispvidctrl_tclSecondDisp::sendITC_SelfDiagResult(tU16 u16SelfDiagResult)
{
   // IT-Commander
   if (u16SelfDiagResult & 0x0001)
   {
      m_poClientDiaglogIf->vSetITC(enITC_AIVI_2ND_DISPLAY_SELF_DIAGNOSIS_FAILURE_IT_COMM, midw_fi_tcl_e8_TestResult::FI_EN_PASSED);
   }
   else
   {
      m_poClientDiaglogIf->vSetITC(enITC_AIVI_2ND_DISPLAY_SELF_DIAGNOSIS_FAILURE_IT_COMM, midw_fi_tcl_e8_TestResult::FI_EN_FAILED);
   }

   // HVAC_Indicator
   if (u16SelfDiagResult & 0x0002)
   {
      m_poClientDiaglogIf->vSetITC(enITC_AIVI_2ND_DISPLAY_SELF_DIAGNOSIS_FAILURE_HVAC, midw_fi_tcl_e8_TestResult::FI_EN_PASSED);
   }
   else
   {
      m_poClientDiaglogIf->vSetITC(enITC_AIVI_2ND_DISPLAY_SELF_DIAGNOSIS_FAILURE_HVAC, midw_fi_tcl_e8_TestResult::FI_EN_FAILED);
   }

   // Buttons
   if (u16SelfDiagResult & 0x0004)
   {
      m_poClientDiaglogIf->vSetITC(enITC_AIVI_2ND_DISPLAY_SELF_DIAGNOSIS_FAILURE_BUTTONS, midw_fi_tcl_e8_TestResult::FI_EN_PASSED);
   }
   else
   {
      m_poClientDiaglogIf->vSetITC(enITC_AIVI_2ND_DISPLAY_SELF_DIAGNOSIS_FAILURE_BUTTONS, midw_fi_tcl_e8_TestResult::FI_EN_FAILED);
   }

   // Touch_Panel
   if (u16SelfDiagResult & 0x0008)
   {
      m_poClientDiaglogIf->vSetITC(enITC_AIVI_2ND_DISPLAY_SELF_DIAGNOSIS_FAILURE_TOUCH, midw_fi_tcl_e8_TestResult::FI_EN_PASSED);
   }
   else
   {
      m_poClientDiaglogIf->vSetITC(enITC_AIVI_2ND_DISPLAY_SELF_DIAGNOSIS_FAILURE_TOUCH, midw_fi_tcl_e8_TestResult::FI_EN_FAILED);
   }

   // LVDS_Interface
   if (u16SelfDiagResult & 0x00010)
   {
      m_poClientDiaglogIf->vSetITC(enITC_AIVI_2ND_DISPLAY_SELF_DIAGNOSIS_FAILURE_LVDS, midw_fi_tcl_e8_TestResult::FI_EN_PASSED);
   }
   else
   {
      m_poClientDiaglogIf->vSetITC(enITC_AIVI_2ND_DISPLAY_SELF_DIAGNOSIS_FAILURE_LVDS, midw_fi_tcl_e8_TestResult::FI_EN_FAILED);
   }

   // TFT
   if (u16SelfDiagResult & 0x00020)
   {
      m_poClientDiaglogIf->vSetITC(enITC_AIVI_2ND_DISPLAY_SELF_DIAGNOSIS_FAILURE_TFT, midw_fi_tcl_e8_TestResult::FI_EN_PASSED);
   }
   else
   {
      m_poClientDiaglogIf->vSetITC(enITC_AIVI_2ND_DISPLAY_SELF_DIAGNOSIS_FAILURE_TFT, midw_fi_tcl_e8_TestResult::FI_EN_FAILED);
   }

   // Rom
   if (u16SelfDiagResult & 0x00040)
   {
      m_poClientDiaglogIf->vSetITC(enITC_AIVI_2ND_DISPLAY_SELF_DIAGNOSIS_FAILURE_ROM, midw_fi_tcl_e8_TestResult::FI_EN_PASSED);
   }
   else
   {
      m_poClientDiaglogIf->vSetITC(enITC_AIVI_2ND_DISPLAY_SELF_DIAGNOSIS_FAILURE_ROM, midw_fi_tcl_e8_TestResult::FI_EN_FAILED);
   }

   // Back_Light
   if (u16SelfDiagResult & 0x00080)
   {
      m_poClientDiaglogIf->vSetITC(enITC_AIVI_2ND_DISPLAY_SELF_DIAGNOSIS_FAILURE_BACKLIGHT, midw_fi_tcl_e8_TestResult::FI_EN_PASSED);
   }
   else
   {
      m_poClientDiaglogIf->vSetITC(enITC_AIVI_2ND_DISPLAY_SELF_DIAGNOSIS_FAILURE_BACKLIGHT, midw_fi_tcl_e8_TestResult::FI_EN_FAILED);
   }

}


//************************************************************************************************************************
//	Set of Interfaces that shall be sending Request or COmmands to V850 to be Used by HMI
//************************************************************************************************************************

/*******************************************************************************
*
* FUNCTION: 	requestV850_HWVersionInfo()
*
* DESCRIPTION: 	Request/Command to V850 to send VersionInfo update
*
* PARAMETER: 	None.
*
* RETURNVALUE: 	None.
*
*******************************************************************************/

tVoid dispvidctrl_tclSecondDisp::requestV850_HWVersionInfo()
{
	if(_poDimmIncClientIf != NULL)
	{
		if(FALSE == _poDimmIncClientIf->sendSECOND_DISP_GET_HW_VERSION())
		{
			ETG_TRACE_USR1(("SECOND_DISP: Msg Sent to V850 : requestV850_HWVersionInfo() : ERROR Sending.."));
		}
		else
		{
			ETG_TRACE_USR1(("SECOND_DISP: Msg Sent to V850 : requestV850_HWVersionInfo()"));
		}
	}
}

/*******************************************************************************
*
* FUNCTION: 	requestV850_SWVersionInfo()
*
* DESCRIPTION: 	Request/Command to V850 to send VersionInfo update
*
* PARAMETER: 	None.
*
* RETURNVALUE: 	None.
*
*******************************************************************************/

tVoid dispvidctrl_tclSecondDisp::requestV850_SWVersionInfo()
{
	if(_poDimmIncClientIf != NULL)
	{
		if(FALSE == _poDimmIncClientIf->sendSECOND_DISP_GET_SW_VERSION())
		{
			ETG_TRACE_USR1(("SECOND_DISP: Msg Sent to V850 : requestV850_SWVersionInfo() : ERROR Sending.."));
		}
		else
		{
			ETG_TRACE_USR1(("SECOND_DISP: Msg Sent to V850 : requestV850_SWVersionInfo()"));
		}
	}
}
/*******************************************************************************
*
* FUNCTION: 	requestV850_setDisplayParam()
*
* DESCRIPTION: 	Request/Command to V850 to set Display Property
*
* PARAMETER: 	u16FunctionId: Enum Containing HMI provided Property ID
* 				u16ParameterValue: Value of Property to be set.
*
* RETURNVALUE: 	None.
*
*******************************************************************************/

tVoid dispvidctrl_tclSecondDisp::requestV850_setDisplayParam(tU16 u16FunctionId, tU16 u16ParameterValue)
{
	::dimming_inc_fi::ESecondDisplayParamID eV850SecondDispParamID;  //V850 Param ID enum
	//Map Parameter Ids from HMI to V850 Parameter IDs
	switch(u16FunctionId)
	{
		case  ::dimming_fi_tcl_SecondDispFunctionID::FI_EN_SENSITIVITY_SETTING:
			eV850SecondDispParamID = ::dimming_inc_fi::eSensitivity_Setting;
		break;
		case ::dimming_fi_tcl_SecondDispFunctionID::FI_EN_BLACK_LEVEL:
			eV850SecondDispParamID = ::dimming_inc_fi::eBlack_Level;
		break;
		case  ::dimming_fi_tcl_SecondDispFunctionID::FI_EN_BRIGHTNESS:
			eV850SecondDispParamID = ::dimming_inc_fi::eBrightness;
		break;
		case ::dimming_fi_tcl_SecondDispFunctionID::FI_EN_CONTRAST:
			eV850SecondDispParamID = ::dimming_inc_fi::eContrast;
		break;
		case ::dimming_fi_tcl_SecondDispFunctionID::FI_EN_GAMMA_LEVEL:
			eV850SecondDispParamID = ::dimming_inc_fi::eGamma_Level;
		break;
		case ::dimming_fi_tcl_SecondDispFunctionID::FI_EN_TINT:
			eV850SecondDispParamID = ::dimming_inc_fi::eTint;
		break;
		default:
			eV850SecondDispParamID = ::dimming_inc_fi::eSecondDisplayParamIDMax;
		break;
	}

	//Send the ParamID eV850SecondDispParamID and Value to V850 over INC
	if(_poDimmIncClientIf != NULL)
	{
		if(FALSE == _poDimmIncClientIf->sendSECOND_DISP_SET_DISPLAY_PARAMETERS(eV850SecondDispParamID, u16ParameterValue))
		{
			ETG_TRACE_USR1(("SECOND_DISP: Msg Sent to V850 : requestV850_setDisplayParam() ERROR sending..."));
		}
		else
		{
			ETG_TRACE_USR1(("SECOND_DISP: Msg Sent to V850 : requestV850_setDisplayParam(): u16FunctionId=%x, u16ParameterValue=%d", (tU16)eV850SecondDispParamID, u16ParameterValue));
		}
	}

}

/*******************************************************************************
*
* FUNCTION: 	requestV850_AllDisplayParam()
*
* DESCRIPTION: 	Request/Command to V850 to send All Display Parameters update
*
* PARAMETER: 	None.
*
* RETURNVALUE: 	None.
*
*******************************************************************************/

tVoid dispvidctrl_tclSecondDisp::requestV850_AllDisplayParam()
{
	//Send Command to V850 to Get All Dimming parameters
	if(_poDimmIncClientIf != NULL)
	{
		if(FALSE == _poDimmIncClientIf->sendSECOND_DISP_GET_DIMMING_PARAMETERS())
		{
			ETG_TRACE_USR1(("SECOND_DISP: Msg Sent to V850 : requestV850_AllDisplayParam() Sending Error ..."));
		}
		else
		{
			ETG_TRACE_USR1(("SECOND_DISP: Msg Sent to V850 : requestV850_AllDisplayParam()"));
		}
	}
}

/*******************************************************************************
*
* FUNCTION: 	requestV850_AllDisplayParam()
*
* DESCRIPTION: 	Request/Command to V850 to toggle Display On/Off State
*
* PARAMETER: 	u8DisplayState: 1->ON and 0->OFF
*
* RETURNVALUE: 	None.
*
*******************************************************************************/

tVoid dispvidctrl_tclSecondDisp::requestV850_setDisplayState(tU8 u8DisplayState)
{
	//Send Command to V850 to Switch Second Display ON and OFF
/*	if(_poDimmIncClientIf != NULL)
	{
		if(FALSE == _poDimmIncClientIf->sendSECOND_DISP_SWITCH_ON_OFF(u8DisplayState))
		{
			ETG_TRACE_USR1(("SECOND_DISP: Msg Sent to V850 : requestV850_setDisplayState() Sending Error ..."));
		}
		else
		{
			ETG_TRACE_USR1(("SECOND_DISP: Msg Sent to V850 : requestV850_setDisplayState(): State = %d", u8DisplayState));
		}
	}*/
}

/*******************************************************************************
*
* FUNCTION: 	requestV850_SelfDiagResult()
*
* DESCRIPTION: 	Request/Command to V850 to send Self Diagnostics Result update
*
* PARAMETER: 	None.
*
* RETURNVALUE: 	None.
*
*******************************************************************************/

tVoid dispvidctrl_tclSecondDisp::requestV850_SelfDiagResult()
{
	//Send Command to V850 to send back Self Diagnostic Result
	if(_poDimmIncClientIf != NULL)
	{
		if(FALSE == _poDimmIncClientIf->sendSECOND_DISP_GET_SELF_DIAGNOSTIC_RESULT())
		{
			ETG_TRACE_USR1(("SECOND_DISP: Msg Sent to V850 : requestV850_SelfDiagResult() Sending Error ..."));
		}
		else
		{
			ETG_TRACE_USR1(("SECOND_DISP: Msg Sent to V850 : requestV850_SelfDiagResult()"));
		}
	}
}
