/************************************************************************
* FILE:        dispvidctrl_tclEarlyIf.h
* PROJECT:
* SW-COMPONENT:vd_dimming
*----------------------------------------------------------------------
*
* DESCRIPTION: definition of configuration manager class
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author             | Modification
* 20.08.2015| CM-AI/EPB2 Bernard | init
*
*************************************************************************/

#ifndef dispvidctrl_tclEarlyIf_H_
#define dispvidctrl_tclEarlyIf_H_

#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#endif //#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC

//include base class
#include "I_dispvidctrl_tclEarlyIf.h"

class dispvidctrl_tclEarlyIf : public I_dispvidctrl_tclEarlyIf
{
private:
   static dispvidctrl_tclEarlyIf*   _poMyStaticRef;

   static tVoid vVdEarlyThread(tVoid *pvArg);

   OSAL_tEventHandle _hEvVideoReady;

public:
    // constructors and destructors
	dispvidctrl_tclEarlyIf(tVoid);
	dispvidctrl_tclEarlyIf(const dispvidctrl_tclAppMain* poMainAppl);
	virtual ~dispvidctrl_tclEarlyIf();

	virtual const tChar* getName() const { return "dispvidctrl_tclEarlyIf"; };

	virtual tVoid vHandleMessage(dispvidctrl_tclBaseIf::TMsg* pMsg);
	virtual tVoid vHandleTraceMessage(const tUChar* puchData);
	virtual tVoid vGetReferences();
	virtual tVoid vStartCommunication();
	virtual tVoid vTraceInfo();

    //
    //interface to vd early
    //

    // main 
    virtual tVoid vStartVdEarly();
    virtual tVoid vWaitForVideoReady(tU32 u32Timeout);

    //animation part
    virtual tVoid vStartAnimationSequence();
    virtual tVoid vStopAnimationSequence();

    //
    //interface from vd early to CCA app
    //
    static  tVoid vVideoReady();
    static  tVoid vSwitchBacklight(tBool bActive);

};

#endif /* dispvidctrl_tclEarlyIf_H_ */
