/************************************************************************
* FILE:        dispvidctrl_tclConfigMgr.h
* PROJECT:
* SW-COMPONENT:vd_dimming
*----------------------------------------------------------------------
*
* DESCRIPTION: definition of configuration manager class
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author             | Modification
* 20.08.2015| CM-AI/EPB2 Bernard | init
*
*************************************************************************/

#ifndef DISPVIDCTRL_TCLCONFIGMGR_H_
#define DISPVIDCTRL_TCLCONFIGMGR_H_

#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#endif //#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_diagdebug_if.h"


//include base class
#include "I_dispvidctrl_tclConfigMgr.h"

#include "dispvidctrl_config_early.h"
#include "dispvidctrl_config_pdd.h"


class dispvidctrl_tclConfigMgr : public I_dispvidctrl_tclConfigMgr
{
public:
    // constructors and destructors
	dispvidctrl_tclConfigMgr(tVoid);
	dispvidctrl_tclConfigMgr(const dispvidctrl_tclAppMain* poMainAppl);
	virtual ~dispvidctrl_tclConfigMgr();

	virtual const tChar* getName() const { return "dispvidctrl_tclConfigMgr"; };

	virtual tVoid vHandleMessage(dispvidctrl_tclBaseIf::TMsg* pMsg);
	virtual tVoid vHandleTraceMessage(const tUChar* puchData);
	virtual tVoid vGetReferences();
	virtual tVoid vStartCommunication();
	virtual tVoid vTraceInfo();

	virtual tVoid vOnLoadSettings(tVoid);

protected:
	dispvidctrl_tclEarlyConfig m_oEarlyConfig;
	dispvidctrl_tclConfigPdd m_oPDDDimming;

private:
    tVoid vStartConfig();
    static tVoid vDoConfigThread(tVoid *pvArg);

#ifdef VARIANT_S_FTR_ENABLE_AIVI_SCOPE2_1
    tBool loadDataBrightnessFromDIAG();
	//Needed to Read Key Illum Datapool Matrix
    virtual tVoid vGetKeyIllumMatrixValues(tU16* u16Array, tU8 length);
    virtual tVoid vSetKeyIllumMatrixValues(tU16* u16Array, tU8 length);
    virtual tVoid vSetT4VSKeyIllumDataPool(tU16 u16Day_Day1, tU16 u16Day_night1, tU16 u16Night_Night1);
    virtual tVoid vGetT4VSKeyIllumDataPool(tU16 (&u16Array)[3]);
    virtual tVoid vUpdateDimmINCBrightnessMatrix();
    virtual tVoid vReset_DispRenaultDatapool();
    tS32 loadDefaultDispBrightnessConfig();
#endif


};

#endif /* DISPVIDCTRL_TCLCONFIGMGR_H_ */
