/************************************************************************
* FILE:        dispvidctrl_config_pdd.h
* PROJECT:
* SW-COMPONENT:vd_dimming
*----------------------------------------------------------------------
*
* DESCRIPTION: definition of PDD dimming class
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author             | Modification
* 13.10.2015| CM-AI/EPB2 Bernard | rework
*
*************************************************************************/

#ifndef _DISPVIDCTRL_CONFIG_PDD_H_
#define _DISPVIDCTRL_CONFIG_PDD_H_

/******************************************************************************/
/* INCLUDES                                                                   */
/******************************************************************************/
// include base class
#ifndef __DISPVIDCTRL_APPMAIN_H
#include "dispvidctrl_AppMain.h"
#endif //#ifndef __DISPVIDCTRL_APPMAIN_H

// include SCC datapool types
#include "DataPoolSCC.h"

/******************************************************************************/
/* DEFINES                                                                   */
/******************************************************************************/

class dispvidctrl_tclConfigPdd
{
public:
    dispvidctrl_tclConfigPdd();
    virtual ~dispvidctrl_tclConfigPdd(){}

    tBool bLoadKDSData();
    tBool bIsValidKDSData(tVoid) const;
    tBool bIsChangedKDSData() const;
    tBool bWritePddData();
	tVoid vTraceInfoConfigPDD(const char* strIdentifier) const;

protected:
	inline tBool bConvertRawKDSData(tU16 &u16Value, const tU8* pu8Data) const {
		if (OSAL_NULL != pu8Data)
			u16Value = (((tU16)*pu8Data) << 8) | ((tU16)*(pu8Data+1));
		return (OSAL_NULL != pu8Data);
	}
	inline tBool bConvertRawKDSData(tS16 &s16Value, const tU8* pu8Data) const {
		tU16 _u16Value = 0;
		if (OSAL_NULL != pu8Data)
			_u16Value = (((tU16)*pu8Data) << 8) | ((tU16)*(pu8Data+1));
		s16Value = (tS16)_u16Value;
		return (OSAL_NULL != pu8Data);
	}
	inline tBool bConvertRawKDSData(tU8 &u8Value, const tU8* pu8Data) const {
		if (OSAL_NULL != pu8Data)
			u8Value = *pu8Data;
		return (OSAL_NULL != pu8Data);
	}
	inline tBool bConvertRawKDSData(tS8 &s8Value, const tU8* pu8Data) const {
		if (OSAL_NULL != pu8Data)
			s8Value = (tS8)*pu8Data;
		return (OSAL_NULL != pu8Data);
	}
	tBool bLoadKDSData_V0(tVoid);
	tBool bLoadKDSData_V1(tVoid);
	tBool bLoadCalibrationData(tVoid);
    tVoid vReadDefaultValues();
    // version information
    tU8 m_u8MajorVersion;
    tU8 m_u8MinorVersion;
 public:
    // prepared new PDD date
    TDataPoolScc_DimmingDpPDD m_oKDSConfigData;
	tBool m_bKDSLoaded : 1;
	tBool m_bUseDefaultCalibrationValues : 1;
};

#endif // _DISPVIDCTRL_CONFIG_PDD_H_

