/************************************************************************
* FILE:        dispvidctrl_config_early.h
* PROJECT:
* SW-COMPONENT:vd_dimming
*----------------------------------------------------------------------
*
* DESCRIPTION: definition of EarlyConfig class
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author             | Modification
* 20.08.2015| CM-AI/EPB2 Bernard | init
*
*************************************************************************/

#ifndef DISPVIDCTRL_CONFIG_EARLY_H_
#define DISPVIDCTRL_CONFIG_EARLY_H_

#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#endif //#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_generic_if.h"
#include "dp_drvass_video_if.h"

#define EARLYCONFIG_ARRAY_ELEMENTS(a)                   (sizeof(a)/sizeof(a[0]))

// helper structure for EarlyConfig_Display
typedef union
{
	tU8 au8KDSRaw[DP_U8_KDSLEN_EARLYCONFIG_DISPLAY_COMPLETE];
	struct
	{
		tU8 au8Resolution[DP_U8_KDSLEN_EARLYCONFIG_DISPLAY_RESOLUTION];
		tU8 au8BackwardComp[DP_U8_KDSLEN_EARLYCONFIG_DISPLAY_BACKWARDCOMPATIBILITY];
		tU8 au8LowFrequency[DP_U8_KDSLEN_EARLYCONFIG_DISPLAY_LOWFREQUENCY];
	} tDisplayRaw;
}tKDS_EarlyConfig_DisplayRaw;
// helper structure for EarlyConfig_TouchDriver
typedef union
{
	tU8 au8KDSRaw[DP_U8_KDSLEN_EARLYCONFIG_TOUCH_COMPLETE];
	struct
	{
		tU8 au8Name[DP_U8_KDSLEN_EARLYCONFIG_TOUCH_TOUCHDRIVERNAME];
		tU8 au8File[DP_U8_KDSLEN_EARLYCONFIG_TOUCH_TOUCHCONFIGFILENAME];
	} tTouchDriverRaw;
}tKDS_EarlyConfig_TouchDriverRaw;

// KDS spare definitions for EarlyConfig_TwoDisplays
#ifndef DP_U8_KDSLEN_EARLYCONFIG2DISPLAYS_COMPLETE
#define DP_U8_KDSLEN_EARLYCONFIG2DISPLAYS_COMPLETE                      (64)
#endif //#ifndef DP_U8_KDSLEN_EARLYCONFIG2DISPLAYS_COMPLETE

#ifndef DP_U8_KDSLEN_EARLYCONFIG2DISPLAYS_TRTIMINGLVDS1
#define DP_U8_KDSLEN_EARLYCONFIG2DISPLAYS_TRTIMINGLVDS1                 (32)
#endif //#ifndef DP_U8_KDSLEN_EARLYCONFIG2DISPLAYS_TRTIMINGLVDS1

#ifndef DP_U8_KDSLEN_EARLYCONFIG2DISPLAYS_TRTIMINGLVDS2
#define DP_U8_KDSLEN_EARLYCONFIG2DISPLAYS_TRTIMINGLVDS2                 (32)
#endif //#ifndef DP_U8_KDSLEN_EARLYCONFIG2DISPLAYS_TRTIMINGLVDS2

#ifndef DP_U8_KDSLEN_EARLYCONFIG_TOUCH2_TOUCHDRIVERNAME
#define DP_U8_KDSLEN_EARLYCONFIG_TOUCH2_TOUCHDRIVERNAME					(64)
#endif //#ifndef DP_U8_KDSLEN_EARLYCONFIG_TOUCH2_TOUCHDRIVERNAME

#ifndef DP_U8_KDSLEN_EARLYCONFIG_TOUCH2_TOUCHCONFIGFILENAME
#define DP_U8_KDSLEN_EARLYCONFIG_TOUCH2_TOUCHCONFIGFILENAME				(64)
#endif //#ifndef DP_U8_KDSLEN_EARLYCONFIG_TOUCH2_TOUCHCONFIGFILENAME

// helper structure for EarlyConfig_TwoDisplays
typedef union
{
	tU8 au8KDSRaw[DP_U8_KDSLEN_EARLYCONFIG2DISPLAYS_COMPLETE];
	struct
	{
		tU8 au8TimingLvds1[DP_U8_KDSLEN_EARLYCONFIG2DISPLAYS_TRTIMINGLVDS1];
		tU8 au8TimingLvds2[DP_U8_KDSLEN_EARLYCONFIG2DISPLAYS_TRTIMINGLVDS2];
	} tTwoDisplaysRaw;
}tKDS_EarlyConfig_TwoDisplaysRaw;

// screen ids
#define EARLYCONFIG_C_U8_SCREENID_HDMI                                          (0x00)
#define EARLYCONFIG_C_U8_SCREENID_LVDS1             (EARLYCONFIG_C_U8_SCREENID_HDMI+1)
#define EARLYCONFIG_C_U8_SCREENID_LVDS2            (EARLYCONFIG_C_U8_SCREENID_LVDS1+1)
#define EARLYCONFIG_C_U8_SCREENID_VGA              (EARLYCONFIG_C_U8_SCREENID_LVDS2+1)
#define EARLYCONFIG_C_U8_SCREENID_LAST                 (EARLYCONFIG_C_U8_SCREENID_VGA)
#define EARLYCONFIG_C_U8_SCREENID_MAX               (EARLYCONFIG_C_U8_SCREENID_LAST+1)
// virtual screen types ... diagnosis specification 1.15 and later - AllianceVirtualScreenType
// ... [0x00] Not used (not configured)
#define EARLYCONFIG_C_U8_SCREENTYPE_UNDEF                                       (0x00)
// ... [0x01] Main HMI
#define EARLYCONFIG_C_U8_SCREENTYPE_MAINHMI      (EARLYCONFIG_C_U8_SCREENTYPE_UNDEF+1)
// ... [0x02] RSE
#define EARLYCONFIG_C_U8_SCREENTYPE_RSE        (EARLYCONFIG_C_U8_SCREENTYPE_MAINHMI+1)
// ... [0x03] Second screen
#define EARLYCONFIG_C_U8_SCREENTYPE_SECONDSCREEN   (EARLYCONFIG_C_U8_SCREENTYPE_RSE+1)
#define EARLYCONFIG_C_U8_SCREENTYPE_LAST    (EARLYCONFIG_C_U8_SCREENTYPE_SECONDSCREEN)
#define EARLYCONFIG_C_U8_SCREENTYPE_MAX             (EARLYCONFIG_C_U8_SCREENTYPE_LAST)

// flush design config file defines
#ifndef DP_U8_KDSLEN_EARLYCONFIGLAYERMANAGER_FLUSHDESIGNCONFIGFILE
#define DP_U8_KDSLEN_EARLYCONFIGLAYERMANAGER_FLUSHDESIGNCONFIGFILE      (64)
#endif //#ifndef DP_U8_KDSLEN_EARLYCONFIG2DISPLAYS_TRTIMINGLVDS2

// touch driver I2C adress define
#define DP_U8_NORLEN_EARLYCONFIG_TOUCHI2CADDRESS                        (12)
#define DP_U8_EARLYCONFIG_TOUCHI2CADDRESS_NOTSET                        (255)

//******************************************************************************
// class for early configuration
//******************************************************************************
class dispvidctrl_tclEarlyConfig
{
public:
	// constructors and destructors
	dispvidctrl_tclEarlyConfig();
	virtual ~dispvidctrl_tclEarlyConfig();

	tBool bLoadKDSEarlyConfig(tVoid);
	tBool bWriteEarlyConfig(tVoid);
	tVoid vTraceInfoEarlyConfig(const char* strIdentifier) const;
	tBool bWriteEarlyConfig_DisplayResolution(const tChar* pStrResolution) const;
	tBool bWriteEarlyConfig_BackwardComp(const tS32 s32BackwardComp) const;
	tBool bWriteEarlyConfig_LowFrequency(const tS32 s32LowFrequency) const;
	tBool bWriteEarlyConfig_RTCDriverName(const tChar* pStrDrivername) const;
	tBool bWriteEarlyConfig_TouchDriverName(const tChar* pStrDrivername) const;
	tBool bWriteEarlyConfig_TouchDriverConfigFile(const tChar* pStrFilename) const;
	tBool bWriteEarlyConfig_TouchDriverI2CAddress(const tChar* pStrI2CAddress) const;
	tBool bWriteEarlyConfig_TouchDriverName2(const tChar* pStrDrivername) const;
	tBool bWriteEarlyConfig_TouchDriverConfigFile2(const tChar* pStrFilename) const;
	tBool bWriteEarlyConfig_TouchDriverI2CAddress2(const tChar* pStrI2CAddress) const;
	tBool bWriteEarlyConfig_TimingLvds1(const tChar* pStrTimingLvds1) const;
	tBool bWriteEarlyConfig_ClockEdgeLvds1(const tS32 s32ClockEdge) const;
	tBool bWriteEarlyConfig_ClockGenerationLvds1(const tS32 s32ClockGeneration) const;
	tBool bWriteEarlyConfig_TimingLvds2(const tChar* pStrTimingLvds1) const;
	tBool bWriteEarlyConfig_ClockEdgeLvds2(const tS32 s32ClockEdge) const;
	tBool bWriteEarlyConfig_ClockGenerationLvds2(const tS32 s32ClockGeneration) const;
	tBool bWriteEarlyConfig_DisplayOrder(const tU8* pu8DisplayOrder) const;
	tBool bWriteEarlyConfig_FlushDesignConfigFile(const tChar* pStrFlushDesignConfigFile) const;

protected:
	// EarlyConfig_Display
	tBool bIsEarlyConfig_DisplayResolutionManuallySet(tVoid) const;
	tBool bIsEarlyConfig_DisplayBackwardCompManuallySet(tVoid) const;
	tBool bIsEarlyConfig_DisplayLowFrequencyManuallySet(tVoid) const;
	tBool bLoadKDSEarlyConfig_Display(tVoid);
	inline tBool bIsLoadedKDSEarlyConfig_Display(tVoid) const {return m_bKDSDisplayLoaded;};
	tBool bIsValidKDSEarlyConfig_Display(tVoid) const;
	tBool bIsChangedEarlyConfig_Display(tVoid) const;
	tBool bWriteEarlyConfig_Display(tVoid);
	tVoid vTraceInfoEarlyConfig_Display(const char* strIdentifier) const;
	tS32 m_s32DisplayBackwardComp;
	tS32 m_s32DisplayLowFrequency;
	tChar m_strDisplayResolution[DP_U8_KDSLEN_EARLYCONFIG_DISPLAY_RESOLUTION];
	tBool m_bKDSDisplayLoaded;
	// EarlyConfig_RTCDriver
	tBool bIsEarlyConfig_RTCDriverManuallySet(tVoid) const;
	tBool bLoadKDSEarlyConfig_RTCDriver(tVoid);
	inline tBool bIsLoadedKDSEarlyConfig_RTCDriver(tVoid) const {return m_bKDSRTCDriverLoaded;};
	tBool bIsValidKDSEarlyConfig_RTCDriver(tVoid) const;
	tBool bIsChangedEarlyConfig_RTCDriver(tVoid) const;
	tBool bWriteEarlyConfig_RTCDriver(tVoid);
	tVoid vTraceInfoEarlyConfig_RTCDriver(const char* strIdentifier) const;
	tChar m_strRTCDriverName[64];
	tBool m_bKDSRTCDriverLoaded;
	// EarlyConfig_TouchDriver
	tBool bIsEarlyConfig_TouchDriverManuallySet(tVoid) const;
	tBool bIsEarlyConfig_TouchDriverConfigFileManuallySet(tVoid) const;
	tBool bIsEarlyConfig_TouchI2CAddressManuallySet(tVoid) const;
	tBool bLoadKDSEarlyConfig_TouchDriver(tVoid);
	inline tBool bIsLoadedKDSEarlyConfig_TouchDriver(tVoid) const {return m_bKDSTouchDriverLoaded;};
	tBool bIsValidKDSEarlyConfig_TouchDriver(tVoid) const;
	tBool bIsChangedEarlyConfig_TouchDriver(tVoid) const;
	tBool bWriteEarlyConfig_TouchDriver(tVoid);
	tVoid vTraceInfoEarlyConfig_TouchDriver(const char* strIdentifier) const;
	tChar m_strTouchDriverName[DP_U8_KDSLEN_EARLYCONFIG_TOUCH_TOUCHDRIVERNAME];
	tChar m_strTouchConfigFileName[DP_U8_KDSLEN_EARLYCONFIG_TOUCH_TOUCHCONFIGFILENAME];
	tU8   m_u8TouchDriverI2CAddress;
	tChar m_strTouchDriverI2CAddress[DP_U8_NORLEN_EARLYCONFIG_TOUCHI2CADDRESS];
	tBool m_bKDSTouchDriverLoaded;
	// EarlyConfig_TwoDisplays
	tBool bIsEarlyConfig_TimingLvds1ManuallySet(tVoid) const;
	tBool bIsEarlyConfig_TimingLvds2ManuallySet(tVoid) const;
	tBool bIsEarlyConfig_ClockEdgeLvds1ManuallySet(tVoid) const;
	tBool bIsEarlyConfig_ClockEdgeLvds2ManuallySet(tVoid) const;
	tBool bIsEarlyConfig_ClockGenerationLvds1ManuallySet(tVoid) const;
	tBool bIsEarlyConfig_ClockGenerationLvds2ManuallySet(tVoid) const;
	tBool bLoadKDSEarlyConfig_TwoDisplays(tVoid);
	inline tBool bIsLoadedKDSEarlyConfig_TwoDisplays(tVoid) const {return m_bKDSTwoDisplaysLoaded;};
	tBool bIsValidKDSEarlyConfig_TwoDisplays(tVoid) const;
	tBool bIsChangedEarlyConfig_TwoDisplays(tVoid) const;
	tBool bWriteEarlyConfig_TwoDisplays(tVoid);
	tVoid vTraceInfoEarlyConfig_TwoDisplays(const char* strIdentifier) const;
	tChar m_strTimingLvds1[DP_U8_KDSLEN_EARLYCONFIG2DISPLAYS_TRTIMINGLVDS1];
	tS8 m_s8ClockEdgeSelectLVDS1;
	tS32 m_s32ClockGenerationLVDS1;
	tChar m_strTimingLvds2[DP_U8_KDSLEN_EARLYCONFIG2DISPLAYS_TRTIMINGLVDS2];
	tS8 m_s8ClockEdgeSelectLVDS2;
	tS32 m_s32ClockGenerationLVDS2;
	tBool m_bKDSTwoDisplaysLoaded;
	// EarlyConfig ... Customer Touch Screen Configuration
	tBool bLoadKDSCustom_TouchScreenConfig(tVoid);
	inline tBool bIsLoadedKDSCustom_TouchScreenConfig(tVoid) const {return m_bKDSCustomTouchScreenLoaded;};
	inline tU8 u8GetTouchScreenConfig(tVoid) const {return m_u8KDSCustomTouchScreen;};
	tBool bIsValidKDSCustom_TouchScreenConfig(tVoid) const;
	const char* cstrGetTouchScreenConfig(tVoid) const;
	const char* cstrGetCustomDisplayDriver(tVoid) const;
	tS32 s32GetCustomDisplayDriverBackwardComp(tVoid) const;
	tS32 s32GetCustomDisplayDriverLowFrequency(tVoid) const;
	tS32 s32GetCustomDisplayDriverClockEdgeSelect(tVoid) const;
	tS32 s32GetCustomDisplayDriverClockGeneration(tVoid) const;
	const char* cstrGetCustomTouchDriver(tVoid) const;
	const char* cstrGetCustomTouchConfigFile(tVoid) const;
	tVoid vTraceInfoEarlyConfig_TouchScreenConfig(const char* strIdentifier) const;
	tU8 m_u8KDSCustomTouchScreen : 4;
	tBool m_bKDSCustomTouchScreenLoaded;
	// EarlyConfig LayerManager
	tBool bLoadKDSearlyConfig_LayerManager(tVoid);
	tU8 u8KDSearlyConfig_LayerManager_SetDisplayOrder(tU8 u8ScreenID, tU8 u8VirtualScreenType, tU8 &u8LastDisplayOrderIndex);
	inline tBool bIsLoadedKDSEarlyConfig_LayerManager(tVoid) const {return m_bKDSLayerManagerLoaded;};
	tBool bIsValidKDSEarlyConfig_LayerManager(tVoid) const;
	tBool bIsExistKDSEarlyConfig_FlushDesignConfigFile(tVoid) const;
	tBool bIsEarlyConfig_DisplayOrder_ManuallySet(tVoid) const;
	tBool bIsEarlyConfig_FlushDesignConfigFile_ManuallySet(tVoid) const;
	tBool bIsChangedEarlyConfig_LayerManager(tVoid) const;
	tBool bWriteEarlyConfig_LayerManager(tVoid);
	tVoid vTraceInfoEarlyConfig_LayerManager(const char* strIdentifier) const;
	tU8 m_u8FlushDesignConfigFile;
	tChar m_strFlushDesignConfigFile[DP_U8_KDSLEN_EARLYCONFIGLAYERMANAGER_FLUSHDESIGNCONFIGFILE];
	tU8 m_au8DisplayOrder[EARLYCONFIG_C_U8_SCREENID_MAX];
	tBool m_bKDSLayerManagerLoaded;
	// EarlyConfig_TwoTouchDriver
	tBool bLoadKDSearlyConfig_TwoTouchDriver(tVoid);
	inline tBool bIsLoadedKDSEarlyConfig_TwoTouchDriver(tVoid) const {return m_bKDSTouchDriverLoaded2;};
	tBool bIsEarlyConfig_TouchDriver2ManuallySet(tVoid) const;
	tBool bIsEarlyConfig_TouchDriverConfigFile2ManuallySet(tVoid) const;
	tBool bIsEarlyConfig_TouchI2CAddress2ManuallySet(tVoid) const;
	tBool bIsValidKDSEarlyConfig_TwoTouchDriver(tVoid) const;
	tBool bIsChangedEarlyConfig_TwoTouchDriver(tVoid) const;
	tBool bIsExistKDSEarlyConfig_TouchConfigFile(const char* strTouchDriverName, const char* strTouchConfigFileName) const;
	tBool bWriteEarlyConfig_TwoTouchDriver(tVoid);
	tVoid vTraceInfoEarlyConfig_TwoTouchDriver(const char* strIdentifier) const;
	tChar m_strTouchDriverName2[DP_U8_KDSLEN_EARLYCONFIG_TOUCH2_TOUCHDRIVERNAME];
	tChar m_strTouchConfigFileName2[DP_U8_KDSLEN_EARLYCONFIG_TOUCH2_TOUCHCONFIGFILENAME];
	tU8   m_u8TouchDriverI2CAddress2;
	tBool m_bKDSTouchDriverLoaded2;
	tChar m_strTouchDriverI2CAddress2[DP_U8_NORLEN_EARLYCONFIG_TOUCHI2CADDRESS];
	tBool m_bTwoTouchChanged;
};

#endif /* DISPVIDCTRL_CONFIG_EARLY_H_ */
