/*
 * dispvidctrl_tclEventObserver.h
 *
 *  Created on: Aug 25, 2015
 *      Author: sgt4kor
 */

#ifndef LVDSKEYOBSERVER_H_
#define LVDSKEYOBSERVER_H_

#include "dispvidctrl_AppMain.h"

#include "dispvidctrl_LvdsThreadHandler.h"
#include "dispvidctrl_tclLvdsMonitor.h"
#include <stdlib.h>
#include <stdio.h>
#include <stdint.h>
#include <string.h>
#include <fcntl.h>
#include <unistd.h>
#include <pthread.h>
#include <errno.h>
#include <sys/inotify.h>
#include <fstream>

#define MAX_SCREEN_SIZE 							      2
#define EVENT_SIZE        ( sizeof (struct inotify_event) )
#define BUFFER_MAX           ( 1024 * ( EVENT_SIZE + 16 ) )
#define FPD_LINK								 "fpd_link"
#define RIN_LOCKED							 "RIN0: locked"
#define TOUCH_DEV_STAT						"touch_dev_stat"
#define TOUCH_DEVICE_ACTV					"touch_device_actv"

class dispvidctrl_LvdsEpoll;

class dispvidctrl_tclLvdsObserver : public dispvidctrl_tclBaseIf
{
public:    
    //Constructor
    dispvidctrl_tclLvdsObserver(dispvidctrl_tclAppMain* poMainAppl);
    virtual ~dispvidctrl_tclLvdsObserver();
    
    virtual const tChar* getName() const { return "dispvidctrl_tclLvdsObserver"; };
    virtual const tChar* getIfName() const { return "dispvidctrl_tclLvdsObserver"; };
    
    virtual tVoid vHandleMessage(dispvidctrl_tclBaseIf::TMsg* pMsg);
    virtual tVoid vHandleTraceMessage(const tUChar* puchData);
    virtual tVoid vGetReferences();
    virtual tVoid vStartCommunication();
    virtual tVoid vTraceInfo();
    
    virtual tVoid vStartCommunicationEarly();
    virtual tVoid vGetReferencesEarly();
    virtual tVoid vGetConfiguration(const TConfiguration* pStConfigurationValues);
    tS32 startObserver();
    tVoid stopObserver();
    tS32 startMonitorThread();
    
    inline tBool isObsRunning() { return bIsObserverActive; }
    LvdsThreadHandler _oLvdsThreadHandler;

    //Thread common callback function for All key Events
    static tVoid* EvObserverCallback(tVoid* pData);
    tVoid addFileToMonitor(char cstrPathToDirectory[],tS32 type = 0);
    static tVoid* TouchControllerCallback(tVoid* pData);

private:
    //Member Variables
    tU8 _u8StartStopRecording;
    static dispvidctrl_tclLvdsObserver* m_poLvdsObserver;
    static std::vector<std::string> m_FileDescList;
    static std::vector<std::string> m_TouchCtrlList;
    static tBool bIsObserverActive;
    static tBool bIsTouchMonitorActive;
#ifndef VARIANT_S_FTR_DISABLE_FOR_GEN4_TEMP
    tBool bCurrentState[];
#endif
	dispvidctrl_tclLvdsMonitor* m_poLvdsMonitor;
    tVoid handleEvent();
    tVoid removeFilesToMonitor();
};

#endif /* LVDSKEYOBSERVER_H_ */
