/************************************************************************
* FILE:        dispvidctrl_tclTouchDriverControl.h
* PROJECT:
* SW-COMPONENT:vd_dimming
*----------------------------------------------------------------------
*
* DESCRIPTION: interface class for touch driver control
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author             | Modification
* 04.07.2017| CM-AI/EPB2 Bernard | init
*
*************************************************************************/

#ifndef DIMMING_COMMON_DISPVIDCTRL_TCLTOUCHDRIVERCONTROL_H_
#define DIMMING_COMMON_DISPVIDCTRL_TCLTOUCHDRIVERCONTROL_H_

#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#endif //#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC

//include base class
#include "I_dispvidctrl_tclTouchDriverControl.h"

/*******************************************************************************
| class definition
|-----------------------------------------------------------------------------*/
class dispvidctrl_tclTouchDriverControl : public I_dispvidctrl_tclTouchDriverControl
{
public:
    // constructors and destructors
	dispvidctrl_tclTouchDriverControl(tVoid);
	dispvidctrl_tclTouchDriverControl(const dispvidctrl_tclAppMain* poMainAppl);
	virtual ~dispvidctrl_tclTouchDriverControl();

	virtual const tChar* getName() const { return "dispvidctrl_tclTouchDriverControl"; };

	virtual tVoid vHandleMessage(dispvidctrl_tclBaseIf::TMsg* pMsg);
	virtual tVoid vHandleTraceMessage(const tUChar* puchData);
	virtual tVoid vGetReferences();
	virtual tVoid vStartCommunication();
	virtual tVoid vTraceInfo();

	virtual tS32 s32StartDriver(const tU8 u8Index);
	virtual tS32 s32StopDriver(const tU8 u8Index);
	virtual tS32 s32RestartDriver(const tU8 u8Index);
	virtual const char* cstrGetDriverName(const tU8 u8Index) const;

protected:
	tS32 s32TraceStatusDriver(const tU8 u8Index) const;
	tS32 s32StartDriver(const char* cstrDriverName);
	tS32 s32StopDriver(const char* cstrDriverName);
	tenTOUCH_DRV_STATE m_aenState[EARLY_CONFIG_TOUCHDRIVER_MAX];
};

#endif /* DIMMING_COMMON_DISPVIDCTRL_TCLTOUCHDRIVERCONTROL_H_ */
