/************************************************************************
* FILE:        dispvidctrl_tclDisplaySettings.h
* PROJECT:
* SW-COMPONENT:vd_dimming
*----------------------------------------------------------------------
*
* DESCRIPTION: definition of display settings class
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author             | Modification
* 17.11.2015| CM-AI/EPB2 Bernard | init
*
*************************************************************************/

#ifndef DISPVIDCTRL_TCLDISPLAYSETTINGS_H_
#define DISPVIDCTRL_TCLDISPLAYSETTINGS_H_

#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#endif //#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC

//include base class
#include "I_dispvidctrl_tclDisplaySettings.h"
#include "I_dispvidctrl_ServiceDimmingIf.h"

/*******************************************************************************
| includes of CSC and DRM
|-----------------------------------------------------------------------------*/
#ifdef VARIANT_S_FTR_ENABLE_DISPLAYSETTINGS_CSC
#include <ilm/ilm_control.h>
#include <unistd.h>
#endif //#ifdef VARIANT_S_FTR_ENABLE_DISPLAYSETTINGS_CSC

#ifdef VARIANT_S_FTR_ENABLE_DISPLAYSETTINGS_GAMMA
#ifndef VARIANT_S_FTR_ENABLE_DISPLAYSETTINGS_CSC
#include <ilm/ilm_control.h>
#endif //#ifndef VARIANT_S_FTR_ENABLE_DISPLAYSETTINGS_CSC
#include <ilm/ilm_client.h>
#endif //#ifdef VARIANT_S_FTR_ENABLE_DISPLAYSETTINGS_GAMMA

// class forward declarations
class I_dispvidctrl_tclSyncHandler;
class dispvidctrl_tclClientDimming;
/*******************************************************************************
| class definition
|-----------------------------------------------------------------------------*/
class dispvidctrl_tclDisplaySettings : public I_dispvidctrl_tclDisplaySettings
{
public:
    // constructors and destructors
	dispvidctrl_tclDisplaySettings(tVoid);
	dispvidctrl_tclDisplaySettings(const dispvidctrl_tclAppMain* poMainAppl);
	virtual ~dispvidctrl_tclDisplaySettings();

	virtual const tChar* getName() const { return "dispvidctrl_tclDisplaySettings"; };

	virtual tVoid vHandleMessage(dispvidctrl_tclBaseIf::TMsg* pMsg);
	virtual tVoid vHandleTraceMessage(const tUChar* puchData);
	virtual tVoid vGetReferences();
	virtual tVoid vStartCommunication();
	virtual tVoid vTraceInfo();

	virtual tU8 u8GetContrastLevel(tVoid) const {return m_u8ContrastLevel;};
	virtual tS32 s32SetContrastLevel(tU8 u8Level);
	virtual tU8 u8GetSaturationLevel(tVoid) const {return m_u8SaturationLevel;};
	virtual tS32 s32SetSaturationLevel(tU8 u8Level);
	virtual tU8 u8GetColorLevel(tVoid) const {return m_u8ColorLevel;};
	virtual tS32 s32SetColorLevel(tU8 u8Level);
	virtual tU8 u8GetBlackLevel(tVoid) const {return m_u8BlackLevel;};
	virtual tS32 s32SetBlackLevel(tU8 u8Level);
	virtual tU8 u8GetGammaLevel(tVoid) const {return m_u8GammaLevel;};
	virtual tS32 s32SetGammaLevel(tU8 u8Level);

	virtual tS32 s32ResetDisplaySettings(tVoid);

	// access to brightness enhancement (AIVI-22378)
	virtual tS32 s32EnhanceBrightness(tU8 u8Level, tU8 u8Mode);
    virtual tVoid vSetDimmingModeRvc(tVoid);
   virtual tVoid vUpdateDisplaySettings(tBool bIsInit);

protected:
	// color space conversion
	tVoid vInitCSC(tVoid);
	tS32 s32UpdateCSC(tVoid);
	tS32 s32ResetCSC(tVoid);
	tVoid vTraceCSC(const char* strIdentifier) const;
	// access to Hue
	tS16 s16GetHueCSC(tVoid) const;
	tS32 s32SetHueCSC(tS16 s16Degree);
	tS16 s16GetHueOffsetCSC(tVoid) const;
	tS32 s32SetHueOffsetCSC(tS16 s16Degree);
	// access to Saturation
	tS16 s16GetSaturationCSC(tVoid) const;
	tS32 s32SetSaturationCSC(tS16 s16Percent);
	tS16 s16GetSaturationOffsetCSC(tVoid) const;
	tS32 s32SetSaturationOffsetCSC(tS16 s16Percent);
	// access to Brightness
	tS16 s16GetBrightnessCSC(tVoid) const;
	tS32 s32SetBrightnessCSC(tS16 s16Percent);
	tS16 s16GetBrightnessOffsetCSC(tVoid) const;
	tS32 s32SetBrightnessOffsetCSC(tS16 s16Percent);
	// access to Contrast
	tS16 s16GetContrastCSC(tVoid) const;
	tS32 s32SetContrastCSC(tS16 s16Percent);
	// gamma adjustment of direct rendering manager
	tVoid vInitDRM(tVoid);
	tS32 s32UpdateDRM(tVoid);
	tS32 s32ResetDRM(tVoid);
	tVoid vTraceDRM(const char* strIdentifier) const;
	// access to Gamma Exponent
	tU16 u16GetGammaExponent(tVoid) const;
	tS32 s32SetGammaExponent(tU16 u16Exponent);
	// access to brightness enhancement (AIVI-22378)
	tS16 s16GetEnhanceBrightnessOffset(tVoid) const;
	// init layer manager interface
#if (defined VARIANT_S_FTR_ENABLE_DISPLAYSETTINGS_GAMMA) || (defined VARIANT_S_FTR_ENABLE_DISPLAYSETTINGS_CSC)
	ilmErrorTypes enInitILM(tVoid);
#endif //#if (defined VARIANT_S_FTR_ENABLE_DISPLAYSETTINGS_GAMMA) || (defined VARIANT_S_FTR_ENABLE_DISPLAYSETTINGS_CSC)

	// attributes of brightness enhancement (AIVI-22378)
#ifdef VARIANT_S_FTR_ENABLE_BRIGHTNESS_ENHANCEMENT
	tU8 m_au8DimBrightnessLevel[2];        // extended brightness level for day (idx 0) and night (idx 1)
	tU8 m_u8DimMode;
#endif //#ifdef VARIANT_S_FTR_ENABLE_BRIGHTNESS_ENHANCEMENT
	tU8 m_DayBrightness,m_NightBrightness;	//Used to store backup value when going in camera screen
	// levels of color space conversion
	tU8 m_u8ContrastLevel;
	tU8 m_u8SaturationLevel;
	tU8 m_u8ColorLevel;
	tU8 m_u8GammaLevel;
	tU8 m_u8BlackLevel;

	Idispvidctrl_tclServiceDimmingIf* m_poSrvDim;
    I_dispvidctrl_tclSyncHandler*     m_poSyncHandler;
    dispvidctrl_tclClientDimming*	m_poClientDim;
    tBool m_bCscInitDone;
    // layer manager interface initialized
	tBool m_bILMInit;
	// screen id of MAIN HMI
	tU8 m_u8DRM_MainHmi_ScreenID;

#ifdef VARIANT_S_FTR_ENABLE_DISPLAYSETTINGS_CSC
	// CSC properties of layer manager interface
	ilmCSCProperties m_tCSCProp;
	// brightness offset
	tS16 m_s16BrightnessOffset;
#endif //#ifdef VARIANT_S_FTR_ENABLE_DISPLAYSETTINGS_CSC

#ifdef VARIANT_S_FTR_ENABLE_DISPLAYSETTINGS_GAMMA
	// gama exponent of direct rendering manager ... 1000 = 1.000
	tU16 m_u16DRM_GammaExponent;
#endif //#ifdef VARIANT_S_FTR_ENABLE_DISPLAYSETTINGS_GAMMA

   tBool m_bDisplaySettingsInitDone;
};

#endif /* DISPVIDCTRL_TCLDISPLAYSETTINGS_H_ */
