/************************************************************************
* FILE:        dispvidctrl_tclBacklightError.h
* PROJECT:
* SW-COMPONENT:vd_dimming
*----------------------------------------------------------------------
*
* DESCRIPTION: definition of back light error detection class
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author             | Modification
* 17.10.2016| CM-AI/EPB2 Bernard | init
*
*************************************************************************/

#ifndef DISPVIDCTRL_TCLBACKLIGHTERROR_H_
#define DISPVIDCTRL_TCLBACKLIGHTERROR_H_

#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#endif //#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC

//include base class
#include "I_dispvidctrl_tclBacklightError.h"

#define DIM_C_U8_BACKLIGHTERROR_MAXERRORS     (2)
#define DIM_C_U8_BACKLIGHTERROR_MAXINPUTS     (20)
#define DIM_C_U8_BACKLIGHTERROR_MAXBUFLEN     (32)
#define DIM_C_U32_BACKLIGHTERROR_CYCLETIME_MS (1000)

#define DIM_C_STR_BACKLIGHTERROR_INPUTPATH    "/sys/class/input"
#define DIM_C_STR_BACKLIGHTERROR_DELIMITER    "/"
#define DIM_C_STR_BACKLIGHTERROR_INPUTDIRNAME "input"            // e.g.: input%2d --> input9
#define DIM_C_STR_BACKLIGHTERROR_BERRORNAME   "backlight_error"  // e.g.: backlight_error%1d --> backlight_error1
#define DIM_C_U32_BACKLIGHTERROR_MAXPATHLEN   ( sizeof(DIM_C_STR_BACKLIGHTERROR_INPUTPATH) \
		+ sizeof(DIM_C_STR_BACKLIGHTERROR_DELIMITER) \
		+ sizeof(DIM_C_STR_BACKLIGHTERROR_INPUTDIRNAME) + 2 \
		+ sizeof(DIM_C_STR_BACKLIGHTERROR_DELIMITER) \
		+ sizeof(DIM_C_STR_BACKLIGHTERROR_BERRORNAME) + 1 + 1 )

// back light error GPIN states
typedef enum {
	enBERR_undef = 0,
	enBERR_unexist,
	enBERR_zero,
	enBERR_one,
	enBERR_max,
	enBERR_size
} tenBERR_State;

// structure of back light error information
struct tBERR_GpinInfo {
	char strPath[DIM_C_U32_BACKLIGHTERROR_MAXPATHLEN];
	tenBERR_State enState : 8;
	tenBERR_State enSimulateState : 8;
};

#define DIM_C_U8_BACKLIGHTERROR_ACTIVE     (enBERR_zero)
#define DIM_C_U8_BACKLIGHTERROR_INACTIVE   (enBERR_one)

/*******************************************************************************
| class definition
|-----------------------------------------------------------------------------*/
class dispvidctrl_tclBacklightError : public I_dispvidctrl_tclBacklightError
{
public:
    // constructors and destructors
	dispvidctrl_tclBacklightError(tVoid);
	dispvidctrl_tclBacklightError(const dispvidctrl_tclAppMain* poMainAppl);
	virtual ~dispvidctrl_tclBacklightError();

	virtual const tChar* getName() const { return "dispvidctrl_tclBacklightError"; };

	virtual tVoid vHandleMessage(dispvidctrl_tclBaseIf::TMsg* pMsg);
	virtual tVoid vHandleTraceMessage(const tUChar* puchData);
	virtual tVoid vGetReferences();
	virtual tVoid vStartCommunication();
	virtual tVoid vTraceInfo();

protected:
	// trace
	tVoid vTraceBEerr(const char* strIdentifier) const;
	tS32 s32SetSimulateState(tU8 u8GPin, tU8 u8State);
	inline tBool bIsSimuActive(tU8 u8GPin) const
	{
		if (DISPVIDCTRL_C_U16_ARRAYELEMENTS(m_tErrorInfo) > u8GPin)
		{
			if ((DIM_C_U8_BACKLIGHTERROR_ACTIVE == m_tErrorInfo[u8GPin].enSimulateState)
				|| (DIM_C_U8_BACKLIGHTERROR_INACTIVE == m_tErrorInfo[u8GPin].enSimulateState))
			{
				return TRUE;
			}
		}
		return FALSE;
	}
	// timer call back and handle#
	static OSAL_tpfCallback cb_vTimer(tVoid* pArg);
	OSAL_tTimerHandle m_hTimer;
	// monitor back light error devices
	tVoid vMonitor(tVoid);
	// update back light error detection state
	tVoid vUpdateDetetctionState(tVoid);
	// find back light error device path
	tVoid vFindGPIN(tU16 u16Idx);
	// read specified back light error GPIN
	tenBERR_State enReadGPIN(const char* cstrPath) const;
	// back light error GPIN device information
	tBERR_GpinInfo m_tErrorInfo[DIM_C_U8_BACKLIGHTERROR_MAXERRORS];
	// display active
	tBool m_bDisplayActive;
	// back light error state not handled
	tBool m_bStateNotHandled;
};

#endif /* DISPVIDCTRL_TCLBACKLIGHTERROR_H_ */
