/************************************************************************
* FILE:        I_dispvidctrl_tclDisplaySettings.h
* PROJECT:
* SW-COMPONENT:vd_dimming
*----------------------------------------------------------------------
*
* DESCRIPTION: interface class for display settings
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author             | Modification
* 17.11.2015| CM-AI/EPB2 Bernard | init
*
*************************************************************************/

#ifndef I_DISPVIDCTRL_TCLDISPLAYSETTINGS_H_
#define I_DISPVIDCTRL_TCLDISPLAYSETTINGS_H_

#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#endif //#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC

#include "dispvidctrl_AppMain.h"
#ifndef DISPVIDCTRL_TCLTYPES_H_
#include "dispvidctrl_tclTypes.h"
#endif //#ifndef DISPVIDCTRL_TCLTYPES_H_

class I_dispvidctrl_tclDisplaySettings : public dispvidctrl_tclBaseIf
{
public:
	// constructor
	I_dispvidctrl_tclDisplaySettings(tVoid);
	I_dispvidctrl_tclDisplaySettings(const dispvidctrl_tclAppMain* poMainAppl) : dispvidctrl_tclBaseIf(poMainAppl) {;};
   // destructor
   virtual ~I_dispvidctrl_tclDisplaySettings(){};

   virtual const tChar* getIfName() const { return "I_dispvidctrl_tclDisplaySettings"; };

	virtual tU8 u8GetContrastLevel(tVoid) const = 0;
	virtual tS32 s32SetContrastLevel(tU8 u8Level) = 0;
	virtual tU8 u8GetSaturationLevel(tVoid) const = 0;
	virtual tS32 s32SetSaturationLevel(tU8 u8Level) = 0;
	virtual tU8 u8GetColorLevel(tVoid) const = 0;
	virtual tS32 s32SetColorLevel(tU8 u8Level) = 0;
	virtual tU8 u8GetBlackLevel(tVoid) const = 0;
	virtual tS32 s32SetBlackLevel(tU8 u8Level) = 0;
	virtual tU8 u8GetGammaLevel(tVoid) const = 0;
	virtual tS32 s32SetGammaLevel(tU8 u8Level) = 0;

	virtual tS32 s32ResetDisplaySettings(tVoid) = 0;
	virtual tVoid vSetDimmingModeRvc(tVoid) = 0;
	// access to brightness enhancement (AIVI-22378)
	virtual tS32 s32EnhanceBrightness(tU8 u8Level, tU8 u8Mode) = 0;
};

#endif /* I_DISPVIDCTRL_TCLDISPLAYSETTINGS_H_ */
