/************************************************************************
* FILE:        dispvidctrl_tclGstIpa.h
* PROJECT:
* SW-COMPONENT: DisplayVideoController
*----------------------------------------------------------------------
*
* DESCRIPTION: Audio player module
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author             | Modification
* 19.11.2017| RBEI/ECV4 deo2kor  | init
*
*************************************************************************/
#ifndef _DISPVIDCTRL_TCLGSTIPA_H_
#define _DISPVIDCTRL_TCLGSTIPA_H_

/*******************************************************************************
                        Includes
*******************************************************************************/
#include "dispvidctrl_AppMain.h"
#include "dispvidctrl_tclGstAudioPipeline.h"

/*******************************************************************************
                        Defines
*******************************************************************************/



/*******************************************************************************
   Class
*******************************************************************************/
class dispvidctrl_tclGstIpa : public dispvidctrl_tclGstAudioPipeline
{
public:

      dispvidctrl_tclGstIpa(tVoid);
      dispvidctrl_tclGstIpa(const TEarlyConfiguration& tEarlyConfig);
      virtual ~dispvidctrl_tclGstIpa();

      // Ipa interface
      virtual tBool bInit(GMainLoop *pGstMainLoop);
      
      virtual tVoid vGetConfiguration(const TConfiguration* pStConfigurationValues);
      
      virtual tVoid vUpdateIpaRequest(const tU8 Request);
      virtual tVoid vStart(); 
      virtual tVoid vPause();
      virtual tVoid vStop();
      
      virtual tVoid vTraceDebugInformation(tVoid);
      
      virtual tVoid vSetAlsaDeviceName(const tChar* szDevName);

private:

      virtual tBool bSetIpaAudioFilePath() const;

      static gboolean bBusCall(GstBus *bus, GstMessage *msg,gpointer data);

      tVoid vAudioPlayerInit();

      tU32    _u32HmiLanguage;
      tU8     _u8IpaActiveRequestId;
      tBool   _bIpaActive;      
      tChar*  _szDevName;

      static dispvidctrl_tclGstIpa*   _poMyStaticRef;
};

#endif // _DISPVIDCTRL_TCLGSTIPA_H_

