/************************************************************************
* FILE:        dispvidctrl_tclAudioPlayer.h
* PROJECT:
* SW-COMPONENT: DisplayVideoController
*----------------------------------------------------------------------
*
* DESCRIPTION: Audio player module
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author             | Modification
* 19.11.2017| RBEI/ECV4 deo2kor  | init
*
*************************************************************************/
#ifndef _DISPVIDCTRL_TCL_AudioPlayer_H_
#define _DISPVIDCTRL_TCL_AudioPlayer_H_

/*******************************************************************************
                        Includes
*******************************************************************************/
#include <glib.h>
#include <glib-unix.h>
#include <gst/gst.h>

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "I_dispvidctrl_tclAudioPlayer.h"

/*******************************************************************************
                        Defines
*******************************************************************************/


class dispvidctrl_tclGstIpa;
/*******************************************************************************
   Class
*******************************************************************************/
class dispvidctrl_tclAudioPlayer : public I_dispvidctrl_tclAudioPlayer
{
public:

      dispvidctrl_tclAudioPlayer(dispvidctrl_tclAppMain* poMainAppl);
      virtual ~dispvidctrl_tclAudioPlayer();

      virtual const tChar* getName() const { return "dispvidctrl_tclAudioPlayer"; };

      virtual tVoid vHandleMessage(dispvidctrl_tclBaseIf::TMsg* pMsg);
      virtual tVoid vHandleTraceMessage(const tUChar* puchData);
      virtual tVoid vGetReferences();
      virtual tVoid vStartCommunication();
      virtual tVoid vTraceInfo();

      virtual tVoid vGetConfiguration(const TConfiguration* pStConfigurationValues);
      
      virtual tVoid vSetAlsaDeviceName(const tChar* cDevName);

      // Ipa interface
      virtual tVoid vPrepareIpaRequest(const tU8 u8RequestId);
      virtual tVoid vActivateIpaAudio(const tBool bActivate);
      
      virtual tVoid vPauseIpaAudio();
      virtual tVoid vResumeIpaAudio();

private:

      tVoid vStartAudioPlayer();
      tVoid vAudioPlayerInit();

      static tVoid vAudioPlayerThread(tVoid *pvArg);
      
      tU8                                  _u8DeviceVariant;
      TEarlyConfiguration                  _tEarlyConfig;
      
      dispvidctrl_tclGstIpa*               _poIpaPipeline;

      static dispvidctrl_tclAudioPlayer*   _poMyStaticRef;
};
#endif

