/******************************************************************************/
/**
* \file    dispvidctrl_tclGstAudioPlayer.cpp
* \ingroup
*
* \brief
*
* \remark  Copyright : (c) 2015 Robert Bosch GmbH, Hildesheim
* \remark  Author    : deo2kor
* \remark  Scope     : AIVI
*
* \todo
*/
/******************************************************************************/

/*******************************************************************************
                        Includes
*******************************************************************************/

#include "dispvidctrl_tclAudioPlayer.h"
#include "dispvidctrl_tclGstIpa.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_DISPVIDCTRL_CLIENT_AUDIOPLAYER
#include "trcGenProj/Header/dispvidctrl_tclAudioPlayer.cpp.trc.h"
#endif

/*******************************************************************************
                        Defines
*******************************************************************************/
#define AUDIOPLAYER_STACKSIZE 2048
#define AUDIOPLAYER_PRIORITY   100

GMainLoop *mainaudioplayerloop = NULL;
dispvidctrl_tclAudioPlayer* dispvidctrl_tclAudioPlayer::_poMyStaticRef = NULL;


dispvidctrl_tclAudioPlayer::dispvidctrl_tclAudioPlayer(dispvidctrl_tclAppMain* poMainAppl) 
: I_dispvidctrl_tclAudioPlayer(poMainAppl)
{
   _poMyStaticRef = this;
   _poIpaPipeline = NULL;
   _u8DeviceVariant = 0;
   //CID: 144711
// initialising it to zero. to check with FO if there is any particular default values to be assigned for the struct members 
   _tEarlyConfig = {0};
}

dispvidctrl_tclAudioPlayer::~dispvidctrl_tclAudioPlayer()
{
   _poMyStaticRef = NULL;

   if ( _poIpaPipeline )
   {
      delete _poIpaPipeline;
      _poIpaPipeline = NULL;
   }
}

tVoid dispvidctrl_tclAudioPlayer::vHandleMessage(dispvidctrl_tclBaseIf::TMsg* pMsg)
{
   ETG_TRACE_FATAL(("[%d ms] dispvidctrl_tclAudioPlayer::vHandleMessage() entered.", OSAL_ClockGetElapsedTime()));
}

tVoid dispvidctrl_tclAudioPlayer::vHandleTraceMessage(const tUChar* puchData)
{
   ETG_TRACE_FATAL(("[%d ms] dispvidctrl_tclAudioPlayer::vHandleTraceMessage() entered.", OSAL_ClockGetElapsedTime()));
}

tVoid dispvidctrl_tclAudioPlayer::vGetReferences()
{
   ETG_TRACE_FATAL(("[%d ms] dispvidctrl_tclAudioPlayer::vGetReferences() entered.", OSAL_ClockGetElapsedTime()));
}

tVoid dispvidctrl_tclAudioPlayer::vStartCommunication()
{
   ETG_TRACE_FATAL(("[%d ms] dispvidctrl_tclAudioPlayer::vStartCommunication() entered.", OSAL_ClockGetElapsedTime()));
   vStartAudioPlayer();
}

tVoid dispvidctrl_tclAudioPlayer::vTraceInfo()
{
   ETG_TRACE_FATAL(("[%d ms] dispvidctrl_tclAudioPlayer::vTraceInfo() entered.", OSAL_ClockGetElapsedTime()));
   
   if (_poIpaPipeline) {
      _poIpaPipeline->vTraceDebugInformation();
   } else {
      ETG_TRACE_FATAL(("dispvidctrl_tclAudioPlayer::vTraceInfo(): _poIpaPipeline is NULL"));
   }
}

tVoid dispvidctrl_tclAudioPlayer::vGetConfiguration(const TConfiguration* pStConfigurationValues)
{
   ETG_TRACE_FATAL(("[%d ms] dispvidctrl_tclAudioPlayer::vGetConfiguration() entered.", OSAL_ClockGetElapsedTime()));
   if (pStConfigurationValues)
   {
      _u8DeviceVariant = pStConfigurationValues->u8DeviceVariantType;
   }
}

tVoid dispvidctrl_tclAudioPlayer::vSetAlsaDeviceName(const tChar* cDevName)
{
   ETG_TRACE_USR4(("dispvidctrl_tclAudioPlayer::vSetAlsaDeviceName() entered"));

   if (_poIpaPipeline)
   {
      _poIpaPipeline->vStart();
   }
   else
   {
      ETG_TRACE_ERR(("dispvidctrl_tclAudioPlayer::vSetAlsaDeviceName() _poIpaPipeline is NULL"));
   }
}

// Ipa interface
tVoid dispvidctrl_tclAudioPlayer::vActivateIpaAudio(const tBool bActivate)
{
   ETG_TRACE_FATAL(("dispvidctrl_tclAudioPlayer::vActivateIpaAudio() bActivate %u", bActivate));

   if (_poIpaPipeline)
   {
      if (bActivate) {
         _poIpaPipeline->vStart();
      } else {
         _poIpaPipeline->vStop();
      }
   }
   else
   {
      ETG_TRACE_ERR(("dispvidctrl_tclAudioPlayer::vActivateIpaAudio() _poIpaPipeline is NULL"));
   }
}

tVoid dispvidctrl_tclAudioPlayer::vPrepareIpaRequest(const tU8 u8RequestId)
{
   ETG_TRACE_FATAL(("dispvidctrl_tclAudioPlayer::vPrepareIpaRequest() u8RequestId %u", u8RequestId));

   if (_poIpaPipeline)
   {
      _poIpaPipeline->vUpdateIpaRequest(u8RequestId);
   }
   else
   {
      ETG_TRACE_FATAL(("dispvidctrl_tclAudioPlayer::vPrepareIpaRequest() _poIpaPipeline is NULL"));
   }
}

tVoid dispvidctrl_tclAudioPlayer::vPauseIpaAudio()
{
   if (_poIpaPipeline)
      _poIpaPipeline->vPause();
}

tVoid dispvidctrl_tclAudioPlayer::vResumeIpaAudio()
{
   if (_poIpaPipeline)
      _poIpaPipeline->vStart();
}


tVoid dispvidctrl_tclAudioPlayer::vStartAudioPlayer()
{
   OSAL_trThreadAttribute rAttr;
   tC8                    szThreadName[] = "dispvidctrlaudplayer";

   rAttr.szName       = szThreadName;

   rAttr.s32StackSize = AUDIOPLAYER_STACKSIZE;
   rAttr.u32Priority  = AUDIOPLAYER_PRIORITY;

   rAttr.pfEntry      = (OSAL_tpfThreadEntry)vAudioPlayerThread;
   rAttr.pvArg        = ( tPVoid ) this;

   OSAL_tThreadID hThreadId = OSAL_ThreadSpawn(&rAttr);

   if ( hThreadId == OSAL_ERROR ){
       ETG_TRACE_ERR( ( "[%d ms] dispvidctrl_tclVideoPlayer::vStartVideoPlayer(): Failed to spawn thread!", OSAL_ClockGetElapsedTime() ) );
   }
}


tVoid dispvidctrl_tclAudioPlayer::vAudioPlayerInit()
{
   ETG_TRACE_FATAL( ( "[%d ms] dispvidctrl_tclVideoPlayer::vAudioPlayerInit(): entered!", OSAL_ClockGetElapsedTime() ) );
   
   if ( _u8DeviceVariant == 0x02 ) // Only needed if DA variant
   {
      int myargc = 2;
      const char* argument[2]= {(const char*)"--gst-disable-registry-update", (const char*)"--gst-debug-disable"};
      char** myargv =(char**)argument;
      
      gst_init(&myargc, &myargv);
      
      mainaudioplayerloop = g_main_loop_new (NULL, false);
      
      DISPVIDCTRL_NULL_POINTER_CHECK(_cpoMain);
      _cpoMain->vGetEarlyConfig(_tEarlyConfig);
      
      _poIpaPipeline = new dispvidctrl_tclGstIpa(_tEarlyConfig);
      DISPVIDCTRL_NULL_POINTER_CHECK(_poIpaPipeline);
      
      _poIpaPipeline->bInit(mainaudioplayerloop);
      
      g_main_loop_run(mainaudioplayerloop);
   }
}


tVoid dispvidctrl_tclAudioPlayer::vAudioPlayerThread(tVoid *pvArg)
{
   dispvidctrl_tclAudioPlayer* myPtr = static_cast<dispvidctrl_tclAudioPlayer*>(pvArg);
   DISPVIDCTRL_NULL_POINTER_CHECK(myPtr);
   
   myPtr->vAudioPlayerInit();
   OSAL_vThreadExit();

   return;
}
