/************************************************************************
* FILE:        VD_EARLYNorData.h
* PROJECT:     NISSAN A-IVI
* SW-COMPONENT:DisplayVideoManager
*----------------------------------------------------------------------
*
* DESCRIPTION: KDS - PDD dimming configuration default values
*
*----------------------------------------------------------------------
* COPYRIGHT:   (c) 2015 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author               | Modification
* 15.12.2015| CM-CI1/ERN2-E Kollai | init
*
*************************************************************************/

#ifndef VD_EARLYNorData_H_
#define VD_EARLYNorData_H_

typedef enum 
{
  CAMERA_TYPE_NONE = 0,
  CAMERA_TYPE_RVC,
  CAMERA_TYPE_AVM_LOW,
  CAMERA_TYPE_AVM_HIGH,
  CAMERA_TYPE_AVM_IPA,
  CAMERA_TYPE_AVM_ENTRY,  
  CAMERA_TYPE_AVM_PHASE3,
  CAMERA_TYPE_MVC,
  CAMERA_TYPE_RVC_RENAULT,
  CAMERA_TYPE_AVM_ENTRY_RENAULT,
  CAMERA_TYPE_AVM_FAP
} enCameraSystemType;

typedef enum {
  DISPLAY_ORIENTATION_LANDSCAPE = 0,
  DISPLAY_ORIENTATION_PORTRAIT = 1
} TenDisplayOrientation;

// Early NOR defaults
#define DEFAULT_SPMAUTOMODE                           1
#define DEFAULT_RVCDAYNIGHT                           1
#define DEFAULT_RVCCOLOURDAY                          50
#define DEFAULT_RVCCONTRASTDAY                        50
#define DEFAULT_RVCBRIGHTNESSDAY                      30
#define DEFAULT_RVCHUEDAY                             127
#define DEFAULT_RVCBLACKLEVELDAY                      20
#define DEFAULT_RVCCOLOURNIGHT                        50
#define DEFAULT_RVCCONTRASTNIGHT                      50
#define DEFAULT_RVCBRIGHTNESSNIGHT                    30
#define DEFAULT_RVCHUENIGHT                           127
#define DEFAULT_RVCBLACKLEVELNIGHT                    20
#define DEFAULT_GUIDELINEWARNINGLANGUAGE              3
#define DEFAULT_GUIDELINEVISIBILITYMODE               1
#define DEFAULT_AVM_LANGUAGE                          0

#define VIDEO_SETTING_DEFAULTS_DAY    DEFAULT_RVCCOLOURDAY, DEFAULT_RVCCONTRASTDAY, DEFAULT_RVCBRIGHTNESSDAY, DEFAULT_RVCHUEDAY, DEFAULT_RVCBLACKLEVELDAY
#define VIDEO_SETTING_DEFAULTS_NIGHT  DEFAULT_RVCCOLOURNIGHT, DEFAULT_RVCCONTRASTNIGHT, DEFAULT_RVCBRIGHTNESSNIGHT, DEFAULT_RVCHUENIGHT, DEFAULT_RVCBLACKLEVELNIGHT
#define VIDEO_SETTING_DEFAULTS        VIDEO_SETTING_DEFAULTS_DAY, VIDEO_SETTING_DEFAULTS_NIGHT
#define GUIDELINE_SETTING_DEFAULTS    DEFAULT_GUIDELINEWARNINGLANGUAGE, DEFAULT_GUIDELINEVISIBILITYMODE

#define EARLY_NOR_DEFAULT_VALUES      DEFAULT_SPMAUTOMODE, VIDEO_SETTING_DEFAULTS, GUIDELINE_SETTING_DEFAULTS, DEFAULT_AVM_LANGUAGE


// Early NOR Force Defaults
#define DEFAULT_RVCLOWSPEEDTHRESHOLD                  1000
#define DEFAULT_RVCHIGHSPEEDTHRESHOLD                 1500
#define DEFAULT_RVCREVERSEOFFGUARDTIME                8
#define DEFAULT_STEERING_POSITION                     0
#define DEFAULT_GUIDELINECAMERATYPE                   1
#define DEFAULT_GUIDELINECAMERASYSTEMTYPE             CAMERA_TYPE_NONE
#define DEFAULT_GUIDELINEWARNINGTEXTBACKGROUND        1
#define DEFAULT_GUIDELINEWARNINGTEXT                  1
#if defined(VARIANT_S_FTR_ENABLE_AIVI_SCOPE2_1)
  #define DEFAULT_BRAND                               0  //Renault
  #define DEFAULT_OPENINGANIMATION                    0  //Renault
#elif defined(VARIANT_S_FTR_ENABLE_AIVI_NPIVI)
  #define DEFAULT_BRAND                               2  //Infiniti
  #define DEFAULT_OPENINGANIMATION                    2  //Infiniti
#else
  #define DEFAULT_BRAND                               1  //Nissan
  #define DEFAULT_OPENINGANIMATION                    1  //Nissan
#endif
#define DEFAULT_DISPLAYASPECTRATIO                    2
#define DEFAULT_GUIDELINEVISIBILITY                   1
#define DEFAULT_VEHICLE_TYPE                          0xFFFF  // == DISPVIDCTRL_VEHICLE_TYPE_UNKNOWN from dispvidctrl_datapool.h

#define DEFAULT_CAMERA_CONNECTION_TYPE                1
#if defined(VARIANT_S_FTR_ENABLE_AIVI_NPIVI)
  #define DEFAULT_CAMERAWIDTH                         1280
  #define DEFAULT_CAMERAHEIGHT                        720
#else
  #define DEFAULT_CAMERAWIDTH                         800
  #define DEFAULT_CAMERAHEIGHT                        480
#endif
 
#define DEFAULT_CAMERAXOFFSET                         0
#define DEFAULT_CAMERAYOFFSET                         0

#define DEFAULT_DISPLAYTYPE                           0
#if defined(VARIANT_S_FTR_ENABLE_AIVI_NPIVI)
  #define DEFAULT_DISPLAY1WIDTH                       1280
  #define DEFAULT_DISPLAY1HEIGHT                      768
  #define DEFAULT_DISPLAY1XOFFSET                     0
  #define DEFAULT_DISPLAY1YOFFSET                     0
  #define DEFAULT_DISPLAY2WIDTH                       1280
  #define DEFAULT_DISPLAY2HEIGHT                      768
  #define DEFAULT_DISPLAY2XOFFSET                     0
  #define DEFAULT_DISPLAY2YOFFSET                     0
  #define DEFAULT_DESTINATIONREGION                   255
#else                                                 
  #define DEFAULT_DISPLAY1WIDTH                       800
  #define DEFAULT_DISPLAY1HEIGHT                      480
  #define DEFAULT_DISPLAY1XOFFSET                     0
  #define DEFAULT_DISPLAY1YOFFSET                     0
  #define DEFAULT_DISPLAY2WIDTH                       800
  #define DEFAULT_DISPLAY2HEIGHT                      480
  #define DEFAULT_DISPLAY2XOFFSET                     0
  #define DEFAULT_DISPLAY2YOFFSET                     0
  #define DEFAULT_DESTINATIONREGION                   255
#endif

#define DEFAULT_DISPLAYORIENTATION                    DISPLAY_ORIENTATION_LANDSCAPE

#define DEFAULT_VCANDIVERSITY                         0
#define DEFAULT_CAMERAIMAGEMIRROR                     0
#define DEFAULT_WELCOMESEQUENCE                       0

#define GUIDELINE_SETTING_DEF_FORCE   DEFAULT_GUIDELINECAMERATYPE, DEFAULT_GUIDELINECAMERASYSTEMTYPE, DEFAULT_GUIDELINEWARNINGTEXTBACKGROUND, DEFAULT_GUIDELINEWARNINGTEXT, DEFAULT_GUIDELINEVISIBILITY
#define GUIDELINE_PARAMETER_DEFAULTS  0,0,0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,0,0
#define VIDEO_SCALING_DEFAULTS        0,0,0,0,0,0,0,0,0,0, 0,0,0,0
#define ANIMATION_DEFAULTS            DEFAULT_BRAND, DEFAULT_OPENINGANIMATION, DEFAULT_DISPLAYASPECTRATIO, DEFAULT_DESTINATIONREGION
#define CAMERA_CONNECTION_DEFAULTS    DEFAULT_CAMERA_CONNECTION_TYPE, DEFAULT_CAMERAWIDTH, DEFAULT_CAMERAHEIGHT, DEFAULT_CAMERAXOFFSET, DEFAULT_CAMERAYOFFSET
#define DISPLAY_DEFAULTS              DEFAULT_DISPLAYTYPE, DEFAULT_DISPLAY1WIDTH, DEFAULT_DISPLAY1HEIGHT, DEFAULT_DISPLAY1XOFFSET, DEFAULT_DISPLAY1YOFFSET, DEFAULT_DISPLAY2WIDTH, DEFAULT_DISPLAY2HEIGHT, DEFAULT_DISPLAY2XOFFSET, DEFAULT_DISPLAY2YOFFSET, DEFAULT_DISPLAYORIENTATION
#define RESOLUTION_DEFAULTS           0,0,0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,0,0, 0,0
#define DISPLAYORDER_DEFAULTS         0,0,0,0
#define FLUSHDESIGNCONFIGFILE_DEFAULTS 0,0,0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,0,0, 0,0,0,0
#define EARLY_NOR_FORCE_DEFAULT_VALUES  DEFAULT_RVCLOWSPEEDTHRESHOLD, DEFAULT_RVCHIGHSPEEDTHRESHOLD, DEFAULT_RVCREVERSEOFFGUARDTIME, GUIDELINE_SETTING_DEF_FORCE, GUIDELINE_PARAMETER_DEFAULTS, VIDEO_SCALING_DEFAULTS, DEFAULT_STEERING_POSITION, ANIMATION_DEFAULTS, CAMERA_CONNECTION_DEFAULTS, DISPLAY_DEFAULTS, DEFAULT_VCANDIVERSITY, DEFAULT_CAMERAIMAGEMIRROR, DEFAULT_WELCOMESEQUENCE, RESOLUTION_DEFAULTS, DEFAULT_VEHICLE_TYPE, DISPLAYORDER_DEFAULTS, FLUSHDESIGNCONFIGFILE_DEFAULTS

// usually for user setting values
typedef struct
{
    // pdd configuration
    tU32  u32SpmAutoMode;
    tU32  u32RvcColourDay;
    tU32  u32RvcContrastDay;
    tU32  u32RvcBrightnessDay;
    tU32  u32RvcHueDay;
    tU32  u32RvcBlackLevelDay;
    tU32  u32RvcColourNight;
    tU32  u32RvcContrastNight;
    tU32  u32RvcBrightnessNight;
    tU32  u32RvcHueNight;
    tU32  u32RvcBlackLevelNight;
    tU32  u32GuidelineWarningLanguage;
    tU32  u32GuidelineVisibilityMode;
    tU8   u8AvmLanguage;
    // If you add/remove elements or if you modify the order, you must adapt "EARLY_NOR_DEFAULT_VALUES" also.
}TEarlyNorConfiguration;

// usually for configuration values
typedef struct
{
    // pdd configuration
    tU32  u32RvcLowSpeedThreshold;
    tU32  u32RvcHighSpeedThreshold;
    tU32  u32RvcReverseOffGuardTime;
    tU32  u32GuidelineCameraType;
    tU32  u32GuidelineCameraSystemType;
    tU32  u32GuidelineBlackWarningTextBackground;
    tU32  u32GuidelineWarningText;
    tBool bGuidelineVisibility;
    tU8   au8GuidelineVehicleParameter[80];
    tU16  u16VideoSourceRectangle_X;
    tU16  u16VideoSourceRectangle_Y;
    tU16  u16VideoSourceRectangle_Width;
    tU16  u16VideoSourceRectangle_Height;
    tU16  u16VideoDestinationRectangle_X;
    tU16  u16VideoDestinationRectangle_Y;
    tU16  u16VideoDestinationRectangle_Width;
    tU16  u16VideoDestinationRectangle_Height;
    tU16  u16VideoCropping_Up;
    tU16  u16VideoCropping_Down;
    tU16  u16VideoCropping_Left;
    tU16  u16VideoCropping_Right;
    tBool bVideoScalingSet;
    tBool bVideoCroppingSet;
    tBool bLeftHandSteeringPosition;
    tU8   u8EarlyBrand;
    tU8   u8EarlyOpeningAnimation;
    tU8   u8EarlyDisplayAspectRatio;
    tU16  u16EarlyDestinationRegion;
    tU8   u8CameraConnectionType;
    tU16  u16CameraWidth;
    tU16  u16CameraHeight;
    tU16  u16CameraXOffset;
    tU16  u16CameraYOffset;
    tU8   u8DisplayType;
    tU16  u16Display1Width;
    tU16  u16Display1Height;
    tU16  u16Display1XOffset;
    tU16  u16Display1YOffset;
    tU16  u16Display2Width;
    tU16  u16Display2Height;
    tU16  u16Display2XOffset;
    tU16  u16Display2YOffset;
    tU8   u8EarlyDisplayOrientation;
    tU8   u8VCANDiversity;
    tU8   u8CameraImageMirror;
    tU8   u8EarlyWelcomeSequence;
    tU8   au8EarlyResolution[32];
    tU16  u16VehicleType;
    tU8   au8EarlyDisplayOrder[4];
    tU8   au8EarlyFlushDesignConfigFile[64];
    // If you add/remove elements or if you modify the order, you must adapt "EARLY_NOR_FORCE_DEFAULT_VALUES" also.
}TEarlyNorForceConfiguration;

#endif /* VD_EARLYNorData_H_ */
