/************************************************************************
* FILE:        PDDDefaultData.h
* PROJECT:     NISSAN A-IVI
* SW-COMPONENT:VD_DIMMING
*----------------------------------------------------------------------
*
* DESCRIPTION: KDS - PDD dimming configuration default values
*
*----------------------------------------------------------------------
* COPYRIGHT:   (c) 2015 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author             | Modification
* 25.09.2015| CM-AI/EPB2 Bernard | init
* 13.10.2015| CM-AI/EPB2 Bernard | added required defines below HMI_DAY
*
*************************************************************************/

#ifndef PDDDEFAULTDATA_H_
#define PDDDEFAULTDATA_H_

// dimming configuration specification
// see https://hi-dms.de.bosch.com/docushare/dsweb/Services/Document-754306/KDS_Dimming.xlsx 
#define DEFAULT_C_AU16_BRIGTHNESS_CURVE_HMI_NIGHT                   51, 54, 58, 62, 66, 71, 76, 81, 87, 93, 99, 106, 114, 122, 131, 141, 151, 162, 174, 187, 201, 216, 233, 250, 269, 289, 311, 335, 360, 388, 418, 449, 484
#define DEFAULT_C_AU16_BRIGTHNESS_CURVE_HMI_DAY                     84, 91, 98, 106, 115, 124, 134, 145, 156, 169, 182, 197, 213, 230, 248, 268, 289, 312, 337, 364, 394, 425, 459, 496, 536, 578, 625, 675, 729, 787, 850, 918, 992
#define DEFAULT_C_U16_DISPLAY_ILLUMINATION_OUTPUT_FREQUENCY         1000
#define DEFAULT_C_U16_KEYS_ENCODER_ILLUMINATION_OUTPUT_FREQUENCY    1000
#define DEFAULT_C_U8_BRIGTHNESS_NO_OF_HMI_OFFSET                    33
#define DEFAUTL_C_U8_NUMBER_OF_KEYS                                 5
#define DEFAULT_C_U8_HIGH_TEMPERATURE                               80
#define DEFAULT_C_U8_CRITICAL_TEMPERATURE                           85
#define DEFAUTL_C_S8_LOW_TEMPERATURE                                -127
#define DEFAULT_C_U8_TEMP_HYSTERESIS                                0
#define DEFAULT_C_U8_TEMP_COMPENSATION_PWM_MIN                      20
#define DEFAULT_C_AU16_KEYB_LED_CALIBRATION_VALUE                   1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000
#define DEFAULT_C_AU16_DISPLAY_TYPE_ATTACHED_VALUE     				0
#define DEFAULT_C_AU16_DISPLAY_TYPE_DETACHED_VALUE     				1
#define DEFAULT_C_AU16_DIMMING_COCKPIT_STRATEGY_VALUE     			0
#define DEFAULT_C_AU16_KEY_BRIGHTNESS_NUMOF_OFFSETS_VALUE     		21
#define DEFAULT_C_AU16_DAMPING_STRATEGY_ENABLED_VALUE     			1
#define DEFAULT_C_AU16_DAMPING_STRATEGY_DISABLED_VALUE     			0
#define DEFAULT_C_AU16_DAMPING_SAMPLING_TIMETE_VALUE     			30
#define DEFAULT_C_AU16_DAMPING_CONSTANTK_VALUE     			        25
#define DEFAULT_C_AU16_DAMPING_CONSTANTJ_VALUE     			        20
#define DEFAULT_C_AU16_BRIGTHNESS_BACKLIGHT_DAY_BUTTONS_DAY_VALUE       0
#define DEFAULT_C_AU16_BRIGTHNESS_BACKLIGHT_DAY_BUTTONS_NIGHT_VALUE     50
#define DEFAULT_C_AU16_BRIGTHNESS_BACKLIGHT_NIGHT_BUTTONS_NIGHT_VALUE   100
#define DEFAULT_C_AU16_BRIGTHNESSBACKLIGHT_DAYBUTTONS_ON_VALUE   		50
#define DEFAULT_C_AU16_BRIGTHNESS_BACKLIGHT_DAYBUTTONS_OFF_VALUE       0
#define DEFAULT_C_AU16_BRIGTHNESS_BACKLIGHT_NIGHTBUTTONS_ON_VALUE      0, 50, 100, 150, 200, 250, 300, 350, 400, 450, 500, 550, 600, 650, 700, 750, 800, 850, 900, 950, 1000
#define DEFAULT_C_AU16_LIGHTENING_PARAMETER_VALUE     				0
#define DEFAULT_C_U8_DIMMING_ARCHITECTURE_VALUE						0



#endif /* PDDDEFAULTDATA_H_ */
